﻿Cartographer_InstanceMaps_Rotations = {
	-- currently only 90*k degree rotations are supported since in-between cases causes texture bleeding.
	["Dire Maul"] = 180,
	["Shadowfang Keep"] = 90,
	["The Deadmines"] = 270,
	["Razorfen Kraul"] = 270,
	["Old Hillsbrad Foothills"] = 90,
	["The Black Morass"] = 90,
	["Hellfire Ramparts"] = 90,
	["Zul'Gurub"] = 90,
	["Zul'Farrak"] = 90,
	["Hyjal Summit"] = 90,
	["Black Temple"] = 270,
	["Zul'Aman"] = 90,
}

Cartographer_InstanceMaps_Floors = {
	["Karazhan"] = {5, 140, 260},
	["Azjol-Nerub"] = {0},
	["Upper Blackrock Spire"] = {0},
}

Cartographer_InstanceMaps_MapData = {
	["Ahn'Qiraj"] = 
		"\038\228\211\125\055\060\144\173\020\046\160\009\125\191\150\004\150\118\126\068\081\012\054\068\176\066\004\196" ..
		-- tex:"26e4d37d373c90ad142ea0097dbf9604"; x:1017.852966; y:728.192505; z:-529.042053
		"\084\190\106\145\249\103\037\243\153\036\254\211\138\243\214\013\075\059\191\068\081\012\118\068\176\066\004\196" ..
		-- tex:"54be6a91f96725f39924fed38af3d60d"; x:1529.852966; y:984.192505; z:-529.042053
		"\029\072\112\125\002\052\238\134\192\179\144\077\186\194\036\046\075\059\191\068\040\006\155\068\176\066\004\196" ..
		-- tex:"1d48707d0234ee86c0b3904dbac2242e"; x:1529.852966; y:1240.192505; z:-529.042053
		"\010\015\142\154\016\239\113\225\012\208\067\111\129\155\069\153\075\059\159\068\081\012\118\068\176\066\004\196" ..
		-- tex:"0a0f8e9a10ef71e10cd0436f819b4599"; x:1273.852966; y:984.192505; z:-529.042053
		"\055\168\063\194\083\074\159\044\094\253\215\250\080\164\009\244\075\059\159\068\040\006\155\068\176\066\004\196" ..
		-- tex:"37a83fc2534a9f2c5efdd7fa50a409f4"; x:1273.852966; y:1240.192505; z:-529.042053
		"\147\036\092\177\223\254\012\194\054\206\173\106\193\125\076\139\150\118\126\068\040\006\155\068\176\066\004\196" ..
		-- tex:"93245cb1dffe0cc236cead6ac17d4c8b"; x:1017.852966; y:1240.192505; z:-529.042053
		"\160\218\052\169\218\127\232\127\078\115\041\019\249\138\203\084\075\059\159\068\081\012\054\068\176\066\004\196" ..
		-- tex:"a0da34a9da7fe87f4e732913f98acb54"; x:1273.852966; y:728.192505; z:-529.042053
		"\117\168\053\037\245\009\057\233\071\187\195\183\109\075\045\144\150\118\126\068\081\012\118\068\176\066\004\196" ..
		-- tex:"75a83525f50939e947bbc3b76d4b2d90"; x:1017.852966; y:984.192505; z:-529.042053
		"\150\037\112\065\127\041\105\164\090\159\066\084\185\095\131\084\203\081\166\068\189\144\167\065\152\013\002\196" ..
		-- tex:"962570417f2969a45a9f4254b95f8354"; x:1330.556152; y:20.945675; z:-520.212463
		"\086\215\013\125\049\080\079\064\155\065\234\096\011\134\245\161\203\081\166\068\011\121\138\067\152\013\002\196" ..
		-- tex:"56d70d7d31504f409b41ea600b86f5a1"; x:1330.556152; y:276.945675; z:-520.212463
		"\076\028\245\236\192\241\007\150\158\157\172\043\194\008\055\020\203\081\198\068\011\121\138\067\152\013\002\196" ..
		-- tex:"4c1cf5ecc0f107969e9dac2bc2083714"; x:1586.556152; y:276.945675; z:-520.212463
		"\220\056\053\031\065\148\073\075\181\091\026\047\028\109\216\086\203\081\166\068\133\060\005\068\152\013\002\196" ..
		-- tex:"dc38351f4194494bb55b1a2f1c6dd856"; x:1330.556152; y:532.945675; z:-520.212463
		"\051\170\159\129\048\089\254\136\132\202\104\236\117\056\038\125\203\081\198\068\133\060\005\068\152\013\002\196" ..
		-- tex:"33aa9f813059fe8884ca68ec7538267d"; x:1586.556152; y:532.945675; z:-520.212463
		"\201\252\051\112\088\053\014\154\127\125\208\082\007\111\075\016\203\081\198\068\189\144\167\065\152\013\002\196" ..
		-- tex:"c9fc337058350e9a7f7dd052076f4b10"; x:1586.556152; y:20.945675; z:-520.212463
		"\035\033\056\005\255\090\035\022\249\008\146\153\227\121\138\069\203\081\166\068\133\060\069\068\152\013\002\196" ..
		-- tex:"23213805ff5a2316f9089299e3798a45"; x:1330.556152; y:788.945675; z:-520.212463
		"\063\205\034\021\251\121\131\163\083\243\119\055\159\160\066\042\188\135\147\194\052\145\007\195\120\112\001\196" ..
		-- tex:"3fcd2215fb7983a353f377379fa0422a"; x:-73.765114; y:-135.567215; z:-517.757385
		"\010\097\037\187\124\238\206\171\165\087\249\236\145\052\121\181\109\036\129\068\095\108\062\068\057\021\000\196" ..
		-- tex:"0a6125bb7ceeceaba557f9ec913479b5"; x:1033.138367; y:761.693329; z:-512.331665
		"\162\186\164\126\035\232\228\050\231\193\067\107\043\083\175\212\109\036\129\068\190\216\252\067\057\021\000\196" ..
		-- tex:"a2baa47e23e8e432e7c1436b2b53afd4"; x:1033.138367; y:505.693329; z:-512.331665
		"\001\234\079\068\215\234\075\023\235\174\033\029\254\056\112\253\218\072\066\068\190\216\252\067\057\021\000\196" ..
		-- tex:"01ea4f44d7ea4b17ebae211dfe3870fd"; x:777.138367; y:505.693329; z:-512.331665
		"\112\202\088\031\013\232\130\071\238\118\228\180\131\114\177\218\218\072\066\068\095\108\062\068\057\021\000\196" ..
		-- tex:"70ca581f0de88247ee76e4b48372b1da"; x:777.138367; y:761.693329; z:-512.331665
		"\232\137\251\000\217\080\203\014\067\073\199\011\035\125\181\239\223\142\008\068\200\031\048\068\194\121\247\195" ..
		-- tex:"e889fb00d950cb0e4349c70b237db5ef"; x:546.232422; y:704.496613; z:-494.951263
		"\002\066\039\064\238\233\025\076\126\210\066\035\044\029\016\162\223\142\072\068\144\063\224\067\194\121\247\195" ..
		-- tex:"02422740eee9194c7ed242232c1d10a2"; x:802.232422; y:448.496613; z:-494.951263
		"\216\050\068\233\008\242\248\112\155\130\230\173\239\210\018\097\223\142\008\068\144\063\224\067\194\121\247\195" ..
		-- tex:"d83244e908f2f8709b82e6adefd21261"; x:546.232422; y:448.496613; z:-494.951263
		"\003\133\126\081\238\011\085\086\138\102\051\067\253\073\240\136\022\165\055\195\205\162\161\068\018\030\245\195" ..
		-- tex:"03857e51ee0b55568a663343fd49f088"; x:-183.644882; y:1293.087646; z:-490.234955
		"\081\063\098\008\155\135\229\216\041\112\066\095\115\054\178\105\022\165\055\195\205\162\193\068\018\030\245\195" ..
		-- tex:"513f62089b87e5d82970425f7336b269"; x:-183.644882; y:1549.087646; z:-490.234955
		"\000\126\119\199\180\251\186\250\032\136\233\130\188\134\149\117\014\028\001\196\115\074\205\068\018\030\245\195" ..
		-- tex:"007e77c7b4fbbafa2088e982bc869575"; x:-516.438416; y:1642.326660; z:-490.234955
		"\079\117\071\151\194\216\228\077\109\057\010\022\153\181\198\042\029\056\130\195\115\074\205\068\018\030\245\195" ..
		-- tex:"4f754797c2d8e44d6d390a1699b5c62a"; x:-260.438416; y:1642.326660; z:-490.234955
		"\122\182\233\120\220\060\241\122\090\137\224\017\011\149\000\114\029\056\130\195\115\074\237\068\018\030\245\195" ..
		-- tex:"7ab6e978dc3cf17a5a89e0110b950072"; x:-260.438416; y:1898.326660; z:-490.234955
		"\207\221\176\038\232\223\033\002\131\160\143\018\051\057\052\227\014\028\001\196\115\074\237\068\018\030\245\195" ..
		-- tex:"cfddb026e8df210283a08f12333934e3"; x:-516.438416; y:1898.326660; z:-490.234955
		"\208\098\140\223\110\231\135\074\100\027\205\185\048\156\055\159\010\000\088\196\038\050\191\068\148\021\245\195" ..
		-- tex:"d0628cdf6ee7874a641bcdb9309c379f"; x:-864.000671; y:1529.567261; z:-490.168610
		"\034\090\000\049\228\071\156\229\207\183\192\028\101\007\209\200\010\000\088\196\038\050\223\068\148\021\245\195" ..
		-- tex:"225a0031e4479ce5cfb7c01c6507d1c8"; x:-864.000671; y:1785.567261; z:-490.168610
		"\186\132\115\225\119\118\161\212\234\138\057\050\172\051\015\150\010\000\024\196\038\050\223\068\148\021\245\195" ..
		-- tex:"ba8473e17776a1d4ea8a3932ac330f96"; x:-608.000671; y:1785.567261; z:-490.168610
		"\091\051\047\209\101\213\249\000\072\142\251\024\045\137\051\208\010\000\088\196\038\050\159\068\148\021\245\195" ..
		-- tex:"5b332fd165d5f900488efb182d8933d0"; x:-864.000671; y:1273.567261; z:-490.168610
		"\091\138\176\158\067\002\253\039\062\060\129\238\217\197\148\169\010\000\024\196\038\050\191\068\148\021\245\195" ..
		-- tex:"5b8ab09e4302fd273e3c81eed9c594a9"; x:-608.000671; y:1529.567261; z:-490.168610
		"\049\225\170\104\109\197\129\137\211\089\006\034\234\064\196\114\055\189\144\067\157\181\003\068\107\248\243\195" ..
		-- tex:"31e1aa686dc58189d3590622ea40c472"; x:289.478271; y:526.837769; z:-487.940796
		"\059\188\085\138\095\079\237\111\073\101\003\234\225\165\136\111\055\189\144\067\059\107\135\067\107\248\243\195" ..
		-- tex:"3bbc558a5f4fed6f496503eae1a5886f"; x:289.478271; y:270.837769; z:-487.940796
		"\046\025\145\105\223\118\198\005\209\050\007\157\201\166\199\202\155\094\008\068\157\181\003\068\107\248\243\195" ..
		-- tex:"2e199169df76c605d132079dc9a6c7ca"; x:545.478271; y:526.837769; z:-487.940796
		"\231\104\065\169\146\119\130\020\062\015\027\114\232\242\209\147\155\094\008\068\059\107\135\067\107\248\243\195" ..
		-- tex:"e76841a9927782143e0f1b72e8f2d193"; x:545.478271; y:270.837769; z:-487.940796
		"\120\067\066\160\225\037\105\105\060\144\173\229\142\043\152\013\191\233\005\066\157\181\003\068\107\248\243\195" ..
		-- tex:"784342a0e12569693c90ade58e2b980d"; x:33.478271; y:526.837769; z:-487.940796
		"\204\152\150\096\161\116\085\175\011\075\032\095\003\073\116\184\191\233\005\066\059\107\135\067\107\248\243\195" ..
		-- tex:"cc989660a17455af0b4b205f034974b8"; x:33.478271; y:270.837769; z:-487.940796
		"\040\090\167\254\108\145\201\102\084\081\076\066\243\042\113\113\099\141\166\067\244\234\136\068\063\030\240\195" ..
		-- tex:"285aa7fe6c91c96654514c42f32a7171"; x:333.104614; y:1095.342407; z:-480.236328
		"\190\159\180\026\007\061\118\114\038\238\050\143\213\157\119\130\177\070\019\068\233\213\017\068\063\030\240\195" ..
		-- tex:"be9fb41a073d767226ee328fd59d7782"; x:589.104614; y:583.342407; z:-480.236328
		"\239\121\161\129\248\055\151\168\115\193\066\007\012\217\067\145\177\070\019\068\244\234\136\068\063\030\240\195" ..
		-- tex:"ef79a181f83797a873c142070cd94391"; x:589.104614; y:1095.342407; z:-480.236328
		"\075\175\022\229\230\173\132\039\097\030\113\189\114\041\043\100\177\070\019\068\233\213\081\068\063\030\240\195" ..
		-- tex:"4baf16e5e6ad8427611e71bd72292b64"; x:589.104614; y:839.342407; z:-480.236328
		"\196\026\177\196\066\135\199\230\140\136\160\196\077\117\092\234\099\141\166\067\233\213\081\068\063\030\240\195" ..
		-- tex:"c41ab1c44287c7e68c88a0c44d755cea"; x:333.104614; y:839.342407; z:-480.236328
		"\061\097\188\187\223\111\159\222\145\241\203\189\154\196\024\254\099\141\166\067\233\213\017\068\063\030\240\195" ..
		-- tex:"3d61bcbbdf6f9fde91f1cbbd9ac418fe"; x:333.104614; y:583.342407; z:-480.236328
		"\065\090\207\007\213\156\012\245\063\018\157\140\219\125\146\215\113\204\134\195\195\153\250\068\016\084\234\195" ..
		-- tex:"415acf07d59c0cf53f129d8cdb7d92d7"; x:-269.597229; y:2004.805176; z:-468.656769
		"\003\051\160\174\168\090\180\170\020\254\158\005\237\243\173\136\252\233\135\067\036\224\137\068\148\061\228\195" ..
		-- tex:"0333a0aea85ab4aa14fe9e05edf3ad88"; x:271.828024; y:1103.004517; z:-456.481110
		"\123\186\211\130\076\018\115\168\068\062\178\164\009\204\149\178\252\233\135\067\036\224\169\068\148\061\228\195" ..
		-- tex:"7bbad3824c1273a8443eb2a409cc95b2"; x:271.828024; y:1359.004517; z:-456.481110
		"\130\100\082\014\227\235\131\116\114\099\076\047\038\047\052\139\149\063\125\065\036\224\169\068\148\061\228\195" ..
		-- tex:"8264520ee3eb837472634c2f262f348b"; x:15.828024; y:1359.004517; z:-456.481110
		"\089\041\129\214\178\255\057\053\161\176\152\051\160\073\068\167\149\063\125\065\036\224\137\068\148\061\228\195" ..
		-- tex:"592981d6b2ff3935a1b09833a04944a7"; x:15.828024; y:1103.004517; z:-456.481110
		"\050\052\234\090\226\102\111\083\211\043\132\100\130\199\231\236\177\065\121\195\136\144\243\068\111\250\227\195" ..
		-- tex:"3234ea5ae2666f53d32b846482c7e7ec"; x:-249.256622; y:1948.516724; z:-455.956543
		"\254\040\155\146\015\088\009\236\225\170\047\068\063\246\023\012\216\160\252\195\136\144\243\068\111\250\227\195" ..
		-- tex:"fe289b920f5809ece1aa2f443ff6170c"; x:-505.256622; y:1948.516724; z:-455.956543
		"\149\107\208\242\067\036\056\224\246\025\171\122\250\221\052\202\216\160\252\195\068\200\009\069\111\250\227\195" ..
		-- tex:"956bd0f2432438e0f619ab7afadd34ca"; x:-505.256622; y:2204.516724; z:-455.956543
		"\172\019\153\060\173\102\191\107\245\079\253\057\188\246\244\193\194\174\044\068\241\214\201\195\008\189\221\195" ..
		-- tex:"ac13993cad66bf6bf54ffd39bcf6f4c1"; x:690.730652; y:-403.679260; z:-443.476837
		"\191\063\096\063\004\231\040\221\150\118\220\103\103\236\066\203\097\087\150\068\241\214\201\195\008\189\221\195" ..
		-- tex:"bf3f603f04e728dd9676dc6767ec42cb"; x:1202.730652; y:-403.679260; z:-443.476837
		"\156\205\164\056\209\066\024\168\136\152\047\195\192\068\081\168\097\087\182\068\120\235\036\196\008\189\221\195" ..
		-- tex:"9ccda438d14218a888982fc3c04451a8"; x:1458.730652; y:-659.679260; z:-443.476837
		"\055\027\030\021\138\238\192\042\035\087\151\137\077\022\176\131\194\174\044\068\120\235\036\196\008\189\221\195" ..
		-- tex:"371b1e158aeec02a235797894d16b083"; x:690.730652; y:-659.679260; z:-443.476837
		"\120\203\222\058\235\138\233\084\086\209\179\167\228\082\138\177\194\174\044\068\120\235\100\196\008\189\221\195" ..
		-- tex:"78cbde3aeb8ae95456d1b3a7e4528ab1"; x:690.730652; y:-915.679260; z:-443.476837
		"\234\133\004\239\081\037\046\224\162\064\064\138\025\115\106\144\194\174\108\068\241\214\201\195\008\189\221\195" ..
		-- tex:"ea8504ef51252ee0a240408a19736a90"; x:946.730652; y:-403.679260; z:-443.476837
		"\231\130\211\209\106\059\128\057\194\022\220\219\050\253\075\081\097\087\150\068\120\235\036\196\008\189\221\195" ..
		-- tex:"e782d3d16a3b8039c216dcdb32fd4b51"; x:1202.730652; y:-659.679260; z:-443.476837
		"\223\172\224\043\140\080\142\246\163\227\129\112\065\122\000\082\097\087\182\068\120\235\100\196\008\189\221\195" ..
		-- tex:"dface02b8c508ef6a3e38170417a0052"; x:1458.730652; y:-915.679260; z:-443.476837
		"\126\191\251\196\247\158\237\171\004\133\217\202\222\052\218\209\097\087\150\068\120\235\100\196\008\189\221\195" ..
		-- tex:"7ebffbc4f79eedab0485d9cade34dad1"; x:1202.730652; y:-915.679260; z:-443.476837
		"\009\174\115\130\057\004\122\099\223\113\110\076\210\010\149\055\194\174\108\068\120\235\036\196\008\189\221\195" ..
		-- tex:"09ae738239047a63df716e4cd20a9537"; x:946.730652; y:-659.679260; z:-443.476837
		"\168\141\114\181\019\238\031\083\190\186\168\068\254\176\233\001\194\174\108\068\120\235\100\196\008\189\221\195" ..
		-- tex:"a88d72b513ee1f53bebaa844feb0e901"; x:946.730652; y:-915.679260; z:-443.476837
		"\079\171\185\229\118\205\170\035\243\111\189\146\170\117\088\073\053\197\010\196\246\131\137\068\208\180\220\195" ..
		-- tex:"4fabb9e576cdaa23f36fbd92aa755849"; x:-555.081421; y:1100.123901; z:-441.412628
		"\115\215\152\075\031\030\253\026\162\129\239\247\048\142\056\231\053\197\010\196\237\007\083\068\208\180\220\195" ..
		-- tex:"73d7984b1f1efd1aa281eff7308e38e7"; x:-555.081421; y:844.123901; z:-441.412628
		"\242\017\236\166\038\064\193\156\025\099\148\255\060\143\006\064\053\197\074\196\246\131\137\068\208\180\220\195" ..
		-- tex:"f211eca62640c19c196394ff3c8f0640"; x:-811.081421; y:1100.123901; z:-441.412628
		"\135\175\022\209\100\244\145\196\067\032\234\148\216\242\197\051\053\197\074\196\237\007\083\068\208\180\220\195" ..
		-- tex:"87af16d164f491c44320ea94d8f2c533"; x:-811.081421; y:844.123901; z:-441.412628
		"\050\193\168\246\154\102\158\002\051\082\107\131\232\139\240\054\174\198\111\068\184\196\178\195\137\067\205\195" ..
		-- tex:"32c1a8f69a669e0233526b83e88bf036"; x:959.104431; y:-357.536896; z:-410.527649
		"\075\179\077\108\205\233\052\243\252\098\227\202\242\100\102\148\023\082\137\068\095\101\143\193\137\067\205\195" ..
		-- tex:"4bb34d6ccde934f3fc62e3caf2646694"; x:1098.565430; y:-17.924500; z:-410.527649
		"\064\053\118\067\092\135\237\177\102\044\008\158\090\157\238\030\047\164\082\068\085\246\136\195\137\067\205\195" ..
		-- tex:"403576435c87edb1662c089e5a9dee1e"; x:842.565430; y:-273.924500; z:-410.527649
		"\061\095\245\188\210\238\206\187\013\068\185\006\076\005\205\109\023\082\137\068\085\246\136\195\137\067\205\195" ..
		-- tex:"3d5ff5bcd2eecebb0d44b9064c05cd6d"; x:1098.565430; y:-273.924500; z:-410.527649
		"\234\211\194\013\142\135\046\224\042\115\089\044\243\091\108\200\047\164\082\068\095\101\143\193\137\067\205\195" ..
		-- tex:"ead3c20d8e872ee02a73592cf35b6cc8"; x:842.565430; y:-17.924500; z:-410.527649
		"\051\165\192\058\174\174\123\047\254\196\227\032\218\231\024\219\004\038\211\195\154\249\009\069\117\231\204\195" ..
		-- tex:"33a5c03aaeae7b2ffec4e320dae718db"; x:-422.297028; y:2207.600342; z:-409.808289
		"\198\098\143\247\170\177\164\158\067\023\010\094\255\088\236\195\004\038\211\195\154\249\025\069\117\231\204\195" ..
		-- tex:"c6628ff7aab1a49e43170a5eff58ecc3"; x:-422.297028; y:2463.600342; z:-409.808289
		"\038\088\161\253\252\044\142\193\103\226\187\172\100\161\096\189\009\076\038\195\154\249\009\069\117\231\204\195" ..
		-- tex:"2658a1fdfc2c8ec167e2bbac64a160bd"; x:-166.297028; y:2207.600342; z:-409.808289
		"\056\243\181\127\074\124\175\126\007\068\194\239\157\004\050\210\009\076\038\195\154\249\025\069\117\231\204\195" ..
		-- tex:"38f3b57f4a7caf7e0744c2ef9d0432d2"; x:-166.297028; y:2463.600342; z:-409.808289
		"\235\071\245\061\218\092\044\033\062\041\000\128\203\137\159\229\117\096\137\068\214\020\226\194\148\161\196\195" ..
		-- tex:"eb47f53dda5c2c213e290080cb899fe5"; x:1099.014404; y:-113.040703; z:-393.262360
		"\183\121\244\096\121\017\210\116\129\016\100\087\231\105\232\197\117\096\169\068\214\020\226\194\148\161\196\195" ..
		-- tex:"b779f4607911d27481106457e769e8c5"; x:1355.014404; y:-113.040703; z:-393.262360
		"\146\183\148\218\121\045\184\055\002\189\026\114\163\167\039\161\225\015\094\195\090\108\014\068\079\042\193\195" ..
		-- tex:"92b794da792db83702bd1a72a3a727a1"; x:-222.062042; y:569.693054; z:-386.330566
		"\141\047\092\202\182\113\253\072\021\238\168\141\105\114\067\005\225\015\094\195\090\108\078\068\079\042\193\195" ..
		-- tex:"8d2f5ccab671fd4815eea88d69724305"; x:-222.062042; y:825.693054; z:-386.330566
		"\082\030\019\065\171\082\053\111\131\019\206\104\011\104\076\013\240\007\239\195\090\108\078\068\079\042\193\195" ..
		-- tex:"521e1341ab52356f8313ce680b684c0d"; x:-478.062042; y:825.693054; z:-386.330566
		"\184\094\035\086\044\223\050\032\220\096\063\017\204\076\074\203\240\007\239\195\090\108\014\068\079\042\193\195" ..
		-- tex:"b85e23562cdf3220dc603f11cc4c4acb"; x:-478.062042; y:569.693054; z:-386.330566
		"\017\071\062\223\089\148\172\020\015\081\142\078\039\095\226\151\230\003\035\068\034\124\211\194\057\244\183\195" ..
		-- tex:"11473edf5994ac140f518e4e275fe297"; x:652.060974; y:-105.742455; z:-367.908020
		"\193\119\055\140\246\137\105\068\192\124\042\171\251\204\003\085\149\195\207\067\179\003\109\195\255\086\182\195" ..
		-- tex:"c177378cf6896944c07c2aabfbcc0355"; x:415.528015; y:-237.014465; z:-364.679688
		"\042\224\015\134\055\004\103\069\237\055\058\047\021\070\002\025\202\225\039\068\179\003\109\195\255\086\182\195" ..
		-- tex:"2ae00f8637046745ed373a2f15460219"; x:671.528015; y:-237.014465; z:-364.679688
		"\106\103\024\154\199\032\242\005\253\162\050\107\228\236\088\028\043\135\031\067\179\003\109\195\255\086\182\195" ..
		-- tex:"6a67189ac720f205fda2326be4ec581c"; x:159.528015; y:-237.014465; z:-364.679688
		"\234\028\218\095\006\137\078\083\181\183\077\242\142\211\051\085\170\236\188\195\026\067\243\066\024\234\160\195" ..
		-- tex:"ea1cda5f06894e53b5b74df28ed33355"; x:-377.848969; y:121.631065; z:-321.828888
		"\241\097\145\253\114\017\030\140\008\190\054\142\097\156\197\110\170\236\188\195\198\208\188\067\024\234\160\195" ..
		-- tex:"f16191fd72111e8c08be368e619cc56e"; x:-377.848969; y:377.631065; z:-321.828888
		"\155\254\011\168\133\103\099\112\185\015\148\029\104\223\164\143\083\154\144\066\117\174\022\195\132\078\160\195" ..
		-- tex:"9bfe0ba885676370b90f941d68dfa48f"; x:72.301422; y:-150.681488; z:-320.613434
		"\002\130\238\140\073\014\106\068\244\016\183\108\195\080\012\006\083\154\144\066\058\087\203\195\132\078\160\195" ..
		-- tex:"0282ee8c490e6a44f410b76cc3500c06"; x:72.301422; y:-406.681488; z:-320.613434
		"\206\167\079\086\096\250\165\255\255\105\232\170\192\024\107\159\213\178\055\195\117\174\022\195\132\078\160\195" ..
		-- tex:"cea74f5660faa5ffff69e8aac0186b9f"; x:-183.698578; y:-150.681488; z:-320.613434
		"\221\173\192\141\060\128\186\216\108\165\164\048\099\139\108\048\213\178\055\195\058\087\203\195\132\078\160\195" ..
		-- tex:"ddadc08d3c80bad86ca5a430638b6c30"; x:-183.698578; y:-406.681488; z:-320.613434
		"\011\035\034\195\230\091\121\226\245\108\056\067\029\021\133\237\219\144\005\195\101\172\231\066\207\021\155\195" ..
		-- tex:"0b2322c3e65b79e2f56c38431d1585ed"; x:-133.565857; y:115.836716; z:-310.170410
		"\195\094\202\248\191\228\227\041\246\232\185\058\164\169\006\247\219\144\005\195\204\041\012\195\207\021\155\195" ..
		-- tex:"c35ecaf8bfe4e329f6e8b93aa4a906f7"; x:-133.565857; y:-140.163284; z:-310.170410
		"\068\118\145\251\028\247\226\013\155\042\215\055\245\183\089\101\071\222\244\066\204\041\012\195\207\021\155\195" ..
		-- tex:"447691fb1cf7e20d9b2ad737f5b75965"; x:122.434143; y:-140.163284; z:-310.170410
		"\249\205\025\013\106\230\193\141\218\164\198\177\083\009\003\194\071\222\244\066\101\172\231\066\207\021\155\195" ..
		-- tex:"f9cd190d6ae6c18ddaa4c6b1530903c2"; x:122.434143; y:115.836716; z:-310.170410
		"\107\005\015\017\247\189\226\208\060\161\044\213\213\248\248\091\191\034\216\195\225\093\209\194\209\134\149\195" ..
		-- tex:"6b050f11f7bde2d03ca12cd5d5f8f85b"; x:-432.271484; y:-104.683365; z:-299.053284
		"\205\141\230\235\079\023\026\193\192\034\055\040\153\007\151\071\191\034\216\195\014\081\023\067\209\134\149\195" ..
		-- tex:"cd8de6eb4f171ac1c022372899079747"; x:-432.271484; y:151.316635; z:-299.053284
		"\067\200\137\117\088\014\195\023\125\095\105\118\007\176\129\126\127\069\048\195\225\093\209\194\209\134\149\195" ..
		-- tex:"43c88975580ec3177d5f697607b0817e"; x:-176.271484; y:-104.683365; z:-299.053284
		"\092\220\222\246\010\067\095\164\005\115\230\174\030\209\014\179\158\076\239\064\002\012\004\195\017\153\050\195" ..
		-- tex:"5cdcdef60a435fa40573e6ae1ed10eb3"; x:7.478103; y:-132.046921; z:-178.597931
		"\222\003\027\143\194\255\217\122\015\047\156\109\197\080\014\235\168\211\006\194\138\053\251\066\043\081\041\195" ..
		-- tex:"de031b8fc2ffd97a0f2f9c6dc5500eeb"; x:-33.706699; y:125.604576; z:-169.317078
		"\022\150\076\164\208\251\051\098\066\017\249\002\148\071\098\001\009\099\062\195\248\120\001\195\195\199\027\195" ..
		-- tex:"16964ca4d0fb33624211f90294476201"; x:-190.386871; y:-129.472549; z:-155.780334
		"\025\067\143\184\192\184\008\216\143\032\152\061\191\116\240\224\080\069\122\066\050\135\132\066\180\196\003\195" ..
		-- tex:"19438fb8c0b808d88f20983dbf74f0e0"; x:62.567692; y:66.264061; z:-131.768387
		"\127\054\210\061\238\029\044\026\049\014\232\161\249\066\213\004\169\007\210\192\095\227\050\066\230\110\208\194" ..
		-- tex:"7f36d23dee1d2c1a310ee8a1f942d504"; x:-6.563436; y:44.722046; z:-104.216606
		"\049\007\226\063\134\080\107\180\180\080\193\016\075\173\160\149\194\111\121\067\039\071\083\195\230\110\208\194" ..
		-- tex:"3107e23f86506bb4b450c1104bada095"; x:249.436564; y:-211.277954; z:-104.216606
		"\072\099\010\217\066\223\056\075\101\223\153\227\122\208\175\245\169\007\210\192\039\071\083\195\230\110\208\194" ..
		-- tex:"48630ad942df384b65df99e37ad0aff5"; x:-6.563436; y:-211.277954; z:-104.216606
		"\201\214\067\210\125\044\054\001\020\004\148\252\113\141\065\255\147\218\201\194\039\174\243\066\215\155\205\194" ..
		-- tex:"c9d643d27d2c3601140494fc718d41ff"; x:-100.926910; y:121.840149; z:-102.804382
		"\149\208\032\073\060\135\204\124\049\116\141\096\021\087\116\153\147\218\201\194\235\040\006\195\215\155\205\194" ..
		-- tex:"95d020493c87cc7c31748d6015577499"; x:-100.926910; y:-134.159851; z:-102.804382
		"\116\191\129\072\245\253\038\108\121\165\236\117\013\204\000\106\178\061\174\195\240\085\201\194\146\025\185\194" ..
		-- tex:"74bf8148f5fd266c79a5ec750dcc006a"; x:-348.482025; y:-100.667854; z:-92.549950
		"\013\253\203\165\019\156\130\021\134\148\146\219\158\234\152\054\113\153\243\064\195\140\077\195\198\123\173\194" ..
		-- tex:"0dfdcba5139c8215869492db9eea9836"; x:7.612481; y:-205.549866; z:-86.741753
		"\128\220\003\122\013\017\092\207\116\007\050\170\022\223\208\134\203\106\011\067\190\047\045\195\157\074\173\194" ..
		-- tex:"80dc037a0d115ccf740732aa16dfd086"; x:139.417175; y:-173.186508; z:-86.645737
		"\159\040\053\121\174\123\092\170\155\126\034\010\035\208\110\248\110\142\130\067\236\248\141\194\102\000\172\194" ..
		-- tex:"9f283579ae7b5caa9b7e220a23d06ef8"; x:261.112762; y:-70.986183; z:-86.000786
		"\058\030\098\088\036\048\022\027\200\098\133\044\138\113\042\036\110\142\130\067\040\131\110\065\102\000\172\194" ..
		-- tex:"3a1e62582430161bc862852c8a712a24"; x:261.112762; y:14.907022; z:-86.000786
		"\076\146\005\022\140\152\027\236\134\144\015\078\038\151\138\123\173\214\069\195\049\008\021\195\220\034\143\194" ..
		-- tex:"4c9205168c981bec86900f4e26978a7b"; x:-197.838593; y:-149.032013; z:-71.568092
		"\062\244\245\043\038\140\255\053\013\023\191\030\087\186\177\240\173\214\069\195\155\239\213\066\220\034\143\194" ..
		-- tex:"3ef4f52b268cff350d17bf1e57bab1f0"; x:-197.838593; y:106.967987; z:-71.568092
		"\004\192\046\128\025\171\151\183\113\214\128\038\064\090\090\085\045\150\119\195\210\182\186\194\161\138\005\194",
		-- tex:"04c02e8019ab97b771d68026405a5a55"; x:-247.586639; y:-93.357079; z:-33.385384
	["Armory"] = 
		"\047\182\003\035\111\089\193\217\209\044\140\195\222\079\018\223\019\059\133\196\219\034\089\067\039\201\068\065" ..
		-- tex:"2fb603236f59c1d9d12c8cc3de4f12df"; x:-1065.846191; y:217.136169; z:12.299110
		"\065\156\223\208\240\126\209\104\248\197\077\058\153\106\156\161\239\061\050\196\038\025\239\066\109\129\092\065" ..
		-- tex:"419cdfd0f07ed168f8c54d3a996a9ca1"; x:-712.967773; y:119.549126; z:13.781599
		"\092\013\188\176\208\129\146\087\007\233\029\106\034\185\099\031\221\203\011\196\230\157\251\066\014\035\122\065" ..
		-- tex:"5c0dbcb0d081925707e91d6a22b9631f"; x:-559.185425; y:125.808403; z:15.633559
		"\088\198\173\049\218\108\041\125\000\209\157\120\044\192\092\031\017\191\099\196\234\019\239\066\170\036\122\065" ..
		-- tex:"58c6ad31da6c297d00d19d782cc05c1f"; x:-910.985474; y:119.538902; z:15.633952
		"\210\225\245\168\119\116\029\018\196\172\157\139\150\082\248\210\165\095\157\195\209\115\156\065\161\180\202\065" ..
		-- tex:"d2e1f5a877741d12c4ac9d8b9652f8d2"; x:-314.747253; y:19.556553; z:25.338200
		"\169\236\016\021\210\167\191\222\137\123\007\196\027\033\251\023\224\188\000\196\092\076\146\066\169\179\229\065" ..
		-- tex:"a9ec1015d2a7bfde897b07c41b21fb17"; x:-514.951233; y:73.149147; z:28.712727
		"\197\090\113\220\219\185\046\221\153\055\033\241\237\039\144\008\187\170\111\196\155\088\126\067\246\131\008\066" ..
		-- tex:"c55a71dcdbb92edd993721f1ed279008"; x:-958.667725; y:254.346130; z:34.128872
		"\064\238\083\038\255\063\056\078\180\075\107\063\175\219\236\084\225\009\191\195\030\042\142\066\148\160\013\066" ..
		-- tex:"40ee5326ff3f384eb44b6b3fafdbec54"; x:-382.077209; y:71.082268; z:35.406818
		"\140\054\205\108\096\129\134\178\040\141\002\130\162\027\115\060\019\159\174\195\177\129\140\194\119\133\015\066" ..
		-- tex:"8c36cd6c608186b2288d0282a21b733c"; x:-349.242798; y:-70.253311; z:35.880341
		"\096\191\177\139\232\206\019\030\056\040\138\122\061\007\048\209\088\113\173\195\204\128\210\065\099\136\015\066" ..
		-- tex:"60bfb18be8ce131e38288a7a3d0730d1"; x:-346.885529; y:26.312891; z:35.883194
		"\213\058\204\007\079\107\090\134\118\066\002\036\159\065\033\145\081\090\109\196\024\223\213\066\095\215\015\066" ..
		-- tex:"d53acc074f6b5a86764202249f412191"; x:-949.411255; y:106.935738; z:35.960327
		"\008\153\095\127\174\208\109\023\119\079\124\125\160\053\082\214\081\090\109\196\105\001\018\067\096\215\015\066" ..
		-- tex:"08995f7faed06d17774f7c7da03552d6"; x:-949.411255; y:146.005524; z:35.960331
		"\025\013\100\141\121\091\140\032\129\128\096\253\174\019\149\200\081\090\109\196\006\177\065\067\098\215\015\066" ..
		-- tex:"190d648d795b8c20818060fdae1395c8"; x:-949.411255; y:193.691513; z:35.960339
		"\048\067\132\093\097\015\071\102\064\076\031\136\224\004\030\007\082\090\109\196\002\083\040\067\099\215\015\066" ..
		-- tex:"3043845d610f4766404c1f88e0041e07"; x:-949.411316; y:168.324265; z:35.960342
		"\141\142\245\033\147\238\217\062\074\151\129\068\121\116\198\109\019\218\146\195\007\163\167\194\142\173\019\066" ..
		-- tex:"8d8ef52193eed93e4a9781447974c66d"; x:-293.703735; y:-83.818420; z:36.919491
		"\206\096\032\039\171\091\180\024\226\020\075\222\190\009\010\208\018\004\147\195\096\243\090\066\015\111\020\066" ..
		-- tex:"ce602027ab5bb418e2144bdebe090ad0"; x:-294.031830; y:54.737675; z:37.108459
		"\195\224\165\096\149\237\141\154\142\172\147\238\097\010\006\109\165\095\157\195\167\229\102\194\205\037\021\066" ..
		-- tex:"c3e0a56095ed8d9a8eac93ee610a066d"; x:-314.747253; y:-57.724274; z:37.286919
		"\189\219\120\223\215\108\069\212\178\244\058\121\253\112\018\199\054\137\140\195\097\228\077\194\029\049\021\066" ..
		-- tex:"bddb78dfd76c45d4b2f43a79fd7012c7"; x:-281.071991; y:-51.473030; z:37.297966
		"\203\139\040\169\179\070\250\031\001\223\175\042\070\134\045\065\170\233\010\195\114\225\010\194\017\050\021\066" ..
		-- tex:"cb8b28a9b346fa1f01dfaf2a46862d41"; x:-138.912766; y:-34.720165; z:37.298897
		"\161\194\133\007\121\145\208\225\242\096\001\209\186\202\054\108\175\233\010\195\201\122\072\065\017\050\021\066",
		-- tex:"a1c285077991d0e1f26001d1baca366c"; x:-138.912842; y:12.529978; z:37.298897
	["Auchenai Crypts"] = 
		"\139\171\159\031\040\164\021\076\131\171\247\006\165\114\169\243\152\242\203\195\139\054\070\067\160\068\185\195" ..
		-- tex:"8bab9f1f28a4154c83abf706a572a9f3"; x:-407.895294; y:198.213074; z:-370.536163
		"\091\082\090\174\089\093\157\186\093\069\208\074\137\058\138\239\155\053\208\066\139\054\070\067\160\068\185\195" ..
		-- tex:"5b525aae595d9dba5d45d04a893a8aef"; x:104.104706; y:198.213074; z:-370.536163
		"\030\046\089\230\004\168\048\100\168\122\009\053\213\021\018\238\049\229\023\195\139\054\070\067\160\068\185\195" ..
		-- tex:"1e2e59e604a83064a87a0935d51512ee"; x:-151.895294; y:198.213074; z:-370.536163
		"\072\064\016\052\096\158\229\007\040\072\175\021\225\129\108\172\156\041\013\196\126\242\173\194\098\043\222\192" ..
		-- tex:"48401034609ee5072848af15e1816cac"; x:-564.650208; y:-86.973625; z:-6.942796
		"\091\111\221\006\186\136\062\219\115\229\063\095\156\247\110\159\223\211\024\195\188\139\204\194\118\001\163\192" ..
		-- tex:"5b6fdd06ba883edb73e53f5f9cf76e9f"; x:-152.827637; y:-102.272926; z:-5.093929
		"\196\165\047\190\020\173\157\198\216\014\218\148\113\151\199\106\239\105\204\195\188\139\204\194\118\001\163\192" ..
		-- tex:"c4a52fbe14ad9dc6d80eda947197c76a"; x:-408.827637; y:-102.272926; z:-5.093929
		"\109\240\146\193\117\208\035\162\132\132\022\092\201\242\173\040\244\097\087\194\018\206\186\193\181\125\005\192" ..
		-- tex:"6df092c175d023a28484165cc9f2ad28"; x:-53.845661; y:-23.350622; z:-2.085798
		"\028\143\172\105\154\148\080\038\082\249\166\157\005\102\118\201\130\039\074\067\018\206\186\193\181\125\005\192" ..
		-- tex:"1c8fac699a94502652f9a69d056676c9"; x:202.154339; y:-23.350622; z:-2.085798
		"\118\197\155\137\043\079\210\116\243\024\089\117\059\113\046\115\023\142\055\066\039\086\040\068\092\012\027\066" ..
		-- tex:"76c59b892b4fd274f31859753b712e73"; x:45.888763; y:673.346191; z:38.762074
		"\086\137\018\214\171\092\197\033\006\099\206\172\010\190\140\114\121\028\082\195\039\086\040\068\092\012\027\066" ..
		-- tex:"568912d6ab5cc5210663ceac0abe8c72"; x:-210.111237; y:673.346191; z:38.762074
		"\248\066\165\135\143\083\014\216\159\151\168\086\179\196\148\051\173\121\019\196\008\042\127\067\013\255\045\066" ..
		-- tex:"f842a5878f530ed89f97a856b3c49433"; x:-589.901245; y:255.164200; z:43.499077
		"\179\114\108\026\053\096\240\063\203\135\109\122\194\148\169\249\082\226\210\066\053\221\013\068\185\064\055\066" ..
		-- tex:"b3726c1a3560f03fcb876d7ac294a9f9"; x:105.442039; y:567.456421; z:45.813210
		"\239\181\208\052\209\064\196\010\118\238\186\160\015\050\014\120\082\226\210\066\107\186\155\067\185\064\055\066" ..
		-- tex:"efb5d034d140c40a76eebaa00f320e78"; x:105.442039; y:311.456421; z:45.813210
		"\090\010\237\178\035\013\142\025\153\066\101\000\115\073\036\101\148\184\180\067\053\221\013\068\185\064\055\066" ..
		-- tex:"5a0aedb2230d8e199942650073492465"; x:361.442039; y:567.456421; z:45.813210
		"\100\017\152\032\155\122\179\166\132\163\230\071\136\229\122\027\148\184\180\067\107\186\155\067\185\064\055\066" ..
		-- tex:"641198209b7ab3a684a3e64788e57a1b"; x:361.442039; y:311.456421; z:45.813210
		"\141\051\235\207\040\096\026\113\209\200\014\100\067\232\222\011\034\126\057\067\030\132\151\067\072\122\084\066" ..
		-- tex:"8d33ebcf28601a71d1c80e6443e8de0b"; x:185.492722; y:303.032196; z:53.119419
		"\196\097\129\078\076\031\059\165\213\138\135\249\040\254\224\191\251\225\059\067\043\201\034\068\086\122\084\066" ..
		-- tex:"c461814e4c1f3ba5d58a87f928fee0bf"; x:187.882751; y:651.143311; z:53.119473
		"\223\012\005\162\242\208\051\013\156\032\130\177\037\136\156\113\089\182\250\195\165\087\175\066\240\129\084\066",
		-- tex:"df0c05a2f2d0330d9c2082b125889c71"; x:-501.424622; y:87.671188; z:53.126896
	["Azjol-Nerub"] = 
		"\056\141\147\073\206\077\103\124\038\252\183\182\114\085\079\189\175\006\041\195\214\112\097\068\178\047\145\196" ..
		-- tex:"388d9349ce4d677c26fcb7b672554fbd"; x:-169.026123; y:901.763092; z:-1161.490601
		"\063\227\080\099\154\065\095\107\070\137\215\085\058\039\140\005\087\131\212\195\172\225\194\067\178\047\145\196" ..
		-- tex:"3fe350639a415f6b4689d7553a278c05"; x:-425.026123; y:389.763092; z:-1161.490601
		"\054\156\165\197\046\203\052\072\169\146\201\224\171\052\170\126\087\131\212\195\089\195\005\067\178\047\145\196" ..
		-- tex:"369ca5c52ecb3448a992c9e0ab34aa7e"; x:-425.026123; y:133.763092; z:-1161.490601
		"\203\244\166\063\095\137\187\061\232\201\169\153\082\044\030\240\087\131\212\195\075\121\244\194\178\047\145\196" ..
		-- tex:"cbf4a63f5f89bb3de8c9a999522c1ef0"; x:-425.026123; y:-122.236908; z:-1161.490601
		"\204\077\111\157\139\204\255\072\082\095\112\164\019\134\104\031\087\131\212\195\214\112\033\068\178\047\145\196" ..
		-- tex:"cc4d6f9d8bccff48525f70a41386681f"; x:-425.026123; y:645.763092; z:-1161.490601
		"\121\221\080\004\072\143\060\170\161\237\033\069\136\206\033\127\175\006\041\195\075\121\244\194\178\047\145\196" ..
		-- tex:"79dd5004488f3caaa1ed214588ce217f"; x:-169.026123; y:-122.236908; z:-1161.490601
		"\243\190\101\008\079\071\111\166\189\248\183\146\040\155\222\105\175\006\041\195\082\030\189\195\178\047\145\196" ..
		-- tex:"f3be65084f476fa6bdf8b792289bde69"; x:-169.026123; y:-378.236908; z:-1161.490601
		"\174\239\021\179\097\106\067\240\072\050\094\059\031\134\231\158\175\006\041\195\089\195\005\067\178\047\145\196" ..
		-- tex:"aeef15b3616a43f048325e3b1f86e79e"; x:-169.026123; y:133.763092; z:-1161.490601
		"\156\200\070\026\092\098\101\158\158\024\081\179\091\215\098\238\175\006\041\195\172\225\194\067\178\047\145\196" ..
		-- tex:"9cc8461a5c62659e9e1851b35bd762ee"; x:-169.026123; y:389.763092; z:-1161.490601
		"\245\097\152\202\226\089\224\009\028\119\028\090\064\112\038\058\087\131\212\195\082\030\189\195\178\047\145\196" ..
		-- tex:"f56198cae259e0091c771c5a4070263a"; x:-425.026123; y:-378.236908; z:-1161.490601
		"\070\153\189\186\193\055\188\012\036\127\140\034\217\217\037\077\159\242\173\066\075\121\244\194\178\047\145\196" ..
		-- tex:"4699bdbac137bc0c247f8c22d9d9254d"; x:86.973877; y:-122.236908; z:-1161.490601
		"\018\111\250\091\164\148\228\010\210\144\005\143\248\228\058\030\159\242\173\066\214\112\097\068\178\047\145\196" ..
		-- tex:"126ffa5ba494e40ad290058ff8e43a1e"; x:86.973877; y:901.763092; z:-1161.490601
		"\228\103\090\132\076\203\034\237\012\177\200\184\093\111\253\026\167\124\171\067\075\121\244\194\178\047\145\196" ..
		-- tex:"e4675a844ccb22ed0cb1c8b85d6ffd1a"; x:342.973877; y:-122.236908; z:-1161.490601
		"\126\005\231\168\071\110\222\224\250\233\093\253\149\154\230\094\159\242\173\066\082\030\189\195\178\047\145\196" ..
		-- tex:"7e05e7a8476edee0fae95dfd959ae65e"; x:86.973877; y:-378.236908; z:-1161.490601
		"\236\113\211\065\193\000\232\238\172\215\021\079\040\123\244\082\159\242\173\066\214\112\033\068\178\047\145\196" ..
		-- tex:"ec71d341c100e8eeacd7154f287bf452"; x:86.973877; y:645.763092; z:-1161.490601
		"\173\026\224\154\251\004\034\090\180\121\187\049\123\097\030\217\159\242\173\066\089\195\005\067\178\047\145\196" ..
		-- tex:"ad1ae09afb04225ab479bb317b611ed9"; x:86.973877; y:133.763092; z:-1161.490601
		"\246\151\002\221\011\119\200\192\000\172\011\036\205\062\020\223\159\242\173\066\172\225\194\067\178\047\145\196" ..
		-- tex:"f69702dd0b77c8c000ac0b24cd3e14df"; x:86.973877; y:389.763092; z:-1161.490601
		"\158\157\108\036\187\059\013\089\177\073\129\033\201\038\045\173\175\006\041\195\214\112\033\068\178\047\145\196" ..
		-- tex:"9e9d6c24bb3b0d59b1498121c9262dad"; x:-169.026123; y:645.763092; z:-1161.490601
		"\072\091\160\159\240\009\150\255\193\041\213\037\198\119\011\034\039\098\145\195\140\164\140\195\078\164\155\195" ..
		-- tex:"485ba09ff00996ffc129d525c6770b22"; x:-290.766846; y:-281.285553; z:-311.283661
		"\030\090\002\111\208\213\171\043\088\119\069\215\107\046\121\180\175\059\093\067\207\072\202\193\078\164\155\195" ..
		-- tex:"1e5a026fd0d5ab2b587745d76b2e79b4"; x:221.233154; y:-25.285553; z:-311.283661
		"\191\100\193\203\013\001\058\083\017\204\031\079\078\106\144\078\063\017\011\194\140\164\140\195\078\164\155\195" ..
		-- tex:"bf64c1cb0d013a5311cc1f4f4e6a904e"; x:-34.766846; y:-281.285553; z:-311.283661
		"\254\047\123\112\112\138\207\104\239\099\138\152\035\245\127\203\039\098\145\195\207\072\202\193\078\164\155\195" ..
		-- tex:"fe2f7b70708acf68ef638a9823f57fcb"; x:-290.766846; y:-25.285553; z:-311.283661
		"\128\029\056\223\067\161\086\168\170\131\222\019\006\064\253\085\063\017\011\194\207\072\202\193\078\164\155\195" ..
		-- tex:"801d38df43a156a8aa83de130640fd55"; x:-34.766846; y:-25.285553; z:-311.283661
		"\221\092\193\060\220\126\210\246\057\125\022\157\003\130\038\086\039\098\145\195\229\182\102\067\078\164\155\195" ..
		-- tex:"dd5cc13cdc7ed2f6397d169d03822656"; x:-290.766846; y:230.714447; z:-311.283661
		"\098\093\212\046\135\023\066\089\132\246\253\253\049\049\030\199\175\059\093\067\140\164\140\195\078\164\155\195" ..
		-- tex:"625dd42e8717425984f6fdfd31311ec7"; x:221.233154; y:-281.285553; z:-311.283661
		"\141\180\008\108\100\214\080\017\114\162\112\160\125\188\241\118\063\017\011\194\229\182\102\067\078\164\155\195" ..
		-- tex:"8db4086c64d6501172a270a07dbcf176"; x:-34.766846; y:230.714447; z:-311.283661
		"\038\134\094\054\226\175\015\232\004\172\251\023\013\098\174\052\093\036\182\195\171\095\033\066\096\124\008\067" ..
		-- tex:"26865e36e2af0fe804acfb170d62ae34"; x:-364.284119; y:40.343430; z:136.485855
		"\017\235\022\140\102\087\229\028\107\226\004\244\184\073\028\250\119\145\216\194\020\168\087\195\096\124\008\067" ..
		-- tex:"11eb168c6657e51c6be204f4b8491cfa"; x:-108.284119; y:-215.656570; z:136.485855
		"\049\253\183\021\178\057\178\121\239\029\089\252\229\114\225\210\119\145\216\194\171\095\033\066\096\124\008\067" ..
		-- tex:"31fdb715b239b279ef1d59fce572e1d2"; x:-108.284119; y:40.343430; z:136.485855
		"\235\018\017\069\061\094\048\000\141\051\086\181\085\160\232\062\093\036\182\195\020\168\087\195\096\124\008\067" ..
		-- tex:"eb1211453d5e30008d3356b555a0e83e"; x:-364.284119; y:-215.656570; z:136.485855
		"\167\149\241\036\025\222\229\179\025\148\082\046\190\128\253\143\067\183\019\067\020\168\087\195\096\124\008\067" ..
		-- tex:"a795f12419dee5b31994522ebe80fd8f"; x:147.715881; y:-215.656570; z:136.485855
		"\152\114\231\004\041\226\166\101\035\211\216\023\185\196\243\076\119\145\216\194\245\043\148\067\096\124\008\067" ..
		-- tex:"9872e70429e2a66523d3d817b9c4f34c"; x:-108.284119; y:296.343430; z:136.485855
		"\197\143\063\214\244\047\126\079\219\217\216\148\068\168\081\017\080\080\193\067\044\150\051\196\062\137\184\067" ..
		-- tex:"c58f3fd6f42f7e4fdbd9d89444a85111"; x:386.627464; y:-718.346497; z:369.072235
		"\041\172\079\002\096\237\190\162\218\144\179\222\034\083\251\034\188\190\250\194\044\150\051\196\062\137\184\067" ..
		-- tex:"29ac4f0260edbea2da90b3de2253fb22"; x:-125.372536; y:-718.346497; z:369.072235
		"\004\008\128\038\095\240\120\103\002\005\002\160\224\181\026\189\161\160\002\067\089\044\231\195\062\137\184\067" ..
		-- tex:"040880265ff07867020502a0e0b51abd"; x:130.627464; y:-462.346497; z:369.072235
		"\016\189\106\100\249\137\105\186\022\078\189\031\094\155\053\054\188\190\250\194\089\044\231\195\062\137\184\067" ..
		-- tex:"10bd6a64f98969ba164ebd1f5e9b3536"; x:-125.372536; y:-462.346497; z:369.072235
		"\177\093\174\166\082\101\024\179\050\155\192\080\068\215\043\033\161\160\002\067\044\150\051\196\062\137\184\067" ..
		-- tex:"b15daea6526518b3329bc05044d72b21"; x:130.627464; y:-718.346497; z:369.072235
		"\048\245\081\052\236\180\139\076\134\005\238\170\049\041\228\246\188\190\250\194\179\088\078\195\062\137\184\067",
		-- tex:"30f55134ecb48b4c8605eeaa3129e4f6"; x:-125.372536; y:-206.346497; z:369.072235
	["Black Temple"] = 
		"\216\055\249\074\191\061\180\025\002\168\229\149\090\066\004\237\163\098\105\194\255\214\155\063\154\057\064\193" ..
		-- tex:"d837f94abf3db41902a8e5955a4204ed"; x:-58.346329; y:1.217499; z:-12.014064
		"\069\096\041\156\143\124\019\105\161\077\176\205\170\019\191\003\163\098\105\194\081\200\126\195\154\057\064\193" ..
		-- tex:"4560299c8f7c1369a14db0cdaa13bf03"; x:-58.346329; y:-254.782501; z:-12.014064
		"\055\125\193\082\156\128\138\001\095\036\039\171\243\078\092\167\037\021\038\195\243\067\013\196\161\163\057\066" ..
		-- tex:"377dc1529c808a015f2427abf34e5ca7"; x:-166.082611; y:-565.061768; z:46.409798
		"\027\219\169\197\084\235\098\151\196\151\161\059\044\011\002\208\037\021\038\195\243\067\077\196\161\163\057\066" ..
		-- tex:"1bdba9c554eb6297c497a13b2c0b02d0"; x:-166.082611; y:-821.061768; z:46.409798
		"\181\193\009\088\098\146\251\071\022\096\062\219\203\236\087\214\037\021\038\195\231\135\154\195\161\163\057\066" ..
		-- tex:"b5c109586292fb4716603edbcbec57d6"; x:-166.082611; y:-309.061768; z:46.409798
		"\243\217\233\169\162\193\059\099\179\129\208\141\114\093\099\188\113\110\054\195\153\044\147\196\078\110\082\067" ..
		-- tex:"f3d9e9a9a2c13b63b381d08d725d63bc"; x:-182.431427; y:-1177.393799; z:210.430893
		"\115\233\148\054\030\068\123\234\081\074\218\192\088\127\163\171\027\035\147\066\051\089\102\196\078\110\082\067" ..
		-- tex:"73e994361e447bea514adac0587fa3ab"; x:73.568573; y:-921.393799; z:210.430893
		"\171\106\120\117\102\187\117\085\025\207\040\037\223\199\091\016\113\110\054\195\051\089\102\196\078\110\082\067" ..
		-- tex:"ab6a787566bb755519cf2825dfc75b10"; x:-182.431427; y:-921.393799; z:210.430893
		"\223\081\189\048\132\012\025\235\149\198\025\108\131\173\069\084\027\035\147\066\153\044\147\196\078\110\082\067" ..
		-- tex:"df51bd30840c19eb95c6196c83ad4554"; x:73.568573; y:-1177.393799; z:210.430893
		"\159\182\056\195\240\248\164\227\209\109\067\210\097\190\132\165\231\016\155\195\252\023\132\196\244\140\103\067" ..
		-- tex:"9fb638c3f0f8a4e3d16d43d261be84a5"; x:-310.132080; y:-1056.749634; z:231.550613
		"\249\218\237\093\012\156\111\134\071\177\040\026\228\189\029\092\115\136\077\196\252\023\132\196\244\140\103\067" ..
		-- tex:"f9daed5d0c9c6f8647b1281ae4bd1d5c"; x:-822.132080; y:-1056.749634; z:231.550613
		"\101\099\037\006\206\013\077\220\102\043\230\006\000\137\117\240\115\136\013\196\252\023\132\196\244\140\103\067" ..
		-- tex:"65632506ce0d4ddc662be606008975f0"; x:-566.132080; y:-1056.749634; z:231.550613
		"\242\076\096\246\129\246\198\066\026\150\213\141\194\032\204\240\072\043\009\196\195\197\155\196\060\013\152\067" ..
		-- tex:"f24c60f681f6c6421a96d58dc220ccf0"; x:-548.676331; y:-1246.180176; z:304.103424
		"\164\229\038\242\028\105\145\082\074\157\165\145\037\160\125\062\205\248\135\195\160\040\156\196\103\194\189\067" ..
		-- tex:"a4e526f21c6991524a9da59125a07d3e"; x:-271.943787; y:-1249.269653; z:379.518799
		"\166\088\063\020\002\143\129\052\009\197\158\134\073\024\203\239\205\248\135\195\160\040\188\196\103\194\189\067" ..
		-- tex:"a6583f14028f813409c59e864918cbef"; x:-271.943787; y:-1505.269653; z:379.518799
		"\114\174\214\175\229\043\044\184\166\216\105\150\056\194\000\078\102\252\003\196\160\040\156\196\103\194\189\067" ..
		-- tex:"72aed6afe52b2cb8a6d8699638c2004e"; x:-527.943787; y:-1249.269653; z:379.518799
		"\214\003\199\184\243\253\037\202\073\048\118\122\240\085\231\125\102\252\067\196\160\040\188\196\103\194\189\067" ..
		-- tex:"d603c7b8f3fd25ca4930767af055e77d"; x:-783.943787; y:-1505.269653; z:379.518799
		"\043\124\122\218\106\034\040\070\193\109\211\165\100\225\107\006\102\252\067\196\160\040\156\196\103\194\189\067" ..
		-- tex:"2b7c7ada6a222846c16dd3a564e16b06"; x:-783.943787; y:-1249.269653; z:379.518799
		"\247\156\036\024\231\146\012\106\145\095\187\178\153\008\096\187\102\252\003\196\160\040\188\196\103\194\189\067" ..
		-- tex:"f79c2418e7920c6a915fbbb2990860bb"; x:-527.943787; y:-1505.269653; z:379.518799
		"\094\088\186\237\002\047\245\125\080\130\038\087\215\233\152\201\177\201\226\196\210\051\217\196\013\126\200\067" ..
		-- tex:"5e58baed022ff57d50822657d7e998c9"; x:-1814.302979; y:-1737.619507; z:400.984802
		"\184\022\184\110\089\131\076\147\076\002\155\218\047\238\226\252\177\201\226\196\210\051\185\196\013\126\200\067" ..
		-- tex:"b816b86e59834c934c029bda2feee2fc"; x:-1814.302979; y:-1481.619507; z:400.984802
		"\115\009\083\043\080\105\198\212\206\225\018\026\237\059\220\189\216\100\001\197\210\051\217\196\013\126\200\067" ..
		-- tex:"7309532b5069c6d4cee1121aed3bdcbd"; x:-2070.302979; y:-1737.619507; z:400.984802
		"\105\220\087\196\152\064\050\107\105\197\151\152\052\233\086\056\216\100\001\197\210\051\185\196\013\126\200\067" ..
		-- tex:"69dc57c49840326b69c5979834e95638"; x:-2070.302979; y:-1481.619507; z:400.984802
		"\130\116\108\144\086\061\209\175\127\204\021\003\051\238\145\191\232\229\130\195\109\161\195\196\045\171\225\067" ..
		-- tex:"82746c90563dd1af7fcc150333ee91bf"; x:-261.796173; y:-1565.044678; z:451.337341
		"\056\253\041\213\078\083\097\179\043\009\001\202\104\180\230\218\122\154\189\196\131\077\003\197\140\062\240\067" ..
		-- tex:"38fd29d54e5361b32b0901ca68b4e6da"; x:-1516.827515; y:-2100.844727; z:480.488678
		"\159\193\075\081\247\037\066\116\208\119\251\137\143\117\244\182\122\154\221\196\131\077\003\197\140\062\240\067" ..
		-- tex:"9fc14b51f7254274d077fb898f75f4b6"; x:-1772.827515; y:-2100.844727; z:480.488678
		"\089\168\070\103\112\012\090\088\143\163\066\161\026\188\191\238\009\209\223\196\196\150\025\197\117\152\241\067" ..
		-- tex:"59a84667700c5a588fa342a11abcbfee"; x:-1790.532471; y:-2457.423096; z:483.191101
		"\166\128\207\115\047\139\015\243\238\035\113\163\212\006\130\030\009\209\191\196\196\150\009\197\117\152\241\067" ..
		-- tex:"a680cf732f8b0ff3ee2371a3d406821e"; x:-1534.532471; y:-2201.423096; z:483.191101
		"\167\218\137\080\182\105\238\011\142\216\138\206\025\032\238\026\009\209\191\196\196\150\025\197\117\152\241\067" ..
		-- tex:"a7da8950b669ee0b8ed88ace1920ee1a"; x:-1534.532471; y:-2457.423096; z:483.191101
		"\017\047\022\061\044\232\058\080\111\146\133\150\049\198\070\010\009\209\223\196\196\150\009\197\117\152\241\067" ..
		-- tex:"112f163d2ce83a506f92859631c6460a"; x:-1790.532471; y:-2201.423096; z:483.191101
		"\222\068\073\107\080\098\208\165\063\228\009\118\189\068\087\077\150\089\235\196\193\076\020\197\181\108\003\068" ..
		-- tex:"de44496b5062d0a53fe40976bd44574d"; x:-1882.799683; y:-2372.797363; z:525.698608
		"\040\228\134\079\050\185\053\163\064\170\088\222\155\180\039\160\115\011\227\196\221\124\238\196\094\122\016\068" ..
		-- tex:"28e4864f32b935a340aa58de9bb427a0"; x:-1816.357910; y:-1907.902100; z:577.912048
		"\219\098\224\073\016\102\149\139\189\081\093\143\116\209\215\230\185\133\001\197\110\062\023\197\094\122\016\068" ..
		-- tex:"db62e0491066958bbd515d8f74d1d7e6"; x:-2072.357910; y:-2419.902100; z:577.912048
		"\108\200\115\129\111\073\159\055\062\184\229\068\025\175\177\104\115\011\227\196\110\062\007\197\094\122\016\068" ..
		-- tex:"6cc873816f499f373eb8e54419afb168"; x:-1816.357910; y:-2163.902100; z:577.912048
		"\132\139\056\126\112\134\200\191\236\162\179\021\125\168\238\091\185\133\001\197\110\062\007\197\094\122\016\068" ..
		-- tex:"848b387e7086c8bfeca2b3157da8ee5b"; x:-2072.357910; y:-2163.902100; z:577.912048
		"\142\116\175\071\066\037\049\107\025\053\114\129\041\068\148\202\115\011\227\196\110\062\023\197\094\122\016\068" ..
		-- tex:"8e74af474225316b19357281294494ca"; x:-1816.357910; y:-2419.902100; z:577.912048
		"\078\246\177\115\190\250\125\198\212\182\031\101\016\147\096\130\185\133\001\197\221\124\238\196\094\122\016\068" ..
		-- tex:"4ef6b173befa7dc6d4b61f6510936082"; x:-2072.357910; y:-1907.902100; z:577.912048
		"\009\080\011\197\129\244\149\014\239\119\176\130\142\134\200\217\161\207\225\196\012\160\212\196\044\186\016\068" ..
		-- tex:"09500bc581f4950eef77b0828e86c8d9"; x:-1806.488525; y:-1701.001587; z:578.908997
		"\137\229\001\152\151\214\098\250\209\133\156\003\141\079\134\058\250\235\143\196\128\041\018\197\188\211\016\068" ..
		-- tex:"89e5019897d662fad1859c038d4f863a"; x:-1151.374390; y:-2338.593994; z:579.308411
		"\146\209\248\140\184\115\122\061\141\065\215\075\013\091\144\174\113\054\148\196\000\202\022\197\164\029\017\068" ..
		-- tex:"92d1f88cb8737a3d8d41d74b0d5b90ae"; x:-1185.701416; y:-2412.625244; z:580.463196
		"\179\041\179\227\149\050\011\024\057\060\182\050\121\186\004\051\113\054\180\196\000\202\022\197\164\029\017\068" ..
		-- tex:"b329b3e395320b18393cb63279ba0433"; x:-1441.701416; y:-2412.625244; z:580.463196
		"\248\133\238\165\106\111\141\241\058\209\199\205\179\011\208\176\204\076\216\196\167\089\209\196\157\049\017\068" ..
		-- tex:"f885eea56a6f8df13ad1c7cdb30bd0b0"; x:-1730.400024; y:-1674.801758; z:580.775269
		"\038\220\041\208\052\010\159\212\205\244\208\014\244\017\072\229\204\076\184\196\211\172\008\197\157\049\017\068" ..
		-- tex:"26dc29d0340a9fd4cdf4d00ef41148e5"; x:-1474.400024; y:-2186.801758; z:580.775269
		"\233\066\208\254\088\058\110\206\124\023\186\212\027\247\055\040\204\076\184\196\167\089\209\196\157\049\017\068" ..
		-- tex:"e942d0fe583a6ece7c17bad41bf73728"; x:-1474.400024; y:-1674.801758; z:580.775269
		"\067\050\144\028\104\011\031\223\183\219\176\069\113\060\072\127\204\076\152\196\167\089\241\196\157\049\017\068" ..
		-- tex:"4332901c680b1fdfb7dbb045713c487f"; x:-1218.400024; y:-1930.801758; z:580.775269
		"\205\175\230\091\174\202\231\074\188\239\230\227\051\240\119\140\204\076\152\196\167\089\209\196\157\049\017\068" ..
		-- tex:"cdafe65baecae74abcefe6e333f0778c"; x:-1218.400024; y:-1674.801758; z:580.775269
		"\011\215\116\238\071\131\189\219\135\248\123\042\102\044\052\053\204\076\152\196\211\172\008\197\157\049\017\068" ..
		-- tex:"0bd774ee4783bddb87f87b2a662c3435"; x:-1218.400024; y:-2186.801758; z:580.775269
		"\119\145\027\122\133\065\208\126\126\079\141\029\023\148\066\052\204\076\216\196\167\089\241\196\157\049\017\068" ..
		-- tex:"77911b7a8541d07e7e4f8d1d17944234"; x:-1730.400024; y:-1930.801758; z:580.775269
		"\150\162\248\064\113\109\229\037\129\010\250\216\019\078\122\245\204\076\216\196\211\172\008\197\157\049\017\068" ..
		-- tex:"96a2f840716de525810afad8134e7af5"; x:-1730.400024; y:-2186.801758; z:580.775269
		"\017\217\221\209\152\133\218\193\175\087\100\130\181\058\239\038\204\076\184\196\167\089\241\196\157\049\017\068" ..
		-- tex:"11d9ddd19885dac1af576482b53aef26"; x:-1474.400024; y:-1930.801758; z:580.775269
		"\013\009\030\069\182\138\115\052\013\203\059\081\158\184\023\045\067\095\142\196\120\059\228\196\094\132\017\068" ..
		-- tex:"0d091e45b68a73340dcb3b519eb8172d"; x:-1138.977051; y:-1825.858521; z:582.068298
		"\161\103\192\045\228\205\072\117\150\046\005\084\215\132\080\060\066\169\139\196\253\235\249\196\094\132\017\068" ..
		-- tex:"a167c02de4cd4875962e0554d784503c"; x:-1117.289429; y:-1999.374756; z:582.068298
		"\174\218\017\071\077\169\249\066\072\160\132\168\066\041\196\144\116\060\143\196\141\120\242\196\087\134\017\068" ..
		-- tex:"aeda11474da9f94248a084a84229c490"; x:-1145.889282; y:-1939.767334; z:582.099121
		"\025\182\253\175\072\251\005\034\002\099\210\070\007\032\102\099\227\099\142\196\013\138\248\196\224\142\017\068" ..
		-- tex:"19b6fdaf48fb05220263d24607206663"; x:-1139.121582; y:-1988.314209; z:582.232483
		"\176\149\188\160\203\000\189\212\113\077\041\184\078\082\248\015\194\196\151\196\003\100\200\196\164\143\017\068" ..
		-- tex:"b095bca0cb00bdd4714d29b84e52f80f"; x:-1214.148804; y:-1603.125488; z:582.244446
		"\052\240\213\153\126\140\005\156\209\018\135\129\102\065\137\176\194\196\183\196\003\100\168\196\164\143\017\068" ..
		-- tex:"34f0d5997e8c059cd1128781664189b0"; x:-1470.148804; y:-1347.125488; z:582.244446
		"\221\165\073\076\154\113\122\016\116\187\121\076\114\217\113\154\194\196\151\196\003\100\168\196\164\143\017\068" ..
		-- tex:"dda5494c9a717a1074bb794c72d9719a"; x:-1214.148804; y:-1347.125488; z:582.244446
		"\238\197\070\060\226\216\023\090\191\037\056\073\128\176\222\254\194\196\183\196\003\100\200\196\164\143\017\068" ..
		-- tex:"eec5463ce2d8175abf25384980b0defe"; x:-1470.148804; y:-1603.125488; z:582.244446
		"\006\006\200\145\058\081\214\079\185\038\229\217\189\112\063\155\146\008\146\196\189\124\012\197\126\252\029\068" ..
		-- tex:"0606c8913a51d64fb926e5d9bd703f9b"; x:-1168.267944; y:-2247.796387; z:631.945251
		"\160\169\240\035\146\254\006\123\251\250\098\199\125\226\227\149\146\008\146\196\123\249\248\196\126\252\029\068" ..
		-- tex:"a0a9f02392fe067bfbfa62c77de2e395"; x:-1168.267944; y:-1991.796387; z:631.945251
		"\085\035\122\172\056\163\235\018\058\158\088\021\072\161\053\005\253\030\237\196\227\051\204\196\127\000\030\068" ..
		-- tex:"55237aac38a3eb123a9e581548a13505"; x:-1896.968506; y:-1633.621582; z:632.007813
		"\000\064\196\029\047\139\057\000\095\159\139\040\178\223\121\096\067\156\133\196\092\088\019\197\028\215\030\068" ..
		-- tex:"0040c41d2f8b39005f9f8b28b2df7960"; x:-1068.883301; y:-2357.522705; z:635.361145
		"\117\082\196\085\124\155\073\171\110\155\236\219\173\089\046\042\011\175\239\196\155\127\214\196\238\218\030\068" ..
		-- tex:"7552c4557c9b49ab6e9becdbad592e2a"; x:-1917.470215; y:-1715.987793; z:635.420837
		"\212\119\015\135\187\245\112\188\103\061\200\036\033\054\135\073\179\197\239\196\116\234\181\196\181\130\040\068" ..
		-- tex:"d4770f87bbf570bc673dc82421368749"; x:-1918.178223; y:-1455.326782; z:674.042358
		"\111\002\135\184\214\210\143\034\195\149\252\161\023\104\002\109\171\111\240\196\088\230\194\196\090\232\041\068" ..
		-- tex:"6f0287b8d6d28f22c395fca11768026d"; x:-1923.489746; y:-1559.198364; z:679.630554
		"\253\172\010\080\216\230\202\072\072\153\125\212\081\143\097\065\081\200\223\196\113\167\194\196\156\049\043\068" ..
		-- tex:"fdac0a50d8e6ca4848997dd4518f6141"; x:-1790.260010; y:-1557.232666; z:684.775208
		"\075\130\160\063\039\220\138\243\162\253\190\133\001\039\017\171\037\223\164\196\017\218\155\196\177\148\043\068" ..
		-- tex:"4b82a03f27dc8af3a2fdbe85012711ab"; x:-1318.973389; y:-1246.814697; z:686.323364
		"\112\238\043\129\051\240\105\177\210\007\206\125\115\119\180\239\037\223\228\196\017\218\187\196\177\148\043\068" ..
		-- tex:"70ee2b8133f069b1d207ce7d7377b4ef"; x:-1830.973389; y:-1502.814697; z:686.323364
		"\106\063\212\018\134\033\116\108\086\144\001\011\060\135\054\166\037\223\132\196\017\218\187\196\177\148\043\068" ..
		-- tex:"6a3fd4128621746c5690010b3c8736a6"; x:-1062.973389; y:-1502.814697; z:686.323364
		"\101\234\179\069\255\112\053\213\178\087\188\187\003\158\033\077\037\223\164\196\017\218\187\196\177\148\043\068" ..
		-- tex:"65eab345ff7035d5b257bcbb039e214d"; x:-1318.973389; y:-1502.814697; z:686.323364
		"\040\047\129\051\033\249\015\015\138\053\000\023\224\143\118\027\037\223\196\196\017\218\155\196\177\148\043\068" ..
		-- tex:"282f813321f90f0f8a350017e08f761b"; x:-1574.973389; y:-1246.814697; z:686.323364
		"\091\169\102\044\215\203\134\119\067\037\080\125\165\229\210\229\146\111\002\197\017\218\187\196\177\148\043\068" ..
		-- tex:"5ba9662cd7cb86774325507da5e5d2e5"; x:-2086.973389; y:-1502.814697; z:686.323364
		"\078\066\201\033\137\247\187\144\150\097\119\102\219\084\108\096\037\223\196\196\017\218\187\196\177\148\043\068" ..
		-- tex:"4e42c92189f7bb9096617766db546c60"; x:-1574.973389; y:-1502.814697; z:686.323364
		"\031\197\082\086\215\246\118\191\118\230\134\131\225\010\170\088\091\196\168\196\014\104\204\196\011\134\056\068" ..
		-- tex:"1fc55256d7f676bf76e68683e10aaa58"; x:-1350.136230; y:-1635.251831; z:738.094482
		"\094\188\197\155\052\150\126\128\048\198\118\006\207\215\201\099\149\122\002\197\048\234\025\197\159\206\056\068" ..
		-- tex:"5ebcc59b34967e8030c67606cfd7c963"; x:-2087.661621; y:-2462.636963; z:739.228516
		"\106\028\195\219\122\124\189\032\144\154\098\200\130\067\131\234\043\245\132\196\048\234\025\197\159\206\056\068" ..
		-- tex:"6a1cc3db7a7cbd20909a62c8824383ea"; x:-1063.661621; y:-2462.636963; z:739.228516
		"\136\079\186\107\203\189\243\248\242\091\117\040\174\185\092\046\043\245\164\196\048\234\025\197\159\206\056\068" ..
		-- tex:"884fba6bcbbdf3f8f25b7528aeb95c2e"; x:-1319.661621; y:-2462.636963; z:739.228516
		"\131\249\122\018\243\135\047\125\215\018\026\087\214\139\049\202\043\245\228\196\048\234\025\197\159\206\056\068" ..
		-- tex:"83f97a12f3872f7dd7121a57d68b31ca"; x:-1831.661621; y:-2462.636963; z:739.228516
		"\100\028\187\153\043\174\255\126\136\212\148\146\207\169\104\095\043\245\196\196\048\234\025\197\159\206\056\068" ..
		-- tex:"641cbb992baeff7e88d49492cfa9685f"; x:-1575.661621; y:-2462.636963; z:739.228516
		"\031\231\089\205\170\245\056\026\022\154\066\141\196\109\015\103\043\245\196\196\048\234\009\197\159\206\056\068" ..
		-- tex:"1fe759cdaaf5381a169a428dc46d0f67"; x:-1575.661621; y:-2206.636963; z:739.228516
		"\005\056\025\155\129\131\254\215\060\200\154\087\247\109\052\037\043\245\228\196\048\234\009\197\159\206\056\068" ..
		-- tex:"0538199b8183fed73cc89a57f76d3425"; x:-1831.661621; y:-2206.636963; z:739.228516
		"\142\200\139\089\188\058\082\106\070\150\251\206\045\161\232\157\118\197\164\196\225\088\187\196\155\153\057\068" ..
		-- tex:"8ec88b59bc3a526a4696fbce2da1e89d"; x:-1318.170776; y:-1498.777588; z:742.400146
		"\069\172\243\137\077\228\129\098\178\047\184\123\150\248\170\038\044\090\168\196\248\100\011\197\169\154\057\068" ..
		-- tex:"45acf3894de48162b22fb87b96f8aa26"; x:-1346.817993; y:-2230.310791; z:742.416626
		"\198\232\148\008\190\233\056\128\142\080\122\042\110\085\026\032\080\184\159\196\031\204\014\197\018\156\057\068" ..
		-- tex:"c6e89408bee938808e507a2a6e551a20"; x:-1277.759888; y:-2284.757813; z:742.438660
		"\071\021\214\051\226\135\140\208\243\186\136\191\201\164\160\059\145\161\227\196\012\214\014\197\175\156\057\068" ..
		-- tex:"4715d633e2878cd0f3ba88bfc9a4a03b"; x:-1821.049072; y:-2285.378174; z:742.448242
		"\200\198\179\198\034\074\024\197\252\224\238\063\143\174\170\101\113\164\236\196\151\041\214\196\008\183\059\068" ..
		-- tex:"c8c6b3c6224a18c5fce0ee3f8faeaa65"; x:-1893.138916; y:-1713.299805; z:750.859924
		"\218\075\193\059\110\062\114\236\057\099\210\165\201\246\236\133\113\164\172\196\151\041\214\196\008\183\059\068" ..
		-- tex:"da4bc13b6e3e72ec3963d2a5c9f6ec85"; x:-1381.138916; y:-1713.299805; z:750.859924
		"\061\245\206\124\149\110\032\117\183\009\012\032\207\129\021\003\113\164\172\196\151\041\246\196\008\183\059\068" ..
		-- tex:"3df5ce7c956e2075b7090c20cf811503"; x:-1381.138916; y:-1969.299805; z:750.859924
		"\218\003\014\079\192\057\001\082\140\175\021\137\140\097\165\072\113\164\204\196\151\041\214\196\008\183\059\068" ..
		-- tex:"da030e4fc03901528caf15898c61a548"; x:-1637.138916; y:-1713.299805; z:750.859924
		"\117\089\145\181\226\230\238\252\061\200\042\200\041\023\145\206\113\164\204\196\203\020\011\197\008\183\059\068" ..
		-- tex:"755991b5e2e6eefc3dc82ac8291791ce"; x:-1637.138916; y:-2225.299805; z:750.859924
		"\037\208\070\175\091\116\167\085\077\224\192\017\132\199\127\048\113\164\236\196\203\020\011\197\008\183\059\068" ..
		-- tex:"25d046af5b74a7554de0c01184c77f30"; x:-1893.138916; y:-2225.299805; z:750.859924
		"\236\144\005\082\086\199\117\000\186\129\030\239\078\028\008\083\113\164\236\196\151\041\246\196\008\183\059\068" ..
		-- tex:"ec90055256c77500ba811eef4e1c0853"; x:-1893.138916; y:-1969.299805; z:750.859924
		"\011\029\006\193\183\181\186\251\202\152\134\202\048\213\033\142\062\102\176\196\109\022\220\196\086\133\096\068" ..
		-- tex:"0b1d06c1b7b5bafbca9886ca30d5218e"; x:-1411.195190; y:-1760.700928; z:898.083435
		"\002\163\193\249\169\238\032\123\183\154\188\081\134\113\005\244\062\102\176\196\109\022\252\196\086\133\096\068" ..
		-- tex:"02a3c1f9a9ee207bb79abc51867105f4"; x:-1411.195190; y:-2016.700928; z:898.083435
		"\088\081\151\174\190\159\240\222\165\163\113\203\048\210\215\138\062\102\208\196\109\022\252\196\086\133\096\068" ..
		-- tex:"585197aebe9ff0dea5a371cb30d2d78a"; x:-1667.195190; y:-2016.700928; z:898.083435
		"\079\140\218\104\059\206\126\250\208\161\233\037\068\245\126\246\062\102\208\196\109\022\220\196\086\133\096\068" ..
		-- tex:"4f8cda683bce7efad0a1e92544f57ef6"; x:-1667.195190; y:-1760.700928; z:898.083435
		"\168\042\204\247\100\161\119\091\080\064\044\087\168\205\182\125\113\239\188\196\118\063\216\196\011\007\097\068" ..
		-- tex:"a82accf764a1775b50402c57a8cdb67d"; x:-1511.482666; y:-1729.983276; z:900.110107
		"\211\120\198\040\118\184\232\153\191\102\096\046\125\030\106\213\101\046\189\196\198\117\254\196\252\088\117\068" ..
		-- tex:"d378c62876b8e899bf66602e7d1e6ad5"; x:-1513.449951; y:-2035.680542; z:981.390442
		"\206\205\208\233\149\088\095\230\040\162\233\017\224\251\179\169\025\034\206\196\062\161\003\197\147\012\121\068" ..
		-- tex:"cecdd0e995585fe628a2e911e0fbb3a9"; x:-1649.065674; y:-2106.077881; z:996.196533
		"\022\112\100\044\030\213\179\123\146\052\248\156\237\041\090\204\025\034\206\196\125\066\231\196\147\012\121\068" ..
		-- tex:"1670642c1ed5b37b9234f89ced295acc"; x:-1649.065674; y:-1850.077881; z:996.196533
		"\161\127\098\026\085\089\089\247\015\229\190\225\061\079\180\036\025\034\174\196\125\066\231\196\147\012\121\068" ..
		-- tex:"a17f621a555959f70fe5bee13d4fb424"; x:-1393.065674; y:-1850.077881; z:996.196533
		"\019\175\133\088\235\248\003\194\079\097\047\168\235\089\176\141\025\034\174\196\062\161\003\197\147\012\121\068" ..
		-- tex:"13af8558ebf803c24f612fa8eb59b08d"; x:-1393.065674; y:-2106.077881; z:996.196533
		"\229\144\241\177\066\228\171\077\082\095\186\215\167\204\212\035\176\154\188\196\099\222\231\196\144\106\128\068",
		-- tex:"e590f1b142e4ab4d525fbad7a7ccd423"; x:-1508.834106; y:-1854.949707; z:1027.330200
	["Blackfathom Deeps"] = 
		"\195\008\013\096\020\104\085\052\102\106\138\213\049\220\102\080\182\235\141\068\101\118\225\195\243\012\033\195" ..
		-- tex:"c3080d6014685534666a8ad531dc6650"; x:1135.366089; y:-450.924988; z:-161.050598
		"\011\087\170\019\081\244\043\076\007\183\081\070\005\171\222\230\109\215\091\068\203\236\066\195\243\012\033\195" ..
		-- tex:"0b57aa1351f42b4c07b7514605abdee6"; x:879.366089; y:-194.924988; z:-161.050598
		"\231\142\230\136\127\157\065\144\048\112\228\170\201\139\074\167\182\235\141\068\050\187\048\196\243\012\033\195" ..
		-- tex:"e78ee6887f9d41903070e4aac98b4aa7"; x:1135.366089; y:-706.924988; z:-161.050598
		"\175\035\117\116\125\136\142\036\158\150\047\061\078\081\207\199\109\215\091\068\050\187\048\196\243\012\033\195" ..
		-- tex:"af2375747d888e249e962f3d4e51cfc7"; x:879.366089; y:-706.924988; z:-161.050598
		"\066\215\054\198\165\139\192\043\113\138\034\100\141\176\248\105\109\215\091\068\101\118\225\195\243\012\033\195" ..
		-- tex:"42d736c6a58bc02b718a22648db0f869"; x:879.366089; y:-450.924988; z:-161.050598
		"\251\241\161\220\151\229\179\086\006\134\049\243\037\001\250\086\205\229\022\068\204\135\050\196\197\032\031\195" ..
		-- tex:"fbf1a1dc97e5b356068631f32501fa56"; x:603.590698; y:-714.121887; z:-159.128021
		"\082\133\110\213\015\237\117\182\055\164\024\191\104\217\028\160\205\229\022\068\051\031\074\195\197\032\031\195" ..
		-- tex:"52856ed50fed75b637a418bf68d91ca0"; x:603.590698; y:-202.121887; z:-159.128021
		"\054\180\113\232\239\054\154\060\234\123\086\199\222\056\229\251\205\229\086\068\204\135\050\196\197\032\031\195" ..
		-- tex:"36b471e8ef369a3cea7b56c7de38e5fb"; x:859.590698; y:-714.121887; z:-159.128021
		"\210\029\097\070\204\044\251\098\221\067\098\104\129\001\180\144\205\229\086\068\051\031\074\195\197\032\031\195" ..
		-- tex:"d21d6146cc2cfb62dd4362688101b490"; x:859.590698; y:-202.121887; z:-159.128021
		"\095\214\234\044\105\119\204\228\207\084\250\200\051\194\056\152\205\229\086\068\153\015\229\195\197\032\031\195" ..
		-- tex:"5fd6ea2c6977cce4cf54fac833c23898"; x:859.590698; y:-458.121887; z:-159.128021
		"\240\179\127\007\029\007\210\107\247\075\178\186\033\161\145\126\205\229\022\068\153\015\229\195\197\032\031\195" ..
		-- tex:"f0b37f071d07d26bf74bb2ba21a1917e"; x:603.590698; y:-458.121887; z:-159.128021
		"\173\127\240\205\215\070\059\212\121\046\095\220\050\054\227\198\068\235\014\068\039\225\055\196\001\239\028\195" ..
		-- tex:"ad7ff0cdd7463bd4792e5fdc3236e3c6"; x:571.676086; y:-735.518066; z:-156.933624
		"\101\069\015\041\180\063\190\054\113\184\137\215\166\035\176\185\181\016\056\068\245\234\037\195\157\131\023\195" ..
		-- tex:"65450f29b43fbe3671b889d7a623b0b9"; x:736.261078; y:-165.917816; z:-151.514130
		"\176\214\181\152\230\212\047\146\019\157\120\033\239\071\066\073\106\033\240\067\245\234\037\195\157\131\023\195" ..
		-- tex:"b0d6b598e6d42f92139d7821ef474249"; x:480.261078; y:-165.917816; z:-151.514130
		"\124\055\207\121\032\219\060\127\148\055\000\193\101\103\085\118\133\217\179\068\139\161\113\067\081\120\238\194" ..
		-- tex:"7c37cf7920db3c7f943700c165675576"; x:1438.797607; y:241.631042; z:-119.235001
		"\108\167\038\109\115\234\044\192\199\033\038\053\242\112\245\120\053\045\012\068\085\253\149\195\047\119\238\194" ..
		-- tex:"6ca7266d73ea2cc0c7212635f270f578"; x:560.706421; y:-299.979187; z:-119.232788
		"\232\159\127\020\219\178\197\163\200\254\187\120\222\246\018\085\176\183\151\068\247\159\147\195\106\068\238\194" ..
		-- tex:"e89f7f14dbb2c5a3c8febb78def61255"; x:1213.740356; y:-295.249756; z:-119.133629
		"\089\173\015\239\086\227\137\023\221\005\126\234\071\247\121\179\033\225\146\068\055\158\000\196\238\019\233\194" ..
		-- tex:"59ad0fef56e38917dd057eea47f779b3"; x:1175.035400; y:-514.472168; z:-116.538933
		"\113\006\101\005\224\157\123\191\087\186\134\086\128\198\082\065\133\056\015\068\026\003\084\196\202\118\231\194" ..
		-- tex:"71066505e09d7bbf57ba865680c65241"; x:572.883179; y:-848.048523; z:-115.732018
		"\196\175\165\203\224\254\034\217\223\201\001\249\063\134\232\009\205\157\143\068\152\186\251\194\250\053\226\194" ..
		-- tex:"c4afa5cbe0fe22d9dfc901f93f86e809"; x:1148.931396; y:-125.864449; z:-113.105431
		"\249\211\194\147\104\049\100\245\227\165\071\009\238\211\209\230\200\015\190\067\149\162\219\194\186\048\221\194" ..
		-- tex:"f9d3c293683164f5e3a54709eed3d1e6"; x:380.123322; y:-109.817551; z:-110.595177
		"\116\045\220\081\068\177\109\125\213\112\236\232\133\043\122\226\048\117\161\067\252\209\028\195\062\243\213\194" ..
		-- tex:"742ddc5144b16d7dd570ece8852b7ae2"; x:322.915558; y:-156.820267; z:-106.975090
		"\237\091\182\183\121\086\078\171\199\043\130\122\034\085\166\068\103\219\067\068\056\021\238\194\136\096\205\194" ..
		-- tex:"ed5bb6b779564eabc72b827a2255a644"; x:783.428223; y:-119.041451; z:-102.688545
		"\219\231\060\173\138\231\024\205\253\191\095\086\049\106\083\046\179\237\129\068\056\021\238\194\136\096\205\194" ..
		-- tex:"dbe73cad8ae718cdfdbf5f56316a532e"; x:1039.428223; y:-119.041451; z:-102.688545
		"\113\232\168\227\189\156\156\202\192\238\169\219\158\245\171\178\150\250\131\068\188\208\079\194\102\122\204\194" ..
		-- tex:"71e8a8e3bd9c9ccac0eea9db9ef5abb2"; x:1055.830933; y:-51.953846; z:-102.239067
		"\066\237\158\150\126\152\110\131\011\024\023\048\244\091\119\072\211\190\136\067\232\163\208\195\246\180\195\194" ..
		-- tex:"42ed9e967e986e830b181730f45b7748"; x:273.490845; y:-417.280548; z:-97.853447
		"\199\075\009\195\105\005\247\176\056\004\147\212\101\149\142\252\184\162\025\067\017\010\172\195\099\104\190\194" ..
		-- tex:"c74b09c36905f7b0380493d465958efc"; x:153.635635; y:-344.078674; z:-95.203888
		"\148\039\076\176\003\229\151\225\135\055\106\234\046\225\117\235\117\195\194\068\241\051\097\068\169\203\187\194" ..
		-- tex:"94274cb003e597e187376aea2ee175eb"; x:1558.108154; y:900.811646; z:-93.897781
		"\211\240\204\077\133\084\203\103\222\144\111\035\148\033\208\027\117\195\194\068\227\103\194\067\169\203\187\194" ..
		-- tex:"d3f0cc4d8554cb67de906f239421d01b"; x:1558.108154; y:388.811646; z:-93.897781
		"\204\205\025\156\154\085\044\253\163\078\030\157\219\017\124\041\117\195\194\068\241\051\033\068\169\203\187\194" ..
		-- tex:"cccd199c9a552cfda34e1e9ddb117c29"; x:1558.108154; y:644.811646; z:-93.897781
		"\158\064\174\048\232\076\247\161\029\095\083\107\083\012\004\183\160\045\095\068\120\211\054\066\158\021\187\194" ..
		-- tex:"9e40ae30e84cf7a11d5f536b530c04b7"; x:892.712952; y:45.706516; z:-93.542229
		"\205\019\021\031\091\173\243\253\205\182\229\173\180\181\027\191\173\106\141\067\026\124\096\195\034\245\184\194" ..
		-- tex:"cd13151f5badf3fdcdb6e5adb4b51bbf"; x:282.833435; y:-224.484787; z:-92.478783
		"\185\137\009\075\140\001\099\200\190\129\231\150\228\138\012\014\069\199\194\068\088\112\004\066\133\233\183\194" ..
		-- tex:"b989094b8c0163c8be81e796e48a0c0e"; x:1558.227295; y:33.109715; z:-91.956100
		"\182\233\202\046\022\066\255\137\047\114\185\081\199\050\047\028\237\115\168\068\006\013\083\067\133\233\183\194" ..
		-- tex:"b6e9ca2e1642ff892f72b951c7322f1c"; x:1347.622803; y:211.050880; z:-91.956100
		"\065\168\217\211\137\212\226\138\128\224\166\157\028\076\149\133\237\115\168\068\229\203\051\194\133\233\183\194" ..
		-- tex:"41a8d9d389d4e28a80e0a69d1c4c9585"; x:1347.622803; y:-44.949120; z:-91.956100
		"\211\162\083\052\059\157\151\252\239\088\232\126\121\025\218\060\078\075\132\068\042\234\067\066\163\023\159\194" ..
		-- tex:"d3a253343b9d97fcef58e87e7919da3c"; x:1058.353394; y:48.978680; z:-79.546173
		"\182\057\046\189\093\083\106\030\180\237\121\102\082\020\213\223\171\139\161\068\149\145\199\194\226\135\129\194" ..
		-- tex:"b6392ebd5d536a1eb4ed79665214d5df"; x:1292.364746; y:-99.784348; z:-64.765404
		"\051\251\214\105\031\222\041\079\249\168\054\179\187\030\055\098\080\247\147\068\158\029\029\064\087\023\108\194" ..
		-- tex:"33fbd6691fde294ff9a836b3bb1e3762"; x:1183.728638; y:2.454933; z:-59.022797
		"\056\203\216\252\020\245\182\101\076\154\153\098\241\051\243\249\016\035\191\068\140\039\079\067\171\148\079\194",
		-- tex:"38cbd8fc14f5b6654c9a9962f133f3f9"; x:1529.095825; y:207.154495; z:-51.895187
	["Blackrock Depths"] = 
		"\245\069\064\208\008\168\158\107\028\213\203\206\252\190\065\037\246\076\026\197\197\108\153\068\121\228\208\195" ..
		-- tex:"f54540d008a89e6b1cd5cbcefcbe4125"; x:-2468.810303; y:1227.399109; z:-417.784973
		"\247\196\185\094\254\202\199\252\073\102\017\046\197\194\093\073\246\076\026\197\138\217\114\068\121\228\208\195" ..
		-- tex:"f7c4b95efecac7fc4966112ec5c25d49"; x:-2468.810303; y:971.399109; z:-417.784973
		"\156\158\145\166\044\020\120\022\158\193\172\030\103\130\076\124\246\076\010\197\197\108\153\068\121\228\208\195" ..
		-- tex:"9c9e91a62c1478169ec1ac1e67824c7c"; x:-2212.810303; y:1227.399109; z:-417.784973
		"\164\140\139\111\111\095\149\059\095\110\092\020\091\214\252\108\246\076\010\197\138\217\114\068\121\228\208\195" ..
		-- tex:"a48c8b6f6f5f953b5f6e5c145bd6fc6c"; x:-2212.810303; y:971.399109; z:-417.784973
		"\137\239\006\052\212\235\195\069\233\198\201\192\011\051\129\091\237\153\244\196\138\217\114\068\121\228\208\195" ..
		-- tex:"89ef0634d4ebc345e9c6c9c00b33815b"; x:-1956.810303; y:971.399109; z:-417.784973
		"\018\100\207\036\171\068\146\217\192\180\247\237\093\252\160\235\101\047\208\196\205\139\238\193\036\230\199\195" ..
		-- tex:"1264cf24ab4492d9c0b4f7ed5dfca0eb"; x:-1665.481201; y:-29.818264; z:-399.798004
		"\048\250\232\010\002\007\228\203\034\073\034\215\042\210\111\044\101\047\208\196\134\046\098\067\036\230\199\195" ..
		-- tex:"30fae80a0207e4cb224922d72ad26f2c"; x:-1665.481201; y:226.181736; z:-399.798004
		"\097\161\046\027\091\172\154\139\006\094\201\212\205\110\227\051\101\047\176\196\161\139\056\068\036\230\199\195" ..
		-- tex:"61a12e1b5bac9a8b065ec9d4cd6ee333"; x:-1409.481201; y:738.181736; z:-399.798004
		"\148\156\015\118\191\168\067\217\094\235\124\155\200\195\246\119\101\047\240\196\161\139\120\068\036\230\199\195" ..
		-- tex:"949c0f76bfa843d95eeb7c9bc8c3f677"; x:-1921.481201; y:994.181736; z:-399.798004
		"\082\151\219\231\212\195\203\226\229\227\109\139\217\088\059\193\101\047\240\196\161\139\056\068\036\230\199\195" ..
		-- tex:"5297dbe7d4c3cbe2e5e36d8bd9583bc1"; x:-1921.481201; y:738.181736; z:-399.798004
		"\092\217\140\185\034\193\115\105\005\010\224\074\193\042\048\033\101\047\240\196\134\046\098\067\036\230\199\195" ..
		-- tex:"5cd98cb922c17369050ae04ac12a3021"; x:-1921.481201; y:226.181736; z:-399.798004
		"\055\207\110\047\113\250\198\204\008\244\059\115\231\052\231\201\101\047\208\196\067\023\241\067\036\230\199\195" ..
		-- tex:"37cf6e2f71fac6cc08f43b73e734e7c9"; x:-1665.481201; y:482.181736; z:-399.798004
		"\136\234\150\099\212\194\073\042\181\183\091\165\228\084\136\050\101\047\176\196\067\023\241\067\036\230\199\195" ..
		-- tex:"88ea9663d4c2492ab5b75ba5e4548832"; x:-1409.481201; y:482.181736; z:-399.798004
		"\169\212\051\113\007\228\147\232\095\034\031\158\166\056\211\229\101\047\240\196\205\139\238\193\036\230\199\195" ..
		-- tex:"a9d4337107e493e85f221f9ea638d3e5"; x:-1921.481201; y:-29.818264; z:-399.798004
		"\000\203\129\225\030\047\127\187\141\190\155\164\037\152\086\007\101\047\208\196\161\139\056\068\036\230\199\195" ..
		-- tex:"00cb81e11e2f7fbb8dbe9ba425985607"; x:-1665.481201; y:738.181736; z:-399.798004
		"\111\170\255\196\062\059\133\004\091\052\144\036\005\146\234\226\101\047\176\196\205\139\238\193\036\230\199\195" ..
		-- tex:"6faaffc43e3b85045b3490240592eae2"; x:-1409.481201; y:-29.818264; z:-399.798004
		"\106\038\008\157\242\114\070\001\131\201\089\103\248\211\100\185\178\023\008\197\134\046\098\067\036\230\199\195" ..
		-- tex:"6a26089df272460183c95967f8d364b9"; x:-2177.481201; y:226.181736; z:-399.798004
		"\153\045\255\185\255\040\087\184\033\055\108\002\236\164\247\188\101\047\176\196\134\046\098\067\036\230\199\195" ..
		-- tex:"992dffb9ff2857b821376c02eca4f7bc"; x:-1409.481201; y:226.181736; z:-399.798004
		"\033\133\190\037\228\066\018\138\145\187\072\009\167\080\215\102\101\047\208\196\161\139\120\068\036\230\199\195" ..
		-- tex:"2185be25e442128a91bb4809a750d766"; x:-1665.481201; y:994.181736; z:-399.798004
		"\207\096\184\013\043\198\225\158\216\172\162\006\174\017\139\233\178\023\008\197\205\139\238\193\036\230\199\195" ..
		-- tex:"cf60b80d2bc6e19ed8aca206ae118be9"; x:-2177.481201; y:-29.818264; z:-399.798004
		"\098\009\233\178\223\192\219\204\092\134\139\045\065\054\159\200\195\161\038\197\114\080\074\068\017\198\122\195" ..
		-- tex:"6209e9b2dfc0dbcc5c868b2d41369fc8"; x:-2666.110352; y:809.257019; z:-250.773712
		"\055\073\238\015\195\128\012\013\228\226\147\249\110\180\060\015\195\161\038\197\057\040\133\068\017\198\122\195" ..
		-- tex:"3749ee0fc3800c0de4e293f96eb43c0f"; x:-2666.110352; y:1065.257019; z:-250.773712
		"\084\063\041\174\099\067\029\076\207\080\153\017\009\035\181\043\195\161\038\197\114\080\010\068\017\198\122\195" ..
		-- tex:"543f29ae63431d4ccf5099110923b52b"; x:-2666.110352; y:553.257019; z:-250.773712
		"\174\169\103\113\247\145\197\020\006\140\025\012\205\021\115\052\195\161\022\197\114\080\074\068\017\198\122\195" ..
		-- tex:"aea96771f791c514068c190ccd157334"; x:-2410.110352; y:809.257019; z:-250.773712
		"\104\176\001\026\074\127\067\003\041\075\173\188\175\166\064\190\195\161\022\197\114\080\010\068\017\198\122\195" ..
		-- tex:"68b0011a4a7f4303294badbcafa640be"; x:-2410.110352; y:553.257019; z:-250.773712
		"\054\160\015\247\083\139\183\212\150\156\220\163\060\024\050\034\207\105\021\197\103\068\020\068\232\147\121\195" ..
		-- tex:"36a00ff7538bb7d4969cdca33c183222"; x:-2390.613281; y:593.068817; z:-249.577774
		"\178\074\015\133\056\074\138\193\234\149\209\003\027\196\013\119\159\211\234\196\206\136\168\067\232\147\121\195" ..
		-- tex:"b24a0f85384a8ac1ea95d1031bc40d77"; x:-1878.613281; y:337.068817; z:-249.577774
		"\002\139\175\103\105\225\156\034\119\040\089\144\245\205\129\068\207\105\005\197\103\068\020\068\232\147\121\195" ..
		-- tex:"028baf6769e19c2277285990f5cd8144"; x:-2134.613281; y:593.068817; z:-249.577774
		"\151\214\247\103\180\061\174\056\037\241\039\099\124\098\190\048\207\105\005\197\206\136\168\067\232\147\121\195" ..
		-- tex:"97d6f767b43dae3825f127637c62be30"; x:-2134.613281; y:337.068817; z:-249.577774
		"\070\022\168\146\178\026\072\025\156\165\096\081\035\219\022\227\207\105\021\197\206\136\168\067\232\147\121\195" ..
		-- tex:"4616a892b21a48199ca5605123db16e3"; x:-2390.613281; y:337.068817; z:-249.577774
		"\093\127\067\226\029\098\024\021\138\038\142\153\007\197\138\094\122\060\157\196\079\127\156\067\229\223\112\195" ..
		-- tex:"5d7f43e21d6218158a268e9907c58a5e"; x:-1257.890015; y:312.994629; z:-240.874603
		"\175\007\131\111\035\073\063\178\187\095\065\241\116\194\044\139\148\241\249\196\215\071\226\067\090\231\104\195" ..
		-- tex:"af07836f23493fb2bb5f41f174c22c8b"; x:-1999.549438; y:452.561279; z:-232.903732
		"\154\119\200\229\248\003\098\236\018\221\062\142\122\113\104\103\148\241\217\196\215\071\226\067\090\231\104\195" ..
		-- tex:"9a77c8e5f80362ec12dd3e8e7a716867"; x:-1743.549438; y:452.561279; z:-232.903732
		"\069\158\029\065\236\239\152\185\037\164\166\125\105\147\010\068\148\241\249\196\235\035\049\068\090\231\104\195" ..
		-- tex:"459e1d41ecef98b925a4a67d69930a44"; x:-1999.549438; y:708.561279; z:-232.903732
		"\045\242\052\119\231\023\185\053\204\117\020\008\179\207\254\103\148\241\217\196\235\035\049\068\090\231\104\195" ..
		-- tex:"2df23477e717b935cc751408b3cffe67"; x:-1743.549438; y:708.561279; z:-232.903732
		"\175\194\168\096\013\022\188\130\225\009\099\184\212\080\089\111\245\006\012\197\238\015\096\068\255\015\100\195" ..
		-- tex:"afc2a8600d16bc82e10963b8d450596f"; x:-2240.435059; y:896.248962; z:-228.062500
		"\159\222\255\096\010\059\215\037\181\070\251\255\149\074\077\021\212\129\043\196\134\216\117\195\101\205\076\195" ..
		-- tex:"9fdeff600a3bd725b546fbff954a4d15"; x:-686.028625; y:-245.845810; z:-204.802338
		"\136\192\215\073\203\124\092\145\021\114\153\154\072\224\220\186\212\129\107\196\143\119\034\065\101\205\076\195" ..
		-- tex:"88c0d749cb7c5c911572999a48e0dcba"; x:-942.028625; y:10.154190; z:-204.802338
		"\225\070\113\112\235\111\052\131\179\042\229\098\250\180\184\144\212\129\107\196\134\216\117\195\101\205\076\195" ..
		-- tex:"e1467170eb6f3483b32ae562fab4b890"; x:-942.028625; y:-245.845810; z:-204.802338
		"\117\082\236\187\018\080\247\115\235\065\065\052\188\001\028\003\165\213\041\197\133\151\088\068\159\103\061\195" ..
		-- tex:"7552ecbb1250f773eb414134bc011c03"; x:-2717.353027; y:866.367554; z:-189.404785
		"\133\021\109\171\225\031\129\028\011\247\070\197\177\246\175\160\165\213\041\197\133\151\024\068\159\103\061\195" ..
		-- tex:"85156dabe11f811c0bf746c5b1f6afa0"; x:-2717.353027; y:610.367554; z:-189.404785
		"\123\089\248\246\228\114\004\003\090\242\183\247\128\233\240\155\165\213\057\197\133\151\088\068\159\103\061\195" ..
		-- tex:"7b59f8f6e47204035af2b7f780e9f09b"; x:-2973.353027; y:866.367554; z:-189.404785
		"\107\244\048\047\074\019\080\016\022\061\049\130\140\073\047\056\165\213\057\197\133\151\024\068\159\103\061\195" ..
		-- tex:"6bf4302f4a135010163d31828c492f38"; x:-2973.353027; y:610.367554; z:-189.404785
		"\098\063\025\124\001\172\080\098\134\048\154\066\048\152\148\031\194\180\050\197\084\000\177\068\069\130\057\195" ..
		-- tex:"623f197c01ac506286309a423098941f"; x:-2859.297607; y:1416.010376; z:-185.508881
		"\052\050\159\056\160\075\177\035\167\012\185\081\038\008\069\149\194\180\050\197\084\000\209\068\069\130\057\195" ..
		-- tex:"34329f38a04bb123a70cb95126084595"; x:-2859.297607; y:1672.010376; z:-185.508881
		"\181\191\106\068\030\051\146\220\040\187\244\170\134\118\034\215\242\221\048\197\156\089\139\068\165\089\056\195" ..
		-- tex:"b5bf6a441e3392dc28bbf4aa867622d7"; x:-2829.871826; y:1114.800415; z:-184.350189
		"\103\017\064\153\141\038\104\234\110\008\124\205\013\176\156\150\242\221\048\197\156\089\171\068\165\089\056\195" ..
		-- tex:"671140998d2668ea6e087ccd0db09c96"; x:-2829.871826; y:1370.800415; z:-184.350189
		"\109\028\206\186\056\017\169\222\172\108\214\221\114\218\069\196\104\087\036\197\066\005\025\068\017\042\056\195" ..
		-- tex:"6d1cceba3811a9deac6cd6dd72da45c4"; x:-2629.463135; y:612.082214; z:-184.164337
		"\115\122\149\053\152\197\058\142\005\039\059\144\162\145\137\027\159\224\037\197\040\121\011\068\038\140\044\195" ..
		-- tex:"737a953598c53a8e05273b90a291891b"; x:-2654.039063; y:557.893127; z:-172.547470
		"\252\202\223\073\181\159\000\122\008\152\225\249\055\241\091\176\159\224\021\197\081\242\150\067\038\140\044\195" ..
		-- tex:"fccadf49b59f007a0898e1f937f15bb0"; x:-2398.039063; y:301.893127; z:-172.547470
		"\181\025\019\157\239\153\199\089\242\158\220\211\110\086\181\030\159\224\037\197\081\242\150\067\038\140\044\195" ..
		-- tex:"b519139def99c759f29edcd36e56b51e"; x:-2654.039063; y:301.893127; z:-172.547470
		"\182\096\180\183\005\114\229\185\223\173\233\102\084\218\132\238\081\203\166\196\216\152\216\067\013\143\043\195" ..
		-- tex:"b660b4b70572e5b9dfade96654da84ee"; x:-1334.353760; y:433.194122; z:-171.558807
		"\086\192\059\044\049\231\129\176\210\193\066\187\085\251\086\065\081\203\134\196\216\152\216\067\013\143\043\195" ..
		-- tex:"56c03b2c31e781b0d2c142bb55fb5641"; x:-1078.353760; y:433.194122; z:-171.558807
		"\021\152\205\245\122\240\144\190\022\100\023\217\023\109\121\126\104\031\010\197\133\058\093\067\201\109\043\195" ..
		-- tex:"1598cdf57af090be166417d9176d797e"; x:-2209.963135; y:221.228607; z:-171.428864
		"\115\156\010\104\118\002\051\121\190\248\021\084\090\067\106\095\104\031\026\197\133\058\093\067\201\109\043\195" ..
		-- tex:"739c0a6876023379bef815545a436a5f"; x:-2465.963135; y:221.228607; z:-171.428864
		"\036\160\075\102\054\052\171\147\016\033\120\206\212\014\176\021\104\031\026\197\066\157\238\067\201\109\043\195" ..
		-- tex:"24a04b663634ab93102178ced40eb015"; x:-2465.963135; y:477.228607; z:-171.428864
		"\034\181\024\072\018\129\246\028\193\173\159\133\150\128\104\207\132\243\254\196\154\131\029\068\117\136\040\195" ..
		-- tex:"22b518481281f61cc1ad9f85968068cf"; x:-2039.609985; y:630.056335; z:-168.533051
		"\234\208\111\004\016\087\174\227\237\207\105\168\126\171\083\015\132\243\254\196\154\131\093\068\117\136\040\195" ..
		-- tex:"ead06f041057aee3edcf69a87eab530f"; x:-2039.609985; y:886.056335; z:-168.533051
		"\054\070\003\142\116\016\221\232\188\165\090\090\197\022\226\014\132\243\222\196\154\131\029\068\117\136\040\195" ..
		-- tex:"3646038e7410dde8bca55a5ac516e20e"; x:-1783.609985; y:630.056335; z:-168.533051
		"\101\198\032\237\014\176\200\235\235\190\122\025\241\079\135\102\098\067\034\196\246\001\140\067\074\158\039\195" ..
		-- tex:"65c620ed0eb0c8ebebbe7a19f14f8766"; x:-649.052917; y:280.015350; z:-167.618332
		"\142\055\129\182\061\088\249\213\190\142\085\218\138\077\185\072\098\067\098\196\246\001\140\067\074\158\039\195" ..
		-- tex:"8e3781b63d58f9d5be8e55da8a4db948"; x:-905.052917; y:280.015350; z:-167.618332
		"\013\238\107\007\227\211\174\008\136\046\122\009\235\153\102\100\074\206\168\196\083\053\091\067\012\028\033\195" ..
		-- tex:"0dee6b07e3d3ae08882e7a09eb996664"; x:-1350.446655; y:219.208313; z:-161.109573
		"\166\069\187\005\237\200\220\061\086\088\076\157\175\088\127\210\184\226\022\196\044\058\156\066\001\117\030\195" ..
		-- tex:"a645bb05edc8dc3d56584c9daf587fd2"; x:-603.542542; y:78.113625; z:-158.457062
		"\102\032\018\030\066\215\003\006\114\189\119\038\186\231\161\116\184\226\022\196\139\014\167\067\001\117\030\195" ..
		-- tex:"6620121e42d7030672bd7726bae7a174"; x:-603.542542; y:334.113625; z:-158.457062
		"\101\055\234\197\214\094\241\072\195\107\077\051\173\009\198\076\184\226\086\196\044\058\156\066\001\117\030\195" ..
		-- tex:"6537eac5d65ef148c36b4d33ad09c64c"; x:-859.542542; y:78.113625; z:-158.457062
		"\196\057\232\255\018\157\156\074\147\064\183\125\173\028\073\194\023\167\032\197\103\153\017\068\126\126\028\195" ..
		-- tex:"c439e8ff129d9c4a9340b77dad1c49c2"; x:-2570.443359; y:582.396973; z:-156.494125
		"\048\227\111\129\150\214\227\143\002\115\233\226\115\074\103\133\132\197\207\196\250\033\205\067\113\138\021\195" ..
		-- tex:"30e36f8196d6e38f0273e9e2734a6785"; x:-1662.172485; y:410.265472; z:-149.540802
		"\207\111\209\070\199\166\060\013\157\078\023\208\235\099\228\205\132\197\239\196\250\033\205\067\113\138\021\195" ..
		-- tex:"cf6fd146c7a63c0d9d4e17d0eb63e4cd"; x:-1918.172485; y:410.265472; z:-149.540802
		"\162\197\240\151\044\060\037\201\034\049\116\020\115\122\139\233\132\197\239\196\253\144\038\068\113\138\021\195" ..
		-- tex:"a2c5f0972c3c25c922317414737a8be9"; x:-1918.172485; y:666.265472; z:-149.540802
		"\093\180\112\154\237\017\197\155\082\006\217\054\190\217\015\042\186\116\146\196\019\250\156\194\015\096\021\195" ..
		-- tex:"5db4709aed11c59b5206d936bed90f2a"; x:-1171.647827; y:-78.488434; z:-149.375244
		"\074\009\139\227\136\231\254\247\069\173\245\213\032\005\158\026\186\116\146\196\245\130\049\067\015\096\021\195" ..
		-- tex:"4a098be388e7fef745adf5d520059e1a"; x:-1171.647827; y:177.511566; z:-149.375244
		"\027\216\194\147\094\232\000\133\143\197\184\121\038\085\188\173\117\233\100\196\019\250\156\194\015\096\021\195" ..
		-- tex:"1bd8c2935ee800858fc5b8792655bcad"; x:-915.647827; y:-78.488434; z:-149.375244
		"\102\020\210\235\019\046\010\061\166\155\124\177\065\211\005\141\117\233\100\196\245\130\049\067\015\096\021\195" ..
		-- tex:"6614d2eb132e0a3da69b7cb141d3058d"; x:-915.647827; y:177.511566; z:-149.375244
		"\081\236\042\139\163\129\245\117\092\092\233\031\004\089\041\047\029\121\158\196\255\147\148\193\127\078\021\195" ..
		-- tex:"51ec2a8ba381f5755c5ce91f0459292f"; x:-1267.784912; y:-18.572266; z:-149.306641
		"\189\190\233\248\086\225\227\179\075\038\039\224\118\168\096\125\029\121\158\196\063\073\137\195\127\078\021\195" ..
		-- tex:"bdbee9f856e1e3b34b2627e076a8607d"; x:-1267.784912; y:-274.572266; z:-149.306641
		"\013\169\119\020\178\138\231\214\152\021\174\054\109\000\091\240\029\121\190\196\063\073\137\195\127\078\021\195" ..
		-- tex:"0da97714b28ae7d69815ae366d005bf0"; x:-1523.784912; y:-274.572266; z:-149.306641
		"\089\199\040\093\147\094\231\048\070\001\107\111\037\240\216\080\029\121\190\196\255\147\148\193\127\078\021\195" ..
		-- tex:"59c7285d935ee73046016b6f25f0d850"; x:-1523.784912; y:-18.572266; z:-149.306641
		"\024\234\228\119\044\110\213\146\170\017\062\002\197\171\105\046\029\121\190\196\159\164\004\196\127\078\021\195" ..
		-- tex:"18eae4772c6ed592aa113e02c5ab692e"; x:-1523.784912; y:-530.572266; z:-149.306641
		"\232\051\169\062\106\180\238\250\195\246\238\218\098\090\135\046\235\068\213\196\192\137\152\067\242\206\019\195" ..
		-- tex:"e833a93e6ab4eefac3f6eeda625a872e"; x:-1706.153809; y:305.076202; z:-147.808395
		"\123\094\145\125\221\114\179\015\056\150\108\157\019\229\046\068\240\132\031\196\088\143\054\067\009\123\014\195" ..
		-- tex:"7b5e917ddd72b30f38966c9d13e52e44"; x:-638.077209; y:182.559952; z:-142.480621
		"\225\001\059\020\200\170\254\093\086\178\107\248\041\016\145\006\240\132\095\196\088\143\054\067\009\123\014\195" ..
		-- tex:"e1013b14c8aafe5d56b26bf829109106"; x:-894.077209; y:182.559952; z:-142.480621
		"\154\060\060\100\237\147\149\228\095\128\004\199\248\071\005\099\036\133\206\196\025\243\001\195\117\230\011\195" ..
		-- tex:"9a3c3c64ed9395e45f8004c7f8470563"; x:-1652.160767; y:-129.949615; z:-139.900238
		"\059\222\141\210\243\116\049\203\154\035\152\222\230\225\159\076\124\163\138\196\178\096\164\067\200\007\000\195" ..
		-- tex:"3bde8dd2f37431cb9a2398dee6e19f4c"; x:-1109.109009; y:328.755463; z:-128.030411
		"\111\205\252\058\160\091\181\156\152\134\049\230\160\175\057\189\077\132\242\196\061\234\199\067\006\067\247\194" ..
		-- tex:"6fcdfc3aa05bb59c988631e6a0af39bd"; x:-1940.134521; y:399.830017; z:-123.630913
		"\136\221\252\153\159\102\147\140\124\134\132\234\222\078\237\219\252\189\159\196\000\092\132\066\163\089\240\194" ..
		-- tex:"88ddfc999f66938c7c8684eade4eeddb"; x:-1277.937134; y:66.179695; z:-120.175079
		"\051\054\069\230\094\166\227\110\203\224\107\146\094\240\244\149\216\074\185\196\245\181\254\194\163\089\240\194" ..
		-- tex:"333645e65ea6e36ecbe06b925ef0f495"; x:-1482.338989; y:-127.355392; z:-120.175079
		"\203\088\135\049\003\085\225\154\149\178\176\017\213\151\072\058\172\095\160\196\211\068\231\067\115\074\237\194" ..
		-- tex:"cb5887310355e19a95b2b011d597483a"; x:-1282.989868; y:462.537720; z:-118.645416
		"\005\146\242\062\010\090\202\113\206\025\059\090\248\157\215\185\027\176\172\196\223\126\234\067\213\178\235\194" ..
		-- tex:"0592f23e0a5aca71ce193b5af89dd7b9"; x:-1381.503418; y:468.991196; z:-117.849289
		"\124\181\170\234\249\057\252\047\068\212\118\045\177\116\090\067\027\176\172\196\190\253\084\067\213\178\235\194" ..
		-- tex:"7cb5aaeaf939fc2f44d4762db1745a43"; x:-1381.503418; y:212.991196; z:-117.849289
		"\236\065\218\183\180\181\208\024\173\181\092\140\255\150\137\106\027\176\140\196\190\253\084\067\213\178\235\194" ..
		-- tex:"ec41dab7b4b5d018adb55c8cff96896a"; x:-1125.503418; y:212.991196; z:-117.849289
		"\236\006\213\204\085\028\194\190\242\149\149\168\213\080\198\095\027\176\140\196\223\126\234\067\213\178\235\194" ..
		-- tex:"ec06d5cc551cc2bef29595a8d550c65f"; x:-1125.503418; y:468.991196; z:-117.849289
		"\074\027\043\181\234\008\229\218\116\072\052\008\073\116\017\154\003\015\214\196\191\091\113\067\085\154\216\194" ..
		-- tex:"4a1b2bb5ea08e5da744834084974119a"; x:-1712.469238; y:241.358398; z:-108.301437
		"\130\203\015\222\075\198\243\149\159\039\175\167\207\153\096\054\171\115\217\196\057\050\181\194\070\018\215\194" ..
		-- tex:"82cb0fde4bc6f3959f27afa7cf996036"; x:-1739.614746; y:-90.598099; z:-107.535698
		"\094\243\035\240\060\100\135\200\157\144\070\199\049\065\073\062\197\211\205\196\156\175\160\066\070\018\215\194" ..
		-- tex:"5ef323f03c6487c89d9046c73141493e"; x:-1646.617920; y:80.342995; z:-107.535698
		"\001\144\177\228\148\022\118\138\079\045\150\005\207\044\147\075\061\152\147\196\179\237\080\067\252\052\214\194" ..
		-- tex:"0190b1e49416768a4f2d9605cf2c934b"; x:-1180.757568; y:208.928528; z:-107.103493
		"\217\158\198\071\005\047\046\038\112\239\000\092\221\022\005\196\025\137\215\196\147\133\022\068\052\196\202\194" ..
		-- tex:"d99ec647052f2e2670ef005cdd1605c4"; x:-1724.284424; y:602.087158; z:-101.383217
		"\162\070\212\229\103\055\225\167\092\217\252\184\033\050\209\074\122\098\208\196\222\014\036\068\100\108\202\194" ..
		-- tex:"a246d4e56737e1a75cd9fcb82132d14a"; x:-1667.077515; y:656.232361; z:-101.211708
		"\166\249\146\103\189\204\065\223\053\036\175\106\048\135\000\154\125\129\225\196\088\069\036\068\217\241\199\194" ..
		-- tex:"a6f99267bdcc41df3524af6a3087009a"; x:-1804.046631; y:657.083557; z:-99.972366
		"\179\031\108\207\030\224\209\237\134\073\113\022\246\186\069\063\203\138\233\196\242\127\096\067\031\054\199\194" ..
		-- tex:"b31f6ccf1ee0d1ed86497116f6ba453f"; x:-1868.337402; y:224.499802; z:-99.605713
		"\152\023\018\224\166\177\037\019\064\229\194\047\092\196\163\029\081\142\232\196\162\095\128\067\182\039\199\194" ..
		-- tex:"981712e0a6b1251340e5c22f5cc4a31d"; x:-1860.447510; y:256.747162; z:-99.577568
		"\059\251\059\253\085\139\228\247\061\225\252\134\174\035\247\120\155\055\212\196\244\033\223\067\014\216\197\194" ..
		-- tex:"3bfb3bfd558be4f73de1fc86ae23f778"; x:-1697.737793; y:446.265289; z:-98.921989
		"\251\089\159\191\116\057\115\138\118\054\194\218\138\036\083\054\227\094\207\196\240\099\240\067\127\164\197\194" ..
		-- tex:"fb599fbf7439738a7636c2da8a245336"; x:-1658.965332; y:480.780792; z:-98.821289
		"\040\010\112\174\218\078\058\083\226\133\250\036\068\216\112\161\044\085\173\196\225\219\105\067\207\011\185\194" ..
		-- tex:"280a70aeda4e3a53e285fa2444d870a1"; x:-1386.661743; y:233.858917; z:-92.523071
		"\097\209\252\054\032\019\165\163\144\003\162\207\128\143\158\082\034\180\192\196\238\188\014\064\206\011\185\194" ..
		-- tex:"61d1fc362013a5a39003a2cf808f9e52"; x:-1541.629272; y:2.230282; z:-92.523064
		"\168\004\007\037\225\240\140\227\125\045\101\239\156\068\118\208\160\117\129\196\240\158\231\067\138\070\176\194" ..
		-- tex:"a8040725e1f08ce37d2d65ef9c4476d0"; x:-1035.675903; y:463.241730; z:-88.137779
		"\179\193\238\130\133\237\063\086\046\005\072\054\061\173\079\175\160\117\161\196\240\158\231\067\138\070\176\194" ..
		-- tex:"b3c1ee8285ed3f562e0548363dad4faf"; x:-1291.675903; y:463.241730; z:-88.137779
		"\164\188\000\020\088\090\091\062\165\181\110\082\237\163\066\020\115\131\218\196\000\106\222\067\175\048\175\194" ..
		-- tex:"a4bc0014585a5b3ea5b56e52eda34214"; x:-1748.107910; y:444.828156; z:-87.595093
		"\227\019\077\226\171\001\061\142\188\083\112\144\135\123\084\197\137\009\205\196\224\086\206\067\121\096\173\194",
		-- tex:"e3134de2ab013d8ebc537090877b54c5"; x:-1640.298096; y:412.678741; z:-86.688431
	["Blackrock Spire"] = 
		"\029\179\202\140\245\076\021\180\097\141\066\035\158\121\177\147\253\002\061\067\095\022\133\064\027\151\065\195" ..
		-- tex:"1db3ca8cf54c15b4618d42239e79b193"; x:189.011688; y:4.158981; z:-193.590271
		"\214\096\058\046\132\098\254\146\184\161\030\238\068\049\111\172\003\250\133\194\076\215\123\195\027\151\065\195" ..
		-- tex:"d6603a2e8462fe92b8a11eee44316fac"; x:-66.988312; y:-251.841019; z:-193.590271
		"\098\095\198\097\162\009\085\239\000\085\127\212\069\095\144\033\128\126\161\195\076\215\123\195\027\151\065\195" ..
		-- tex:"625fc661a20955ef00557fd4455f9021"; x:-322.988312; y:-251.841019; z:-193.590271
		"\099\070\236\152\147\036\247\197\252\162\070\170\060\135\150\220\128\126\161\195\095\022\133\064\027\151\065\195" ..
		-- tex:"6346ec989324f7c5fca246aa3c8796dc"; x:-322.988312; y:4.158981; z:-193.590271
		"\252\010\236\069\199\195\190\006\236\186\245\014\145\004\181\102\003\250\133\194\095\022\133\064\027\151\065\195" ..
		-- tex:"fc0aec45c7c3be06ecbaf50e9104b566"; x:-66.988312; y:4.158981; z:-193.590271
		"\192\152\093\019\001\150\081\241\062\164\204\198\203\042\235\111\243\204\166\195\091\057\018\067\239\051\065\195" ..
		-- tex:"c0985d13019651f13ea4ccc6cb2aeb6f"; x:-333.601196; y:146.224060; z:-193.202881
		"\074\137\155\087\063\170\017\149\196\149\150\189\119\060\190\137\023\102\050\067\091\057\018\067\239\051\065\195" ..
		-- tex:"4a899b573faa1195c49596bd773cbe89"; x:178.398804; y:146.224060; z:-193.202881
		"\075\175\119\064\226\102\171\192\014\252\057\223\198\037\100\165\243\204\166\195\173\028\201\067\239\051\065\195" ..
		-- tex:"4baf7740e266abc00efc39dfc62564a5"; x:-333.601196; y:402.224060; z:-193.202881
		"\028\143\217\217\129\100\065\025\007\036\155\250\059\142\117\020\207\051\155\194\091\057\018\067\239\051\065\195" ..
		-- tex:"1c8fd9d98164411907249bfa3b8e7514"; x:-77.601196; y:146.224060; z:-193.202881
		"\002\220\158\081\116\234\023\103\022\222\112\067\107\155\137\184\207\051\155\194\173\028\201\067\239\051\065\195" ..
		-- tex:"02dc9e5174ea176716de70436b9b89b8"; x:-77.601196; y:402.224060; z:-193.202881
		"\168\027\192\254\094\048\137\139\092\024\103\013\077\033\200\062\191\078\108\195\137\133\029\068\015\230\148\194" ..
		-- tex:"a81bc0fe5e30898b5c18670d4d21c83e"; x:-236.307617; y:630.086548; z:-74.449341
		"\095\025\220\068\179\040\242\159\199\124\176\219\089\251\100\022\255\137\157\065\137\133\029\068\015\230\148\194" ..
		-- tex:"5f19dc44b328f29fc77cb0db59fb6416"; x:19.692383; y:630.086548; z:-74.449341
		"\006\010\126\246\041\003\134\117\254\082\139\053\019\229\250\235\191\078\108\195\137\133\093\068\015\230\148\194" ..
		-- tex:"060a7ef629038675fe528b3513e5faeb"; x:-236.307617; y:886.086548; z:-74.449341
		"\217\103\001\024\065\023\114\211\090\044\038\131\124\022\232\006\255\137\157\065\137\133\093\068\015\230\148\194" ..
		-- tex:"d9670118411772d35a2c26837c16e806"; x:19.692383; y:886.086548; z:-74.449341
		"\113\174\105\140\143\247\080\191\018\019\009\040\094\077\128\118\159\216\137\067\137\133\029\068\015\230\148\194" ..
		-- tex:"71ae698c8ff750bf121309285e4d8076"; x:275.692383; y:630.086548; z:-74.449341
		"\047\140\227\116\031\058\170\188\153\160\029\013\223\094\195\230\025\096\067\067\213\083\110\068\063\054\031\194" ..
		-- tex:"2f8ce3741f3aaabc99a01d0ddf5ec3e6"; x:195.375397; y:953.309937; z:-39.802979
		"\240\033\181\027\201\054\100\009\028\231\028\037\214\191\179\092\120\035\099\193\086\249\105\068\035\064\028\194" ..
		-- tex:"f021b51bc93664091ce71c25d6bfb35c"; x:-14.196160; y:935.895935; z:-39.062637
		"\045\153\117\181\058\196\037\207\066\141\080\170\250\061\207\081\018\248\075\195\031\214\117\068\091\007\026\194" ..
		-- tex:"2d9975b53ac425cf428d50aafa3dcf51"; x:-203.969040; y:983.345703; z:-38.507187
		"\180\216\060\021\229\150\082\031\149\019\149\118\125\040\239\196\179\031\080\066\031\214\117\068\091\007\026\194" ..
		-- tex:"b4d83c15e596521f951395767d28efc4"; x:52.030960; y:983.345703; z:-38.507187
		"\160\218\251\140\230\253\084\148\222\023\051\206\113\184\006\245\227\121\087\065\219\123\093\068\135\006\024\194" ..
		-- tex:"a0dafb8ce6fd5494de1733ce71b806f5"; x:13.467258; y:885.935303; z:-38.006378
		"\248\210\123\031\033\136\131\236\224\247\223\080\201\037\207\176\077\246\048\193\163\020\141\068\115\028\023\194" ..
		-- tex:"f8d27b1f218883ece0f7df50c925cfb0"; x:-11.060133; y:1128.645020; z:-37.777786
		"\018\098\018\178\124\229\210\228\057\018\069\200\083\012\030\206\228\085\213\066\102\154\093\068\092\096\021\194" ..
		-- tex:"126212b27ce5d2e4391245c8530c1ece"; x:106.667763; y:886.412537; z:-37.344105
		"\235\052\252\009\021\123\160\102\069\094\212\074\052\118\193\198\016\058\115\066\012\129\093\068\090\096\021\194" ..
		-- tex:"eb34fc09157ba066455ed44a3476c1c6"; x:60.806705; y:886.016418; z:-37.344097
		"\076\142\197\228\164\040\150\001\184\200\138\126\003\046\179\093\202\032\123\067\244\058\090\068\204\134\132\065" ..
		-- tex:"4c8ec5e4a4289601b8c88a7e032eb35d"; x:251.128098; y:872.921204; z:16.565821
		"\022\237\020\209\069\199\245\234\187\072\223\184\199\027\120\083\182\024\219\194\110\088\009\068\059\016\153\065" ..
		-- tex:"16ed14d145c7f5eabb48dfb8c71b7853"; x:-109.548271; y:549.381775; z:19.132927
		"\002\131\245\158\211\253\099\118\156\161\051\098\135\198\083\126\012\035\129\065\229\203\093\068\211\036\255\065" ..
		-- tex:"0283f59ed3fd63769ca1336287c6537e"; x:16.142115; y:887.185913; z:31.892982
		"\099\086\062\095\095\086\246\139\032\018\165\149\156\195\105\136\013\113\245\066\163\153\109\068\057\204\001\066" ..
		-- tex:"63563e5f5f56f68b2012a5959cc36988"; x:122.720810; y:950.400635; z:32.449440
		"\047\049\028\213\123\019\182\113\100\200\172\110\171\078\035\108\163\109\192\194\138\078\015\068\143\023\046\066" ..
		-- tex:"2f311cd57b13b67164c8ac6eab4e236c"; x:-96.214142; y:573.227234; z:43.523010
		"\108\143\195\059\107\009\046\060\096\246\193\071\113\083\143\114\222\234\040\067\019\122\105\068\101\200\064\066" ..
		-- tex:"6c8fc33b6b092e3c60f6c14771538f72"; x:168.917465; y:933.907471; z:48.195702
		"\222\141\114\070\243\174\012\076\200\101\246\219\056\037\153\032\114\003\113\066\127\152\093\068\073\133\105\066" ..
		-- tex:"de8d7246f3ae0c4cc865f6db38259920"; x:60.253368; y:886.382813; z:58.380165
		"\038\026\068\071\100\046\031\079\216\014\116\025\160\148\166\134\118\232\143\065\184\141\018\068\143\042\116\066" ..
		-- tex:"261a4447642e1f4fd80e7419a094a686"; x:17.988508; y:586.214417; z:61.041565
		"\068\103\007\099\168\216\158\172\228\046\016\024\016\022\093\202\094\179\038\066\054\048\052\068\070\022\124\066" ..
		-- tex:"44670763a8d89eace42e101810165dca"; x:41.675167; y:720.753357; z:63.021755
		"\049\013\242\050\102\128\186\211\213\058\052\094\006\130\015\162\159\219\228\194\021\195\248\067\104\213\157\066" ..
		-- tex:"310df2326680bad3d53a345e06820fa2"; x:-114.428955; y:497.524109; z:78.916817
		"\152\129\047\142\044\253\220\138\135\185\029\082\108\016\125\011\056\150\095\194\099\045\000\068\122\178\168\066" ..
		-- tex:"98812f8e2cfddc8a87b91d526c107d0b"; x:-55.896702; y:512.709229; z:84.348595
		"\182\235\137\152\009\060\221\140\048\248\124\255\208\025\135\024\077\006\078\194\195\146\236\067\071\252\168\066" ..
		-- tex:"b6eb8998093cdd8c30f87cffd0198718"; x:-51.506157; y:473.146606; z:84.492737
		"\071\196\007\104\177\220\249\125\057\169\005\147\164\093\033\135\086\031\039\195\096\218\203\067\088\121\176\066" ..
		-- tex:"47c40768b1dcf97d39a90593a45d2187"; x:-167.122421; y:407.706085; z:88.237007
		"\245\249\209\179\150\128\213\243\142\204\210\152\056\057\215\026\011\111\095\194\105\244\041\068\052\174\192\066" ..
		-- tex:"f5f9d1b39680d5f38eccd2983839d71a"; x:-55.858444; y:679.818970; z:96.340248
		"\074\223\203\001\008\089\217\217\015\100\012\177\013\009\231\197\203\236\177\194\110\218\042\068\230\127\194\066" ..
		-- tex:"4adfcb010859d9d90f640cb10d09e7c5"; x:-88.962494; y:683.413025; z:97.249809
		"\155\018\241\035\127\226\105\005\170\090\204\143\162\003\026\081\007\106\046\195\197\230\222\067\089\104\198\066" ..
		-- tex:"9b12f1237fe26905aa5acc8fa2031a51"; x:-174.414185; y:445.802917; z:99.203812
		"\211\002\219\032\154\039\048\119\008\233\114\066\254\138\165\002\056\202\255\194\221\200\022\068\250\224\214\066" ..
		-- tex:"d302db209a27307708e97242fe8aa502"; x:-127.894966; y:603.138550; z:107.439415
		"\217\252\247\181\096\103\004\194\083\007\100\008\166\080\175\179\095\120\095\195\037\164\022\068\250\224\214\066" ..
		-- tex:"d9fcf7b5606704c253076408a650afb3"; x:-223.470215; y:602.564819; z:107.439415
		"\088\094\117\077\017\206\087\055\209\041\075\143\236\093\226\056\095\120\095\195\100\217\031\068\215\116\215\066" ..
		-- tex:"585e754d11ce5737d1294b8fec5de238"; x:-223.470215; y:639.396790; z:107.728210
		"\228\103\158\058\199\016\036\239\228\023\008\205\132\049\187\038\056\202\255\194\198\217\031\068\186\138\215\066" ..
		-- tex:"e4679e3ac71024efe41708cd8431bb26"; x:-127.894966; y:639.402771; z:107.770958
		"\046\136\186\165\006\133\155\083\045\032\030\157\090\218\090\186\197\028\090\195\072\064\254\067\244\145\215\066" ..
		-- tex:"2e88baa506859b532d201e9d5ada5aba"; x:-218.112396; y:508.502228; z:107.785072
		"\255\088\186\114\208\151\131\086\095\189\057\161\031\135\073\089\217\081\068\067\068\199\027\068\179\218\225\066" ..
		-- tex:"ff58ba72d09783565fbd39a11f874959"; x:196.319733; y:623.113586; z:112.927155
		"\048\036\003\196\239\090\051\240\214\117\115\091\099\134\049\078\135\079\134\067\072\241\053\068\077\183\231\066" ..
		-- tex:"302403c4ef5a33f0d675735b6386314e"; x:268.621338; y:727.770081; z:115.858017
		"\214\087\054\226\103\163\138\253\023\079\018\017\023\255\090\221\039\182\073\195\069\059\042\068\251\244\240\066" ..
		-- tex:"d65736e267a38afd174f121117ff5add"; x:-201.711548; y:680.926147; z:120.478485
		"\061\126\168\205\206\187\079\172\226\148\067\052\156\108\154\238\096\204\176\067\065\165\018\068\059\013\255\066" ..
		-- tex:"3d7ea8cdcebb4face29443349c6c9aee"; x:353.596710; y:586.582153; z:127.525848
		"\062\147\153\041\000\089\014\167\240\001\142\183\014\133\036\119\105\063\158\067\193\167\028\068\090\122\000\067" ..
		-- tex:"3e93992900590ea7f0018eb70e852477"; x:316.495422; y:626.621216; z:128.477951
		"\172\061\092\115\154\183\220\207\238\065\076\119\250\016\251\202\105\063\158\067\193\167\092\068\090\122\000\067" ..
		-- tex:"ac3d5c739ab7dccfee414c77fa10fbca"; x:316.495422; y:882.621216; z:128.477951
		"\090\150\092\185\225\075\114\135\021\162\049\037\086\131\125\137\114\057\135\067\208\049\041\068\080\195\000\067" ..
		-- tex:"5a965cb9e14b728715a2312556837d89"; x:270.448822; y:676.778381; z:128.762955
		"\239\103\240\098\056\211\039\120\048\186\100\073\235\181\255\247\010\009\119\195\056\227\027\068\043\222\002\067" ..
		-- tex:"ef67f06238d3277830ba6449ebb5fff7"; x:-247.035324; y:623.550354; z:130.867859
		"\018\105\177\234\002\173\198\046\164\246\089\228\016\112\235\072\111\140\167\066\249\169\013\068\016\022\005\067" ..
		-- tex:"1269b1ea02adc62ea4f659e41070eb48"; x:83.774292; y:566.655884; z:133.086197
		"\190\018\026\199\237\187\083\242\187\113\042\235\246\103\032\194\247\233\093\195\151\064\248\067\089\159\013\067" ..
		-- tex:"be121ac7edbb53f2bb712aebf66720c2"; x:-221.913940; y:496.504639; z:141.622467
		"\109\007\215\128\147\140\134\089\173\105\014\143\222\018\253\040\251\244\238\195\151\064\248\067\089\159\013\067" ..
		-- tex:"6d07d780938c8659ad690e8fde12fd28"; x:-477.913940; y:496.504639; z:141.622467
		"\151\172\240\196\028\085\208\140\015\068\070\184\075\219\008\045\007\144\189\066\152\165\045\068\240\165\013\067" ..
		-- tex:"97acf0c41c55d08c0f4446b84bdb082d"; x:94.781311; y:694.587463; z:141.648209
		"\090\149\247\173\057\064\201\026\019\218\007\008\209\140\124\191\246\134\233\195\018\204\004\068\209\184\025\067" ..
		-- tex:"5a95f7ad3940c91a13da0708d18c7cbf"; x:-467.054413; y:531.188660; z:153.721954
		"\100\118\239\152\226\248\114\246\149\134\100\228\213\232\052\159\077\168\031\193\000\067\091\068\244\018\027\067" ..
		-- tex:"6476ef98e2f872f6958664e4d5e8349f"; x:-9.978590; y:877.046936; z:155.074051
		"\244\038\059\170\176\047\171\247\169\166\109\155\202\224\226\057\043\083\215\195\231\105\251\067\086\031\036\067" ..
		-- tex:"f4263baab02fabf7a9a66d9bcae0e239"; x:-430.649780; y:502.827393; z:164.122421
		"\017\205\143\049\144\073\143\091\083\090\230\087\154\149\061\198\212\166\230\195\090\205\253\067\086\031\036\067" ..
		-- tex:"11cd8f3190498f5b535ae6579a953dc6"; x:-461.303375; y:507.604340; z:164.122421
		"\184\104\215\186\112\172\224\046\225\149\109\157\151\103\053\078\233\015\180\067\206\067\094\068\146\185\046\067" ..
		-- tex:"b868d7ba70ace02ee1956d9d9767354e"; x:360.124329; y:889.059509; z:174.724899
		"\014\190\061\100\236\109\029\134\238\237\058\120\184\121\254\056\122\015\097\195\238\162\231\067\212\055\049\067" ..
		-- tex:"0ebe3d64ec6d1d86eeed3a78b879fe38"; x:-225.060471; y:463.272919; z:177.218094
		"\088\203\029\225\195\195\228\169\078\104\045\070\041\037\229\101\076\021\176\194\040\164\024\068\149\123\053\067" ..
		-- tex:"58cb1de1c3c3e4a94e682d462925e565"; x:-88.041603; y:610.565002; z:181.482758
		"\099\141\033\248\001\219\119\241\217\140\245\226\190\001\093\168\194\116\176\195\078\079\228\067\059\082\054\067" ..
		-- tex:"638d21f801db77f1d98cf5e2be015da8"; x:-352.912201; y:456.619598; z:182.321228
		"\235\242\109\098\224\034\240\102\188\034\147\201\221\157\082\070\077\196\130\195\046\115\252\067\199\208\084\067" ..
		-- tex:"ebf26d62e022f066bc2293c9dd9d5246"; x:-261.533630; y:504.899872; z:212.815552
		"\025\225\221\237\233\077\218\251\022\191\177\092\045\180\100\177\000\180\130\195\111\141\024\068\199\208\084\067" ..
		-- tex:"19e1ddede94ddafb16bfb15c2db464b1"; x:-261.406281; y:610.209961; z:212.815552
		"\169\137\107\003\250\210\030\046\038\160\149\213\047\037\204\023\028\199\172\195\222\002\239\067\248\079\085\067" ..
		-- tex:"a9896b03fad21e2e26a095d52f25cc17"; x:-345.555573; y:478.022430; z:213.312393
		"\016\167\073\014\207\204\209\010\167\119\081\096\180\216\078\171\015\058\149\195\088\040\122\068\158\163\085\067" ..
		-- tex:"10a7490ecfccd10aa7775160b4d84eab"; x:-298.453613; y:1000.630432; z:213.639145
		"\205\167\202\010\157\096\088\190\209\087\190\019\078\096\252\049\127\208\041\194\088\040\122\068\158\163\085\067" ..
		-- tex:"cda7ca0a9d6058bed157be134e60fc31"; x:-42.453613; y:1000.630432; z:213.639145
		"\125\153\109\028\218\085\022\197\150\144\136\131\180\219\103\081\191\128\089\195\170\091\074\068\255\186\091\067" ..
		-- tex:"7d996d1cda5516c596908883b4db6751"; x:-217.502930; y:809.432312; z:219.730469
		"\234\001\167\088\053\053\140\234\021\231\151\024\223\177\078\126\157\085\225\195\050\209\051\068\148\227\092\067" ..
		-- tex:"ea01a75835358cea15e79718dfb14e7e"; x:-450.668884; y:719.268738; z:220.888992
		"\163\226\249\033\074\062\140\145\029\243\247\097\092\181\152\097\006\203\169\194\104\234\049\068\028\051\093\067" ..
		-- tex:"a3e2f9214a3e8c911df3f7615cb59861"; x:-84.896538; y:711.662659; z:221.199661
		"\048\045\028\244\005\066\234\255\105\226\239\236\106\013\005\150\234\163\026\195\197\163\106\068\019\185\093\067" ..
		-- tex:"302d1cf40542eaff69e2efec6a0d0596"; x:-154.640305; y:938.558960; z:221.722961
		"\049\098\039\239\036\193\130\197\014\160\130\099\055\192\068\005\093\111\068\195\249\246\089\068\019\185\093\067" ..
		-- tex:"316227ef24c182c50ea0826337c04405"; x:-196.435028; y:871.859009; z:221.722961
		"\176\205\083\212\244\228\004\207\102\223\212\060\082\134\060\194\064\108\068\195\055\207\062\068\019\185\093\067" ..
		-- tex:"b0cd53d4f4e404cf66dfd43c52863cc2"; x:-196.422867; y:763.237793; z:221.722961
		"\146\163\113\146\037\044\001\247\121\030\123\126\013\178\226\088\063\228\216\194\175\183\091\068\080\199\093\067" ..
		-- tex:"92a37192252c01f7791e7b7e0db2e258"; x:-108.445801; y:878.870117; z:221.778580
		"\096\171\143\061\120\199\109\141\057\060\062\029\203\255\198\018\233\156\177\194\133\223\022\068\058\205\093\067" ..
		-- tex:"60ab8f3d78c76d8d393c3e1dcbffc612"; x:-88.806473; y:603.492554; z:221.801682
		"\239\009\180\017\244\107\172\094\079\053\065\106\088\235\205\031\035\186\177\194\000\117\247\067\182\212\093\067" ..
		-- tex:"ef09b411f46bac5e4f35416a58ebcd1f"; x:-88.863556; y:494.914093; z:221.830917
		"\076\050\018\239\045\182\218\170\004\140\163\050\052\061\083\104\178\194\219\195\079\091\105\068\061\006\104\067" ..
		-- tex:"4c3212ef2db6daaa048ca332343d5368"; x:-439.521088; y:933.426758; z:232.024384
		"\077\180\152\148\015\015\189\207\127\082\244\225\184\085\254\097\160\192\194\195\177\007\052\068\227\112\104\067" ..
		-- tex:"4db498940f0fbdcf7f52f4e1b855fe61"; x:-389.504913; y:720.120239; z:232.440979
		"\033\162\026\121\028\053\006\143\023\025\094\017\169\010\059\248\093\165\026\195\178\249\051\068\227\112\104\067" ..
		-- tex:"21a21a791c35068f17195e11a90a3bf8"; x:-154.645966; y:719.901550; z:232.440979
		"\218\213\052\034\172\068\087\181\170\010\053\113\093\106\224\244\021\017\089\195\110\131\101\068\230\112\104\067" ..
		-- tex:"dad53422ac4457b5aa0a35715d6ae0f4"; x:-217.066742; y:918.053650; z:232.441025
		"\225\252\024\186\054\171\055\098\156\116\150\247\050\223\250\217\149\018\089\195\099\152\047\068\234\109\105\067" ..
		-- tex:"e1fc18ba36ab37629c7496f732dffad9"; x:-217.072601; y:702.381104; z:233.429367
		"\060\094\144\205\032\004\149\110\220\163\191\106\127\130\187\077\013\077\123\195\230\093\052\068\127\141\105\067" ..
		-- tex:"3c5e90cd2004956edca3bf6a7f82bb4d"; x:-251.300995; y:721.467224; z:233.552734
		"\228\100\083\247\023\102\018\008\186\175\248\074\097\221\242\169\141\075\123\195\067\169\106\068\022\161\105\067" ..
		-- tex:"e46453f717661208baaff84a61ddf2a9"; x:-251.295135; y:938.644775; z:233.629257
		"\060\178\164\142\073\056\232\018\100\181\213\069\138\055\197\195\234\050\039\196\070\245\080\068\198\183\120\067",
		-- tex:"3cb2a48e4938e81264b5d5458a37c5c3"; x:-668.795593; y:835.832458; z:248.717880
	["Blackwing Lair"] = 
		"\181\122\078\152\120\217\009\064\241\031\149\252\201\152\192\052\208\171\193\195\050\209\051\068\148\227\092\067" ..
		-- tex:"b57a4e9878d90940f11f95fcc998c034"; x:-387.342316; y:719.268738; z:220.888992
		"\124\247\244\219\254\189\078\045\173\088\014\056\253\160\153\208\234\163\026\195\197\163\106\068\019\185\093\067" ..
		-- tex:"7cf7f4dbfebd4e2dad580e38fda099d0"; x:-154.640305; y:938.558960; z:221.722961
		"\037\097\100\004\185\128\163\197\154\099\102\193\025\163\031\098\063\228\216\194\175\183\091\068\080\199\093\067" ..
		-- tex:"25616404b980a3c59a6366c119a31f62"; x:-108.445801; y:878.870117; z:221.778580
		"\195\129\198\109\196\092\030\103\044\224\014\035\223\146\056\049\099\205\040\196\230\120\149\068\079\104\104\067" ..
		-- tex:"c381c66dc45c1e672ce00e23df923831"; x:-675.209229; y:1195.778198; z:232.407471
		"\044\111\008\027\049\196\201\150\131\010\254\195\167\148\110\081\199\154\209\195\230\120\149\068\079\104\104\067" ..
		-- tex:"2c6f081b31c4c996830afec3a7946e51"; x:-419.209229; y:1195.778198; z:232.407471
		"\105\034\082\182\001\182\244\219\179\050\246\043\148\112\166\012\021\017\089\195\110\131\101\068\230\112\104\067" ..
		-- tex:"692252b601b6f4dbb332f62b9470a60c"; x:-217.066742; y:918.053650; z:232.441025
		"\083\110\182\219\004\244\068\135\166\019\088\087\233\165\206\050\178\194\219\195\165\215\105\068\244\143\105\067" ..
		-- tex:"536eb6db04f44487a6135857e9a5ce32"; x:-439.521088; y:935.369507; z:233.562332
		"\138\086\125\028\117\038\154\009\155\038\198\008\053\028\013\242\141\075\123\195\067\169\106\068\022\161\105\067" ..
		-- tex:"8a567d1c75269a099b26c608351c0df2"; x:-251.295135; y:938.644775; z:233.629257
		"\170\158\240\182\126\180\202\187\170\145\139\224\141\076\033\170\234\050\039\196\070\245\080\068\139\171\126\067" ..
		-- tex:"aa9ef0b67eb4cabbaa918be08d4c21aa"; x:-668.795593; y:835.832458; z:254.670105
		"\205\147\019\143\033\108\135\055\239\050\010\077\017\068\158\049\101\041\044\196\005\255\106\068\106\167\128\067" ..
		-- tex:"cd93138f216c8737ef320a4d11449e31"; x:-688.646851; y:939.984741; z:257.307953
		"\136\176\150\208\044\016\010\096\008\133\207\153\052\128\238\195\218\114\087\196\242\157\098\068\217\177\128\067" ..
		-- tex:"88b096d02c100a600885cf993480eec3"; x:-861.794617; y:906.467957; z:257.389465
		"\008\068\234\053\217\209\207\214\232\039\013\140\102\139\255\071\190\165\090\196\255\179\045\068\209\171\139\067" ..
		-- tex:"0844ea35d9d1cfd6e8270d8c668bff47"; x:-874.589783; y:694.812500; z:279.342346
		"\191\220\114\054\035\143\141\227\068\085\192\105\017\165\225\063\213\156\056\196\190\027\034\068\065\139\148\067" ..
		-- tex:"bfdc7236238f8de34455c06911a5e13f"; x:-738.450562; y:648.433533; z:297.087952
		"\210\053\231\254\173\103\184\230\070\192\221\116\106\071\229\128\086\074\038\196\182\110\089\068\208\173\159\067" ..
		-- tex:"d235e7fead67b8e646c0dd746a47e580"; x:-665.161560; y:869.729919; z:319.357941
		"\000\183\104\048\196\007\106\101\063\201\110\022\007\212\133\123\105\178\038\196\067\228\044\068\040\037\160\067" ..
		-- tex:"00b76830c4076a653fc96e1607d4857b"; x:-666.787720; y:691.566650; z:320.290314
		"\082\250\255\138\083\072\164\141\129\009\217\052\075\223\110\207\211\100\205\195\067\228\108\068\040\037\160\067" ..
		-- tex:"52faff8a5348a48d8109d9344bdf6ecf"; x:-410.787720; y:947.566650; z:320.290314
		"\155\004\137\133\245\157\188\230\135\217\070\189\051\009\052\020\211\100\205\195\067\228\044\068\040\037\160\067" ..
		-- tex:"9b048985f59dbce687d946bd33093414"; x:-410.787720; y:691.566650; z:320.290314
		"\069\209\100\251\059\242\091\172\075\188\123\090\009\191\089\030\105\178\038\196\067\228\108\068\040\037\160\067" ..
		-- tex:"45d164fb3bf25bac4bbc7b5a09bf591e"; x:-666.787720; y:947.566650; z:320.290314
		"\095\159\113\249\015\251\145\064\120\033\169\040\192\254\141\173\224\227\091\196\094\171\091\068\093\237\163\067" ..
		-- tex:"5f9f71f90ffb91407821a928c0fe8dad"; x:-879.560608; y:878.677673; z:327.854431
		"\180\238\084\004\036\066\085\139\212\216\127\227\007\232\225\246\143\042\098\196\082\163\072\068\205\103\169\067" ..
		-- tex:"b4ee54042442558bd4d87fe307e8e1f6"; x:-904.665039; y:802.551941; z:338.810974
		"\109\099\053\051\068\212\124\138\234\110\216\207\016\051\092\219\152\017\130\196\152\229\063\068\187\010\185\067" ..
		-- tex:"6d63353344d47c8aea6ed8cf10335cdb"; x:-1040.549927; y:767.587463; z:370.083862
		"\231\015\142\105\069\086\018\183\022\067\022\235\223\113\068\111\152\017\130\196\152\229\127\068\187\010\185\067" ..
		-- tex:"e70f8e69455612b7164316ebdf71446f"; x:-1040.549927; y:1023.587463; z:370.083862
		"\090\122\163\152\176\233\187\192\184\163\074\081\060\001\182\166\095\221\135\196\085\181\129\068\100\031\185\067" ..
		-- tex:"5a7aa398b0e9bbc0b8a34a513c01b6a6"; x:-1086.917969; y:1037.666748; z:370.245270
		"\098\079\003\242\028\005\237\153\090\150\225\255\225\029\245\006\191\186\079\196\085\181\129\068\100\031\185\067" ..
		-- tex:"624f03f21c05ed995a96e1ffe11df506"; x:-830.917969; y:1037.666748; z:370.245270
		"\055\158\199\128\207\170\109\181\099\028\033\250\210\007\163\122\097\035\018\196\114\100\141\068\130\236\188\067" ..
		-- tex:"379ec780cfaa6db5631c21fad207a37a"; x:-584.552856; y:1131.139038; z:377.847748
		"\203\164\148\038\044\043\140\246\169\203\177\000\166\223\125\177\012\136\199\195\114\100\141\068\131\236\188\067" ..
		-- tex:"cba494262c2b8cf6a9cbb100a6df7db1"; x:-399.062897; y:1131.139038; z:377.847778
		"\180\121\251\065\103\027\214\238\122\031\101\176\082\158\006\251\050\170\077\196\022\134\112\068\200\169\196\067" ..
		-- tex:"b479fb41671bd6ee7a1f65b0529e06fb"; x:-822.659363; y:962.095154; z:393.326447
		"\230\129\049\132\043\246\157\225\036\153\185\253\223\003\137\231\063\191\057\196\133\137\149\068\158\178\196\067" ..
		-- tex:"e68131842bf69de12499b9fddf0389e7"; x:-742.988281; y:1196.297607; z:393.395477
		"\230\137\212\141\116\135\083\048\144\230\224\182\124\164\006\156\197\051\039\196\143\076\152\068\159\178\196\067",
		-- tex:"e689d48d7487533090e6e0b67ca4069c"; x:-668.808960; y:1218.392578; z:393.395508
	["Cathedral"] = 
		"\105\062\059\131\146\174\254\099\238\135\049\080\064\053\033\109\137\193\131\196\255\170\235\195\203\015\141\191" ..
		-- tex:"693e3b8392aefe63ee8731504035216d"; x:-1054.048096; y:-471.335938; z:-1.102045
		"\063\069\151\089\020\218\215\051\083\220\096\217\215\075\186\195\137\193\131\196\255\085\087\195\203\015\141\191" ..
		-- tex:"3f45975914dad73353dc60d9d74bbac3"; x:-1054.048096; y:-215.335938; z:-1.102045
		"\248\246\049\075\104\002\211\228\074\173\141\217\240\162\238\046\019\131\071\196\255\170\235\195\203\015\141\191" ..
		-- tex:"f8f6314b6802d3e44aad8dd9f0a2ee2e"; x:-798.048096; y:-471.335938; z:-1.102045
		"\044\043\159\081\155\087\043\123\063\214\024\207\188\250\040\084\019\131\071\196\255\085\087\195\203\015\141\191" ..
		-- tex:"2c2b9f519b572b7b3fd618cfbcfa2854"; x:-798.048096; y:-215.335938; z:-1.102045
		"\022\072\168\185\161\033\200\219\189\215\230\129\218\102\232\036\019\131\007\196\255\170\235\195\203\015\141\191" ..
		-- tex:"1648a8b9a121c8dbbdd7e681da66e824"; x:-542.048096; y:-471.335938; z:-1.102045
		"\231\223\017\157\047\117\041\101\075\212\172\084\060\108\006\122\019\131\007\196\255\085\087\195\203\015\141\191" ..
		-- tex:"e7df119d2f7529654bd4ac543c6c067a"; x:-542.048096; y:-215.335938; z:-1.102045
		"\138\052\080\085\056\222\230\179\050\161\138\206\012\056\195\230\155\246\154\195\195\097\060\195\033\220\026\065" ..
		-- tex:"8a34505538dee6b332a18ace0c38c3e6"; x:-309.926636; y:-188.381897; z:9.678743
		"\082\130\209\107\251\185\202\227\073\243\033\249\150\024\005\157\077\123\013\196\225\048\222\195\033\220\026\065" ..
		-- tex:"5282d16bfbb9cae349f321f99618059d"; x:-565.926636; y:-444.381897; z:9.678743
		"\180\137\149\023\109\091\000\024\097\214\185\195\250\159\210\129\077\123\013\196\195\097\060\195\033\220\026\065" ..
		-- tex:"b48995176d5b001861d6b9c3fa9fd281"; x:-565.926636; y:-188.381897; z:9.678743
		"\237\082\053\117\108\248\006\106\017\094\113\014\210\195\069\069\155\246\154\195\225\048\222\195\033\220\026\065" ..
		-- tex:"ed5235756cf8066a115e710ed2c34545"; x:-309.926636; y:-444.381897; z:9.678743
		"\195\224\165\096\149\237\141\154\142\172\147\238\097\010\006\109\164\095\157\195\167\229\102\194\167\110\207\065" ..
		-- tex:"c3e0a56095ed8d9a8eac93ee610a066d"; x:-314.747223; y:-57.724274; z:25.929031
		"\202\219\046\031\036\026\123\140\196\035\094\067\225\171\084\061\019\159\174\195\177\129\140\194\119\133\015\066" ..
		-- tex:"cadb2e1f241a7b8cc4235e43e1ab543d"; x:-349.242798; y:-70.253311; z:35.880341
		"\231\075\129\053\021\199\156\213\001\024\066\016\092\206\019\241\159\179\174\195\153\055\034\195\119\133\015\066" ..
		-- tex:"e74b813515c79cd5011842105cce13f1"; x:-349.403320; y:-162.217194; z:35.880341
		"\057\088\015\099\093\155\217\117\072\106\044\205\233\048\255\193\099\159\174\195\126\073\003\195\119\133\015\066" ..
		-- tex:"39580f635d9bd975486a2ccde930ffc1"; x:-349.245239; y:-131.287094; z:35.880341
		"\169\151\219\217\134\073\077\065\079\083\074\118\057\014\190\106\099\159\174\195\061\230\201\194\119\133\015\066" ..
		-- tex:"a997dbd986494d414f534a76390ebe6a"; x:-349.245239; y:-100.949692; z:35.880341
		"\174\143\092\149\155\092\204\157\003\162\051\029\145\239\083\153\088\113\173\195\204\128\210\065\099\136\015\066" ..
		-- tex:"ae8f5c959b5ccc9d03a2331d91ef5399"; x:-346.885529; y:26.312891; z:35.883194
		"\235\021\204\077\047\239\204\105\137\093\125\171\124\231\161\174\137\238\179\195\045\152\109\195\158\172\015\066" ..
		-- tex:"eb15cc4d2fefcc69895d7dab7ce7a1ae"; x:-359.863586; y:-237.594452; z:35.918575
		"\051\037\196\144\004\048\240\138\083\163\126\127\202\129\054\168\159\179\174\195\155\213\062\195\098\211\015\066" ..
		-- tex:"3325c4900430f08a53a37e7fca8136a8"; x:-349.403320; y:-190.834412; z:35.956432
		"\073\221\229\113\085\047\093\251\124\239\165\057\033\105\036\082\019\218\146\195\007\163\167\194\142\173\019\066" ..
		-- tex:"49dde571552f5dfb7cefa53921692452"; x:-293.703735; y:-83.818420; z:36.919491
		"\174\075\010\184\183\039\087\125\117\229\190\133\124\094\174\038\018\004\147\195\096\243\090\066\015\111\020\066" ..
		-- tex:"ae4b0ab8b727577d75e5be857c5eae26"; x:-294.031830; y:54.737675; z:37.108459
		"\210\225\245\168\119\116\029\018\196\172\157\139\150\082\248\210\166\095\157\195\209\115\156\065\203\037\021\066" ..
		-- tex:"d2e1f5a877741d12c4ac9d8b9652f8d2"; x:-314.747284; y:19.556553; z:37.286911
		"\130\252\015\012\234\079\192\111\062\093\146\224\194\196\102\017\059\137\140\195\097\228\077\194\029\049\021\066" ..
		-- tex:"82fc0f0cea4fc06f3e5d92e0c2c46611"; x:-281.072144; y:-51.473030; z:37.297966
		"\203\139\040\169\179\070\250\031\001\223\175\042\070\134\045\065\150\233\010\195\114\225\010\194\017\050\021\066" ..
		-- tex:"cb8b28a9b346fa1f01dfaf2a46862d41"; x:-138.912460; y:-34.720165; z:37.298897
		"\161\194\133\007\121\145\208\225\242\096\001\209\186\202\054\108\163\233\010\195\201\122\072\065\017\050\021\066" ..
		-- tex:"a1c285077991d0e1f26001d1baca366c"; x:-138.912659; y:12.529978; z:37.298897
		"\095\183\019\141\035\029\135\226\105\110\055\099\014\142\210\054\000\112\128\196\177\164\109\195\222\130\101\066" ..
		-- tex:"5fb7138d231d87e2696e37630e8ed236"; x:-1027.500122; y:-237.643341; z:57.377804
		"\221\162\135\037\207\124\006\064\042\010\180\099\174\177\089\044\130\033\106\196\219\140\168\194\089\248\113\066" ..
		-- tex:"dda28725cf7c06402a0ab463aeb1592c"; x:-936.523621; y:-84.275116; z:60.492531
		"\205\238\083\240\239\139\000\019\043\239\208\107\236\214\155\196\130\033\106\196\054\035\170\195\089\248\113\066" ..
		-- tex:"cdee53f0ef8b00132befd06becd69bc4"; x:-936.523621; y:-340.275116; z:60.492531
		"\043\238\076\237\224\123\141\169\068\002\168\014\058\239\227\082\193\199\104\196\019\032\166\195\102\055\114\066" ..
		-- tex:"2bee4cede07b8da94402a80e3aefe352"; x:-931.121216; y:-332.250610; z:60.554104
		"\229\240\090\067\194\188\083\020\104\227\039\107\005\066\025\184\047\200\104\196\126\225\147\195\102\055\114\066" ..
		-- tex:"e5f05a43c2bc531468e3276b054219b8"; x:-931.127930; y:-295.761688; z:60.554104
		"\215\116\077\118\177\186\116\016\116\195\069\229\102\227\197\136\193\199\104\196\006\157\255\194\006\057\114\066" ..
		-- tex:"d7744d76b1ba741074c345e566e3c588"; x:-931.121216; y:-127.806694; z:60.555691
		"\157\095\222\202\209\075\067\158\116\166\112\074\118\087\050\044\193\199\104\196\172\244\202\194\013\057\114\066" ..
		-- tex:"9d5fdecad14b439e74a6704a7657322c"; x:-931.121216; y:-101.477882; z:60.555717
		"\069\112\127\170\105\205\017\114\003\133\074\128\212\177\169\141\114\113\108\196\109\048\088\195\095\142\127\066" ..
		-- tex:"45707faa69cd117203854a80d4b1a98d"; x:-945.772644; y:-216.189178; z:63.889038
		"\007\053\059\072\252\125\078\171\129\230\035\176\239\112\181\060\180\228\129\196\225\189\121\195\013\206\173\066",
		-- tex:"07353b48fc7d4eab81e623b0ef70b53c"; x:-1039.147095; y:-249.741730; z:86.902451
	["Dire Maul"] = 
		"\176\038\053\046\091\120\108\084\255\152\163\082\015\099\225\060\093\149\130\067\099\203\153\196\170\250\111\195" ..
		-- tex:"b026352e5b786c54ff98a3520f63e13c"; x:261.166931; y:-1230.355957; z:-239.979172
		"\026\071\017\141\240\199\217\080\120\144\111\142\046\186\124\198\174\074\001\068\199\150\051\196\170\250\111\195" ..
		-- tex:"1a47118df0c7d95078906f8e2eba7cc6"; x:517.166931; y:-718.355957; z:-239.979172
		"\255\195\128\244\116\007\074\187\038\046\002\228\223\012\203\122\174\074\065\068\199\150\115\196\170\250\111\195" ..
		-- tex:"ffc380f474074abb262e02e4df0ccb7a"; x:773.166931; y:-974.355957; z:-239.979172
		"\033\029\209\060\183\168\087\017\223\095\250\211\150\059\001\157\174\074\001\068\199\150\115\196\170\250\111\195" ..
		-- tex:"211dd13cb7a85711df5ffad3963b019d"; x:517.166931; y:-974.355957; z:-239.979172
		"\036\015\020\180\206\229\178\086\120\057\032\068\253\108\162\113\093\149\130\067\199\150\115\196\170\250\111\195" ..
		-- tex:"240f14b4cee5b25678392044fd6ca271"; x:261.166931; y:-974.355957; z:-239.979172
		"\115\232\076\081\081\138\167\038\044\038\148\002\043\206\043\177\093\149\130\067\199\150\051\196\170\250\111\195" ..
		-- tex:"73e84c51518aa7262c2694022bce2bb1"; x:261.166931; y:-718.355957; z:-239.979172
		"\015\152\234\127\174\026\240\205\044\200\084\129\014\014\128\182\174\074\001\068\099\203\153\196\170\250\111\195" ..
		-- tex:"0f98ea7fae1af0cd2cc854810e0e80b6"; x:517.166931; y:-1230.355957; z:-239.979172
		"\184\052\150\232\071\018\182\088\103\124\194\161\189\054\053\005\236\017\245\067\235\058\066\196\124\113\106\195" ..
		-- tex:"b83496e84712b658677cc2a1bd363505"; x:490.140045; y:-776.920654; z:-234.443314
		"\081\026\239\102\151\138\186\216\181\096\143\109\134\215\180\076\141\236\004\068\081\028\049\196\093\128\078\195" ..
		-- tex:"511aef66978abad8b5608f6d86d7b44c"; x:531.696167; y:-708.442505; z:-206.501434
		"\144\095\206\142\040\003\079\098\038\221\053\094\187\211\022\150\056\215\239\067\105\212\026\196\191\187\042\195" ..
		-- tex:"905fce8e28034f6226dd355ebbd31696"; x:479.681427; y:-619.318970; z:-170.733398
		"\195\178\213\104\216\027\200\095\031\021\206\162\003\168\099\110\012\020\120\195\015\095\109\196\165\146\244\194" ..
		-- tex:"c3b2d568d81bc85f1f15cea203a8636e"; x:-248.078323; y:-949.485352; z:-122.286423
		"\110\158\214\047\147\126\209\010\153\255\246\234\139\171\155\204\095\126\253\064\015\095\109\196\165\146\244\194" ..
		-- tex:"6e9ed62f937ed10a99fff6ea8bab9bcc"; x:7.921677; y:-949.485352; z:-122.286423
		"\028\047\254\228\051\068\064\221\198\167\130\198\242\230\248\157\187\006\130\194\205\195\058\196\001\161\237\194" ..
		-- tex:"1c2ffee4334440ddc6a782c6f2e6f89d"; x:-65.013153; y:-747.059448; z:-118.814468
		"\014\039\079\141\169\147\150\036\224\000\220\215\032\132\242\045\187\006\130\194\155\135\245\195\001\161\237\194" ..
		-- tex:"0e274f8da9939624e000dcd72084f22d"; x:-65.013153; y:-491.059448; z:-118.814468
		"\089\081\088\204\113\132\250\191\063\117\199\046\192\240\187\255\161\252\062\067\205\195\058\196\001\161\237\194" ..
		-- tex:"595158cc7184fabf3f75c72ec0f0bbff"; x:190.986847; y:-747.059448; z:-118.814468
		"\241\109\030\092\063\110\067\150\130\202\188\022\101\117\094\020\161\252\062\067\155\135\245\195\001\161\237\194" ..
		-- tex:"f16d1e5c3f6e439682cabc1665755e14"; x:190.986847; y:-491.059448; z:-118.814468
		"\091\145\126\037\087\031\038\096\072\116\064\224\153\090\168\161\174\129\160\195\205\195\058\196\001\161\237\194" ..
		-- tex:"5b917e25571f2660487440e0995aa8a1"; x:-321.013153; y:-747.059448; z:-118.814468
		"\044\163\216\199\024\142\093\052\029\028\027\057\124\125\186\056\174\129\160\195\155\135\245\195\001\161\237\194" ..
		-- tex:"2ca3d8c7188e5d341d1c1b397c7dba38"; x:-321.013153; y:-491.059448; z:-118.814468
		"\078\149\120\114\099\234\106\172\066\221\244\040\111\143\169\253\050\134\160\195\151\108\129\196\209\071\234\194" ..
		-- tex:"4e95787263ea6aac42ddf4286f8fa9fd"; x:-321.048431; y:-1035.393555; z:-117.140274
		"\214\029\235\246\238\154\041\223\121\168\151\029\234\093\125\009\104\130\151\195\130\239\077\196\197\105\230\194" ..
		-- tex:"d61debf6ee9a29df79a8971dea5d7d09"; x:-303.018829; y:-823.742371; z:-115.206589
		"\118\003\162\251\230\050\164\222\023\110\144\129\145\184\161\154\080\161\083\066\058\161\120\196\234\139\228\194" ..
		-- tex:"7603a2fbe632a4de176e908191b8a19a"; x:52.907536; y:-994.519226; z:-114.273277
		"\244\193\247\076\254\001\079\183\053\097\054\009\079\149\153\058\167\142\132\195\000\141\075\196\076\056\228\194" ..
		-- tex:"f4c1f74cfe014fb7356136094f95993a"; x:-265.114502; y:-814.203186; z:-114.109962
		"\044\066\171\089\028\162\035\103\121\208\180\080\034\105\242\076\062\242\147\195\213\004\062\196\047\045\228\194" ..
		-- tex:"2c42ab591ca2236779d0b4502269f24c"; x:-295.892548; y:-760.075562; z:-114.088257
		"\168\216\040\144\146\016\180\062\061\032\201\044\160\132\126\182\097\022\234\067\036\133\025\196\083\128\226\194" ..
		-- tex:"a8d828909210b43e3d20c92ca0847eb6"; x:468.174866; y:-614.080383; z:-113.250641
		"\041\147\250\034\007\006\068\216\043\035\240\153\207\004\091\224\080\061\183\067\106\026\014\196\083\128\226\194" ..
		-- tex:"2993fa22070644d82b23f099cf045be0"; x:366.479034; y:-568.412781; z:-113.250641
		"\074\012\104\091\107\177\214\051\170\118\061\240\249\131\041\046\040\241\130\067\219\025\014\196\254\099\226\194" ..
		-- tex:"4a0c685b6bb1d633aa763df0f983292e"; x:261.884064; y:-568.404053; z:-113.195305
		"\084\106\022\001\072\208\204\181\221\173\077\086\041\063\233\230\167\111\000\068\252\072\036\196\245\086\226\194" ..
		-- tex:"546a160148d0ccb5ddad4d56293fe9e6"; x:513.744629; y:-657.140442; z:-113.169846
		"\025\129\109\104\087\127\233\220\180\148\232\010\007\232\002\009\091\025\194\067\019\011\007\196\070\245\201\194" ..
		-- tex:"19816d68577fe9dcb494e80a07e80209"; x:388.198120; y:-540.173096; z:-100.979057
		"\008\049\222\039\139\033\249\105\227\247\028\116\190\068\133\055\041\107\082\067\227\084\140\068\024\000\194\194" ..
		-- tex:"0831de278b21f969e3f71c74be448537"; x:210.418610; y:1122.652771; z:-97.000191
		"\156\176\070\086\236\099\246\082\247\111\126\255\022\124\039\057\041\107\082\067\198\169\088\068\024\000\194\194" ..
		-- tex:"9cb04656ec63f652f76f7eff167c2739"; x:210.418610; y:866.652771; z:-97.000191
		"\144\170\134\189\127\037\159\151\046\019\149\044\004\204\054\009\004\035\163\067\211\131\078\068\211\012\191\194" ..
		-- tex:"90aa86bd7f259f972e13952c04cc3609"; x:326.273590; y:826.059814; z:-95.525055
		"\000\055\188\154\220\135\161\013\149\101\047\060\167\167\147\190\224\153\252\067\014\034\055\068\207\012\191\194" ..
		-- tex:"0037bc9adc87a10d95652f3ca7a793be"; x:505.202179; y:732.532166; z:-95.525024
		"\021\048\248\121\042\249\001\145\208\111\067\125\173\130\097\223\220\082\173\067\019\228\083\068\080\241\187\194" ..
		-- tex:"1530f8792af90191d06f437dad8261df"; x:346.647369; y:847.563721; z:-93.971321
		"\089\222\198\040\142\191\115\218\046\068\116\241\219\174\159\085\211\053\013\068\139\002\224\195\166\135\186\194" ..
		-- tex:"59dec6288ebf73da2e4474f1dbae9f55"; x:564.841034; y:-448.019897; z:-93.264946
		"\205\202\189\166\115\186\205\020\146\130\020\054\236\066\127\149\166\107\154\067\069\001\048\196\166\135\186\194" ..
		-- tex:"cdcabda673bacd1492821436ec427f95"; x:308.841034; y:-704.019897; z:-93.264946
		"\093\203\196\110\255\017\212\105\055\047\107\001\061\045\221\247\211\053\013\068\069\001\048\196\166\135\186\194" ..
		-- tex:"5dcbc46eff11d469372f6b013d2dddf7"; x:564.841034; y:-704.019897; z:-93.264946
		"\071\166\158\199\095\212\004\057\236\226\148\232\035\225\145\196\211\053\013\068\069\001\112\196\166\135\186\194" ..
		-- tex:"47a69ec75fd40439ece294e823e191c4"; x:564.841034; y:-960.019897; z:-93.264946
		"\193\002\137\107\128\193\024\185\211\011\111\235\100\030\161\030\211\053\077\068\069\001\112\196\166\135\186\194" ..
		-- tex:"c102896b80c118b9d30b6feb641ea11e"; x:820.841034; y:-960.019897; z:-93.264946
		"\065\218\186\088\138\111\128\147\081\192\096\117\000\168\226\027\166\107\154\067\162\000\184\196\166\135\186\194" ..
		-- tex:"41daba588a6f809351c0607500a8e21b"; x:308.841034; y:-1472.019897; z:-93.264946
		"\211\250\012\129\060\129\199\011\109\093\002\098\051\225\161\124\088\148\229\195\139\002\224\195\166\135\186\194" ..
		-- tex:"d3fa0c813c81c70b6d5d026233e1a17c"; x:-459.158966; y:-448.019897; z:-93.264946
		"\087\209\081\066\212\115\242\009\126\205\234\210\220\100\034\253\088\148\229\195\069\001\112\196\166\135\186\194" ..
		-- tex:"57d15142d473f2097ecdead2dc6422fd"; x:-459.158966; y:-960.019897; z:-93.264946
		"\248\142\078\214\142\229\114\172\238\225\231\111\219\075\223\028\177\040\075\195\069\001\112\196\166\135\186\194" ..
		-- tex:"f88e4ed68ee572aceee1e76fdb4bdf1c"; x:-203.158966; y:-960.019897; z:-93.264946
		"\048\105\134\208\203\059\048\139\141\212\075\224\049\036\118\078\041\175\022\068\029\032\017\068\037\125\171\194" ..
		-- tex:"306986d0cb3b308b8dd44be03124764e"; x:602.736938; y:580.501831; z:-85.744431
		"\238\074\061\033\047\010\246\062\157\026\136\133\223\063\147\238\035\227\239\194\201\253\066\196\232\221\164\194" ..
		-- tex:"ee4a3d212f0af63e9d1a8885df3f93ee"; x:-119.943634; y:-779.965454; z:-82.433418
		"\224\007\022\246\066\047\101\105\154\023\171\043\116\156\066\246\200\248\187\195\201\253\066\196\232\221\164\194" ..
		-- tex:"e00716f6422f65699a17ab2b749c42f6"; x:-375.943634; y:-779.965454; z:-82.433418
		"\100\082\221\120\154\207\024\006\181\142\019\217\161\210\088\038\200\248\187\195\201\253\002\196\232\221\164\194" ..
		-- tex:"6452dd789acf1806b58e13d9a1d25826"; x:-375.943634; y:-523.965454; z:-82.433418
		"\134\218\093\138\074\056\012\049\183\121\206\145\001\068\035\015\109\014\008\067\201\253\002\196\232\221\164\194" ..
		-- tex:"86da5d8a4a380c31b779ce910144230f"; x:136.056366; y:-523.965454; z:-82.433418
		"\046\165\134\070\099\162\172\216\177\105\158\209\228\133\099\042\109\014\008\067\201\253\066\196\232\221\164\194" ..
		-- tex:"2ea5864663a2acd8b1699ed1e485632a"; x:136.056366; y:-779.965454; z:-82.433418
		"\212\101\054\136\104\036\054\043\142\141\245\182\183\021\046\081\035\227\239\194\201\253\002\196\232\221\164\194" ..
		-- tex:"d46536886824362b8e8df5b6b7152e51"; x:-119.943634; y:-523.965454; z:-82.433418
		"\074\180\217\217\216\047\248\193\010\053\069\056\119\250\074\248\207\115\022\068\180\007\217\067\002\213\151\194" ..
		-- tex:"4ab4d9d9d82ff8c10a35453877fa4af8"; x:601.809570; y:434.060211; z:-75.916039
		"\221\018\066\184\164\232\114\120\147\217\109\230\098\175\251\074\009\198\214\193\149\174\070\067\048\099\146\194" ..
		-- tex:"dd1242b8a4e8727893d96de662affb4a"; x:-26.846699; y:198.681976; z:-73.193733
		"\099\185\205\013\030\185\179\073\018\253\051\072\117\060\011\009\165\198\214\193\107\023\005\067\168\098\146\194" ..
		-- tex:"63b9cd0d1eb9b34912fd3348753c0b09"; x:-26.846996; y:133.091492; z:-73.192696
		"\255\200\166\249\039\061\220\209\135\108\035\177\199\071\151\048\207\246\114\066\081\030\038\067\167\098\146\194" ..
		-- tex:"ffc8a6f9273ddcd1876c23b1c7479730"; x:60.741028; y:166.118439; z:-73.192688
		"\169\001\072\184\119\042\223\087\132\171\253\051\064\061\189\122\066\196\031\068\121\119\152\067\030\242\145\194" ..
		-- tex:"a90148b8772adf5784abfd33403dbd7a"; x:639.066589; y:304.933411; z:-72.972893
		"\192\042\159\228\182\132\118\235\110\050\005\048\026\080\037\171\162\148\060\193\150\149\120\196\102\193\145\194" ..
		-- tex:"c02a9fe4b68476eb6e3205301a5025ab"; x:-11.786288; y:-994.337341; z:-72.877739
		"\032\195\022\042\138\109\101\004\075\228\255\198\101\149\103\107\085\144\158\192\083\184\010\067\100\077\145\194" ..
		-- tex:"20c3162a8a6d65044be4ffc66595676b"; x:-4.955119; y:138.720032; z:-72.651161
		"\188\182\058\169\125\040\183\108\235\205\201\010\028\017\235\142\222\228\112\194\077\116\117\067\247\072\145\194" ..
		-- tex:"bcb63aa97d28b76cebcdc90a1c11eb8e"; x:-60.223507; y:245.454315; z:-72.642517
		"\099\083\129\228\240\254\000\240\076\060\082\030\006\088\222\091\001\057\119\194\069\148\133\067\247\072\145\194" ..
		-- tex:"635381e4f0fe00f04c3c521e0658de5b"; x:-61.805672; y:267.158386; z:-72.642517
		"\173\057\098\143\015\122\067\194\138\071\081\041\046\057\001\245\245\145\168\065\124\001\221\066\055\070\145\194" ..
		-- tex:"ad39628f0f7a43c28a4751292e3901f5"; x:21.071270; y:110.502907; z:-72.637146
		"\249\227\031\252\230\011\022\116\096\235\255\131\078\119\009\027\164\053\167\065\143\070\088\066\055\070\145\194" ..
		-- tex:"f9e31ffce60b167460ebff834e77091b"; x:20.901194; y:54.068909; z:-72.637146
		"\242\225\153\091\145\165\158\221\230\163\009\178\153\204\161\238\058\222\070\068\073\090\110\067\243\082\143\194" ..
		-- tex:"f2e1995b91a59edde6a309b299cca1ee"; x:795.472351; y:238.352692; z:-71.662018
		"\155\206\043\172\178\141\148\249\205\242\233\004\140\211\048\222\058\222\006\068\073\090\110\067\243\082\143\194" ..
		-- tex:"9bce2bacb28d94f9cdf2e9048cd330de"; x:539.472351; y:238.352692; z:-71.662018
		"\008\219\210\133\211\224\177\057\249\232\208\108\230\118\047\018\058\222\070\068\175\045\141\193\243\082\143\194" ..
		-- tex:"08dbd285d3e0b139f9e8d06ce6762f12"; x:795.472351; y:-17.647308; z:-71.662018
		"\101\013\223\124\107\061\227\181\039\028\080\095\126\069\229\078\058\222\070\068\218\210\136\195\243\082\143\194" ..
		-- tex:"650ddf7c6b3de3b5271c505f7e45e54e"; x:795.472351; y:-273.647308; z:-71.662018
		"\000\068\074\108\232\063\147\230\014\051\176\231\163\136\141\240\058\222\006\068\175\045\141\193\243\082\143\194" ..
		-- tex:"00444a6ce83f93e60e33b0e7a3888df0"; x:539.472351; y:-17.647308; z:-71.662018
		"\216\248\235\224\157\239\157\005\226\055\003\251\025\253\127\167\102\020\045\068\102\127\044\067\243\082\143\194" ..
		-- tex:"d8f8ebe09def9d05e23703fb19fd7fa7"; x:692.318787; y:172.497665; z:-71.662018
		"\028\223\180\043\002\131\027\181\190\156\089\051\190\198\246\009\058\222\006\068\218\210\136\195\243\082\143\194" ..
		-- tex:"1cdfb42b02831bb5be9c5933bec6f609"; x:539.472351; y:-273.647308; z:-71.662018
		"\032\180\207\089\193\010\245\136\118\037\176\123\150\032\053\207\104\230\203\194\100\168\150\067\086\040\138\194" ..
		-- tex:"20b4cf59c10af5887625b07b962035cf"; x:-101.950020; y:301.315582; z:-69.078789
		"\247\149\202\175\013\175\113\096\104\136\255\090\189\208\089\000\123\029\191\066\038\218\213\068\184\091\132\194" ..
		-- tex:"f795caaf0daf71606888ff5abdd05900"; x:95.557587; y:1710.817261; z:-66.179146
		"\012\163\054\158\112\007\109\237\021\099\182\216\243\011\227\014\160\056\208\195\038\218\213\068\184\091\132\194" ..
		-- tex:"0ca3369e70076ded1563b6d8f30be30e"; x:-416.442413; y:1710.817261; z:-66.179146
		"\128\058\024\212\079\154\129\003\166\149\146\205\175\168\073\242\065\113\032\195\038\218\149\068\184\091\132\194" ..
		-- tex:"803a18d44f9a8103a69592cdafa849f2"; x:-160.442413; y:1198.817261; z:-66.179146
		"\065\071\016\209\046\170\170\155\160\123\012\075\148\014\007\233\160\056\208\195\038\218\181\068\184\091\132\194" ..
		-- tex:"414710d12eaaaa9ba07b0c4b940e07e9"; x:-416.442413; y:1454.817261; z:-66.179146
		"\009\236\110\084\191\047\047\071\124\092\255\015\249\054\192\254\123\029\191\066\038\218\181\068\184\091\132\194" ..
		-- tex:"09ec6e54bf2f2f477c5cff0ff936c0fe"; x:95.557587; y:1454.817261; z:-66.179146
		"\007\243\089\200\007\061\190\106\190\181\057\080\240\126\162\188\160\056\208\195\038\218\149\068\184\091\132\194" ..
		-- tex:"07f359c8073dbe6abeb53950f07ea2bc"; x:-416.442413; y:1198.817261; z:-66.179146
		"\086\200\066\063\090\251\245\224\202\074\009\179\164\209\223\123\065\113\032\195\038\218\213\068\184\091\132\194" ..
		-- tex:"56c8423f5afbf5e0ca4a09b3a4d1df7b"; x:-160.442413; y:1710.817261; z:-66.179146
		"\125\087\092\191\107\046\139\225\133\170\241\092\114\199\167\035\123\029\191\066\038\218\149\068\184\091\132\194" ..
		-- tex:"7d575cbf6b2e8be185aaf15c72c7a723"; x:95.557587; y:1198.817261; z:-66.179146
		"\226\182\254\112\238\072\229\114\000\241\207\160\179\183\190\053\065\113\032\195\038\218\181\068\184\091\132\194" ..
		-- tex:"e2b6fe70ee48e57200f1cfa0b3b7be35"; x:-160.442413; y:1454.817261; z:-66.179146
		"\043\190\008\193\032\178\245\244\111\144\220\171\168\223\126\185\136\090\084\194\009\203\216\196\095\077\132\194" ..
		-- tex:"2bbe08c120b2f5f46f90dcaba8df7eb9"; x:-53.088413; y:-1734.344971; z:-66.151123
		"\064\182\062\005\092\252\089\221\036\221\156\097\117\081\073\191\206\126\057\194\017\214\217\196\080\077\132\194" ..
		-- tex:"40b63e055cfc59dd24dd9c61755149bf"; x:-46.373837; y:-1742.689697; z:-66.151009
		"\252\248\178\141\015\149\231\240\198\103\170\067\087\091\189\020\012\060\105\065\141\009\210\196\125\072\132\194" ..
		-- tex:"fcf8b28d0f95e7f0c667aa43575bbd14"; x:14.577161; y:-1680.298584; z:-66.141586
		"\249\122\096\041\227\028\138\058\164\058\194\109\098\025\050\232\240\188\138\194\076\077\027\194\103\151\126\194" ..
		-- tex:"f97a6029e31c8a3aa43ac26d621932e8"; x:-69.369026; y:-38.825489; z:-63.647858
		"\192\196\134\197\083\052\189\079\126\087\179\239\071\184\081\193\202\078\042\066\180\147\210\196\074\209\119\194" ..
		-- tex:"c0c486c55334bd4f7e57b3ef47b851c1"; x:42.576946; y:-1684.615845; z:-61.954388
		"\133\242\237\226\143\162\057\038\065\039\177\206\041\220\082\073\230\024\156\067\221\051\250\195\141\077\094\194" ..
		-- tex:"85f2ede28fa239264127b1ce29dc5249"; x:312.194550; y:-500.405212; z:-55.575737
		"\073\042\156\111\249\253\032\194\239\064\063\136\189\077\221\096\001\128\038\195\180\253\163\067\184\080\088\194" ..
		-- tex:"492a9c6ff9fd20c2ef403f88bd4ddd60"; x:-166.500031; y:327.982086; z:-54.078831
		"\100\242\171\168\188\085\154\120\126\098\175\200\127\191\234\198\212\029\188\066\212\003\204\196\004\124\086\194" ..
		-- tex:"64f2aba8bc559a787e62afc87fbfeac6"; x:94.058266; y:-1632.119751; z:-53.621113
		"\192\066\222\025\087\054\181\183\077\177\116\110\250\184\168\174\198\110\245\066\020\138\154\068\067\094\082\194" ..
		-- tex:"c042de195736b5b74db1746efab8a8ae"; x:122.716362; y:1236.315063; z:-52.592056
		"\229\239\214\138\084\117\067\174\079\247\229\087\223\117\087\240\112\108\021\067\021\196\213\195\232\127\079\194" ..
		-- tex:"e5efd68a547543ae4ff7e557df7557f0"; x:149.423599; y:-427.531921; z:-51.874912
		"\214\038\104\206\002\151\140\133\015\114\140\011\141\124\144\235\106\253\147\068\141\181\129\068\184\127\075\194" ..
		-- tex:"d62668ce02978c850f728c0b8d7c90eb"; x:1183.919312; y:1037.673584; z:-50.874729
		"\090\213\113\020\211\074\179\045\090\130\097\252\192\033\125\193\213\250\103\068\141\181\129\068\184\127\075\194" ..
		-- tex:"5ad57114d34ab32d5a8261fcc0217dc1"; x:927.919312; y:1037.673584; z:-50.874729
		"\106\228\148\041\155\105\066\014\144\220\028\074\214\053\148\070\155\209\232\192\244\022\199\196\069\141\074\194" ..
		-- tex:"6ae494299b69420e90dc1c4ad6359446"; x:-7.275587; y:-1592.717407; z:-50.637962
		"\084\159\087\009\081\107\105\187\164\222\207\145\254\074\045\150\155\209\232\192\244\022\167\196\069\141\074\194" ..
		-- tex:"549f5709516b69bba4decf91fe4a2d96"; x:-7.275587; y:-1336.717407; z:-50.637962
		"\005\191\088\198\245\099\232\244\211\141\144\196\097\123\032\101\016\050\057\068\065\125\113\068\025\109\063\194" ..
		-- tex:"05bf58c6f563e8f4d38d90c4617b2065"; x:740.782288; y:965.957153; z:-47.856544
		"\139\217\090\173\065\120\011\188\097\254\087\192\114\084\140\066\158\067\099\068\126\193\134\068\025\109\063\194" ..
		-- tex:"8bd95aad41780bbc61fe57c072548c42"; x:909.056580; y:1078.046753; z:-47.856544
		"\037\119\251\177\231\199\253\217\227\060\088\008\250\122\153\156\100\150\188\066\101\125\146\196\210\208\060\194" ..
		-- tex:"2577fbb1e7c7fdd9e33c5808fa7a999c"; x:94.293739; y:-1171.918701; z:-47.203930
		"\201\209\121\143\229\162\216\061\168\008\099\144\112\141\254\045\055\074\157\065\169\216\120\068\031\219\058\194" ..
		-- tex:"c9d1798fe5a2d83da8086390708dfe2d"; x:19.661240; y:995.385376; z:-46.713989
		"\084\007\091\170\133\230\015\148\190\088\204\175\005\207\250\052\055\074\157\065\169\216\056\068\031\219\058\194" ..
		-- tex:"54075baa85e60f94be58ccaf05cffa34"; x:19.661240; y:739.385376; z:-46.713989
		"\045\128\098\122\075\019\005\090\217\182\101\200\052\078\098\016\184\086\108\195\169\216\120\068\031\219\058\194" ..
		-- tex:"2d80627a4b13055ad9b665c8344e6210"; x:-236.338760; y:995.385376; z:-46.713989
		"\097\092\160\211\189\221\142\041\164\013\161\102\010\052\062\157\163\212\137\067\169\216\056\068\031\219\058\194" ..
		-- tex:"615ca0d3bddd8e29a40da1660a343e9d"; x:275.661240; y:739.385376; z:-46.713989
		"\012\248\201\199\136\151\115\084\199\172\217\141\224\075\048\102\163\212\137\067\169\216\120\068\031\219\058\194" ..
		-- tex:"0cf8c9c788977354c7acd98de04b3066"; x:275.661240; y:995.385376; z:-46.713989
		"\062\055\223\232\231\128\023\089\151\069\099\118\198\091\158\122\184\086\108\195\169\216\056\068\031\219\058\194" ..
		-- tex:"3e37dfe8e780175997456376c65b9e7a"; x:-236.338760; y:739.385376; z:-46.713989
		"\154\069\186\045\225\180\146\253\177\126\192\029\243\127\010\083\220\248\046\066\211\038\131\068\021\171\058\194" ..
		-- tex:"9a45ba2de1b492fdb17ec01df37f0a53"; x:43.743031; y:1049.213379; z:-46.667076
		"\177\183\140\157\142\181\022\086\021\247\003\085\059\172\034\068\012\165\199\194\031\029\136\068\024\170\058\194" ..
		-- tex:"b1b78c9d8eb5165615f703553bac2244"; x:-99.822365; y:1088.910156; z:-46.666111
		"\226\064\125\076\000\206\023\045\176\107\045\089\010\165\208\081\046\136\174\066\222\004\121\068\023\170\058\194" ..
		-- tex:"e2407d4c00ce172db06b2d590aa5d051"; x:87.265984; y:996.076111; z:-46.666107
		"\125\190\139\096\008\105\164\180\143\150\060\162\072\100\032\170\037\165\199\194\165\199\146\068\000\170\058\194" ..
		-- tex:"7dbe8b600869a4b48f963ca2486420aa"; x:-99.822556; y:1174.239014; z:-46.666019
		"\198\184\137\135\186\074\154\197\157\037\220\183\126\090\009\165\190\094\058\195\118\068\138\067\193\080\028\194" ..
		-- tex:"c6b88987ba4a9ac59d25dcb77e5a09a5"; x:-186.370102; y:276.534882; z:-39.078865
		"\129\249\129\081\217\109\003\137\207\086\104\210\000\120\001\231\234\243\179\066\155\144\141\196\130\137\027\194" ..
		-- tex:"81f98151d96d0389cf5668d2007801e7"; x:89.976402; y:-1132.519043; z:-38.884289
		"\109\142\091\217\000\052\132\042\084\131\040\212\191\081\081\252\072\109\029\067\242\001\137\196\138\104\244\193" ..
		-- tex:"6d8e5bd90034842a548328d4bf5151fc"; x:157.426895; y:-1096.060913; z:-30.551046
		"\141\060\209\219\143\153\065\157\017\095\206\171\068\005\135\197\157\166\057\067\024\140\137\196\179\189\177\193" ..
		-- tex:"8d3cd1db8f99419d115fceab440587c5"; x:185.650848; y:-1100.378052; z:-22.217628
		"\103\220\144\076\230\082\224\052\153\138\024\056\192\065\226\071\213\152\085\067\058\161\132\196\179\189\177\193" ..
		-- tex:"67dc904ce652e034998a1838c041e247"; x:213.597015; y:-1061.038452; z:-22.217628
		"\253\081\181\236\120\157\037\150\249\216\128\240\156\018\215\187\064\067\134\067\119\149\174\067\146\193\147\193" ..
		-- tex:"fd51b5ec789d2596f9d880f09c12d7bb"; x:268.525421; y:349.167725; z:-18.469519
		"\151\239\087\201\193\129\059\016\247\132\043\099\201\009\205\032\125\121\115\195\119\149\174\067\146\193\147\193" ..
		-- tex:"97ef57c9c1813b10f7842b63c909cd20"; x:-243.474579; y:349.167725; z:-18.469519
		"\193\200\010\015\019\094\016\178\217\173\066\072\253\055\032\098\064\067\134\067\187\074\023\068\146\193\147\193" ..
		-- tex:"c1c80a0f135e10b2d9ad4248fd372062"; x:268.525421; y:605.167725; z:-18.469519
		"\101\074\067\087\101\234\185\208\249\198\186\103\051\243\076\232\031\104\072\065\119\149\174\067\146\193\147\193" ..
		-- tex:"654a435765eab9d0f9c6ba6733f34ce8"; x:12.525421; y:349.167725; z:-18.469519
		"\225\206\210\250\171\111\029\004\141\149\071\228\119\214\223\100\031\104\072\065\187\074\023\068\146\193\147\193" ..
		-- tex:"e1ced2faab6f1d048d9547e477d6df64"; x:12.525421; y:605.167725; z:-18.469519
		"\208\034\044\148\176\089\221\023\158\245\167\028\082\159\215\081\125\121\115\195\187\074\023\068\146\193\147\193" ..
		-- tex:"d0222c94b059dd179ef5a71c529fd751"; x:-243.474579; y:605.167725; z:-18.469519
		"\225\098\199\255\004\186\080\077\043\070\022\207\224\223\074\022\138\230\054\068\127\020\060\068\093\082\104\193" ..
		-- tex:"e162c7ff04ba504d2b4616cfe0df4a16"; x:731.602234; y:752.320313; z:-14.520109
		"\190\190\036\217\017\117\067\135\114\039\184\036\104\143\141\100\165\179\075\067\255\181\110\196\242\147\026\193" ..
		-- tex:"bebe24d9117543877227b824688f8d64"; x:203.701752; y:-954.843750; z:-9.661120
		"\061\015\022\091\236\060\088\107\072\014\150\088\000\150\021\026\029\236\107\067\224\009\079\068\076\206\013\193" ..
		-- tex:"3d0f165bec3c586b480e96580096151a"; x:235.922329; y:828.154358; z:-8.862866
		"\012\032\145\091\051\060\185\168\005\001\146\219\060\125\188\013\029\236\107\067\240\132\135\068\076\206\013\193" ..
		-- tex:"0c20915b333cb9a8050192db3c7dbc0d"; x:235.922329; y:1084.154358; z:-8.862866
		"\116\236\008\145\159\131\118\200\126\080\125\124\142\087\005\160\017\159\160\193\224\009\079\068\076\206\013\193" ..
		-- tex:"74ec08919f8376c87e507d7c8e5705a0"; x:-20.077671; y:828.154358; z:-8.862866
		"\086\000\173\137\136\083\050\121\162\117\043\199\004\187\142\220\017\159\160\193\240\132\135\068\076\206\013\193" ..
		-- tex:"5600ad8988533279a2752bc704bb8edc"; x:-20.077671; y:1084.154358; z:-8.862866
		"\036\063\161\102\067\084\195\109\072\231\200\201\248\007\200\165\090\063\109\195\019\230\144\068\074\206\013\193" ..
		-- tex:"243fa1664354c36d48e7c8c9f807c8a5"; x:-237.247482; y:1159.189880; z:-8.862864
		"\226\100\072\051\013\127\138\234\225\169\059\099\070\255\152\024\090\063\109\195\038\204\097\068\074\206\013\193" ..
		-- tex:"e26448330d7f8aeae1a93b6346ff9818"; x:-237.247482; y:903.189880; z:-8.862864
		"\185\008\095\028\022\112\208\135\177\111\197\159\109\131\234\079\179\075\112\195\061\025\111\196\186\146\009\193" ..
		-- tex:"b9085f1c1670d087b16fc59f6d83ea4f"; x:-240.295715; y:-956.394409; z:-8.598323
		"\067\184\183\229\046\185\149\082\099\082\016\184\245\090\023\010\191\068\123\065\061\025\111\196\186\146\009\193" ..
		-- tex:"43b8b7e52eb99552635210b8f55a170a"; x:15.704285; y:-956.394409; z:-8.598323
		"\166\251\071\051\064\161\028\097\042\190\046\229\123\036\090\044\180\078\177\194\212\001\149\067\169\079\224\192" ..
		-- tex:"a6fb473340a11c612abe2ee57b245a2c"; x:-88.653725; y:298.014313; z:-7.009725
		"\215\065\076\120\125\105\251\039\172\140\119\137\019\150\047\193\119\216\038\195\111\088\151\067\096\055\224\192" ..
		-- tex:"d7414c787d69fb27ac8c778913962fc1"; x:-166.845581; y:302.690918; z:-7.006760
		"\107\045\032\138\006\086\199\153\018\016\251\158\180\143\104\166\138\185\098\066\193\242\150\067\096\055\224\192" ..
		-- tex:"6b2d208a0656c7991210fb9eb48f68a6"; x:56.681194; y:301.896545; z:-7.006760
		"\163\081\067\097\088\120\176\028\250\217\216\082\162\184\056\235\204\110\210\065\142\139\155\067\072\240\223\192" ..
		-- tex:"a35143615878b01cfad9d852a2b838eb"; x:26.304102; y:311.090302; z:-6.998082
		"\098\079\229\072\055\133\159\028\024\066\216\167\004\072\168\077\207\015\238\194\168\241\155\067\184\132\223\192" ..
		-- tex:"624fe54837859f1c1842d8a70448a84d"; x:-119.030884; y:311.887970; z:-6.984951
		"\082\078\237\107\125\109\081\128\101\157\100\052\095\028\031\137\113\007\024\195\115\126\165\195\032\239\214\192" ..
		-- tex:"524eed6b7d6d5180659d64345f1c1f89"; x:-152.029083; y:-330.987915; z:-6.716691
		"\175\251\248\035\122\032\242\153\146\131\154\032\026\052\032\088\254\198\217\195\212\086\132\065\092\049\177\192" ..
		-- tex:"affbf8237a20f29992839a201a342058"; x:-435.554657; y:16.542398; z:-5.537276
		"\020\253\149\168\145\194\130\128\251\225\015\076\220\186\226\131\106\022\208\195\053\118\044\196\158\066\176\192" ..
		-- tex:"14fd95a891c28280fbe10f4cdcbae283"; x:-416.175140; y:-689.847046; z:-5.508132
		"\235\023\005\122\052\227\215\075\191\015\000\233\189\035\051\212\255\035\221\195\113\089\032\196\155\066\176\192" ..
		-- tex:"eb17057a34e3d74bbf0f00e9bd2333d4"; x:-442.281250; y:-641.397583; z:-5.508131
		"\019\190\192\136\058\138\068\140\217\144\120\076\175\176\222\034\071\247\048\067\255\040\099\196\015\025\176\192" ..
		-- tex:"13bec0883a8a448cd990784cafb0de22"; x:176.965942; y:-908.640625; z:-5.503059
		"\069\178\228\004\127\117\112\178\050\020\053\193\064\084\091\086\215\047\167\066\060\166\175\195\215\127\175\192" ..
		-- tex:"45b2e4047f7570b2321435c140545b56"; x:83.593445; y:-351.298737; z:-5.484356
		"\206\254\255\252\239\171\145\176\229\249\043\154\131\133\108\070\191\151\208\065\152\028\159\195\164\127\175\192" ..
		-- tex:"cefefffcefab91b0e5f92b9a83856c46"; x:26.074097; y:-318.223419; z:-5.484332
		"\207\116\128\182\183\029\021\121\075\068\148\113\193\100\054\017\049\127\244\067\014\148\124\065\115\128\174\192" ..
		-- tex:"cf7480b6b71d15794b449471c1643611"; x:488.993713; y:15.786147; z:-5.453180
		"\248\025\190\052\046\106\163\206\119\029\199\176\060\228\242\234\065\109\251\067\191\009\213\193\101\128\174\192" ..
		-- tex:"f819be342e6aa3ce771dc7b03ce4f2ea"; x:502.853577; y:-26.629761; z:-5.453174
		"\181\102\076\145\217\113\008\237\153\108\026\021\154\018\058\101\133\011\251\067\212\186\002\067\083\128\174\192" ..
		-- tex:"b5664c91d97108ed996c1a159a123a65"; x:502.090027; y:130.729813; z:-5.453165
		"\030\158\227\237\071\204\037\008\138\084\109\024\135\088\152\073\160\024\211\195\143\004\003\067\034\128\174\192" ..
		-- tex:"1e9ee3ed47cc25088a546d1887589849"; x:-422.192413; y:131.017822; z:-5.453142
		"\152\189\030\049\255\022\109\229\204\148\134\055\046\110\019\231\247\132\211\195\014\088\221\193\220\127\174\192" ..
		-- tex:"98bd1e31ff166de5cc9486372e6e13e7"; x:-423.038818; y:-27.667997; z:-5.453108
		"\075\227\108\040\022\233\212\062\195\245\239\146\251\090\003\090\078\188\026\068\078\077\137\067\226\058\167\192" ..
		-- tex:"4be36c2816e9d43ec3f5ef92fb5a035a"; x:618.942322; y:274.603973; z:-5.225938
		"\043\229\249\122\116\071\037\024\214\238\121\179\108\004\020\014\250\066\086\068\039\077\137\067\203\058\167\192" ..
		-- tex:"2be5f97a74472518d6ee79b36c04140e"; x:857.046570; y:274.602783; z:-5.225927
		"\075\227\108\040\022\233\212\062\195\245\239\146\251\090\003\090\136\190\056\068\088\077\137\067\198\058\167\192" ..
		-- tex:"4be36c2816e9d43ec3f5ef92fb5a035a"; x:738.977112; y:274.604279; z:-5.225925
		"\246\145\047\123\128\132\078\082\179\236\204\052\190\081\019\255\158\172\246\067\181\217\143\194\159\151\165\192" ..
		-- tex:"f6912f7b80844e52b3eccc34be5113ff"; x:493.348602; y:-71.925217; z:-5.174759
		"\170\133\004\134\187\023\157\184\010\162\021\223\131\077\161\170\156\172\246\067\023\139\038\067\135\151\165\192" ..
		-- tex:"aa850486bb179db80aa215df834da1aa"; x:493.348541; y:166.543335; z:-5.174747
		"\192\010\187\147\124\019\040\183\026\132\209\213\088\192\172\156\191\199\004\068\092\066\152\067\069\045\090\192" ..
		-- tex:"c00abb937c1328b71a84d1d558c0ac9c"; x:531.121094; y:304.518463; z:-3.409013
		"\109\031\033\116\157\025\158\057\014\003\116\221\141\032\053\121\191\199\068\068\092\066\152\067\069\045\090\192" ..
		-- tex:"6d1f21749d199e390e0374dd8d203579"; x:787.121094; y:304.518463; z:-3.409013
		"\213\180\152\000\092\181\035\036\200\001\201\118\235\102\093\006\191\199\068\068\046\033\012\068\069\045\090\192" ..
		-- tex:"d5b498005cb52324c801c976eb665d06"; x:787.121094; y:560.518463; z:-3.409013
		"\055\162\065\181\187\153\112\118\188\014\083\178\031\211\129\213\191\199\004\068\046\033\012\068\069\045\090\192" ..
		-- tex:"37a241b5bb997076bc0e53b21fd381d5"; x:531.121094; y:560.518463; z:-3.409013
		"\225\002\125\093\096\035\042\186\109\211\071\004\062\167\063\049\101\136\187\068\020\048\126\068\196\066\089\066" ..
		-- tex:"e1027d5d60232aba6dd347043ea73f31"; x:1500.262451; y:1016.751282; z:54.315205
		"\048\118\222\065\123\039\138\220\169\083\072\152\193\042\015\157\101\136\155\068\020\048\126\068\196\066\089\066" ..
		-- tex:"3076de417b278adca9534898c12a0f9d"; x:1244.262451; y:1016.751282; z:54.315205
		"\237\134\146\072\055\006\221\081\240\063\006\069\067\089\248\063\101\136\155\068\020\048\062\068\196\066\089\066" ..
		-- tex:"ed8692483706dd51f03f06454359f83f"; x:1244.262451; y:760.751282; z:54.315205
		"\112\039\085\188\180\106\117\176\016\065\215\002\147\014\107\031\101\136\219\068\020\048\062\068\196\066\089\066" ..
		-- tex:"702755bcb46a75b01041d702930e6b1f"; x:1756.262451; y:760.751282; z:54.315205
		"\079\046\136\057\165\240\079\220\100\023\188\253\061\216\246\028\101\136\187\068\020\048\062\068\196\066\089\066" ..
		-- tex:"4f2e8839a5f04fdc6417bcfd3dd8f61c"; x:1500.262451; y:760.751282; z:54.315205
		"\056\072\163\229\181\012\198\006\222\194\093\069\101\168\194\254\101\136\219\068\020\048\126\068\196\066\089\066" ..
		-- tex:"3848a3e5b50cc606dec25d4565a8c2fe"; x:1756.262451; y:1016.751282; z:54.315205
		"\132\097\198\243\247\035\074\159\013\106\221\063\038\084\114\211\250\025\063\067\112\117\057\068\164\153\100\066" ..
		-- tex:"8461c6f3f7234a9f0d6add3f265472d3"; x:191.101486; y:741.835022; z:57.150043
		"\138\192\182\125\185\221\205\138\238\135\139\054\049\065\044\114\004\058\077\195\173\116\057\068\018\155\100\066" ..
		-- tex:"8ac0b67db9ddcd8aee878b3631412c72"; x:-205.226639; y:741.823120; z:57.151440
		"\177\057\197\010\186\248\033\112\131\202\225\084\196\119\049\158\122\175\114\068\161\011\110\068\091\122\107\066" ..
		-- tex:"b139c50abaf8217083cae154c477319e"; x:970.741882; y:952.181763; z:58.869492
		"\201\159\121\250\087\040\207\188\044\241\137\239\130\118\164\078\202\004\131\068\081\054\103\068\096\122\107\066" ..
		-- tex:"c99f79fa5728cfbc2cf189ef8276a44e"; x:1048.149780; y:924.848755; z:58.869511
		"\110\004\118\032\103\227\000\081\176\017\022\096\250\069\200\028\187\221\065\196\200\088\030\068\153\212\162\066" ..
		-- tex:"6e04762067e30051b0111660fa45c81c"; x:-775.464600; y:633.387238; z:81.415237
		"\097\080\057\082\059\215\149\231\028\067\125\196\234\194\169\158\187\221\065\196\200\088\094\068\153\212\162\066" ..
		-- tex:"615039523bd795e71c437dc4eac2a99e"; x:-775.464600; y:889.387238; z:81.415237
		"\087\201\144\250\205\229\194\126\196\244\161\013\091\120\010\164\187\221\065\196\100\044\143\068\153\212\162\066" ..
		-- tex:"57c990facde5c27ec4f4a10d5b780aa4"; x:-775.464600; y:1145.387238; z:81.415237
		"\138\045\248\213\066\191\146\177\197\026\181\056\137\110\030\180\187\221\065\196\144\177\188\067\153\212\162\066" ..
		-- tex:"8a2df8d542bf92b1c51ab538896e1eb4"; x:-775.464600; y:377.387238; z:81.415237
		"\059\087\182\092\206\209\030\056\220\103\105\158\069\208\220\023\187\221\001\196\200\088\030\068\153\212\162\066" ..
		-- tex:"3b57b65cced11e38dc67699e45d0dc17"; x:-519.464600; y:633.387238; z:81.415237
		"\221\176\085\206\223\249\234\205\109\093\232\033\139\217\000\183\187\221\001\196\200\088\094\068\153\212\162\066" ..
		-- tex:"ddb055cedff9eacd6d5de8218bd900b7"; x:-519.464600; y:889.387238; z:81.415237
		"\002\097\036\130\233\173\160\000\037\230\106\189\213\164\142\047\015\137\120\067\144\177\188\067\153\212\162\066" ..
		-- tex:"02612482e9ada00025e66abdd5a48e2f"; x:248.535400; y:377.387238; z:81.415237
		"\011\095\190\216\140\189\172\121\008\167\200\211\172\093\166\179\135\068\252\067\200\088\094\068\153\212\162\066" ..
		-- tex:"0b5fbed88cbdac7908a7c8d3ac5da6b3"; x:504.535400; y:889.387238; z:81.415237
		"\031\099\158\199\173\252\238\107\209\124\159\134\219\137\095\229\015\137\120\067\100\044\143\068\153\212\162\066" ..
		-- tex:"1f639ec7adfcee6bd17c9f86db895fe5"; x:248.535400; y:1145.387238; z:81.415237
		"\113\049\016\109\197\099\033\027\064\151\174\096\151\176\184\128\135\068\252\067\200\088\030\068\153\212\162\066" ..
		-- tex:"7131106dc563211b4097ae6097b0b880"; x:504.535400; y:633.387238; z:81.415237
		"\087\244\058\023\158\093\203\115\253\106\097\229\237\163\004\232\015\137\120\067\200\088\094\068\153\212\162\066" ..
		-- tex:"57f43a179e5dcb73fd6a61e5eda304e8"; x:248.535400; y:889.387238; z:81.415237
		"\166\079\064\139\003\231\097\118\172\234\167\171\226\031\120\070\015\137\120\067\200\088\030\068\153\212\162\066" ..
		-- tex:"a64f408b03e76176aceaa7abe21f7846"; x:248.535400; y:633.387238; z:81.415237
		"\127\121\076\136\070\186\088\026\240\066\157\199\177\135\106\134\076\086\187\068\046\003\209\067\127\113\182\066" ..
		-- tex:"7f794c8846ba581af0429dc7b1876a86"; x:1498.696808; y:418.024872; z:91.221680
		"\003\171\050\158\222\176\106\138\069\101\088\138\177\170\067\114\076\086\187\068\151\129\040\068\127\113\182\066" ..
		-- tex:"03ab329edeb06a8a4565588ab1aa4372"; x:1498.696808; y:674.024872; z:91.221680
		"\166\027\227\146\246\178\024\026\010\088\192\213\092\140\053\150\152\172\118\068\093\006\034\067\127\113\182\066" ..
		-- tex:"a61be392f6b2181a0a58c0d55c8c3596"; x:986.696808; y:162.024872; z:91.221680
		"\042\106\101\220\191\102\098\210\051\116\197\164\142\158\068\151\076\086\187\068\203\064\148\068\127\113\182\066" ..
		-- tex:"2a6a65dcbf6662d23374c5a48e9e4497"; x:1498.696808; y:1186.024872; z:91.221680
		"\005\024\194\226\240\044\040\244\160\171\132\070\198\131\131\167\152\172\054\068\208\252\174\195\127\113\182\066" ..
		-- tex:"0518c2e2f02c28f4a0ab8446c68383a7"; x:730.696808; y:-349.975128; z:91.221680
		"\233\012\132\249\180\009\176\192\116\225\149\163\110\092\149\208\152\172\054\068\151\129\040\068\127\113\182\066" ..
		-- tex:"e90c84f9b409b0c074e195a36e5c95d0"; x:730.696808; y:674.024872; z:91.221680
		"\053\236\152\073\128\033\112\219\084\218\045\253\094\245\220\223\048\089\237\067\093\006\034\067\127\113\182\066" ..
		-- tex:"35ec9849802170db54da2dfd5ef5dcdf"; x:474.696808; y:162.024872; z:91.221680
		"\054\115\149\188\099\020\239\086\217\046\128\048\150\003\002\196\076\086\219\068\151\129\104\068\127\113\182\066",
		-- tex:"367395bc6314ef56d92e8030960302c4"; x:1754.696808; y:930.024872; z:91.221680
	["Drak'Tharon Keep"] = 
		"\049\027\109\108\248\207\235\054\198\095\097\116\115\077\254\170\109\077\229\195\190\040\057\195\110\222\017\066" ..
		-- tex:"311b6d6cf8cfeb36c65f6174734dfeaa"; x:-458.604919; y:-185.159164; z:36.467220
		"\115\167\179\220\037\097\144\095\210\184\167\029\186\095\154\230\219\154\074\195\190\040\057\195\110\222\017\066" ..
		-- tex:"73a7b3dc2561905fd2b8a71dba5f9ae6"; x:-202.604919; y:-185.159164; z:36.467220
		"\056\232\121\155\024\195\155\234\218\031\095\241\247\027\254\065\143\148\085\066\190\040\057\195\110\222\017\066",
		-- tex:"38e8799b18c39beada1f5ff1f71bfe41"; x:53.395081; y:-185.159164; z:36.467220
	["Gnomeregan"] = 
		"\158\188\019\239\164\198\061\053\251\159\074\032\217\069\171\003\211\000\154\068\089\101\181\196\083\234\037\196" ..
		-- tex:"9ebc13efa4c63d35fb9f4a20d945ab03"; x:1232.025879; y:-1451.167236; z:-663.661377
		"\157\236\222\104\026\214\177\078\022\178\070\118\152\223\093\173\144\117\179\068\115\107\170\196\191\103\037\196" ..
		-- tex:"9decde681ad6b14e16b2467698df5dad"; x:1435.673950; y:-1363.357910; z:-661.621094
		"\235\167\201\224\103\138\081\196\202\056\086\086\079\178\070\043\182\118\170\068\206\124\182\196\191\103\037\196" ..
		-- tex:"eba7c9e0678a51c4ca3856564fb2462b"; x:1363.709839; y:-1459.900269; z:-661.621094
		"\073\019\206\086\211\190\188\000\213\090\173\051\008\054\167\102\064\157\142\068\075\010\157\196\114\175\035\196" ..
		-- tex:"4913ce56d3bebc00d55aad330836a766"; x:1140.914124; y:-1256.321777; z:-654.741394
		"\014\186\028\014\171\073\044\037\005\187\212\141\168\016\124\202\064\157\142\068\075\010\189\196\114\175\035\196" ..
		-- tex:"0eba1c0eab492c2505bbd48da8107cca"; x:1140.914124; y:-1512.321777; z:-654.741394
		"\137\020\173\235\254\024\204\043\115\150\118\083\181\192\146\058\128\058\093\068\075\010\157\196\114\175\035\196" ..
		-- tex:"8914adebfe18cc2b73967653b5c0923a"; x:884.914124; y:-1256.321777; z:-654.741394
		"\024\091\131\052\173\115\048\253\203\101\100\022\216\113\057\241\128\058\093\068\075\010\189\196\114\175\035\196" ..
		-- tex:"185b8334ad7330fdcb656416d87139f1"; x:884.914124; y:-1512.321777; z:-654.741394
		"\166\151\219\028\061\050\055\198\233\247\172\139\162\006\023\237\100\061\181\068\089\098\163\196\192\231\032\196" ..
		-- tex:"a697db1c3d3237c6e9f7ac8ba20617ed"; x:1449.918579; y:-1307.073486; z:-643.621155
		"\003\115\048\232\232\175\010\229\028\045\147\169\180\111\232\250\158\188\180\068\242\094\165\196\192\231\032\196" ..
		-- tex:"037330e8e8af0ae51c2d93a9b46fe8fa"; x:1445.894409; y:-1322.967163; z:-643.621155
		"\113\176\201\021\215\089\233\197\105\215\134\167\082\131\005\152\181\166\192\068\034\121\081\196\242\170\032\196" ..
		-- tex:"71b0c915d759e9c569d786a752830598"; x:1541.209717; y:-837.892761; z:-642.671082
		"\007\178\002\079\111\095\208\229\036\228\059\132\099\147\045\056\053\005\215\068\242\164\083\196\105\061\030\196" ..
		-- tex:"07b2024f6f5fd0e524e43b8463932d38"; x:1720.162842; y:-846.577332; z:-632.959595
		"\212\137\249\153\131\221\116\038\041\197\062\085\231\185\160\253\043\177\204\068\215\045\099\196\103\061\030\196" ..
		-- tex:"d489f99983dd742629c53e55e7b9a0fd"; x:1637.536621; y:-908.716309; z:-632.959473
		"\149\155\220\132\089\167\193\014\062\104\070\212\222\153\242\240\143\132\182\068\157\085\158\196\191\103\028\196" ..
		-- tex:"959bdc8459a7c10e3e6846d4de99f2f0"; x:1460.142578; y:-1266.675537; z:-625.621094
		"\149\144\014\093\156\094\169\081\090\235\036\227\180\017\154\065\086\005\183\068\037\089\156\196\191\103\028\196" ..
		-- tex:"95900e5d9c5ea9515aeb24e3b4119a41"; x:1464.166870; y:-1250.785889; z:-625.621094
		"\030\012\154\228\226\211\150\195\086\148\069\059\157\081\158\208\189\017\202\068\117\082\130\196\221\016\026\196" ..
		-- tex:"1e0c9ae4e2d396c35694453b9d519ed0"; x:1616.554443; y:-1042.576904; z:-616.263550
		"\125\140\000\093\086\146\249\123\203\079\105\245\008\124\116\215\176\244\191\068\181\174\140\196\133\251\023\196" ..
		-- tex:"7d8c005d5692f97bcb4f69f5087c74d7"; x:1535.646606; y:-1125.459717; z:-607.930054
		"\029\129\085\241\158\043\015\163\137\066\222\186\046\050\073\196\030\083\180\068\134\076\151\196\193\231\023\196" ..
		-- tex:"1d8155f19e2b0fa38942deba2e3249c4"; x:1442.597534; y:-1210.391479; z:-607.621216
		"\083\217\017\156\219\155\030\137\038\045\126\197\186\231\073\163\073\070\175\068\231\067\142\196\193\231\023\196" ..
		-- tex:"53d9119cdb9b1e89262d7ec5bae749a3"; x:1402.196533; y:-1138.122070; z:-607.621216
		"\067\078\003\077\026\245\062\181\017\141\130\089\001\149\117\093\192\073\173\068\198\252\140\196\190\103\019\196" ..
		-- tex:"434e034d1af53eb5118d82590195755d"; x:1386.304810; y:-1127.899292; z:-589.621033
		"\048\196\130\022\067\169\245\162\045\010\210\091\050\162\239\253\096\061\168\068\072\124\140\196\190\103\019\196" ..
		-- tex:"30c4821643a9f5a22d0ad25b32a2effd"; x:1345.918091; y:-1123.883911; z:-589.621033
		"\181\191\120\067\003\178\186\125\076\187\188\003\182\117\226\119\118\074\166\068\138\052\139\196\191\231\014\196" ..
		-- tex:"b5bf784303b2ba7d4cbbbc03b675e277"; x:1330.327026; y:-1113.641968; z:-571.621094
		"\178\069\019\041\135\126\179\247\201\133\157\252\157\010\198\122\014\045\107\068\112\002\146\196\189\231\014\196" ..
		-- tex:"b2451329877eb3f7c9859dfc9d0ac67a"; x:940.704041; y:-1168.076294; z:-571.620972
		"\135\243\156\215\121\028\219\105\159\211\124\152\239\019\014\205\135\150\149\068\112\002\146\196\189\231\014\196" ..
		-- tex:"87f39cd7791cdb699fd37c98ef130ecd"; x:1196.704041; y:-1168.076294; z:-571.620972
		"\133\117\163\148\084\115\171\080\210\012\235\123\011\222\239\182\014\045\107\068\225\004\100\196\189\231\014\196" ..
		-- tex:"8575a3945473ab50d20ceb7b0bdeefb6"; x:940.704041; y:-912.076294; z:-571.620972
		"\092\188\062\193\105\023\004\170\095\223\088\114\154\252\212\025\135\150\149\068\225\004\100\196\189\231\014\196" ..
		-- tex:"5cbc3ec1691704aa5fdf58729afcd419"; x:1196.704041; y:-912.076294; z:-571.620972
		"\184\131\177\002\011\234\238\147\148\201\157\166\199\066\061\102\214\059\200\068\232\160\193\195\137\113\009\196" ..
		-- tex:"b883b1020beaee9394c99da6c7423d66"; x:1601.869995; y:-387.257111; z:-549.774048
		"\123\203\014\158\060\131\131\050\139\242\203\189\245\046\155\053\117\061\180\068\172\159\000\196\125\088\009\196" ..
		-- tex:"7bcb0e9e3c8383328bf2cbbdf52e9b35"; x:1441.920654; y:-514.494934; z:-549.382690
		"\061\006\053\193\106\146\155\155\023\231\038\063\150\240\080\199\186\248\181\068\154\041\110\196\050\086\009\196" ..
		-- tex:"3d0635c16a929b9b17e7263f96f050c7"; x:1455.772827; y:-952.650085; z:-549.346863
		"\224\251\119\159\108\044\245\192\001\020\011\214\010\100\209\051\186\248\149\068\154\041\110\196\050\086\009\196" ..
		-- tex:"e0fb779f6c2cf5c001140bd60a64d133"; x:1199.772827; y:-952.650085; z:-549.346863
		"\142\181\077\254\030\097\102\173\118\009\041\254\034\019\089\191\241\193\180\068\098\165\093\196\167\167\008\196" ..
		-- tex:"8eb54dfe1e6166ad760929fe221359bf"; x:1446.060791; y:-886.584167; z:-546.619629
		"\220\098\195\073\150\054\118\123\010\206\040\147\151\054\069\048\158\242\210\068\224\123\090\196\178\160\008\196" ..
		-- tex:"dc62c3499636767b0ace289397364530"; x:1687.581909; y:-873.935608; z:-546.510925
		"\233\091\130\009\022\137\004\055\013\226\249\002\186\029\176\050\169\066\188\068\061\217\068\196\167\147\008\196" ..
		-- tex:"e95b8209168904370de2f902ba1db032"; x:1506.083252; y:-787.394409; z:-546.307129
		"\030\021\062\028\225\001\083\146\020\100\077\016\100\003\044\189\173\113\190\068\088\205\035\196\053\147\008\196" ..
		-- tex:"1e153e1ce101539214644d1064032cbd"; x:1523.552490; y:-655.208557; z:-546.300171
		"\255\082\110\168\102\199\113\046\100\102\046\082\091\150\163\134\166\141\186\068\161\214\012\196\209\141\008\196" ..
		-- tex:"ff526ea866c7712e64662e525b96a386"; x:1492.426636; y:-563.353638; z:-546.215942
		"\162\071\213\229\112\163\027\116\154\042\013\099\093\108\091\250\197\081\157\068\035\070\066\196\107\139\008\196" ..
		-- tex:"a247d5e570a31b749a2a0d635d6c5bfa"; x:1258.555420; y:-777.095947; z:-546.178467
		"\100\120\045\235\127\207\017\039\092\171\128\023\141\226\195\221\036\170\187\068\113\143\091\196\076\125\008\196" ..
		-- tex:"64782deb7fcf11275cab80178de2c3dd"; x:1501.317017; y:-878.241333; z:-545.957825
		"\121\237\112\092\247\060\131\005\106\102\066\232\098\156\055\226\036\170\187\068\113\143\027\196\076\125\008\196" ..
		-- tex:"79ed705cf73c83056a6642e8629c37e2"; x:1501.317017; y:-622.241333; z:-545.957825
		"\078\111\119\224\192\114\133\235\227\190\249\018\199\052\192\193\036\170\219\068\113\143\091\196\076\125\008\196" ..
		-- tex:"4e6f77e0c07285ebe3bef912c734c0c1"; x:1757.317017; y:-878.241333; z:-545.957825
		"\144\187\016\130\081\025\233\142\174\020\229\172\085\051\136\021\032\105\187\068\033\230\085\196\055\118\008\196" ..
		-- tex:"90bb10825119e98eae14e5ac55338815"; x:1499.285278; y:-855.595825; z:-545.847168
		"\030\237\058\019\155\190\131\043\019\235\246\119\063\242\150\053\062\042\224\068\195\228\044\196\054\118\008\196" ..
		-- tex:"1eed3a139bbe832b13ebf6773ff29635"; x:1793.320190; y:-691.574463; z:-545.847107
		"\158\123\014\207\251\008\117\125\250\068\005\031\228\143\066\120\186\127\217\068\226\220\090\196\225\079\008\196" ..
		-- tex:"9e7b0ecffb08757dfa44051fe48f4278"; x:1739.991577; y:-875.451355; z:-545.248169
		"\214\077\041\020\245\047\055\109\145\038\150\167\104\144\005\000\014\140\215\068\195\202\031\196\224\079\008\196" ..
		-- tex:"d64d2914f52f376d912696a768900500"; x:1724.376831; y:-639.168213; z:-545.248108
		"\101\001\068\067\067\232\053\169\184\178\172\022\194\020\009\184\192\241\198\068\101\076\018\196\223\079\008\196" ..
		-- tex:"6501444343e835a9b8b2ac16c21409b8"; x:1591.554810; y:-585.193726; z:-545.248047
		"\176\033\177\130\037\241\220\157\027\120\071\058\030\244\186\150\213\176\195\068\227\022\102\195\022\100\004\196" ..
		-- tex:"b021b18225f1dc9d1b78473a1ef4ba96"; x:1565.526123; y:-230.089417; z:-529.563904
		"\157\032\035\176\063\027\207\037\232\152\228\078\121\217\121\029\025\127\188\068\012\062\079\195\230\181\002\196" ..
		-- tex:"9d2023b03f1bcf25e898e44e79d9791d"; x:1507.971924; y:-207.242386; z:-522.842224
		"\199\167\202\189\119\136\088\056\079\179\206\055\228\054\068\209\010\025\187\068\090\035\021\195\002\076\002\196" ..
		-- tex:"c7a7cabd778858384fb3ce37e43644d1"; x:1496.782593; y:-149.138107; z:-521.187683
		"\216\170\242\063\135\253\255\223\248\142\173\110\218\050\123\203\062\175\154\068\221\053\058\196\130\157\255\195" ..
		-- tex:"d8aaf23f87fdffdff88ead6eda327bcb"; x:1237.476440; y:-744.841675; z:-511.230560
		"\130\103\041\134\024\142\212\234\219\204\166\234\193\239\174\097\234\252\181\068\215\180\038\194\004\067\252\195" ..
		-- tex:"82672986188ed4eadbcca6eac1efae61"; x:1455.903687; y:-41.676605; z:-504.523590
		"\114\085\026\255\127\154\236\005\001\187\247\249\248\039\104\118\141\143\164\068\045\166\211\193\226\018\248\195" ..
		-- tex:"72551aff7f9aec0501bbf7f9f8276876"; x:1316.486084; y:-26.456142; z:-496.147552
		"\236\042\151\032\053\206\169\044\235\116\252\173\216\044\130\199\104\170\151\068\105\181\078\196\109\081\247\195" ..
		-- tex:"ec2a972035cea92ceb74fcadd82c82c7"; x:1213.325317; y:-826.834595; z:-494.636169
		"\140\057\165\035\104\118\135\234\195\060\237\208\160\134\182\027\168\216\091\068\215\235\115\196\088\017\233\195" ..
		-- tex:"8c39a523687687eac33cedd0a086b61b"; x:879.385315; y:-975.685059; z:-466.135529
		"\246\235\182\152\211\062\102\227\082\137\025\237\223\054\113\171\168\216\091\068\235\245\153\196\088\017\233\195" ..
		-- tex:"f6ebb698d33e66e3528919eddf3671ab"; x:879.385315; y:-1231.685059; z:-466.135529
		"\005\218\100\144\157\248\186\067\197\131\119\095\094\134\011\054\084\236\141\068\235\245\153\196\088\017\233\195" ..
		-- tex:"05da64909df8ba43c583775f5e860b36"; x:1135.385315; y:-1231.685059; z:-466.135529
		"\174\092\211\220\024\225\181\020\199\232\210\242\087\051\045\053\084\236\141\068\215\235\115\196\088\017\233\195" ..
		-- tex:"ae5cd3dc18e1b514c7e8d2f257332d35"; x:1135.385315; y:-975.685059; z:-466.135529
		"\077\148\154\193\001\080\227\084\069\248\213\243\217\137\144\044\185\236\128\068\082\081\069\196\102\187\231\195" ..
		-- tex:"4d949ac10150e35445f8d5f3d989902c"; x:1031.397705; y:-789.270691; z:-463.464081
		"\137\077\016\057\040\183\003\225\149\193\186\139\249\136\153\148\197\018\132\068\028\069\048\196\107\070\231\195" ..
		-- tex:"894d103928b703e195c1ba8bf9889994"; x:1056.586670; y:-705.079895; z:-462.550171
		"\080\233\002\221\250\172\222\111\167\206\052\023\226\203\237\100\074\152\158\068\071\247\090\196\047\168\230\195" ..
		-- tex:"50e902ddfaacde6fa7ce3417e2cbed64"; x:1268.759155; y:-875.863770; z:-461.313965
		"\195\015\112\213\037\157\073\242\004\179\066\127\125\088\060\234\118\206\048\068\087\130\196\195\196\109\217\195" ..
		-- tex:"c30f70d5259d49f204b3427f7d583cea"; x:707.226013; y:-393.018311; z:-434.857574
		"\030\086\068\160\182\192\149\018\019\222\209\113\128\217\065\056\118\206\112\068\175\004\009\195\196\109\217\195" ..
		-- tex:"1e5644a0b6c0951213ded17180d94138"; x:963.226013; y:-137.018311; z:-434.857574
		"\217\069\131\139\006\227\018\031\144\155\048\228\074\002\103\113\118\206\112\068\087\130\196\195\196\109\217\195" ..
		-- tex:"d945838b06e3121f909b30e44a026771"; x:963.226013; y:-393.018311; z:-434.857574
		"\199\215\121\043\192\238\180\201\243\220\047\245\047\094\021\233\118\206\048\068\175\004\009\195\196\109\217\195" ..
		-- tex:"c7d7792bc0eeb4c9f3dc2ff52f5e15e9"; x:707.226013; y:-137.018311; z:-434.857574
		"\086\228\067\245\016\220\022\203\057\254\117\145\065\139\178\132\196\205\130\068\151\018\026\196\052\007\217\195" ..
		-- tex:"56e443f510dc16cb39fe7591418bb284"; x:1046.430298; y:-616.290527; z:-434.056305
		"\072\135\042\042\122\046\124\154\090\049\063\143\078\091\098\113\049\061\106\068\203\201\019\196\096\181\211\195" ..
		-- tex:"48872a2a7a2e7c9a5a313f8f4e5b6271"; x:936.956177; y:-591.153076; z:-423.417023
		"\225\170\156\116\233\227\157\124\119\114\079\008\090\166\142\153\062\111\086\068\135\201\019\196\180\149\211\195" ..
		-- tex:"e1aa9c74e9e39d7c77724f085aa68e99"; x:857.738220; y:-591.148926; z:-423.169586
		"\255\127\031\222\183\219\096\213\228\060\002\063\067\131\086\132\008\033\128\068\060\066\021\196\177\149\211\195" ..
		-- tex:"ff7f1fdeb7db60d5e43c023f43835684"; x:1025.032349; y:-597.034973; z:-423.169495
		"\089\199\104\219\125\164\066\182\199\200\078\184\052\094\239\026\223\179\078\068\066\210\010\196\176\149\211\195" ..
		-- tex:"59c768db7da442b6c7c84eb8345eef1a"; x:826.810547; y:-555.285339; z:-423.169464
		"\232\022\143\217\047\053\146\010\046\165\093\138\172\012\054\046\223\179\078\068\134\208\236\195\176\149\211\195" ..
		-- tex:"e8168fd92f35920a2ea55d8aac0c362e"; x:826.810547; y:-473.629120; z:-423.169464
		"\082\255\222\179\166\203\189\188\171\226\233\208\078\132\223\215\205\007\131\068\235\250\163\195\029\233\204\195" ..
		-- tex:"52ffdeb3a6cbbdbcabe2e9d04e84dfd7"; x:1048.243896; y:-327.960327; z:-409.821228
		"\116\080\145\102\161\155\069\165\147\027\167\012\153\132\175\178\205\007\131\068\175\235\143\194\029\233\204\195" ..
		-- tex:"74509166a19b45a5931ba70c9984afb2"; x:1048.243896; y:-71.960327; z:-409.821228
		"\228\186\163\076\100\188\245\242\176\159\178\208\252\073\070\066\038\145\135\068\168\219\166\195\073\200\203\195" ..
		-- tex:"e4baa34c64bcf5f2b09fb2d0fc494642"; x:1084.536011; y:-333.716095; z:-407.564758
		"\197\229\252\167\123\142\051\203\202\107\007\221\210\094\103\128\212\007\140\068\206\211\245\194\188\189\200\195" ..
		-- tex:"c5e5fca77b8e33cbca6b07ddd25e6780"; x:1120.244751; y:-122.913689; z:-401.482330
		"\033\154\034\148\118\024\218\226\124\092\161\001\011\069\123\086\076\194\132\068\204\211\245\194\063\132\200\195" ..
		-- tex:"219a22947618dae27c5ca1010b457b56"; x:1062.071899; y:-122.913673; z:-401.033203
		"\054\181\235\144\182\030\005\127\008\011\026\162\141\036\224\204\209\186\148\068\135\229\167\195\199\176\199\195" ..
		-- tex:"36b5eb90b61e057f080b1aa28d24e0cc"; x:1189.838135; y:-335.793213; z:-399.381104
		"\154\060\100\047\081\142\241\095\179\119\221\015\248\006\176\214\209\186\148\068\200\172\122\195\251\174\199\195" ..
		-- tex:"9a3c642f518ef15fb377dd0ff806b0d6"; x:1189.838135; y:-250.674942; z:-399.367065
		"\243\240\219\139\071\172\183\112\237\194\009\057\039\014\187\088\209\186\148\068\120\188\040\195\250\174\199\195" ..
		-- tex:"f3f0db8b47acb770edc20939270ebb58"; x:1189.838135; y:-168.736221; z:-399.367035
		"\136\150\021\051\221\181\237\026\040\241\036\092\129\071\009\242\099\001\112\068\153\195\240\195\096\228\194\195" ..
		-- tex:"88961533ddb5ed1a28f1245c814709f2"; x:960.021729; y:-481.528137; z:-389.784210
		"\221\003\103\058\218\225\107\232\236\218\001\006\166\006\153\064\247\202\141\068\064\025\233\195\060\184\184\195" ..
		-- tex:"dd03673adae16be8ecda0106a6069940"; x:1134.342773; y:-466.197296; z:-369.439362
		"\049\189\007\104\122\232\069\116\250\185\226\159\092\117\208\195\123\030\153\068\177\050\156\195\024\243\183\195" ..
		-- tex:"31bd07687ae84574fab9e29f5c75d0c3"; x:1224.952637; y:-312.396057; z:-367.899200
		"\239\033\219\061\014\254\034\244\204\030\158\095\165\116\144\025\124\030\153\068\111\232\071\195\244\077\183\195" ..
		-- tex:"ef21db3d0efe22f4cc1e9e5fa5749019"; x:1224.952759; y:-199.907959; z:-366.609039
		"\210\061\220\109\209\144\242\240\252\146\013\246\156\224\157\067\250\155\134\068\143\138\159\194\071\197\179\195" ..
		-- tex:"d23ddc6dd190f2f0fc920df69ce09d43"; x:1076.874390; y:-79.770630; z:-359.541260
		"\128\156\188\111\090\114\074\244\055\131\010\138\042\235\077\009\142\240\143\068\142\138\159\194\202\182\179\195" ..
		-- tex:"809cbc6f5a724af437830a8a2aeb4d09"; x:1151.517456; y:-79.770622; z:-359.428070
		"\138\057\055\071\018\066\019\109\197\017\194\227\237\024\155\141\214\085\050\068\019\026\250\194\141\157\175\195" ..
		-- tex:"8a3937471242136dc511c2e3ed189b8d"; x:713.341248; y:-125.050934; z:-351.230896
		"\106\062\172\250\122\204\141\154\068\060\216\172\111\086\197\212\214\085\114\068\132\134\190\195\141\157\175\195" ..
		-- tex:"6a3eacfa7acc8d9a443cd8ac6f56c5d4"; x:969.341248; y:-381.050934; z:-351.230896
		"\217\012\039\250\156\224\203\254\166\235\093\246\001\042\115\029\214\085\050\068\132\134\190\195\141\157\175\195" ..
		-- tex:"d90c27fa9ce0cbfea6eb5df6012a731d"; x:713.341248; y:-381.050934; z:-351.230896
		"\167\233\203\182\174\056\056\237\041\087\080\210\158\228\005\210\214\085\114\068\019\026\250\194\141\157\175\195" ..
		-- tex:"a7e9cbb6ae3838ed295750d29ee405d2"; x:969.341248; y:-125.050934; z:-351.230896
		"\131\029\125\148\058\244\119\144\040\118\060\117\188\111\003\225\078\139\033\068\031\128\248\194\050\134\162\195" ..
		-- tex:"831d7d943af4779028763c75bc6f03e1"; x:646.176697; y:-124.250244; z:-325.048431
		"\017\188\122\200\211\028\085\030\045\185\238\201\253\166\091\090\119\152\133\068\171\174\243\195\203\116\159\195" ..
		-- tex:"11bc7ac8d31c551e2db9eec9fda65b5a"; x:1068.764648; y:-487.364624; z:-318.912476
		"\049\216\253\194\202\127\222\187\125\157\219\171\027\119\034\019\108\092\106\068\154\194\190\066\112\016\159\195" ..
		-- tex:"31d8fdc2ca7fdebb7d9ddbab1b772213"; x:937.444153; y:95.380089; z:-318.128448
		"\179\039\085\213\255\106\037\021\146\019\200\134\117\065\103\116\105\227\200\067\191\080\246\193\145\199\158\195" ..
		-- tex:"b32755d5ff6a25159213c88675416774"; x:401.776672; y:-30.789429; z:-317.559143
		"\081\035\043\065\144\091\046\052\189\179\206\064\188\057\244\088\105\227\200\067\011\101\143\195\145\199\158\195" ..
		-- tex:"51232b41905b2e34bdb3ce40bc39f458"; x:401.776672; y:-286.789429; z:-317.559143
		"\140\191\169\181\155\240\126\235\239\105\178\110\183\244\050\107\141\183\128\068\019\064\143\194\022\140\157\195" ..
		-- tex:"8cbfa9b59bf07eebef69b26eb7f4326b"; x:1029.736084; y:-71.625153; z:-315.094452
		"\006\208\123\229\221\235\119\192\052\132\210\088\110\207\199\185\152\242\113\068\085\191\005\195\070\085\157\195" ..
		-- tex:"06d07be5ddeb77c03484d2586ecfc7b9"; x:967.790588; y:-133.747406; z:-314.666229
		"\214\128\228\154\019\061\245\164\142\059\230\071\045\097\077\097\108\023\117\068\081\165\199\195\157\067\155\195",
		-- tex:"d680e49a133df5a48e3be6472d614d61"; x:980.366028; y:-399.291565; z:-310.528259
	["Graveyard"] = 
		"\021\069\026\074\086\199\138\064\031\102\212\158\032\190\172\139\142\197\005\196\221\000\080\196\033\237\164\193" ..
		-- tex:"15451a4a56c78a401f66d49e20beac8b"; x:-535.086853; y:-832.013550; z:-20.615788
		"\032\101\073\109\152\221\020\010\234\007\137\131\148\151\041\231\212\055\241\195\119\006\072\196\002\101\135\193" ..
		-- tex:"2065496d98dd140aea078983949729e7"; x:-482.436188; y:-800.101074; z:-16.924322
		"\026\141\013\015\022\037\053\111\190\096\169\020\091\107\153\208\032\058\232\195\244\253\067\196\056\162\096\192" ..
		-- tex:"1a8d0d0f1625356fbe60a9145b6b99d0"; x:-464.454132; y:-783.968079; z:-3.509901
		"\252\249\049\197\145\109\162\167\088\078\220\185\182\251\017\064\230\011\244\195\218\160\083\196\013\162\096\192" ..
		-- tex:"fcf931c5916da2a7584edcb9b6fb1140"; x:-488.092987; y:-846.513367; z:-3.509891
		"\210\073\022\220\030\115\116\040\127\081\110\123\181\132\051\096\201\120\215\195\035\112\134\195\002\241\085\192" ..
		-- tex:"d24916dc1e7374287f516e7bb5843360"; x:-430.943665; y:-268.876099; z:-3.342835
		"\176\202\031\238\228\192\077\005\202\045\014\070\054\108\086\124\100\188\107\196\017\056\067\196\002\241\085\192" ..
		-- tex:"b0ca1feee4c04d05ca2d0e46366c567c"; x:-942.943665; y:-780.876099; z:-3.342835
		"\211\208\155\158\144\097\178\001\050\091\030\092\095\109\116\080\100\188\107\196\008\156\129\196\002\241\085\192" ..
		-- tex:"d3d09b9e9061b201325b1e5c5f6d7450"; x:-942.943665; y:-1036.876099; z:-3.342835
		"\163\225\145\218\165\096\051\151\114\154\111\138\181\185\183\034\100\188\107\196\017\056\003\196\002\241\085\192" ..
		-- tex:"a3e191daa5603397729a6f8ab5b9b722"; x:-942.943665; y:-524.876099; z:-3.342835
		"\151\121\189\218\071\226\236\018\065\107\187\032\245\000\040\020\201\120\215\195\017\056\003\196\002\241\085\192" ..
		-- tex:"9779bdda47e2ec12416bbb20f5002814"; x:-430.943665; y:-524.876099; z:-3.342835
		"\179\134\063\046\030\152\143\020\223\056\064\252\109\237\002\059\100\188\043\196\008\156\129\196\002\241\085\192" ..
		-- tex:"b3863f2e1e988f14df3840fc6ded023b"; x:-686.943665; y:-1036.876099; z:-3.342835
		"\076\050\235\240\252\207\019\043\070\165\097\013\157\247\240\019\100\188\043\196\017\056\003\196\002\241\085\192" ..
		-- tex:"4c32ebf0fccf132b46a5610d9df7f013"; x:-686.943665; y:-524.876099; z:-3.342835
		"\233\170\127\073\130\119\112\137\114\161\124\253\072\172\102\084\100\188\043\196\017\056\067\196\002\241\085\192" ..
		-- tex:"e9aa7f498277708972a17cfd48ac6654"; x:-686.943665; y:-780.876099; z:-3.342835
		"\059\014\008\190\015\119\199\209\112\119\231\147\190\026\188\184\201\120\215\195\008\156\129\196\002\241\085\192" ..
		-- tex:"3b0e08be0f77c7d17077e793be1abcb8"; x:-430.943665; y:-1036.876099; z:-3.342835
		"\219\241\131\204\139\155\184\013\096\015\175\255\159\077\248\110\100\188\043\196\035\112\134\195\002\241\085\192" ..
		-- tex:"dbf183cc8b9bb80d600fafff9f4df86e"; x:-686.943665; y:-268.876099; z:-3.342835
		"\032\195\198\106\033\239\235\054\073\244\208\007\172\109\043\061\201\120\215\195\017\056\067\196\002\241\085\192" ..
		-- tex:"20c3c66a21efeb3649f4d007ac6d2b3d"; x:-430.943665; y:-780.876099; z:-3.342835
		"\139\022\021\146\196\018\211\036\003\140\037\223\203\182\190\021\127\037\230\195\041\177\073\196\141\033\096\191" ..
		-- tex:"8b161592c412d324038c25dfcbb6be15"; x:-460.292969; y:-806.768188; z:-0.875512
		"\241\143\028\143\132\057\067\215\128\101\017\167\176\213\143\225\039\171\003\196\135\093\082\196\210\064\045\191" ..
		-- tex:"f18f1c8f843943d7806511a7b0d58fe1"; x:-526.674316; y:-841.461426; z:-0.676770
		"\089\223\208\091\177\008\225\161\122\177\251\213\133\045\139\208\181\152\214\195\131\127\050\195\008\034\088\065" ..
		-- tex:"59dfd05bb108e1a17ab1fbd5852d8bd0"; x:-429.193054; y:-178.498108; z:13.508309
		"\159\072\254\114\051\127\240\191\140\212\036\128\056\134\067\163\018\166\183\195\144\037\044\195\008\034\088\065" ..
		-- tex:"9f48fe72337ff0bf8cd42480388643a3"; x:-367.297455; y:-172.146744; z:13.508309
		"\137\086\136\193\132\002\135\181\022\123\033\133\066\093\106\218\173\073\153\195\243\037\044\195\008\034\088\065" ..
		-- tex:"895688c1840287b5167b2185425d6ada"; x:-306.575623; y:-172.148254; z:13.508309
		"\076\088\117\119\172\037\239\008\087\099\122\076\013\009\102\122\190\055\195\195\143\037\044\195\008\034\088\065" ..
		-- tex:"4c587577ac25ef0857637a4c0d09667a"; x:-390.435516; y:-172.146729; z:13.508309
		"\118\177\125\207\130\030\164\040\018\213\145\017\181\141\122\020\164\222\231\195\223\213\155\195\088\037\088\065" ..
		-- tex:"76b17dcf821ea42812d59111b58d7a14"; x:-463.739410; y:-311.670898; z:13.509118
		"\012\024\157\000\036\096\103\235\129\043\236\152\146\209\100\073\216\113\253\195\038\222\155\195\088\037\088\065" ..
		-- tex:"0c189d00246067eb812bec9892d16449"; x:-506.889435; y:-311.735565; z:13.509118
		"\242\055\137\208\176\033\195\168\067\015\168\103\112\102\039\130\184\178\148\195\141\002\012\195\024\120\105\065" ..
		-- tex:"f23789d0b021c3a8430fa86770662782"; x:-297.396271; y:-140.009979; z:14.591821
		"\037\227\181\211\180\192\025\250\070\212\196\011\159\175\216\126\207\082\243\195\199\166\191\195\102\123\105\065" ..
		-- tex:"25e3b5d3b4c019fa46d4c40b9fafd87e"; x:-486.646973; y:-383.302979; z:14.592628
		"\187\019\161\193\239\238\099\118\020\141\013\137\025\223\054\145\118\015\239\195\072\163\136\195\009\125\109\065" ..
		-- tex:"bb13a1c1efee6376148d0d8919df3691"; x:-478.120819; y:-273.275665; z:14.843027
		"\107\027\006\212\246\226\167\233\059\122\009\052\102\131\049\251\221\084\250\195\192\100\072\196\218\111\135\065" ..
		-- tex:"6b1b06d4f6e2a7e93b7a0934668331fb"; x:-500.663025; y:-801.574280; z:16.929617
		"\146\123\052\045\052\154\115\196\031\011\204\139\238\011\031\012\054\137\140\195\145\095\127\194\200\058\218\065" ..
		-- tex:"927b342d349a73c41f0bcc8bee0b1f0c"; x:-281.071991; y:-63.843330; z:27.278704
		"\142\012\214\210\218\145\044\217\005\071\239\137\212\000\001\115\019\218\146\195\008\163\167\194\200\058\218\065" ..
		-- tex:"8e0cd6d2da912cd90547ef89d4000173"; x:-293.703735; y:-83.818428; z:27.278704
		"\070\046\006\216\070\123\104\189\191\134\085\212\078\146\156\167\013\175\164\195\004\136\033\194\118\133\015\066" ..
		-- tex:"462e06d8467b68bdbf8655d44e929ca7"; x:-329.367615; y:-40.382832; z:35.880337
		"\174\075\010\184\183\039\087\125\117\229\190\133\124\094\174\038\018\004\147\195\096\243\090\066\015\111\020\066" ..
		-- tex:"ae4b0ab8b727577d75e5be857c5eae26"; x:-294.031830; y:54.737675; z:37.108459
		"\087\139\185\008\047\241\198\214\192\145\220\252\098\205\014\209\047\097\157\195\209\115\156\065\203\037\021\066" ..
		-- tex:"578bb9082ff1c6d6c091dcfc62cd0ed1"; x:-314.759277; y:19.556553; z:37.286911
		"\161\194\133\007\121\145\208\225\242\096\001\209\186\202\054\108\150\233\010\195\201\122\072\065\017\050\021\066" ..
		-- tex:"a1c285077991d0e1f26001d1baca366c"; x:-138.912460; y:12.529978; z:37.298897
		"\203\139\040\169\179\070\250\031\001\223\175\042\070\134\045\065\150\233\010\195\114\225\010\194\017\050\021\066",
		-- tex:"cb8b28a9b346fa1f01dfaf2a46862d41"; x:-138.912460; y:-34.720165; z:37.298897
	["Gruul's Lair"] = 
		"\233\123\238\095\100\060\032\001\161\027\036\064\191\048\254\019\230\133\191\195\186\140\002\196\205\020\246\193" ..
		-- tex:"e97bee5f643c2001a11b2440bf30fe13"; x:-383.046112; y:-522.198914; z:-30.760159
		"\236\074\164\110\098\223\135\014\005\153\113\061\225\157\039\183\155\023\254\194\117\025\133\195\205\020\246\193" ..
		-- tex:"ec4aa46e62df870e0599713de19d27b7"; x:-127.046112; y:-266.198914; z:-30.760159
		"\128\142\074\221\105\061\057\204\052\042\026\136\227\004\050\093\155\023\254\194\186\140\002\196\205\020\246\193" ..
		-- tex:"808e4add693d39cc342a1a88e304325d"; x:-127.046112; y:-522.198914; z:-30.760159
		"\178\127\243\217\028\059\238\033\070\036\166\100\139\086\112\112\230\133\191\195\117\025\133\195\205\020\246\193" ..
		-- tex:"b27ff3d91c3bee214624a6648b567070"; x:-383.046112; y:-266.198914; z:-30.760159
		"\223\027\207\066\114\063\043\189\153\234\039\053\151\246\083\112\248\066\021\196\034\217\091\196\199\082\181\193" ..
		-- tex:"df1bcf42723f2bbd99ea273597f65370"; x:-597.046448; y:-879.392761; z:-22.665421
		"\031\226\226\201\103\008\007\061\037\030\111\108\064\125\165\162\248\066\021\196\034\217\027\196\199\082\181\193" ..
		-- tex:"1fe2e2c96708073d251e6f6c407da5a2"; x:-597.046448; y:-623.392761; z:-22.665421
		"\082\202\103\110\145\128\020\057\113\111\179\187\100\080\046\093\241\133\170\195\034\217\091\196\199\082\181\193" ..
		-- tex:"52ca676e91801439716fb3bb64502e5d"; x:-341.046448; y:-879.392761; z:-22.665421
		"\059\093\018\008\017\207\127\152\019\227\200\252\175\224\016\149\086\068\068\195\183\004\135\065\139\029\155\193" ..
		-- tex:"3b5d120811cf7f9813e3c8fcafe01095"; x:-196.266953; y:16.877304; z:-19.389427
		"\224\185\111\204\203\164\131\190\024\102\219\007\227\069\217\030\086\068\068\195\104\031\111\195\139\029\155\193" ..
		-- tex:"e0b96fcccba483be1866db07e345d91e"; x:-196.266953; y:-239.122696; z:-19.389427
		"\191\105\165\166\004\000\132\041\238\070\157\250\221\234\061\245\177\132\156\195\043\218\066\196\136\031\211\192" ..
		-- tex:"bf69a5a604008429ee469dfaddea3df5"; x:-313.036682; y:-779.408936; z:-6.597600
		"\029\210\006\221\114\148\132\096\025\241\124\162\081\154\206\168\177\132\156\195\043\218\002\196\136\031\211\192",
		-- tex:"1dd206dd7294846019f17ca2519acea8"; x:-313.036682; y:-523.408936; z:-6.597600
	["Gundrak"] = 
		"\044\113\004\085\129\153\227\029\217\212\042\208\220\162\109\126\120\240\007\067\218\202\101\067\152\053\122\195" ..
		-- tex:"2c7104558199e31dd9d42ad0dca26d7e"; x:135.939339; y:229.792393; z:-250.209366
		"\114\179\237\007\128\071\092\248\049\071\010\241\169\198\208\133\014\031\240\194\218\202\101\067\152\053\122\195" ..
		-- tex:"72b3ed0780475cf831470af1a9c6d085"; x:-120.060661; y:229.792393; z:-250.209366
		"\118\054\167\053\039\106\141\247\079\161\129\080\017\142\046\020\120\240\007\067\045\169\209\193\152\053\122\195" ..
		-- tex:"7636a735276a8df74fa18150118e2e14"; x:135.939339; y:-26.207607; z:-250.209366
		"\058\105\238\009\185\131\140\122\120\223\000\162\033\146\052\135\014\031\240\194\045\169\209\193\152\053\122\195" ..
		-- tex:"3a69ee09b9838c7a78df00a221923487"; x:-120.060661; y:-26.207607; z:-250.209366
		"\009\049\087\107\115\134\154\068\068\132\008\219\236\010\115\113\232\211\055\067\038\226\079\195\191\137\106\195" ..
		-- tex:"0931576b73869a44448408dbec0a7371"; x:183.827774; y:-207.883408; z:-234.538086
		"\133\090\233\115\209\021\148\147\077\087\054\164\170\180\078\182\244\233\219\067\038\226\079\195\191\137\106\195" ..
		-- tex:"855ae973d11594934d5736a4aab44eb6"; x:439.827774; y:-207.883408; z:-234.538086
		"\225\050\041\143\124\186\012\068\135\058\138\081\147\132\176\179\232\211\055\067\099\119\064\066\191\137\106\195" ..
		-- tex:"e132298f7cba0c44873a8a519384b0b3"; x:183.827774; y:48.116592; z:-234.538086
		"\212\117\182\090\079\117\170\183\180\039\028\066\185\173\072\012\246\121\002\068\101\089\046\066\117\244\097\195" ..
		-- tex:"d475b65a4f75aab7b4271c42b9ad480c"; x:521.905701; y:43.587303; z:-225.954926
		"\081\115\152\151\105\050\129\167\159\015\156\088\069\157\003\087\237\243\132\067\101\089\046\066\117\244\097\195" ..
		-- tex:"51739897693281a79f0f9c58459d0357"; x:265.905701; y:43.587303; z:-225.954926
		"\038\255\022\205\189\198\086\039\144\067\073\045\117\149\014\138\164\043\038\067\098\114\050\193\028\007\097\195" ..
		-- tex:"26ff16cdbdc656279043492d75950e8a"; x:166.170486; y:-11.152926; z:-225.027786
		"\218\099\138\098\208\169\231\036\223\211\222\051\148\017\148\135\249\113\180\067\250\039\046\195\090\002\088\195" ..
		-- tex:"da638a62d0a9e724dfd3de3394119487"; x:360.890442; y:-174.156174; z:-216.009201
		"\054\092\051\209\171\185\234\200\011\080\138\240\112\203\107\209\107\023\033\067\084\192\223\067\205\024\083\195" ..
		-- tex:"365c33d1abb9eac80b508af070cb6bd1"; x:161.091492; y:447.502594; z:-211.096893
		"\211\027\197\055\018\048\205\075\068\188\128\244\254\105\076\135\181\139\208\067\169\128\063\067\205\024\083\195" ..
		-- tex:"d31bc5371230cd4b44bc80f4fe694c87"; x:417.091492; y:191.502594; z:-211.096893
		"\219\196\047\221\066\129\057\087\144\177\068\183\123\121\223\009\181\139\208\067\084\192\223\067\205\024\083\195" ..
		-- tex:"dbc42fdd4281395790b144b77b79df09"; x:417.091492; y:447.502594; z:-211.096893
		"\204\025\168\098\248\019\136\247\173\112\047\148\038\204\164\084\107\023\033\067\169\128\063\067\205\024\083\195" ..
		-- tex:"cc19a862f81388f7ad702f9426cca454"; x:161.091492; y:191.502594; z:-211.096893
		"\130\052\235\201\162\063\236\183\030\103\169\244\032\072\219\072\104\106\132\067\175\154\173\195\103\239\079\195" ..
		-- tex:"8234ebc9a23fecb71e67a9f42048db48"; x:264.831329; y:-347.208496; z:-207.935181
		"\248\042\099\222\044\163\072\237\223\145\237\072\116\061\021\115\186\023\135\066\201\193\192\195\144\161\024\195" ..
		-- tex:"f82a63de2ca348eddf91ed48743d1573"; x:67.546349; y:-385.513977; z:-152.631119
		"\069\147\027\031\241\082\034\007\174\099\087\072\064\005\252\004\102\100\116\066\187\188\131\195\010\001\014\195" ..
		-- tex:"45931b1ff1522207ae6357484005fc04"; x:61.098049; y:-263.474487; z:-142.004074
		"\006\188\226\246\111\053\010\250\061\146\205\253\119\060\111\180\006\243\199\194\213\255\237\194\001\126\012\195" ..
		-- tex:"06bce2f66f350afa3d92cdfd773c6fb4"; x:-99.974663; y:-118.999680; z:-140.492218
		"\082\045\068\188\197\085\015\065\016\034\077\001\007\109\105\076\150\110\209\194\008\043\159\067\001\126\012\195" ..
		-- tex:"522d44bcc5550f4110224d01076d694c"; x:-104.715996; y:318.336212; z:-140.492218
		"\069\053\147\216\114\198\027\035\149\004\065\236\055\008\201\196\102\100\116\066\230\246\064\195\158\135\010\195" ..
		-- tex:"453593d872c61b23950441ec3708c9c4"; x:61.098049; y:-192.964462; z:-138.529770
		"\222\063\092\124\190\048\243\170\149\038\125\157\113\071\056\077\113\185\028\192\109\239\030\195\065\239\007\195" ..
		-- tex:"de3f5c7cbe30f3aa95267d9d7147384d"; x:-2.448819; y:-158.935272; z:-135.934601
		"\036\104\151\238\025\207\153\056\002\121\190\151\018\005\046\191\159\068\167\192\108\102\139\067\015\220\005\195" ..
		-- tex:"246897ee19cf99380279be9712052ebf"; x:-5.227127; y:278.800201; z:-133.859619
		"\130\105\135\174\074\157\067\066\151\061\175\095\079\087\148\021\154\145\202\194\051\150\019\195\021\188\236\194" ..
		-- tex:"826987ae4a9d4342973daf5f4f579415"; x:-101.284386; y:-147.586731; z:-118.367355
		"\074\124\011\205\252\087\237\190\148\172\094\240\123\066\115\085\043\013\212\194\132\225\144\067\019\188\236\194" ..
		-- tex:"4a7c0bcdfc57edbe94ac5ef07b427355"; x:-106.025726; y:289.761871; z:-118.367340
		"\001\074\065\150\210\067\129\029\249\163\092\007\123\069\157\137\153\136\048\195\107\208\074\067\229\238\225\194" ..
		-- tex:"014a4196d243811df9a35c077b459d89"; x:-176.533600; y:202.814144; z:-112.966599
		"\242\250\190\175\224\047\127\064\032\174\177\108\220\152\120\123\076\068\216\195\107\208\074\067\229\238\225\194" ..
		-- tex:"f2fabeafe02f7f4020aeb16cdc98787b"; x:-432.533600; y:202.814144; z:-112.966599
		"\207\204\128\152\070\162\094\007\177\212\059\188\078\134\063\174\153\136\048\195\080\190\084\194\229\238\225\194" ..
		-- tex:"cfcc809846a25e07b1d43bbc4e863fae"; x:-176.533600; y:-53.185856; z:-112.966599
		"\067\223\139\059\073\082\064\252\115\052\052\106\023\021\039\004\076\068\216\195\080\190\084\194\229\238\225\194" ..
		-- tex:"43df8b3b495240fc7334346a17152704"; x:-432.533600; y:-53.185856; z:-112.966599
		"\175\036\174\228\149\055\017\253\114\113\073\058\118\209\040\112\194\175\134\195\240\198\135\067\206\032\224\194" ..
		-- tex:"af24aee4953711fd7271493a76d12870"; x:-269.373138; y:271.554230; z:-112.064079
		"\018\125\132\181\137\194\175\255\179\086\147\071\161\018\154\180\002\168\194\195\168\167\171\194\021\222\223\194" ..
		-- tex:"127d84b589c2afffb3569347a1129ab4"; x:-389.312592; y:-85.827461; z:-111.933762
		"\040\194\051\011\063\219\092\189\253\255\213\035\156\248\238\070\186\194\041\195\092\230\031\195\150\165\243\193" ..
		-- tex:"28c2330b3fdb5cbdfdffd5239cf8ee46"; x:-169.760666; y:-159.899857; z:-30.455854
		"\124\234\014\011\175\225\227\163\209\032\026\035\037\115\025\247\131\128\046\195\168\024\116\067\148\165\243\193" ..
		-- tex:"7cea0e0bafe1e3a3d1201a23257319f7"; x:-174.502014; y:244.096329; z:-30.455851
		"\000\107\187\236\198\004\003\228\028\033\132\191\136\128\044\000\215\055\140\065\116\028\084\066\180\241\162\064",
		-- tex:"006bbbecc60403e41c2184bf88802c00"; x:17.527267; y:53.027790; z:5.092005
	["Hellfire Ramparts"] = 
		"\052\244\063\080\147\139\071\129\221\201\011\142\118\253\035\038\255\255\223\069\255\255\007\198\000\000\000\000" ..
		-- tex:"34f43f50938b4781ddc90b8e76fd2326"; x:7168.000000; y:-8704.000000
		"\145\105\174\077\244\244\055\055\114\050\066\163\152\024\116\254\255\255\231\069\255\255\007\198\000\000\000\000",
		-- tex:"9169ae4df4f43737723242a3981874fe"; x:7424.000000; y:-8704.000000
	["Hyjal Summit"] = 
		"\156\207\117\224\245\048\078\004\105\058\078\063\241\103\224\096\255\255\007\070\255\255\159\197\000\000\000\000" ..
		-- tex:"9ccf75e0f5304e04693a4e3ff167e060"; x:8704.000000; y:-5120.000000
		"\173\027\075\003\235\146\183\058\096\208\055\136\042\121\254\143\255\255\007\070\255\255\167\197\000\000\000\000" ..
		-- tex:"ad1b4b03eb92b73a60d037882a79fe8f"; x:8704.000000; y:-5376.000000
		"\074\011\091\098\119\142\144\076\149\053\100\097\139\204\063\167\255\255\007\070\255\255\175\197\000\000\000\000" ..
		-- tex:"4a0b5b62778e904c953564618bcc3fa7"; x:8704.000000; y:-5632.000000
		"\003\130\220\190\061\140\252\146\171\007\021\046\045\220\161\197\255\255\007\070\255\255\183\197\000\000\000\000" ..
		-- tex:"0382dcbe3d8cfc92ab07152e2ddca1c5"; x:8704.000000; y:-5888.000000
		"\037\125\070\169\094\247\082\089\117\135\002\154\146\186\061\161\255\255\007\070\255\255\191\197\000\000\000\000" ..
		-- tex:"257d46a95ef752597587029a92ba3da1"; x:8704.000000; y:-6144.000000
		"\242\179\010\053\079\033\167\009\148\139\060\120\236\217\183\049\255\255\011\070\255\255\159\197\000\000\000\000" ..
		-- tex:"f2b30a354f21a709948b3c78ecd9b731"; x:8960.000000; y:-5120.000000
		"\057\199\021\045\251\127\208\210\229\081\122\227\179\111\072\121\255\255\011\070\255\255\167\197\000\000\000\000" ..
		-- tex:"39c7152dfb7fd0d2e5517ae3b36f4879"; x:8960.000000; y:-5376.000000
		"\000\001\058\073\133\137\013\218\097\102\120\038\190\032\239\054\255\255\011\070\255\255\175\197\000\000\000\000" ..
		-- tex:"00013a4985890dda61667826be20ef36"; x:8960.000000; y:-5632.000000
		"\126\126\226\152\116\219\253\103\078\127\023\143\040\060\041\090\255\255\011\070\255\255\183\197\000\000\000\000" ..
		-- tex:"7e7ee29874dbfd674e7f178f283c295a"; x:8960.000000; y:-5888.000000
		"\118\032\167\246\248\118\070\145\109\014\054\221\006\206\217\178\255\255\011\070\255\255\191\197\000\000\000\000" ..
		-- tex:"7620a7f6f87646916d0e36dd06ced9b2"; x:8960.000000; y:-6144.000000
		"\003\046\026\025\155\129\202\205\133\017\249\167\176\114\174\012\255\255\015\070\255\255\159\197\000\000\000\000" ..
		-- tex:"032e1a199b81cacd8511f9a7b072ae0c"; x:9216.000000; y:-5120.000000
		"\216\043\070\001\141\106\191\018\223\023\118\049\173\029\165\055\255\255\015\070\255\255\167\197\000\000\000\000" ..
		-- tex:"d82b46018d6abf12df177631ad1da537"; x:9216.000000; y:-5376.000000
		"\167\021\152\178\129\190\067\066\218\084\085\115\089\172\068\009\255\255\015\070\255\255\175\197\000\000\000\000" ..
		-- tex:"a71598b281be4342da54557359ac4409"; x:9216.000000; y:-5632.000000
		"\029\219\152\044\080\001\073\151\027\081\042\231\191\014\123\221\255\255\015\070\255\255\183\197\000\000\000\000" ..
		-- tex:"1ddb982c500149971b512ae7bf0e7bdd"; x:9216.000000; y:-5888.000000
		"\003\123\194\037\056\106\210\195\107\187\238\139\198\031\048\138\255\255\015\070\255\255\191\197\000\000\000\000" ..
		-- tex:"037bc225386ad2c36bbbee8bc61f308a"; x:9216.000000; y:-6144.000000
		"\192\072\001\081\091\149\083\161\074\146\123\174\231\230\101\110\255\255\019\070\255\255\159\197\000\000\000\000" ..
		-- tex:"c04801515b9553a14a927baee7e6656e"; x:9472.000000; y:-5120.000000
		"\156\152\173\252\014\244\180\191\148\006\116\050\205\167\081\229\255\255\019\070\255\255\167\197\000\000\000\000" ..
		-- tex:"9c98adfc0ef4b4bf94067432cda751e5"; x:9472.000000; y:-5376.000000
		"\135\099\073\088\143\222\061\193\226\253\255\225\090\058\146\141\255\255\019\070\255\255\175\197\000\000\000\000" ..
		-- tex:"876349588fde3dc1e2fdffe15a3a928d"; x:9472.000000; y:-5632.000000
		"\019\201\034\127\087\042\072\215\094\251\040\010\035\117\075\157\255\255\019\070\255\255\183\197\000\000\000\000" ..
		-- tex:"13c9227f572a48d75efb280a23754b9d"; x:9472.000000; y:-5888.000000
		"\144\089\058\036\255\186\179\121\153\061\068\136\110\056\033\208\255\255\019\070\255\255\191\197\000\000\000\000" ..
		-- tex:"90593a24ffbab379993d44886e3821d0"; x:9472.000000; y:-6144.000000
		"\222\030\178\149\204\084\049\016\069\183\247\180\048\192\121\088\255\255\023\070\255\255\159\197\000\000\000\000" ..
		-- tex:"de1eb295cc54311045b7f7b430c07958"; x:9728.000000; y:-5120.000000
		"\095\251\093\046\156\074\007\244\130\143\086\162\049\073\124\021\255\255\023\070\255\255\167\197\000\000\000\000" ..
		-- tex:"5ffb5d2e9c4a07f4828f56a231497c15"; x:9728.000000; y:-5376.000000
		"\192\207\014\126\014\187\087\049\015\055\064\047\055\224\239\214\255\255\023\070\255\255\175\197\000\000\000\000" ..
		-- tex:"c0cf0e7e0ebb57310f37402f37e0efd6"; x:9728.000000; y:-5632.000000
		"\003\092\081\094\224\185\077\001\071\250\167\247\233\045\158\039\255\255\023\070\255\255\183\197\000\000\000\000" ..
		-- tex:"035c515ee0b94d0147faa7f7e92d9e27"; x:9728.000000; y:-5888.000000
		"\219\122\100\142\190\149\127\228\036\035\033\146\028\229\037\206\255\255\023\070\255\255\191\197\000\000\000\000" ..
		-- tex:"db7a648ebe957fe4242321921ce525ce"; x:9728.000000; y:-6144.000000
		"\174\034\212\130\208\001\142\163\251\058\169\224\120\193\220\151\255\255\027\070\255\255\159\197\000\000\000\000" ..
		-- tex:"ae22d482d0018ea3fb3aa9e078c1dc97"; x:9984.000000; y:-5120.000000
		"\131\080\166\238\187\024\120\078\126\231\086\248\142\184\173\092\255\255\027\070\255\255\167\197\000\000\000\000" ..
		-- tex:"8350a6eebb18784e7ee756f88eb8ad5c"; x:9984.000000; y:-5376.000000
		"\221\216\003\020\062\058\209\199\038\013\136\059\054\209\215\068\255\255\027\070\255\255\175\197\000\000\000\000" ..
		-- tex:"ddd803143e3ad1c7260d883b36d1d744"; x:9984.000000; y:-5632.000000
		"\194\091\058\148\126\245\106\007\178\108\121\207\229\189\096\135\255\255\027\070\255\255\183\197\000\000\000\000" ..
		-- tex:"c25b3a947ef56a07b26c79cfe5bd6087"; x:9984.000000; y:-5888.000000
		"\056\009\006\189\072\191\164\168\226\239\205\066\035\093\022\013\255\255\027\070\255\255\191\197\000\000\000\000",
		-- tex:"380906bd48bfa4a8e2efcd42235d160d"; x:9984.000000; y:-6144.000000
	["Karazhan"] = 
		"\212\191\204\054\151\004\238\193\058\200\171\197\068\142\123\096\149\137\212\195\122\233\144\195\008\166\214\192" ..
		-- tex:"d4bfcc369704eec13ac8abc5448e7b60"; x:-425.074890; y:-289.824066; z:-6.707768
		"\101\135\014\022\013\125\149\044\145\103\015\194\097\246\071\149\043\019\041\195\215\075\007\194\008\166\214\192" ..
		-- tex:"65870e160d7d952c91670fc261f64795"; x:-169.074890; y:-33.824066; z:-6.707768
		"\148\009\221\236\080\187\102\127\023\146\220\129\202\177\199\041\043\019\041\195\122\233\144\195\008\166\214\192" ..
		-- tex:"9409ddec50bb667f1792dc81cab1c729"; x:-169.074890; y:-289.824066; z:-6.707768
		"\080\186\156\064\108\157\224\245\142\040\146\048\150\244\080\108\017\190\084\066\136\060\099\194\250\201\247\191" ..
		-- tex:"50ba9c406c9de0f58e28923096f4506c"; x:53.185616; y:-56.809116; z:-1.935851
		"\128\145\215\118\044\028\219\005\085\062\058\032\056\173\240\095\250\103\006\195\200\054\220\195\218\124\189\063" ..
		-- tex:"8091d7762c1cdb05553e3a2038adf05f"; x:-134.406174; y:-440.428009; z:1.480373
		"\161\068\219\093\131\203\194\081\045\189\025\204\157\162\222\147\114\181\030\194\005\033\050\194\198\249\235\063" ..
		-- tex:"a144db5d83cbc2512dbd19cc9da2de93"; x:-39.677197; y:-44.532249; z:1.843560
		"\240\168\000\030\203\164\092\144\157\096\047\220\106\005\101\091\074\219\163\193\185\227\153\066\205\133\022\064" ..
		-- tex:"f0a8001ecba45c909d602fdc6a05655b"; x:-20.482077; y:76.944778; z:2.351917
		"\188\043\253\181\047\185\157\024\027\079\118\065\143\047\101\251\048\021\192\194\145\015\205\194\072\108\032\065" ..
		-- tex:"bc2bfdb52fb99d181b4f76418f2f65fb"; x:-96.041389; y:-102.530411; z:10.026437
		"\069\014\253\235\203\021\056\079\028\031\232\227\156\085\141\033\111\105\099\194\157\144\138\195\224\076\017\066" ..
		-- tex:"450efdebcb15384f1c1fe8e39c558d21"; x:-56.852966; y:-277.129822; z:36.325077
		"\132\255\187\001\046\236\190\144\197\120\195\069\248\130\190\067\045\109\156\195\157\144\138\195\224\076\017\066" ..
		-- tex:"84ffbb012eecbe90c578c345f882be43"; x:-312.852966; y:-277.129822; z:36.325077
		"\166\137\215\041\006\202\104\164\001\132\010\172\098\212\001\004\045\109\156\195\223\009\169\193\224\076\017\066" ..
		-- tex:"a689d72906ca68a401840aac62d40104"; x:-312.852966; y:-21.129822; z:36.325077
		"\218\056\186\242\175\175\158\068\251\078\063\243\181\132\247\006\168\098\227\193\046\107\000\065\234\153\080\066" ..
		-- tex:"da38baf2afaf9e44fb4e3ff3b584f706"; x:-28.423174; y:8.026168; z:52.150311
		"\234\166\247\220\198\138\135\098\176\144\062\086\233\001\070\047\138\208\247\194\136\062\230\194\205\248\092\066" ..
		-- tex:"eaa6f7dcc68a8762b0903e56e901462f"; x:-123.907310; y:-115.122139; z:55.242973
		"\182\066\229\205\024\158\197\153\093\048\219\145\093\223\208\253\235\129\120\066\034\115\167\195\027\190\100\066" ..
		-- tex:"b642e5cd189ec5995d30db915ddfd0fd"; x:62.126877; y:-334.899506; z:57.185654
		"\155\230\082\113\099\063\244\184\013\117\070\052\229\138\044\205\132\223\065\195\034\115\167\195\027\190\100\066" ..
		-- tex:"9be65271633ff4b80d754634e58a2ccd"; x:-193.873123; y:-334.899506; z:57.185654
		"\136\091\153\141\177\030\146\112\105\094\080\010\102\133\239\180\222\031\231\194\082\045\019\196\020\190\109\066" ..
		-- tex:"885b998db11e9270695e500a6685efb4"; x:-115.562248; y:-588.708191; z:59.435627
		"\073\236\186\024\203\169\182\077\181\193\231\226\167\238\192\237\016\112\012\067\082\045\019\196\020\190\109\066" ..
		-- tex:"49ecba18cba9b64db5c1e7e2a7eec0ed"; x:140.437752; y:-588.708191; z:59.435627
		"\179\140\167\176\141\178\091\165\044\036\150\205\074\204\131\022\222\031\231\194\165\090\166\195\020\190\109\066" ..
		-- tex:"b38ca7b08db25ba52c2496cd4acc8316"; x:-115.562248; y:-332.708191; z:59.435627
		"\155\211\050\183\044\141\068\180\076\132\203\097\104\130\202\175\228\228\235\066\003\153\010\196\022\190\109\066" ..
		-- tex:"9bd332b72c8d44b44c84cb616882caaf"; x:117.947060; y:-554.390869; z:59.435635
		"\036\118\192\149\170\069\088\110\251\045\149\131\034\137\050\177\005\253\081\195\227\199\202\195\036\197\110\066" ..
		-- tex:"2476c095aa45586efb2d9583228932b1"; x:-209.988373; y:-405.561646; z:59.692524
		"\133\052\088\211\034\107\244\210\132\050\178\220\210\246\051\203\087\203\054\065\047\011\041\196\011\032\163\066" ..
		-- tex:"853458d3226bf4d28432b2dcd2f633cb"; x:11.424644; y:-676.174805; z:81.562592
		"\035\177\075\184\170\039\122\226\137\091\212\203\158\185\165\114\170\138\207\066\034\110\028\196\098\042\167\066" ..
		-- tex:"23b14bb8aa277ae2895bd4cb9eb9a572"; x:103.770836; y:-625.720886; z:83.582787
		"\178\073\098\170\006\230\065\122\194\071\242\203\095\006\230\076\088\137\219\066\015\039\240\195\120\052\167\066" ..
		-- tex:"b24962aa06e6417ac247f2cb5f06e64c"; x:109.768257; y:-480.305176; z:83.602486
		"\185\223\047\005\210\139\091\251\230\100\064\019\054\005\011\146\125\209\247\195\054\122\069\195\034\072\167\066" ..
		-- tex:"b9df2f05d28b5bfbe664401336050b92"; x:-495.636658; y:-197.477402; z:83.640892
		"\172\204\185\195\210\077\116\224\186\166\250\106\225\094\196\036\085\197\205\195\008\099\153\195\154\255\168\066" ..
		-- tex:"acccb9c3d24d74e0baa6fa6ae15ec424"; x:-411.541687; y:-306.773712; z:84.499229
		"\206\243\137\070\065\052\109\241\169\246\133\220\003\212\215\103\192\245\062\192\191\037\166\192\009\012\171\066" ..
		-- tex:"cef3894641346df1a9f685dc03d4d767"; x:-2.983750; y:-5.192108; z:85.523514
		"\102\128\118\159\221\161\109\187\004\063\182\058\188\037\015\136\225\236\161\066\079\138\030\194\166\016\171\066" ..
		-- tex:"6680769fdda16dbb043fb63abc250f88"; x:80.962662; y:-39.635071; z:85.532524
		"\064\117\240\131\179\026\218\070\012\199\111\182\106\061\182\076\027\193\070\066\056\220\054\194\206\044\171\066" ..
		-- tex:"4075f083b31ada460cc76fb66a3db64c"; x:49.688583; y:-45.715061; z:85.587517
		"\017\046\059\214\050\234\063\067\082\191\049\063\241\047\070\177\113\187\238\194\185\097\179\195\156\224\173\066" ..
		-- tex:"112e3bd632ea3f4352bf313ff12f46b1"; x:-119.366104; y:-358.763489; z:86.938698
		"\229\138\060\173\025\113\116\217\212\245\155\248\024\022\093\051\222\038\185\195\194\010\203\195\255\239\173\066" ..
		-- tex:"e58a3cad197174d9d4f59bf818165d33"; x:-370.303680; y:-406.084076; z:86.968750
		"\091\196\183\108\010\151\115\204\005\004\106\070\010\177\244\176\097\141\182\195\050\249\165\195\190\244\173\066" ..
		-- tex:"5bc4b76c0a9773cc05046a460ab1f4b0"; x:-365.104553; y:-331.946869; z:86.978020
		"\255\166\064\219\214\002\208\128\211\223\098\214\194\005\101\092\102\065\223\195\155\095\210\194\162\249\173\066" ..
		-- tex:"ffa640dbd602d080d3df62d6c205655c"; x:-446.510956; y:-105.186737; z:86.987572
		"\119\002\038\044\242\060\137\125\181\085\006\068\037\075\213\240\178\010\089\195\213\046\143\195\116\252\173\066" ..
		-- tex:"7702262cf23c897db5550644254bd5f0"; x:-217.041794; y:-286.365906; z:86.993080
		"\252\205\178\239\209\137\235\053\216\119\065\125\228\032\221\168\240\018\087\194\198\070\144\194\239\126\178\066" ..
		-- tex:"fccdb2efd189eb35d877417de420dda8"; x:-53.768497; y:-72.138237; z:89.247925
		"\006\183\216\200\072\103\041\116\108\083\215\235\157\098\019\176\117\025\244\194\056\040\014\194\248\134\178\066" ..
		-- tex:"06b7d8c8486729746c53d7eb9d6213b0"; x:-122.049728; y:-35.539280; z:89.263618
		"\097\122\175\171\245\156\209\071\247\154\165\059\245\111\156\247\046\156\210\194\174\087\246\194\081\096\232\066" ..
		-- tex:"617aafabf59cd147f79aa53bf56f9cf7"; x:-105.305046; y:-123.171257; z:116.188126
		"\197\173\175\142\239\152\186\046\181\128\251\085\050\098\020\247\252\059\159\194\046\200\091\195\065\039\002\067" ..
		-- tex:"c5adaf8eef98ba2eb580fb55326214f7"; x:-79.617165; y:-219.781967; z:130.153351
		"\240\189\042\236\006\205\054\038\023\218\061\025\137\119\222\192\231\232\101\196\012\037\013\196\154\029\022\067" ..
		-- tex:"f0bd2aec06cd362617da3d198977dec0"; x:-919.639160; y:-564.578918; z:150.115646
		"\240\113\080\001\103\165\105\142\238\246\013\205\242\150\205\248\231\232\101\196\025\074\154\195\154\029\022\067" ..
		-- tex:"f071500167a5698eeef60dcdf296cdf8"; x:-919.639160; y:-308.578918; z:150.115646
		"\035\201\122\029\044\171\041\212\175\245\087\096\198\184\132\219\231\232\101\196\207\080\082\194\154\029\022\067" ..
		-- tex:"23c97a1d2cab29d4aff55760c6b884db"; x:-919.639160; y:-52.578918; z:150.115646
		"\150\228\130\004\089\187\038\095\230\085\183\219\051\214\230\140\115\244\178\196\229\181\229\067\154\029\022\067" ..
		-- tex:"96e4820459bb265fe655b7db33d6e68c"; x:-1431.639160; y:459.421082; z:150.115646
		"\103\196\255\136\218\169\072\155\210\101\210\230\186\177\201\215\231\232\101\196\203\107\075\067\154\029\022\067" ..
		-- tex:"67c4ff88daa9489bd265d2e6bab1c9d7"; x:-919.639160; y:203.421082; z:150.115646
		"\003\018\132\198\030\086\050\147\153\123\102\048\063\254\064\219\231\232\101\196\229\181\229\067\154\029\022\067" ..
		-- tex:"031284c61e563293997b66303ffe40db"; x:-919.639160; y:459.421082; z:150.115646
		"\075\082\121\242\214\219\050\128\102\200\018\068\030\024\090\071\231\232\101\196\012\037\077\196\154\029\022\067" ..
		-- tex:"4b5279f2d6db328066c812441e185a47"; x:-919.639160; y:-820.578918; z:150.115646
		"\097\193\068\095\129\058\109\128\237\095\052\251\020\041\173\026\231\232\101\196\242\218\050\068\154\029\022\067" ..
		-- tex:"61c1445f813a6d80ed5f34fb1429ad1a"; x:-919.639160; y:715.421082; z:150.115646
		"\171\117\104\250\150\072\131\154\254\067\254\063\015\060\035\086\115\244\146\196\242\218\050\068\154\029\022\067" ..
		-- tex:"ab7568fa9648839afe43fe3f0f3c2356"; x:-1175.639160; y:715.421082; z:150.115646
		"\128\027\201\008\249\035\154\057\247\166\049\034\125\036\146\233\115\244\146\196\229\181\229\067\154\029\022\067" ..
		-- tex:"801bc908f9239a39f7a631227d2492e9"; x:-1175.639160; y:459.421082; z:150.115646
		"\087\117\133\198\223\254\234\121\183\154\034\109\202\117\135\216\115\244\146\196\203\107\075\067\154\029\022\067" ..
		-- tex:"577585c6dffeea79b79a226dca7587d8"; x:-1175.639160; y:203.421082; z:150.115646
		"\039\045\201\186\159\211\177\198\039\050\052\187\084\075\106\153\115\244\178\196\203\107\075\067\154\029\022\067" ..
		-- tex:"272dc9ba9fd3b1c6273234bb544b6a99"; x:-1431.639160; y:203.421082; z:150.115646
		"\054\196\039\014\130\252\118\127\163\145\008\091\054\004\241\198\115\244\178\196\012\037\077\196\154\029\022\067" ..
		-- tex:"36c4270e82fc767fa391085b3604f1c6"; x:-1431.639160; y:-820.578918; z:150.115646
		"\147\087\206\059\163\033\156\140\139\096\006\044\225\235\187\079\115\244\178\196\012\037\013\196\154\029\022\067" ..
		-- tex:"9357ce3ba3219c8c8b60062ce1ebbb4f"; x:-1431.639160; y:-564.578918; z:150.115646
		"\185\153\148\047\156\025\178\182\086\154\200\183\140\197\065\133\231\232\037\196\012\037\077\196\154\029\022\067" ..
		-- tex:"b999942f9c19b2b6569ac8b78cc54185"; x:-663.639160; y:-820.578918; z:150.115646
		"\094\103\231\043\243\020\119\167\214\052\086\217\032\022\108\017\115\244\146\196\012\037\077\196\154\029\022\067" ..
		-- tex:"5e67e72bf31477a7d63456d920166c11"; x:-1175.639160; y:-820.578918; z:150.115646
		"\181\042\032\178\201\092\200\056\254\052\018\081\161\172\209\123\115\244\146\196\025\074\154\195\154\029\022\067" ..
		-- tex:"b52a20b2c95cc838fe341251a1acd17b"; x:-1175.639160; y:-308.578918; z:150.115646
		"\248\190\033\016\082\068\225\087\188\068\109\182\082\122\034\077\115\244\146\196\012\037\013\196\154\029\022\067" ..
		-- tex:"f8be21105244e157bc446db6527a224d"; x:-1175.639160; y:-564.578918; z:150.115646
		"\255\241\068\185\000\228\014\108\163\205\020\144\087\114\099\028\115\244\146\196\207\080\082\194\154\029\022\067" ..
		-- tex:"fff144b900e40e6ca3cd14905772631c"; x:-1175.639160; y:-52.578918; z:150.115646
		"\219\198\003\002\219\224\239\017\240\085\250\033\019\111\201\224\231\232\037\196\012\037\013\196\154\029\022\067" ..
		-- tex:"dbc60302dbe0ef11f055fa21136fc9e0"; x:-663.639160; y:-564.578918; z:150.115646
		"\128\027\254\123\078\233\069\210\208\220\044\165\220\092\104\171\231\232\037\196\025\074\154\195\154\029\022\067" ..
		-- tex:"801bfe7b4ee945d2d0dc2ca5dc5c68ab"; x:-663.639160; y:-308.578918; z:150.115646
		"\104\080\243\017\029\227\015\182\116\094\019\080\069\166\035\211\231\232\037\196\207\080\082\194\154\029\022\067" ..
		-- tex:"6850f3111de30fb6745e135045a623d3"; x:-663.639160; y:-52.578918; z:150.115646
		"\033\041\171\142\012\123\176\078\078\165\205\030\195\241\215\147\159\163\023\195\012\037\013\196\154\029\022\067" ..
		-- tex:"2129ab8e0c7bb04e4ea5cd1ec3f1d793"; x:-151.639160; y:-564.578918; z:150.115646
		"\203\169\212\205\151\153\095\064\031\231\208\100\101\253\211\247\159\163\023\195\012\037\077\196\154\029\022\067" ..
		-- tex:"cba9d4cd97995f401fe7d06465fdd3f7"; x:-151.639160; y:-820.578918; z:150.115646
		"\254\147\057\155\140\191\072\004\056\108\026\181\221\236\251\209\115\244\178\196\025\074\154\195\154\029\022\067" ..
		-- tex:"fe93399b8cbf4804386c1ab5ddecfbd1"; x:-1431.639160; y:-308.578918; z:150.115646
		"\246\094\067\093\205\231\180\034\033\013\042\058\092\143\102\057\159\163\023\195\025\074\154\195\154\029\022\067" ..
		-- tex:"f65e435dcde7b422210d2a3a5c8f6639"; x:-151.639160; y:-308.578918; z:150.115646
		"\104\236\128\248\005\179\024\140\009\224\199\053\197\131\168\183\159\163\023\195\203\107\075\067\154\029\022\067" ..
		-- tex:"68ec80f805b3188c09e0c735c583a8b7"; x:-151.639160; y:203.421082; z:150.115646
		"\235\252\222\099\092\118\095\032\011\069\077\027\011\049\164\007\159\163\023\195\207\080\082\194\154\029\022\067" ..
		-- tex:"ebfcde635c765f200b454d1b0b31a407"; x:-151.639160; y:-52.578918; z:150.115646
		"\210\220\087\246\129\041\154\219\172\016\206\032\188\236\221\047\159\163\023\195\229\181\229\067\154\029\022\067" ..
		-- tex:"d2dc57f681299adbac10ce20bcecdd2f"; x:-151.639160; y:459.421082; z:150.115646
		"\121\240\030\034\181\037\246\046\049\073\076\129\035\255\133\134\207\209\203\195\229\181\229\067\154\029\022\067" ..
		-- tex:"79f01e22b525f62e31494c8123ff8586"; x:-407.639160; y:459.421082; z:150.115646
		"\122\166\052\042\192\119\116\159\099\121\010\252\018\147\069\171\207\209\203\195\242\218\050\068\154\029\022\067" ..
		-- tex:"7aa6342ac077749f63790afc129345ab"; x:-407.639160; y:715.421082; z:150.115646
		"\255\158\116\003\148\060\236\042\200\137\004\249\139\188\158\177\207\209\203\195\207\080\082\194\154\029\022\067" ..
		-- tex:"ff9e7403943cec2ac88904f98bbc9eb1"; x:-407.639160; y:-52.578918; z:150.115646
		"\181\039\003\111\077\162\009\184\117\204\177\213\238\233\103\091\207\209\203\195\203\107\075\067\154\029\022\067" ..
		-- tex:"b527036f4da209b875ccb1d5eee9675b"; x:-407.639160; y:203.421082; z:150.115646
		"\081\064\037\104\227\183\144\223\089\079\217\184\142\083\109\097\231\232\037\196\229\181\229\067\154\029\022\067" ..
		-- tex:"51402568e3b790df594fd9b88e536d61"; x:-663.639160; y:459.421082; z:150.115646
		"\096\213\236\043\214\215\136\036\023\177\062\034\220\003\091\069\231\232\037\196\203\107\075\067\154\029\022\067" ..
		-- tex:"60d5ec2bd6d7882417b13e22dc035b45"; x:-663.639160; y:203.421082; z:150.115646
		"\105\065\009\246\075\156\252\142\044\187\027\022\060\066\026\233\231\232\037\196\242\218\050\068\154\029\022\067" ..
		-- tex:"694109f64b9cfc8e2cbb1b163c421ae9"; x:-663.639160; y:715.421082; z:150.115646
		"\020\164\213\090\165\010\032\079\155\140\230\042\222\154\089\089\115\244\178\196\207\080\082\194\154\029\022\067" ..
		-- tex:"14a4d55aa50a204f9b8ce62ade9a5959"; x:-1431.639160; y:-52.578918; z:150.115646
		"\229\022\053\236\213\115\083\242\071\199\221\105\085\107\039\018\207\209\203\195\012\037\013\196\154\029\022\067" ..
		-- tex:"e51635ecd57353f247c7dd69556b2712"; x:-407.639160; y:-564.578918; z:150.115646
		"\110\237\064\190\158\067\176\014\048\255\057\221\021\168\238\040\207\209\203\195\025\074\154\195\154\029\022\067" ..
		-- tex:"6eed40be9e43b00e30ff39dd15a8ee28"; x:-407.639160; y:-308.578918; z:150.115646
		"\030\227\095\174\007\059\057\193\014\203\180\241\030\123\029\206\207\209\203\195\012\037\077\196\154\029\022\067" ..
		-- tex:"1ee35fae073b39c10ecbb4f11e7b1dce"; x:-407.639160; y:-820.578918; z:150.115646
		"\169\241\027\145\086\075\242\113\071\148\254\145\057\144\227\041\119\075\213\193\156\152\150\195\163\196\023\067" ..
		-- tex:"a9f11b91564bf2714794fe913990e329"; x:-26.661850; y:-301.192291; z:151.768127
		"\230\253\230\222\128\245\152\151\161\067\215\140\216\206\136\075\222\051\140\194\072\106\145\194\209\199\023\067" ..
		-- tex:"e6fde6de80f59897a143d78cd8ce884b"; x:-70.101311; y:-72.707588; z:151.780548
		"\106\110\114\231\001\237\237\149\165\182\030\071\202\201\220\114\017\023\010\068\207\188\210\194\099\205\045\067" ..
		-- tex:"6a6e72e701eded95a5b61e47cac9dc72"; x:552.360443; y:-105.368774; z:173.802307
		"\105\043\255\023\178\204\203\116\080\045\091\010\201\207\217\197\034\046\148\067\051\175\180\195\099\205\045\067" ..
		-- tex:"692bff17b2cccb74502d5b0ac9cfd9c5"; x:296.360443; y:-361.368774; z:173.802307
		"\240\090\114\184\040\075\066\166\008\116\154\015\072\150\239\004\023\113\033\066\203\080\203\067\099\205\045\067" ..
		-- tex:"f05a72b8284b42a608749a0f4896ef04"; x:40.360443; y:406.631226; z:173.802307
		"\188\003\140\185\166\201\249\041\157\187\068\111\162\063\040\179\017\023\010\068\151\161\022\067\099\205\045\067" ..
		-- tex:"bc038cb9a6c9f9299dbb446fa23f28b3"; x:552.360443; y:150.631226; z:173.802307
		"\109\156\073\178\081\071\028\184\138\210\144\103\034\197\245\054\017\023\010\068\203\080\203\067\099\205\045\067" ..
		-- tex:"6d9c49b251471cb88ad2906722c5f536"; x:552.360443; y:406.631226; z:173.802307
		"\213\025\150\186\239\036\136\130\234\034\173\126\211\160\006\071\017\023\010\068\051\175\180\195\099\205\045\067" ..
		-- tex:"d51996baef248882ea22ad7ed3a00647"; x:552.360443; y:-361.368774; z:173.802307
		"\134\037\216\089\060\165\253\173\141\144\187\026\071\221\123\196\034\046\148\067\151\161\022\067\099\205\045\067" ..
		-- tex:"8625d8593ca5fdad8d90bb1a47dd7bc4"; x:296.360443; y:150.631226; z:173.802307
		"\135\233\169\247\068\187\054\233\179\142\206\100\062\050\243\230\034\046\148\067\203\080\203\067\099\205\045\067" ..
		-- tex:"87e9a9f744bb36e9b38ece643e32f3e6"; x:296.360443; y:406.631226; z:173.802307
		"\005\135\170\234\123\102\113\061\212\108\000\020\025\101\028\118\034\046\148\067\207\188\210\194\099\205\045\067" ..
		-- tex:"0587aaea7b66713dd46c001419651c76"; x:296.360443; y:-105.368774; z:173.802307
		"\149\104\012\001\177\033\169\059\235\085\021\173\165\038\166\232\017\023\074\068\051\175\180\195\099\205\045\067" ..
		-- tex:"95680c01b121a93beb5515ada526a6e8"; x:808.360443; y:-361.368774; z:173.802307
		"\080\160\021\238\104\004\156\131\018\025\027\129\112\127\156\114\017\023\074\068\151\161\022\067\099\205\045\067" ..
		-- tex:"50a015ee68049c8312191b81707f9c72"; x:808.360443; y:150.631226; z:173.802307
		"\073\221\184\038\061\145\191\072\186\085\116\171\226\086\098\164\023\113\033\066\051\175\180\195\099\205\045\067" ..
		-- tex:"49ddb8263d91bf48ba5574abe25662a4"; x:40.360443; y:-361.368774; z:173.802307
		"\023\133\116\158\078\198\043\192\169\122\152\242\215\029\091\169\017\023\074\068\207\188\210\194\099\205\045\067" ..
		-- tex:"1785749e4ec62bc0a97a98f2d71d5ba9"; x:808.360443; y:-105.368774; z:173.802307
		"\146\233\105\211\166\186\248\016\143\108\065\059\034\230\057\032\023\113\033\066\207\188\210\194\099\205\045\067" ..
		-- tex:"92e969d3a6baf8108f6c413b22e63920"; x:40.360443; y:-105.368774; z:173.802307
		"\154\102\094\028\212\109\181\089\234\008\151\099\109\186\117\013\017\023\074\068\203\080\203\067\099\205\045\067" ..
		-- tex:"9a665e1cd46db559ea0897636dba750d"; x:808.360443; y:406.631226; z:173.802307
		"\100\170\189\205\108\119\137\014\125\154\053\185\120\249\019\115\023\113\033\066\151\161\022\067\099\205\045\067" ..
		-- tex:"64aabdcd6c77890e7d9a35b978f91373"; x:40.360443; y:150.631226; z:173.802307
		"\039\138\213\047\023\227\218\228\027\195\255\213\184\075\137\204\086\242\034\067\150\109\184\193\172\200\086\067" ..
		-- tex:"278ad52f17e3dae41bc3ffd5b84b89cc"; x:162.946640; y:-23.053511; z:214.783890
		"\154\141\125\194\029\198\159\191\245\079\232\059\081\012\011\149\246\111\009\194\034\171\000\195\246\081\096\067" ..
		-- tex:"9a8d7dc21dc69fbff54fe83b510c0b95"; x:-34.359341; y:-128.668503; z:224.320175
		"\032\050\173\000\051\191\080\034\117\197\005\147\226\055\144\046\210\063\186\193\017\175\134\195\099\089\097\067" ..
		-- tex:"2032ad0033bf502275c50593e237902e"; x:-23.281164; y:-269.367737; z:225.349182
		"\187\108\017\042\146\149\171\169\205\029\017\167\221\086\196\200\111\173\003\067\204\098\114\195\043\034\103\067" ..
		-- tex:"bb6c112a9295aba9cd1d11a7dd56c4c8"; x:131.677490; y:-242.385941; z:231.133484
		"\133\249\176\195\007\104\150\164\120\220\188\056\008\072\094\132\170\130\017\068\175\037\009\195\194\143\130\067" ..
		-- tex:"85f9b0c3076896a478dcbc3808485e84"; x:582.041687; y:-137.147217; z:261.123138
		"\171\227\138\113\132\232\242\201\040\028\252\098\165\232\190\177\225\037\226\067\007\204\052\195\016\152\130\067" ..
		-- tex:"abe38a7184e8f2c9281cfc62a5e8beb1"; x:452.295959; y:-180.796997; z:261.188019
		"\040\072\199\231\049\192\179\189\027\121\156\186\213\243\228\181\243\051\199\067\064\150\047\195\128\121\152\067" ..
		-- tex:"2848c7e731c0b3bd1b799cbad5f3e4b5"; x:398.405884; y:-175.586929; z:304.949249
		"\216\202\129\163\169\223\049\122\205\238\102\181\095\126\163\127\099\220\016\068\122\121\244\194\059\052\162\067" ..
		-- tex:"d8ca81a3a9df317acdee66b55f7ea37f"; x:579.443604; y:-122.237267; z:324.408081
		"\043\214\223\079\076\071\173\166\053\061\143\207\004\025\241\100\232\077\096\066\175\243\042\195\233\253\171\067" ..
		-- tex:"2bd6df4f4c47ada6353d8fcf0419f164"; x:56.076084; y:-170.951904; z:343.983704
		"\114\175\087\197\171\210\249\031\154\179\172\185\144\072\002\170\193\037\189\067\054\054\057\066\011\062\175\067" ..
		-- tex:"72af57c5abd2f91f9ab3acb9904802aa"; x:378.294983; y:46.302944; z:350.484741
		"\158\069\186\170\161\059\123\126\087\224\000\113\111\053\000\173\062\117\032\194\008\102\065\194\235\182\181\067" ..
		-- tex:"9e45baaaa13b7b7e57e000716f3500ad"; x:-40.114498; y:-48.349644; z:363.429077
		"\174\035\189\022\119\102\048\234\239\202\250\123\180\255\183\042\064\204\016\067\247\189\138\065\110\070\183\067" ..
		-- tex:"ae23bd16776630eaefcafa7bb4ffb72a"; x:144.797867; y:17.342758; z:366.550262
		"\163\076\194\237\101\166\056\004\181\252\252\208\186\034\231\202\241\038\008\193\154\096\083\195\236\148\183\067" ..
		-- tex:"a34cc2ed65a63804b5fcfcd0ba22e7ca"; x:-8.509508; y:-211.377365; z:367.163483
		"\115\097\125\040\006\174\237\191\127\071\097\235\203\082\211\244\052\211\019\194\045\132\009\195\236\148\183\067" ..
		-- tex:"73617d2806aeedbf7f4761ebcb52d3f4"; x:-36.956257; y:-137.516327; z:367.163483
		"\109\238\120\188\218\167\191\207\040\207\022\009\117\005\152\162\056\213\015\068\021\234\017\195\015\067\192\067" ..
		-- tex:"6dee78bcdaa7bfcf28cf1609750598a2"; x:575.331604; y:-145.914398; z:384.523926
		"\252\066\037\081\098\066\159\136\255\116\093\224\247\085\238\249\187\147\152\066\067\063\105\195\071\053\196\067" ..
		-- tex:"fc42255162429f88ff745de0f755eef9"; x:76.288544; y:-233.247131; z:392.416260
		"\164\052\024\025\235\120\112\072\185\093\186\183\121\182\182\041\091\040\142\066\042\122\030\195\072\053\196\067" ..
		-- tex:"a4341819eb787048b95dbab779b6b629"; x:71.078827; y:-158.477219; z:392.416290
		"\141\109\043\227\138\099\083\238\006\164\192\143\154\170\230\123\110\090\105\194\146\002\053\195\203\119\198\067" ..
		-- tex:"8d6d2be38a6353ee06a4c08f9aaae67b"; x:-58.338314; y:-181.010056; z:396.935913
		"\121\032\254\150\060\148\042\085\171\065\121\080\161\128\237\130\104\087\076\194\234\134\129\194\011\132\199\067" ..
		-- tex:"7920fe963c942a55ab417950a180ed82"; x:-51.085361; y:-64.763512; z:399.031616
		"\117\034\024\073\222\071\022\114\242\025\078\063\012\186\189\146\166\158\124\193\088\158\126\194\198\005\216\067" ..
		-- tex:"75221849de471672f2194e3f0cbabd92"; x:-15.788733; y:-63.654636; z:432.045135
		"\205\052\221\206\157\122\113\247\159\182\036\202\166\067\219\028\033\212\237\193\025\196\150\194\129\009\224\067" ..
		-- tex:"cd34ddce9d7a71f79fb624caa643db1c"; x:-29.728580; y:-75.383011; z:448.074280
		"\090\128\055\206\236\243\162\174\156\200\099\061\193\241\134\005\204\158\104\194\235\038\187\194\167\059\226\067" ..
		-- tex:"5a8037ceecf3a2ae9cc8633dc1f18605"; x:-58.155079; y:-93.576019; z:452.466064
		"\074\029\158\180\163\117\201\032\114\143\126\214\156\238\207\225\012\142\075\194\169\213\191\194\167\059\226\067" ..
		-- tex:"4a1d9eb4a375c920728f7ed69ceecfe1"; x:-50.888721; y:-95.917313; z:452.466064
		"\090\241\140\109\071\061\250\192\011\240\050\078\044\152\126\105\058\145\125\193\214\237\158\194\167\059\226\067" ..
		-- tex:"5af18c6d473dfac00bf0324e2c987e69"; x:-15.847957; y:-79.464531; z:452.466064
		"\015\115\131\173\238\037\080\114\007\013\171\038\238\185\075\010\168\020\190\193\088\201\187\194\168\059\226\067" ..
		-- tex:"0f7383adee255072070dab26eeb94b0a"; x:-23.760088; y:-93.893257; z:452.466095
		"\038\027\037\036\093\183\015\146\094\192\193\041\085\253\212\236\055\126\138\194\108\090\176\194\168\059\226\067" ..
		-- tex:"261b25245db70f925ec0c12955fdd4ec"; x:-69.246521; y:-88.176613; z:452.466095
		"\007\038\254\089\224\232\252\195\126\177\085\099\161\132\221\104\088\070\024\194\070\094\197\194\168\059\226\067" ..
		-- tex:"0726fe59e0e8fcc37eb15563a184dd68"; x:-38.068699; y:-98.684135; z:452.466095
		"\247\098\236\159\053\131\071\011\156\172\210\083\029\129\061\089\105\237\146\193\201\058\173\194\168\059\226\067" ..
		-- tex:"f762ec9f3583470b9cacd2531d813d59"; x:-18.365925; y:-86.614822; z:452.466095
		"\008\177\146\230\079\083\158\237\081\100\240\065\138\009\144\130\232\222\057\068\233\130\001\196\160\176\227\067" ..
		-- tex:"08b192e64f539eed5164f0418a099082"; x:743.482971; y:-518.045532; z:455.379913
		"\018\106\062\185\057\019\116\131\229\030\182\052\236\219\186\122\209\189\243\067\211\005\131\195\160\176\227\067" ..
		-- tex:"126a3eb939137483e51eb634ecdbba7a"; x:487.482971; y:-262.045532; z:455.379913
		"\144\083\045\159\090\037\147\096\108\011\235\019\247\138\094\243\209\189\243\067\233\130\001\196\160\176\227\067" ..
		-- tex:"90532d9f5a2593606c0beb13f78a5ef3"; x:487.482971; y:-518.045532; z:455.379913
		"\203\200\253\047\067\175\220\214\052\048\183\228\233\215\235\059\232\222\057\068\211\005\131\195\160\176\227\067" ..
		-- tex:"cbc8fd2f43afdcd63430b7e4e9d7eb3b"; x:743.482971; y:-262.045532; z:455.379913
		"\185\043\216\020\082\126\022\097\213\187\217\071\092\091\066\238\101\082\026\068\053\220\064\195\035\144\229\067",
		-- tex:"b92bd814527e1661d5bbd9475c5b42ee"; x:617.287476; y:-192.860199; z:459.126099
	["Library"] = 
		"\137\069\154\048\081\011\089\027\212\153\110\136\147\133\177\185\093\175\164\195\221\026\139\194\096\211\015\066" ..
		-- tex:"89459a30510b591bd4996e889385b1b9"; x:-329.370056; y:-69.552475; z:35.956425
		"\184\041\100\215\148\009\219\109\210\178\249\205\085\158\104\219\013\175\164\195\023\085\028\194\096\211\015\066" ..
		-- tex:"b82964d79409db6dd2b2f9cd559e68db"; x:-329.367615; y:-39.083099; z:35.956425
		"\131\027\188\072\201\055\087\214\115\010\093\215\202\140\046\023\208\031\188\194\122\145\231\067\076\169\019\066" ..
		-- tex:"831bbc48c93757d6730a5dd7ca8c2e17"; x:-94.062141; y:463.136566; z:36.915333
		"\023\016\017\130\055\249\006\021\179\044\224\044\114\178\213\150\019\218\146\195\007\163\167\194\142\173\019\066" ..
		-- tex:"1710118237f90615b32ce02c72b2d596"; x:-293.703735; y:-83.818420; z:36.919491
		"\062\013\231\132\146\083\185\006\012\024\029\216\101\017\148\212\157\231\154\195\114\080\140\067\192\235\019\066" ..
		-- tex:"3e0de7849253b9060c181dd8651194d4"; x:-309.809509; y:280.628510; z:36.980228
		"\180\192\244\150\217\145\204\110\142\136\155\051\087\063\198\080\157\231\154\195\112\098\240\067\192\235\019\066" ..
		-- tex:"b4c0f496d991cc6e8e889b33573fc650"; x:-309.809509; y:480.769073; z:36.980228
		"\133\200\150\141\197\173\233\224\179\243\255\081\108\114\170\045\236\255\229\194\083\151\110\067\013\003\020\066" ..
		-- tex:"85c8968dc5ade9e0b3f3ff516c72aa2d"; x:-114.999855; y:238.591125; z:37.002983
		"\116\125\113\203\091\040\086\119\140\009\083\119\150\042\177\090\029\120\017\195\187\052\121\067\013\003\020\066" ..
		-- tex:"747d71cb5b2856778c095377962ab15a"; x:-145.469208; y:249.205994; z:37.002983
		"\014\053\139\136\160\074\129\227\058\013\136\071\213\214\044\085\063\214\093\195\118\217\114\067\016\003\020\066" ..
		-- tex:"0e358b88a04a81e33a0d8847d5d62c55"; x:-221.836914; y:242.849472; z:37.002995
		"\209\033\085\133\013\110\149\092\108\085\227\219\089\034\183\109\179\240\047\195\187\052\121\067\017\003\020\066" ..
		-- tex:"d12155850d6e955c6c55e3db5922b76d"; x:-175.940247; y:249.205994; z:37.002998
		"\142\203\201\153\247\015\207\113\212\252\246\230\076\162\254\084\092\031\036\195\154\199\236\067\064\005\020\066" ..
		-- tex:"8ecbc999f70fcf71d4fcf6e64ca2fe54"; x:-164.122513; y:473.559418; z:37.005131
		"\142\231\054\055\214\131\203\193\160\139\033\172\135\025\151\236\196\033\158\195\038\195\170\066\255\005\020\066" ..
		-- tex:"8ee73637d683cbc1a08b21ac871997ec"; x:-316.263824; y:85.381157; z:37.005859
		"\040\179\019\196\236\233\086\155\040\248\073\203\013\166\088\078\046\237\137\195\001\119\183\066\000\006\020\066" ..
		-- tex:"28b313c4ece9569b28f849cb0da6584e"; x:-275.852997; y:91.732437; z:37.005863
		"\240\154\143\108\103\091\222\147\150\109\198\143\138\027\226\026\117\113\100\195\058\118\183\066\002\006\020\066" ..
		-- tex:"f09a8f6c675bde93966dc68f8a1be21a"; x:-228.443207; y:91.730919; z:37.005871
		"\167\100\234\097\088\084\183\060\081\079\159\129\152\052\218\146\211\061\125\195\175\140\187\066\004\006\020\066" ..
		-- tex:"a764ea615854b73c514f9f819834da92"; x:-253.241516; y:93.774780; z:37.005878
		"\249\150\137\159\127\093\137\070\010\191\184\061\189\082\106\180\197\245\033\195\017\189\247\066\099\038\020\066" ..
		-- tex:"f996899f7f5d89460abfb83dbd526ab4"; x:-161.960052; y:123.869278; z:37.037491
		"\224\048\090\062\201\233\055\071\237\146\162\013\247\220\146\080\042\136\061\194\062\236\021\067\102\038\020\066" ..
		-- tex:"e0305a3ec9e93747ed92a20df7dc9250"; x:-47.382977; y:149.922836; z:37.037502
		"\231\085\209\226\151\040\014\039\087\015\194\121\116\041\032\169\200\066\018\194\107\211\006\067\102\038\020\066" ..
		-- tex:"e755d1e297280e27570fc279742920a9"; x:-36.565220; y:134.825867; z:37.037502
		"\087\139\185\008\047\241\198\214\192\145\220\252\098\205\014\209\047\097\157\195\209\115\156\065\203\037\021\066" ..
		-- tex:"578bb9082ff1c6d6c091dcfc62cd0ed1"; x:-314.759277; y:19.556553; z:37.286911
		"\010\071\220\240\067\138\076\202\138\222\178\228\030\085\176\170\054\137\140\195\097\228\077\194\029\049\021\066" ..
		-- tex:"0a47dcf0438a4cca8adeb2e41e55b0aa"; x:-281.071991; y:-51.473030; z:37.297966
		"\042\046\238\009\233\047\149\036\245\230\054\013\092\143\188\179\019\004\147\195\096\243\090\066\072\050\021\066" ..
		-- tex:"2a2eee09e92f9524f5e6360d5c8fbcb3"; x:-294.031860; y:54.737675; z:37.299107
		"\239\095\021\238\199\171\019\051\093\173\142\214\246\103\214\015\205\176\075\195\127\126\092\067\160\095\025\066" ..
		-- tex:"ef5f15eec7ab13335dad8ed6f667d60f"; x:-203.690643; y:220.494141; z:38.343388
		"\107\112\194\244\084\089\208\055\139\102\052\081\060\169\236\031\095\251\157\195\074\009\205\067\176\096\032\066" ..
		-- tex:"6b70c2f45459d0378b6634513ca9ec1f"; x:-315.963867; y:410.072601; z:40.094425
		"\035\246\041\119\206\129\223\068\158\165\190\153\132\172\070\214\095\251\157\195\074\059\169\067\176\096\032\066" ..
		-- tex:"23f62977ce81df449ea5be9984ac46d6"; x:-315.963867; y:338.463226; z:40.094425
		"\076\085\128\073\094\191\140\252\062\039\012\231\078\041\207\060\096\050\146\195\104\250\124\067\074\102\032\066" ..
		-- tex:"4c5580495ebf8cfc3e270ce74e29cf3c"; x:-292.393585; y:252.978165; z:40.099895
		"\099\204\120\178\255\005\254\207\023\014\047\082\006\162\183\040\086\060\120\195\104\250\124\067\074\102\032\066",
		-- tex:"63cc78b2ff05fecf170e2f5206a2b728"; x:-248.235703; y:252.978165; z:40.099895
	["Magisters' Terrace"] = 
		"\030\036\135\017\196\177\025\081\114\106\030\204\214\119\111\212\005\066\214\195\121\011\242\066\183\124\051\194" ..
		-- tex:"1e248711c4b11951726a1eccd6776fd4"; x:-428.515808; y:121.022415; z:-44.871796
		"\059\023\170\224\147\225\099\092\075\014\182\129\227\192\181\035\005\066\214\195\066\250\006\195\183\124\051\194" ..
		-- tex:"3b17aae093e1635c4b0eb681e3c0b523"; x:-428.515808; y:-134.977585; z:-44.871796
		"\130\135\013\206\194\255\121\114\118\035\082\246\152\023\132\197\011\132\044\195\121\011\242\066\183\124\051\194" ..
		-- tex:"82870dcec2ff7972762352f6981784c5"; x:-172.515808; y:121.022415; z:-44.871796
		"\068\159\002\053\190\043\101\062\207\151\006\092\229\254\230\111\011\132\044\195\066\250\006\195\183\124\051\194" ..
		-- tex:"449f0235be2b653ecf97065ce5fee66f"; x:-172.515808; y:-134.977585; z:-44.871796
		"\003\058\151\105\074\120\086\037\034\178\052\239\071\121\072\161\145\087\139\195\085\231\041\195\214\167\050\194" ..
		-- tex:"033a97694a78562522b234ef477948a1"; x:-278.684143; y:-169.903656; z:-44.663906
		"\015\210\144\141\227\032\101\198\212\044\063\006\189\142\103\000\051\055\156\195\211\095\120\195\210\167\050\194" ..
		-- tex:"0fd2908de32065c6d42c3f06bd8e6700"; x:-312.431274; y:-248.374329; z:-44.663891
		"\211\139\116\248\046\219\216\000\190\135\026\098\136\107\143\228\037\085\178\195\169\197\023\067\168\068\046\194" ..
		-- tex:"d38b74f82edbd800be871a62886b8fe4"; x:-356.665222; y:151.772125; z:-43.567051
		"\123\155\167\131\034\181\104\237\222\150\122\147\196\162\094\004\238\073\212\195\168\027\195\067\053\136\044\194" ..
		-- tex:"7b9ba78322b568edde967a93c4a25e04"; x:-424.577606; y:390.216095; z:-43.133018
		"\006\026\129\159\086\074\097\090\025\142\079\097\135\187\074\147\231\253\140\195\028\210\169\067\221\204\043\194" ..
		-- tex:"061a819f564a615a198e4f6187bb4a93"; x:-281.983643; y:339.641510; z:-42.950066
		"\092\219\125\175\106\066\151\222\236\193\035\245\254\161\086\108\222\006\141\195\015\194\233\066\000\193\043\194" ..
		-- tex:"5cdb7daf6a4297deecc123f5fea1566c"; x:-282.053680; y:116.879028; z:-42.938480
		"\148\096\119\132\062\215\046\121\182\178\007\237\048\144\013\202\057\250\178\195\253\225\212\195\184\108\006\194" ..
		-- tex:"946077843ed72e79b6b207ed30900dca"; x:-357.954895; y:-425.765564; z:-33.606174
		"\237\206\215\013\202\136\190\121\159\022\096\227\028\142\161\040\032\037\211\195\096\143\232\067\205\130\155\193" ..
		-- tex:"edced70dca88be799f1660e31c8ea128"; x:-422.290070; y:465.120148; z:-19.438869
		"\090\239\245\171\038\061\196\246\191\027\032\002\233\174\065\012\233\160\253\195\106\029\219\067\240\052\155\193" ..
		-- tex:"5aeff5ab263dc4f6bf1b2002e9ae410c"; x:-507.257141; y:438.229813; z:-19.400850
		"\022\086\251\179\245\059\003\008\014\002\041\006\185\004\041\178\233\160\253\195\212\058\054\067\240\052\155\193" ..
		-- tex:"1656fbb3f53b03080e022906b90429b2"; x:-507.257141; y:182.229813; z:-19.400850
		"\077\089\055\251\223\252\228\179\016\176\213\034\172\006\093\232\066\036\244\195\252\092\236\067\121\166\081\193" ..
		-- tex:"4d5937fbdffce4b310b0d522ac065de8"; x:-488.283295; y:472.726471; z:-13.103144
		"\026\166\190\203\178\205\110\228\075\042\088\008\233\196\033\226\127\098\002\196\127\057\110\066\226\045\068\193" ..
		-- tex:"1aa6becbb2cd6ee44b2a5808e9c421e2"; x:-521.539063; y:59.556152; z:-12.261203
		"\064\142\210\217\056\093\147\000\101\112\092\229\131\219\209\088\054\126\255\194\215\108\048\194\068\007\238\192" ..
		-- tex:"408ed2d9385d930065705ce583dbd158"; x:-127.746513; y:-44.106293; z:-7.438387
		"\132\073\120\207\246\176\195\063\019\254\029\086\219\140\234\155\000\175\012\196\003\232\114\194\212\087\201\192" ..
		-- tex:"844978cff6b0c33f13fe1d56db8cea9b"; x:-562.734436; y:-60.726578; z:-6.291972
		"\201\046\089\167\185\069\011\210\237\099\048\231\235\033\037\008\251\062\215\195\067\232\050\194\083\017\194\192" ..
		-- tex:"c92e59a7b9450bd2ed6330e7eb212508"; x:-430.492065; y:-44.726822; z:-6.064615
		"\016\117\089\032\240\002\146\118\037\238\078\137\062\185\091\138\007\219\204\195\056\232\050\194\235\016\194\192" ..
		-- tex:"10755920f002927625ee4e893eb95b8a"; x:-409.711182; y:-44.726780; z:-6.064566
		"\116\235\150\107\123\203\200\038\206\084\149\198\140\094\181\021\036\060\165\195\246\134\045\067\215\091\158\066",
		-- tex:"74eb966b7bcbc826ce5495c68c5eb515"; x:-330.469879; y:173.527206; z:79.179382
	["Magtheridon's Lair"] = 
		"\216\235\035\037\181\191\004\236\140\224\123\160\021\140\054\043\108\018\012\067\131\192\055\195\022\147\145\191" ..
		-- tex:"d8eb2325b5bf04ec8ce07ba0158c362b"; x:140.071968; y:-183.752014; z:-1.137301
		"\084\190\234\226\079\061\174\172\141\103\090\199\181\114\141\127\038\219\231\194\247\126\144\066\022\147\145\191" ..
		-- tex:"54beeae24f3daeac8d675ac7b5728d7f"; x:-115.928032; y:72.247986; z:-1.137301
		"\057\074\180\065\110\026\094\167\227\145\125\134\146\112\115\035\038\219\231\194\131\192\055\195\022\147\145\191" ..
		-- tex:"394ab4416e1a5ea7e3917d8692707323"; x:-115.928032; y:-183.752014; z:-1.137301
		"\184\122\233\236\110\151\191\149\239\228\053\217\206\245\164\221\111\048\011\066\200\001\030\195\218\171\097\191" ..
		-- tex:"b87ae9ec6e97bf95efe435d9cef5a4dd"; x:34.797302; y:-158.006973; z:-0.881529
		"\205\188\061\010\037\088\143\202\074\098\026\018\171\076\077\255\171\158\004\067\095\042\097\194\142\171\097\191" ..
		-- tex:"cdbc3d0a25588fca4a621a12ab4c4dff"; x:132.619812; y:-56.291382; z:-0.881524
		"\107\071\249\004\105\130\105\001\086\160\123\159\193\130\146\024\109\048\011\066\044\118\029\066\232\163\097\191" ..
		-- tex:"6b47f9046982690156a07b9fc1829218"; x:34.797295; y:39.365406; z:-0.881407
		"\005\089\169\155\001\244\183\120\172\039\104\005\163\057\013\025\064\111\133\195\252\252\049\194\082\028\180\066" ..
		-- tex:"0559a99b01f4b778ac276805a3390d19"; x:-266.869171; y:-44.497059; z:90.055321
		"\222\213\056\206\209\248\002\122\072\035\066\076\115\124\230\244\079\208\236\195\170\067\106\195\194\229\006\067" ..
		-- tex:"ded538ced1f8027a4823424c737ce6f4"; x:-473.627441; y:-234.264328; z:134.897507
		"\093\236\235\193\105\000\012\230\193\202\213\183\017\002\089\099\079\208\236\195\167\226\173\065\194\229\006\067" ..
		-- tex:"5decebc169000ce6c1cad5b711025963"; x:-473.627441; y:21.735672; z:134.897507
		"\158\131\045\101\158\163\035\005\011\123\111\228\134\206\069\209\146\152\006\195\145\122\154\066\166\144\015\067" ..
		-- tex:"9e832d659ea323050b7b6fe486ce45d1"; x:-134.595993; y:77.239395; z:143.565048
		"\243\102\212\068\017\089\037\196\146\006\219\214\154\088\076\066\146\152\006\195\182\194\050\195\166\144\015\067" ..
		-- tex:"f366d444115925c49206dbd69a584c42"; x:-134.595993; y:-178.760605; z:143.565048
		"\042\230\218\233\019\044\154\251\184\136\027\027\247\164\034\003\217\206\242\066\182\194\050\195\166\144\015\067",
		-- tex:"2ae6dae9132c9afbb8881b1bf7a42203"; x:121.404007; y:-178.760605; z:143.565048
	["Mana-Tombs"] = 
		"\079\215\023\224\012\071\168\006\132\079\030\189\034\028\219\144\140\173\038\068\202\085\199\067\096\251\152\193" ..
		-- tex:"4fd717e00c47a806844f1ebd221cdb90"; x:666.711731; y:398.670258; z:-19.122744
		"\062\090\088\215\215\060\106\165\017\030\012\252\233\127\066\002\124\226\169\194\103\111\170\067\095\251\152\193" ..
		-- tex:"3e5a58d7d73c6aa5111e0cfce97f4202"; x:-84.942360; y:340.870361; z:-19.122742
		"\175\108\187\139\173\035\140\150\135\160\043\064\136\034\234\050\068\181\030\068\080\014\152\066\095\251\152\193" ..
		-- tex:"af6cbb8bad238c9687a02b408822ea32"; x:634.832336; y:76.027962; z:-19.122742
		"\202\114\105\011\171\245\243\042\144\192\233\188\151\028\060\084\062\181\030\068\134\164\128\067\095\251\152\193" ..
		-- tex:"ca72690babf5f32a90c0e9bc971c3c54"; x:634.831970; y:257.285370; z:-19.122742
		"\113\128\014\081\028\138\044\237\109\176\084\225\222\214\125\226\193\014\043\067\103\111\170\067\095\251\152\193" ..
		-- tex:"71800e511c8a2ced6db054e1ded67de2"; x:171.057640; y:340.870361; z:-19.122742
		"\119\123\115\140\152\151\238\249\011\200\134\228\140\073\167\096\088\140\178\067\160\202\143\067\105\052\029\193" ..
		-- tex:"777b738c9897eef90bc886e48c49a760"; x:357.096466; y:287.583038; z:-9.825296
		"\252\203\135\153\219\079\022\097\144\209\208\146\180\241\076\254\088\140\178\067\080\229\007\068\105\052\029\193" ..
		-- tex:"fccb8799db4f166190d1d092b4f14cfe"; x:357.096466; y:543.583038; z:-9.825296
		"\160\210\194\230\080\089\171\012\055\175\207\175\095\083\149\201\044\070\025\068\160\202\143\067\105\052\029\193" ..
		-- tex:"a0d2c2e65059ab0c37afcfaf5f5395c9"; x:613.096466; y:287.583038; z:-9.825296
		"\161\052\195\173\048\114\177\059\078\133\230\079\248\000\083\205\044\070\025\068\080\229\007\068\105\052\029\193" ..
		-- tex:"a134c3ad3072b13b4e85e64ff80053cd"; x:613.096466; y:543.583038; z:-9.825296
		"\021\120\244\098\184\099\129\070\080\253\178\096\085\138\014\197\236\050\120\065\157\068\081\066\014\092\171\192" ..
		-- tex:"1578f462b863814650fdb260558a0ec5"; x:15.512433; y:52.317009; z:-5.354988
		"\177\214\021\242\104\005\017\055\161\184\152\233\174\156\124\051\067\036\032\195\022\078\207\194\081\054\112\192" ..
		-- tex:"b1d615f268051137a1b898e9ae9c7c33"; x:-160.141663; y:-103.652519; z:-3.753315
		"\071\179\239\002\023\097\223\052\097\138\143\124\027\226\147\078\119\183\191\066\022\078\207\194\081\054\112\192" ..
		-- tex:"47b3ef021761df34618a8f7c1be2934e"; x:95.858337; y:-103.652519; z:-3.753315
		"\085\255\152\013\033\184\091\029\219\024\241\112\101\083\116\146\043\241\224\066\135\123\146\067\246\179\255\191" ..
		-- tex:"55ff980d21b85b1ddb18f17065537492"; x:112.471039; y:292.965088; z:-1.997680
		"\201\040\221\192\212\200\140\163\207\146\006\245\252\115\146\034\035\244\039\068\066\016\036\194\147\182\252\191" ..
		-- tex:"c928ddc0d4c88ca3cf9206f5fc739222"; x:671.814697; y:-41.015881; z:-1.974322
		"\120\208\196\047\152\153\224\124\045\130\010\024\240\215\030\160\209\211\052\068\180\105\089\067\063\146\252\191" ..
		-- tex:"78d0c42f9899e07c2d820a18f0d71ea0"; x:723.309692; y:217.412918; z:-1.973213
		"\111\110\254\055\069\162\078\074\054\098\056\079\137\221\118\249\116\069\156\067\208\245\211\067\042\165\251\191" ..
		-- tex:"6f6efe3745a24e4a3662384f89dd76f9"; x:312.542633; y:423.920441; z:-1.965978
		"\107\001\039\056\192\239\181\052\047\030\002\126\015\051\207\087\076\053\015\068\246\005\240\194\253\224\229\065" ..
		-- tex:"6b012738c0efb5342f1e027e0f33cf57"; x:572.832794; y:-120.011650; z:28.734859
		"\051\118\097\007\218\142\076\230\009\029\191\050\071\063\011\182\152\106\158\067\246\005\240\194\253\224\229\065" ..
		-- tex:"33766107da8e4ce6091dbf32473f0bb6"; x:316.832794; y:-120.011650; z:28.734859
		"\168\021\002\140\097\028\215\199\112\152\069\205\244\244\030\126\061\163\047\067\066\031\036\194\232\018\006\066",
		-- tex:"a815028c611cd7c7709845cdf4f41e7e"; x:175.637665; y:-41.030529; z:33.518467
	["Maraudon"] = 
		"\058\027\077\198\020\020\132\052\202\046\153\040\124\118\136\207\226\185\150\195\141\193\159\195\171\244\208\195" ..
		-- tex:"3a1b4dc614148434ca2e99287c7688cf"; x:-301.452240; y:-319.512146; z:-417.911499
		"\254\161\237\211\188\047\235\223\246\169\109\202\097\015\198\174\226\185\150\195\111\012\126\194\171\244\208\195" ..
		-- tex:"fea1edd3bc2febdff6a96dca610fc6ae"; x:-301.452240; y:-63.512146; z:-417.911499
		"\024\094\040\090\095\001\058\088\115\139\019\170\029\189\174\095\023\207\053\194\227\124\064\067\171\244\208\195" ..
		-- tex:"185e285a5f013a58738b13aa1dbdae5f"; x:-45.452240; y:192.487854; z:-417.911499
		"\240\093\237\156\086\203\220\012\006\040\058\022\244\189\012\231\023\207\053\194\113\062\224\067\171\244\208\195" ..
		-- tex:"f05ded9c56cbdc0c06283a16f4bd0ce7"; x:-45.452240; y:448.487854; z:-417.911499
		"\076\037\243\236\109\077\014\253\107\057\110\114\055\176\006\109\023\207\053\194\141\193\159\195\171\244\208\195" ..
		-- tex:"4c25f3ec6d4d0efd6b396e7237b0066d"; x:-45.452240; y:-319.512146; z:-417.911499
		"\065\104\043\012\185\073\069\021\242\216\018\074\142\041\215\143\226\185\150\195\227\124\064\067\171\244\208\195" ..
		-- tex:"41682b0cb9494515f2d8124a8e29d78f"; x:-301.452240; y:192.487854; z:-417.911499
		"\128\047\032\166\089\000\047\217\245\100\048\175\180\232\027\148\226\185\150\195\113\062\224\067\171\244\208\195" ..
		-- tex:"802f20a659002fd9f56430afb4e81b94"; x:-301.452240; y:448.487854; z:-417.911499
		"\187\156\040\108\101\204\114\125\255\080\073\199\016\041\037\218\023\207\053\194\056\031\048\068\171\244\208\195" ..
		-- tex:"bb9c286c65cc727dff5049c7102925da"; x:-45.452240; y:704.487854; z:-417.911499
		"\016\087\014\098\218\033\106\042\182\162\004\244\000\147\077\048\023\207\053\194\111\012\126\194\171\244\208\195" ..
		-- tex:"10570e62da216a2ab6a204f400934d30"; x:-45.452240; y:-63.512146; z:-417.911499
		"\133\017\240\187\046\181\225\008\237\205\136\026\106\037\016\181\215\128\007\194\154\203\093\068\246\040\208\195" ..
		-- tex:"8511f0bb2eb5e108edcd881a6a2510b5"; x:-33.875824; y:887.181335; z:-416.320038
		"\149\002\119\112\043\149\227\038\210\195\039\097\082\040\120\243\201\031\094\067\154\203\029\068\246\040\208\195" ..
		-- tex:"950277702b95e326d2c32761522878f3"; x:222.124176; y:631.181335; z:-416.320038
		"\160\151\201\000\058\191\012\242\130\115\172\075\127\040\002\158\215\128\007\194\154\203\029\068\246\040\208\195" ..
		-- tex:"a097c9003abf0cf28273ac4b7f28029e"; x:-33.875824; y:631.181335; z:-416.320038
		"\033\147\086\254\088\066\151\044\184\089\191\003\119\049\135\114\173\067\225\195\094\163\021\068\102\132\175\195" ..
		-- tex:"219356fe5842972cb859bf0377318772"; x:-450.528748; y:598.552673; z:-351.034393
		"\042\000\069\080\044\195\079\070\139\079\109\052\041\207\150\108\214\161\048\196\094\163\021\068\102\132\175\195" ..
		-- tex:"2a0045502cc34f468b4f6d3429cf966c"; x:-706.528748; y:598.552673; z:-351.034393
		"\037\123\200\096\243\072\194\089\066\145\221\053\036\059\067\133\144\079\197\195\243\247\016\068\049\161\174\195" ..
		-- tex:"257bc860f348c2594291dd35243b4385"; x:-394.621613; y:579.874268; z:-349.259338
		"\190\071\217\088\089\244\045\033\252\076\143\250\034\160\074\209\205\203\179\195\156\255\168\067\136\063\172\195" ..
		-- tex:"be47d95859f42d21fc4c8ffa22a04ad1"; x:-359.592224; y:337.996979; z:-344.496368
		"\213\227\142\128\030\038\086\146\019\043\217\239\074\073\010\222\144\079\197\195\025\161\216\067\176\228\171\195" ..
		-- tex:"d5e38e801e265692132bd9ef4a490ade"; x:-394.621613; y:433.258606; z:-343.786652
		"\003\008\046\222\002\110\163\216\229\129\190\206\041\029\008\254\043\055\005\067\248\025\233\067\078\115\170\195" ..
		-- tex:"03082ede026ea3d8e581bece291d08fe"; x:133.215515; y:466.202911; z:-340.900848
		"\156\200\106\126\083\169\170\193\023\115\078\214\176\226\185\023\224\153\137\195\248\055\151\067\147\224\169\195" ..
		-- tex:"9cc86a7e53a9aac117734ed6b0e2b917"; x:-275.202179; y:302.437286; z:-339.754517
		"\070\100\025\194\175\028\237\075\236\021\071\140\042\194\071\068\121\050\072\196\031\199\121\195\114\024\150\195" ..
		-- tex:"466419c2af1ced4bec15478c2ac24744"; x:-800.788696; y:-249.777832; z:-300.191010
		"\236\225\010\013\037\071\229\010\026\008\120\070\211\184\083\169\060\025\132\196\255\027\199\064\114\024\150\195" ..
		-- tex:"ece10a0d2547e50a1a087846d3b853a9"; x:-1056.788696; y:6.222168; z:-300.191010
		"\215\127\023\107\233\162\103\052\085\053\207\224\024\180\109\220\060\025\132\196\031\199\121\195\114\024\150\195" ..
		-- tex:"d77f176be9a267345535cfe018b46ddc"; x:-1056.788696; y:-249.777832; z:-300.191010
		"\052\147\252\227\215\202\251\026\121\249\075\059\131\030\050\249\121\050\008\196\031\199\121\195\114\024\150\195" ..
		-- tex:"3493fce3d7cafb1a79f94b3b831e32f9"; x:-544.788696; y:-249.777832; z:-300.191010
		"\111\114\252\019\136\102\152\135\037\047\135\223\038\005\064\214\121\050\008\196\255\027\199\064\114\024\150\195" ..
		-- tex:"6f72fc1388669887252f87df260540d6"; x:-544.788696; y:6.222168; z:-300.191010
		"\250\176\119\184\015\033\142\138\212\222\120\013\128\009\235\232\121\050\072\196\255\027\199\064\114\024\150\195" ..
		-- tex:"fab077b80f218e8ad4de780d8009ebe8"; x:-800.788696; y:6.222168; z:-300.191010
		"\043\009\051\172\246\020\114\047\089\149\079\229\116\029\072\217\073\155\079\196\012\174\018\196\067\202\131\195" ..
		-- tex:"2b0933acf614722f59954fe5741d48d9"; x:-830.426392; y:-586.719543; z:-263.580200
		"\187\196\250\033\003\252\097\128\011\044\003\144\178\079\071\059\073\155\079\196\025\092\165\195\067\202\131\195" ..
		-- tex:"bbc4fa2103fc61800b2c0390b24f473b"; x:-830.426392; y:-330.719543; z:-263.580200
		"\140\049\214\106\030\070\122\165\051\100\010\207\201\132\096\000\004\063\050\196\192\230\175\195\067\202\131\195" ..
		-- tex:"8c31d66a1e467aa533640acfc9846000"; x:-712.984680; y:-351.802765; z:-263.580200
		"\006\111\133\206\124\038\104\073\077\034\139\040\145\223\184\231\164\205\135\196\025\092\165\195\067\202\131\195" ..
		-- tex:"066f85ce7c2668494d228b2891dfb8e7"; x:-1086.426392; y:-330.719543; z:-263.580200
		"\225\030\053\115\200\053\087\246\196\132\110\148\203\102\111\185\164\205\135\196\012\174\018\196\067\202\131\195" ..
		-- tex:"e11e3573c83557f6c4846e94cb666fb9"; x:-1086.426392; y:-586.719543; z:-263.580200
		"\247\129\009\158\016\156\123\119\002\022\091\211\092\186\149\032\189\104\037\196\118\182\121\195\067\202\131\195" ..
		-- tex:"f781099e109c7b7702165bd35cba9520"; x:-661.636597; y:-249.712753; z:-263.580200
		"\009\148\008\227\001\119\213\089\098\255\240\047\001\114\070\171\051\136\244\195\067\097\218\067\231\194\131\195" ..
		-- tex:"099408e30177d55962fff02f017246ab"; x:-489.064087; y:436.759872; z:-263.522705
		"\028\001\039\075\074\024\028\217\209\027\218\006\234\091\049\165\025\068\058\196\067\097\218\067\231\194\131\195" ..
		-- tex:"1c01274b4a181cd9d11bda06ea5b31a5"; x:-745.064087; y:436.759872; z:-263.522705
		"\076\127\012\153\202\126\224\193\189\116\237\226\124\164\013\088\025\068\058\196\134\194\052\067\231\194\131\195" ..
		-- tex:"4c7f0c99ca7ee0c1bd74ede27ca40d58"; x:-745.064087; y:180.759872; z:-263.522705
		"\069\070\024\224\038\092\163\110\016\148\233\181\035\124\066\078\051\136\244\195\134\194\052\067\231\194\131\195" ..
		-- tex:"454618e0265ca36e1094e9b5237c424e"; x:-489.064087; y:180.759872; z:-263.522705
		"\227\117\073\005\142\036\162\105\222\141\042\012\230\059\097\182\141\048\240\195\199\162\001\067\055\166\129\195" ..
		-- tex:"e37549058e24a269de8d2a0ce63b61b6"; x:-480.379333; y:129.635864; z:-259.298584
		"\139\058\125\197\001\064\125\104\113\166\195\146\104\186\215\064\022\044\008\196\075\127\031\067\054\166\129\195" ..
		-- tex:"8b3a7dc501407d6871a6c39268bad740"; x:-544.688904; y:159.497253; z:-259.298553
		"\008\073\169\167\185\186\156\056\121\113\244\128\143\004\174\255\079\136\051\196\049\221\246\067\005\046\112\195" ..
		-- tex:"0849a9a7b9ba9c387971f4808f04aeff"; x:-718.129883; y:493.728088; z:-240.179779
		"\019\129\186\219\003\135\136\065\022\210\017\164\020\236\147\234\002\044\175\195\176\171\203\067\209\194\089\195" ..
		-- tex:"1381badb0387884116d211a414ec93ea"; x:-350.343842; y:407.341339; z:-217.761017
		"\086\245\144\140\085\100\116\187\095\145\050\149\070\178\021\147\195\036\133\196\222\093\147\195\102\174\064\195" ..
		-- tex:"56f5908c556474bb5f91329546b21593"; x:-1065.148926; y:-294.733368; z:-192.681259
		"\216\020\238\153\028\137\109\152\230\148\221\129\251\137\140\028\195\036\165\196\247\238\026\194\102\174\064\195" ..
		-- tex:"d814ee991c896d98e694dd81fb898c1c"; x:-1321.148926; y:-38.733368; z:-192.681259
		"\199\234\169\248\167\046\147\161\232\220\173\209\030\071\149\014\195\036\165\196\222\093\147\195\102\174\064\195" ..
		-- tex:"c7eaa9f8a72e93a1e8dcadd11e47950e"; x:-1321.148926; y:-294.733368; z:-192.681259
		"\167\159\136\176\255\141\200\212\141\204\077\037\058\069\157\025\195\036\133\196\247\238\026\194\102\174\064\195" ..
		-- tex:"a79f88b0ff8dc8d48dcc4d253a459d19"; x:-1065.148926; y:-38.733368; z:-192.681259
		"\200\215\186\173\156\167\002\193\128\064\019\081\216\176\081\087\111\066\133\196\152\166\156\195\235\128\060\195" ..
		-- tex:"c8d7baad9ca702c180401351d8b05157"; x:-1066.076172; y:-313.301544; z:-188.503601
		"\020\020\120\143\010\021\099\187\085\094\251\184\243\175\228\118\111\066\133\196\060\196\205\195\118\039\060\195" ..
		-- tex:"1414788f0a1563bb555efbb8f3afe476"; x:-1066.076172; y:-411.533112; z:-188.154160
		"\187\007\171\041\069\174\181\077\159\019\051\225\134\010\207\155\205\146\214\196\223\148\018\193\024\093\050\195" ..
		-- tex:"bb07ab2945aeb54d9f1333e1860acf9b"; x:-1716.587646; y:-9.161346; z:-178.363663
		"\225\014\227\231\087\175\092\252\215\165\176\061\204\190\130\184\205\146\214\196\166\148\132\195\024\093\050\195" ..
		-- tex:"e10ee3e757af5cfcd7a5b03dccbe82b8"; x:-1716.587646; y:-265.161346; z:-178.363663
		"\228\081\155\067\041\074\054\238\056\086\191\049\054\185\043\088\205\146\182\196\166\148\132\195\024\093\050\195" ..
		-- tex:"e4519b43294a36ee3856bf3136b92b58"; x:-1460.587646; y:-265.161346; z:-178.363663
		"\134\017\091\078\215\076\085\057\206\019\197\050\189\036\233\106\100\168\234\196\099\188\004\064\166\207\049\195" ..
		-- tex:"86115b4ed74c5539ce13c532bd24e96a"; x:-1877.262329; y:2.073998; z:-177.811142
		"\138\231\109\126\057\191\014\006\139\064\086\199\159\070\240\153\100\168\234\196\120\009\129\067\166\207\049\195" ..
		-- tex:"8ae76d7e39bf0e068b4056c79f46f099"; x:-1877.262329; y:258.073998; z:-177.811142
		"\172\092\163\211\041\172\229\120\015\162\095\143\198\049\051\236\100\168\234\196\188\132\000\068\166\207\049\195" ..
		-- tex:"ac5ca3d329ace5780fa25f8fc63133ec"; x:-1877.262329; y:514.073998; z:-177.811142
		"\229\197\079\149\000\163\142\081\191\152\000\241\173\010\097\124\100\168\202\196\099\188\004\064\166\207\049\195" ..
		-- tex:"e5c54f9500a38e51bf9800f1ad0a617c"; x:-1621.262329; y:2.073998; z:-177.811142
		"\209\080\047\020\175\166\048\094\229\235\225\252\043\199\122\114\100\168\202\196\188\132\000\068\166\207\049\195" ..
		-- tex:"d1502f14afa6305ee5ebe1fc2bc77a72"; x:-1621.262329; y:514.073998; z:-177.811142
		"\004\201\166\135\209\189\118\169\247\181\233\027\001\112\124\014\100\168\202\196\120\009\129\067\166\207\049\195" ..
		-- tex:"04c9a687d1bd76a9f7b5e91b01707c0e"; x:-1621.262329; y:258.073998; z:-177.811142
		"\144\250\019\162\038\064\010\066\013\211\121\090\087\091\055\186\220\027\018\197\177\076\169\067\140\227\032\195" ..
		-- tex:"90fa13a226400a420dd3795a575b37ba"; x:-2337.741455; y:338.599182; z:-160.888870
		"\226\074\118\233\242\101\204\130\066\220\183\031\229\197\108\105\220\027\002\197\177\076\169\067\140\227\032\195" ..
		-- tex:"e24a76e9f265cc8242dcb71fe5c56c69"; x:-2081.741455; y:338.599182; z:-160.888870
		"\193\071\070\253\030\231\022\145\248\042\191\232\122\048\126\107\220\027\018\197\088\166\020\068\140\227\032\195" ..
		-- tex:"c14746fd1ee71691f82abfe87a307e6b"; x:-2337.741455; y:594.599182; z:-160.888870
		"\093\143\044\167\102\114\220\034\133\235\149\055\187\029\046\124\066\200\006\197\033\174\012\068\082\133\018\195" ..
		-- tex:"5d8f2ca76672dc2285eb9537bb1d2e7c"; x:-2156.516357; y:562.720825; z:-146.520798
		"\062\098\222\240\138\224\139\114\137\214\195\042\195\103\110\202\043\003\255\196\250\254\021\068\116\136\016\195" ..
		-- tex:"3e62def08ae08b7289d6c32ac3676eca"; x:-2040.099121; y:599.984070; z:-144.533035
		"\162\167\187\012\028\202\211\002\241\211\222\203\206\194\231\048\038\061\245\196\192\212\037\067\158\085\008\195" ..
		-- tex:"a2a7bb0c1ccad302f1d3decbcec2e730"; x:-1961.911011; y:165.831070; z:-136.334457
		"\008\224\088\227\020\041\023\144\193\247\192\069\209\048\155\255\240\116\156\196\080\249\133\067\009\034\002\195" ..
		-- tex:"08e058e314291790c1f7c045d1309bff"; x:-1251.654419; y:267.947784; z:-130.132965
		"\164\035\201\114\253\078\081\084\177\197\139\138\138\078\137\137\240\116\188\196\080\249\133\067\009\034\002\195" ..
		-- tex:"a423c972fd4e5154b1c58b8a8a4e8989"; x:-1507.654419; y:267.947784; z:-130.132965
		"\067\178\100\215\082\155\031\051\183\137\075\009\244\248\102\179\240\116\188\196\168\252\002\068\009\034\002\195" ..
		-- tex:"43b264d7529b1f33b7894b09f4f866b3"; x:-1507.654419; y:523.947784; z:-130.132965
		"\120\203\141\039\204\158\019\207\233\047\026\145\028\035\233\093\240\116\156\196\168\252\002\068\009\034\002\195" ..
		-- tex:"78cb8d27cc9e13cfe92f1a911c23e95d"; x:-1251.654419; y:523.947784; z:-130.132965
		"\013\041\056\206\069\068\196\146\084\129\115\141\088\203\012\102\036\014\225\196\155\165\092\068\177\231\000\195" ..
		-- tex:"0d2938ce4544c4925481738d58cb0c66"; x:-1800.442017; y:882.587646; z:-128.905060
		"\102\199\068\081\095\116\082\166\187\211\248\208\122\237\164\085\036\014\225\196\155\165\028\068\177\231\000\195" ..
		-- tex:"66c744515f7452a6bbd3f8d07aeda455"; x:-1800.442017; y:626.587646; z:-128.905060
		"\068\042\046\046\083\124\156\118\221\166\213\010\037\169\193\120\036\014\193\196\155\165\028\068\177\231\000\195" ..
		-- tex:"442a2e2e537c9c76dda6d50a25a9c178"; x:-1544.442017; y:626.587646; z:-128.905060
		"\148\138\084\050\172\040\211\049\120\176\183\096\225\232\049\178\234\115\219\196\186\065\152\193\254\140\253\194" ..
		-- tex:"948a5432ac28d33178b0b760e1e831b2"; x:-1755.622437; y:-19.032095; z:-126.775383
		"\032\095\187\155\120\218\250\145\061\156\221\180\082\072\087\188\234\115\251\196\186\065\152\193\254\140\253\194" ..
		-- tex:"205fbb9b78dafa913d9cddb4524857bc"; x:-2011.622437; y:-19.032095; z:-126.775383
		"\249\222\204\115\211\092\251\223\079\009\207\022\029\073\093\208\123\118\175\196\120\232\019\067\156\229\230\194" ..
		-- tex:"f9decc73d35cfbdf4f09cf161d495dd0"; x:-1403.702637; y:147.908096; z:-115.448463
		"\147\015\254\035\201\175\152\171\039\255\146\082\067\008\251\095\145\036\217\196\149\143\081\068\186\025\226\194" ..
		-- tex:"930ffe23c9af98ab27ff92524308fb5f"; x:-1737.142822; y:838.243530; z:-113.050255
		"\005\110\191\232\164\162\218\168\059\252\055\097\199\064\125\040\076\235\219\196\016\216\188\068\096\141\225\194" ..
		-- tex:"056ebfe8a4a2daa83bfc3761c7407d28"; x:-1759.353149; y:1510.752075; z:-112.776131
		"\012\090\002\028\031\083\203\160\207\088\061\035\026\009\107\208\076\235\219\196\016\216\156\068\096\141\225\194" ..
		-- tex:"0c5a021c1f53cba0cf583d231a096bd0"; x:-1759.353149; y:1254.752075; z:-112.776131
		"\219\084\248\120\114\050\104\097\166\205\180\255\189\113\205\181\076\235\187\196\016\216\188\068\096\141\225\194" ..
		-- tex:"db54f87872326861a6cdb4ffbd71cdb5"; x:-1503.353149; y:1510.752075; z:-112.776131
		"\057\175\142\086\163\028\226\241\212\013\106\058\049\196\068\248\076\235\187\196\016\216\156\068\096\141\225\194" ..
		-- tex:"39af8e56a31ce2f1d40d6a3a31c444f8"; x:-1503.353149; y:1254.752075; z:-112.776131
		"\055\096\224\181\220\062\238\084\228\152\089\104\036\254\119\090\020\187\206\196\086\016\078\068\186\126\222\194" ..
		-- tex:"3760e0b5dc3eee54e498596824fe775a"; x:-1653.846313; y:824.255310; z:-111.247520
		"\133\121\114\223\100\062\190\063\249\239\139\007\170\091\030\178\020\187\206\196\043\008\135\068\186\126\222\194" ..
		-- tex:"857972df643ebe3ff9ef8b07aa5b1eb2"; x:-1653.846313; y:1080.255310; z:-111.247520
		"\238\058\021\029\144\119\215\246\134\137\231\099\007\223\144\159\020\187\174\196\086\016\078\068\186\126\222\194" ..
		-- tex:"ee3a151d9077d7f68689e76307df909f"; x:-1397.846313; y:824.255310; z:-111.247520
		"\109\247\073\072\080\026\062\230\207\179\225\163\163\143\023\047\196\194\221\196\097\192\203\067\183\057\218\194" ..
		-- tex:"6df74948501a3ee6cfb3e1a3a38f172f"; x:-1774.086548; y:407.502991; z:-109.112732
		"\173\011\111\166\240\148\081\233\069\236\215\208\217\049\115\194\196\194\253\196\097\192\203\067\183\057\218\194" ..
		-- tex:"ad0b6fa6f09451e945ecd7d0d93173c2"; x:-2030.086548; y:407.502991; z:-109.112732
		"\026\176\037\124\030\202\004\022\182\186\153\130\156\086\155\181\196\194\253\196\048\224\037\068\183\057\218\194" ..
		-- tex:"1ab0257c1eca0416b6ba99829c569bb5"; x:-2030.086548; y:663.502991; z:-109.112732
		"\067\161\085\253\114\101\116\050\066\015\051\002\160\097\217\137\189\168\226\196\231\018\069\068\062\143\213\194" ..
		-- tex:"43a155fd72657432420f3302a061d989"; x:-1813.273193; y:788.295410; z:-106.779778
		"\148\137\000\206\040\167\127\160\048\141\058\159\129\100\043\038\212\153\152\196\067\221\018\068\112\252\211\194" ..
		-- tex:"948900ce28a77fa0308d3a9f81642b26"; x:-1220.807251; y:587.457275; z:-105.993050
		"\083\215\213\089\203\180\139\120\213\024\145\093\180\176\229\045\212\153\184\196\067\221\018\068\112\252\211\194" ..
		-- tex:"53d7d559cbb48b78d518915db4b0e52d"; x:-1476.807251; y:587.457275; z:-105.993050
		"\183\153\114\010\203\150\031\110\111\087\058\023\097\123\178\157\054\024\252\196\192\047\085\068\174\068\205\194" ..
		-- tex:"b799720acb961f6e6f573a17617bb29d"; x:-2016.756714; y:852.746155; z:-102.634148
		"\247\128\237\033\081\223\096\250\212\239\036\225\180\166\082\025\096\004\009\197\175\031\080\068\252\184\175\194" ..
		-- tex:"f780ed2151df60fad4ef24e1b4a65219"; x:-2192.273682; y:832.495117; z:-87.861305
		"\241\252\005\166\247\017\139\025\126\049\230\236\124\150\183\100\183\096\000\197\127\126\039\068\195\246\173\194" ..
		-- tex:"f1fc05a6f7118b197e31e6ec7c96b764"; x:-2054.044922; y:669.976563; z:-86.981964
		"\124\220\220\140\014\251\012\150\158\165\040\116\104\040\214\245\176\191\004\197\048\071\027\068\158\192\164\194" ..
		-- tex:"7cdcdc8c0efb0c969ea528746828d6f5"; x:-2123.980713; y:621.112366; z:-82.376213
		"\085\115\204\171\114\028\134\227\202\036\048\101\138\253\213\191\200\209\008\197\014\204\050\068\111\087\150\194" ..
		-- tex:"5573ccab721c86e3ca2430658afdd5bf"; x:-2189.111572; y:715.188416; z:-75.170776
		"\186\247\113\218\008\031\116\225\111\076\133\084\004\203\005\087\163\198\205\196\034\227\145\068\049\032\133\194" ..
		-- tex:"baf771da081f74e16f4c855404cb0557"; x:-1646.207520; y:1167.098022; z:-66.562881
		"\216\176\103\172\147\162\052\224\131\176\083\224\069\102\090\250\163\198\205\196\173\030\137\068\056\252\132\194",
		-- tex:"d8b067ac93a234e083b053e045665afa"; x:-1646.207520; y:1096.958740; z:-66.492622
	["Molten Core"] = 
		"\132\123\253\063\204\078\156\146\149\143\200\190\007\214\084\175\212\169\204\196\166\014\200\068\176\133\233\195" ..
		-- tex:"847bfd3fcc4e9c92958fc8be07d654af"; x:-1637.307251; y:1600.457886; z:-467.044464
		"\019\221\251\107\182\016\076\071\096\111\063\172\220\076\190\005\212\169\236\196\166\014\232\068\176\133\233\195" ..
		-- tex:"13ddfb6bb6104c47606f3facdc4cbe05"; x:-1893.307251; y:1856.457886; z:-467.044464
		"\025\101\236\176\002\037\189\181\019\002\140\188\058\106\091\038\212\169\236\196\166\014\168\068\176\133\233\195" ..
		-- tex:"1965ecb00225bdb513028cbc3a6a5b26"; x:-1893.307251; y:1344.457886; z:-467.044464
		"\012\081\132\107\084\247\190\246\246\137\223\082\118\223\195\107\212\169\204\196\166\014\168\068\176\133\233\195" ..
		-- tex:"0c51846b54f7bef6f689df5276dfc36b"; x:-1637.307251; y:1344.457886; z:-467.044464
		"\069\103\046\230\253\081\080\238\103\149\158\152\082\189\015\158\212\169\236\196\166\014\200\068\176\133\233\195" ..
		-- tex:"45672ee6fd5150ee67959e9852bd0f9e"; x:-1893.307251; y:1600.457886; z:-467.044464
		"\046\148\108\148\244\131\130\136\163\091\088\149\175\187\119\127\212\169\204\196\166\014\232\068\176\133\233\195" ..
		-- tex:"2e946c94f4838288a35b5895afbb777f"; x:-1637.307251; y:1856.457886; z:-467.044464
		"\121\217\164\094\090\080\186\004\056\067\246\195\068\010\052\067\127\069\245\196\002\151\153\068\000\228\230\195" ..
		-- tex:"79d9a45e5a50ba043843f6c3440a3443"; x:-1962.171875; y:1228.719116; z:-461.781281
		"\076\223\234\208\230\015\041\220\099\224\145\207\142\244\236\061\127\069\245\196\005\046\115\068\000\228\230\195" ..
		-- tex:"4cdfead0e60f29dc63e091cf8ef4ec3d"; x:-1962.171875; y:972.719116; z:-461.781281
		"\115\170\176\022\220\013\051\193\218\143\212\141\222\222\008\035\127\069\213\196\002\151\153\068\000\228\230\195" ..
		-- tex:"73aab016dc0d33c1da8fd48ddede0823"; x:-1706.171875; y:1228.719116; z:-461.781281
		"\135\000\217\133\155\116\085\014\229\108\191\004\040\038\209\083\127\069\245\196\002\151\185\068\000\228\230\195" ..
		-- tex:"8700d9859b74550ee56cbf042826d153"; x:-1962.171875; y:1484.719116; z:-461.781281
		"\162\229\219\124\042\097\129\006\176\203\198\210\000\253\022\128\127\069\213\196\005\046\115\068\000\228\230\195" ..
		-- tex:"a2e5db7c2a618106b0cbc6d200fd1680"; x:-1706.171875; y:972.719116; z:-461.781281
		"\161\189\250\056\071\250\048\041\191\100\139\096\096\080\090\016\191\162\010\197\002\151\185\068\000\228\230\195" ..
		-- tex:"a1bdfa3847fa3029bf648b6060505a10"; x:-2218.171875; y:1484.719116; z:-461.781281
		"\058\162\051\111\207\178\061\099\142\217\226\114\248\022\038\083\191\162\026\197\002\151\185\068\000\228\230\195" ..
		-- tex:"3aa2336fcfb23d638ed9e272f8162653"; x:-2474.171875; y:1484.719116; z:-461.781281
		"\082\047\201\074\065\100\176\166\189\178\183\188\192\052\218\033\191\162\010\197\005\046\115\068\000\228\230\195" ..
		-- tex:"522fc94a4164b0a6bdb2b7bcc034da21"; x:-2218.171875; y:972.719116; z:-461.781281
		"\124\187\166\025\254\172\078\041\124\254\032\222\012\164\003\042\191\162\010\197\002\151\153\068\000\228\230\195" ..
		-- tex:"7cbba619feac4e297cfe20de0ca4032a"; x:-2218.171875; y:1228.719116; z:-461.781281
		"\060\121\002\249\200\080\097\156\040\223\175\225\034\188\025\179\191\162\026\197\002\151\153\068\000\228\230\195" ..
		-- tex:"3c7902f9c850619c28dfafe122bc19b3"; x:-2474.171875; y:1228.719116; z:-461.781281
		"\088\014\161\185\110\011\197\211\066\081\057\038\097\046\060\031\191\162\026\197\005\046\115\068\000\228\230\195" ..
		-- tex:"580ea1b96e0bc5d342513926612e3c1f"; x:-2474.171875; y:972.719116; z:-461.781281
		"\161\088\085\241\084\073\038\004\023\165\083\139\029\171\215\126\003\045\230\196\071\005\016\069\109\088\225\195" ..
		-- tex:"a15855f15449260417a5538b1dabd77e"; x:-1841.406738; y:2304.329956; z:-450.690857
		"\137\242\231\053\024\058\241\032\101\108\130\009\073\012\138\226\003\045\198\196\142\010\224\068\109\088\225\195" ..
		-- tex:"89f2e735183af120656c8209490c8ae2"; x:-1585.406738; y:1792.329956; z:-450.690857
		"\025\060\254\106\086\119\238\202\065\103\094\013\241\001\147\254\003\045\230\196\142\010\224\068\109\088\225\195" ..
		-- tex:"193cfe6a5677eeca41675e0df10193fe"; x:-1841.406738; y:1792.329956; z:-450.690857
		"\232\083\132\004\243\234\070\111\112\073\255\163\199\137\040\057\003\045\198\196\071\005\000\069\109\088\225\195" ..
		-- tex:"e8538404f3ea466f7049ffa3c7892839"; x:-1585.406738; y:2048.329956; z:-450.690857
		"\210\089\088\135\175\150\060\091\247\227\070\100\176\164\046\149\003\045\166\196\142\010\224\068\109\088\225\195" ..
		-- tex:"d2595887af963c5bf7e34664b0a42e95"; x:-1329.406738; y:1792.329956; z:-450.690857
		"\141\101\189\082\036\241\001\196\050\227\213\128\159\231\122\139\003\045\198\196\071\005\016\069\109\088\225\195" ..
		-- tex:"8d65bd5224f101c432e3d5809fe77a8b"; x:-1585.406738; y:2304.329956; z:-450.690857
		"\106\134\094\222\105\060\126\224\127\193\049\052\052\039\209\190\003\045\134\196\071\005\000\069\109\088\225\195" ..
		-- tex:"6a865ede693c7ee07fc131343427d1be"; x:-1073.406738; y:2048.329956; z:-450.690857
		"\188\131\017\226\012\022\059\182\087\147\236\020\027\027\111\108\003\045\230\196\071\005\000\069\109\088\225\195" ..
		-- tex:"bc8311e20c163bb65793ec141b1b6f6c"; x:-1841.406738; y:2048.329956; z:-450.690857
		"\142\215\165\125\102\095\030\189\216\153\150\059\048\054\075\100\003\045\166\196\071\005\016\069\109\088\225\195" ..
		-- tex:"8ed7a57d665f1ebdd899963b30364b64"; x:-1329.406738; y:2304.329956; z:-450.690857
		"\198\052\240\031\062\163\179\110\100\083\115\228\179\133\184\206\003\045\166\196\071\005\000\069\109\088\225\195" ..
		-- tex:"c634f01f3ea3b36e645373e4b385b8ce"; x:-1329.406738; y:2048.329956; z:-450.690857
		"\006\218\152\175\247\154\092\085\066\056\083\193\105\084\176\215\224\019\185\196\006\191\214\068\244\044\219\195" ..
		-- tex:"06da98aff79a5c55423853c16954b0d7"; x:-1480.621216; y:1717.969604; z:-438.351227
		"\234\134\217\015\207\102\246\025\210\217\197\079\070\098\179\227\224\019\185\196\006\191\150\068\244\044\219\195" ..
		-- tex:"ea86d90fcf66f619d2d9c54f4662b3e3"; x:-1480.621216; y:1205.969604; z:-438.351227
		"\142\156\009\197\180\098\147\144\026\198\023\142\065\015\228\235\224\019\153\196\006\191\150\068\244\044\219\195" ..
		-- tex:"8e9c09c5b46293901ac6178e410fe4eb"; x:-1224.621216; y:1205.969604; z:-438.351227
		"\001\029\065\152\130\253\133\151\104\178\217\156\075\109\029\129\224\019\153\196\006\191\214\068\244\044\219\195" ..
		-- tex:"011d419882fd859768b2d99c4b6d1d81"; x:-1224.621216; y:1717.969604; z:-438.351227
		"\039\116\006\105\081\182\227\056\239\182\044\067\248\084\110\127\224\019\153\196\006\191\182\068\244\044\219\195" ..
		-- tex:"2774066951b6e338efb62c43f8546e7f"; x:-1224.621216; y:1461.969604; z:-438.351227
		"\239\200\023\148\125\127\137\226\207\003\027\130\202\151\076\135\224\019\185\196\006\191\182\068\244\044\219\195" ..
		-- tex:"efc817947d7f89e2cf031b82ca974c87"; x:-1480.621216; y:1461.969604; z:-438.351227
		"\146\150\169\086\102\245\229\162\184\164\208\235\024\068\049\108\079\009\170\196\120\026\100\068\090\041\218\195" ..
		-- tex:"9296a95666f5e5a2b8a4d0eb1844316c"; x:-1360.291016; y:912.413635; z:-436.323090
		"\013\134\008\160\145\225\088\184\178\170\062\050\048\236\239\047\079\009\202\196\060\013\146\068\090\041\218\195" ..
		-- tex:"0d8608a091e158b8b2aa3e3230ecef2f"; x:-1616.291016; y:1168.413635; z:-436.323090
		"\037\182\220\102\015\140\205\210\203\017\145\125\047\016\055\250\079\009\202\196\120\026\100\068\090\041\218\195" ..
		-- tex:"25b6dc660f8ccdd2cb11917d2f1037fa"; x:-1616.291016; y:912.413635; z:-436.323090
		"\178\190\113\121\202\003\007\199\046\170\020\187\235\194\091\230\098\040\181\196\033\114\149\068\123\028\210\195" ..
		-- tex:"b2be7179ca0307c72eaa14bbebc25be6"; x:-1449.262085; y:1195.566650; z:-420.222534
		"\053\216\126\149\031\251\207\019\235\202\213\212\140\199\131\212\000\149\017\197\044\204\000\069\059\121\192\195" ..
		-- tex:"35d87e951ffbcf13ebcad5d48cc783d4"; x:-2329.312744; y:2060.760864; z:-384.947144
		"\055\201\100\007\228\209\137\183\117\102\174\209\049\037\006\249\000\149\017\197\088\152\225\068\059\121\192\195" ..
		-- tex:"37c96407e4d189b77566aed1312506f9"; x:-2329.312744; y:1804.760864; z:-384.947144
		"\214\176\052\164\230\117\228\023\081\150\023\215\123\086\041\137\001\042\227\196\088\152\225\068\059\121\192\195" ..
		-- tex:"d6b034a4e675e417519617d77b562989"; x:-1817.312744; y:1804.760864; z:-384.947144
		"\212\018\242\098\065\103\191\021\075\197\151\018\081\209\020\138\000\149\001\197\088\152\225\068\059\121\192\195" ..
		-- tex:"d412f2624167bf154bc5971251d1148a"; x:-2073.312744; y:1804.760864; z:-384.947144
		"\228\126\158\182\039\174\008\222\005\055\008\162\093\142\209\141\176\253\006\197\245\198\217\068\163\043\179\195" ..
		-- tex:"e47e9eb627ae08de053708a25d8ed18d"; x:-2159.855713; y:1742.217529; z:-358.340942
		"\109\065\179\100\110\200\217\218\035\126\255\223\137\085\089\076\097\251\237\196\245\198\217\068\163\043\179\195" ..
		-- tex:"6d41b3646ec8d9da237effdf8955594c"; x:-1903.855713; y:1742.217529; z:-358.340942
		"\198\162\076\017\227\009\219\126\150\082\135\235\211\053\105\056\090\167\005\197\157\246\208\068\009\045\167\195" ..
		-- tex:"c6a24c11e309db7e965287ebd3356938"; x:-2138.459717; y:1671.706787; z:-334.351868
		"\120\155\078\096\178\149\138\115\061\132\205\123\149\105\076\162\195\161\038\197\068\213\131\068\017\198\122\195" ..
		-- tex:"789b4e60b2958a733d84cd7b95694ca2"; x:-2666.110352; y:1054.664612; z:-250.773712
		"\202\116\190\086\113\179\186\056\195\126\120\226\031\013\080\000\195\161\038\197\136\170\071\068\017\198\122\195" ..
		-- tex:"ca74be5671b3ba38c37e78e21f0d5000"; x:-2666.110352; y:798.664612; z:-250.773712
		"\086\101\119\251\118\200\092\200\000\236\053\032\153\134\233\232\195\161\022\197\136\170\007\068\017\198\122\195" ..
		-- tex:"566577fb76c85cc800ec35209986e9e8"; x:-2410.110352; y:542.664612; z:-250.773712
		"\230\129\053\118\236\192\225\093\184\102\134\077\137\189\114\202\195\161\022\197\136\170\071\068\017\198\122\195" ..
		-- tex:"e6813576ecc0e15db866864d89bd72ca"; x:-2410.110352; y:798.664612; z:-250.773712
		"\048\177\237\118\092\104\215\206\024\061\063\153\130\237\065\232\195\161\038\197\136\170\007\068\017\198\122\195" ..
		-- tex:"30b1ed765c68d7ce183d3f9982ed41e8"; x:-2666.110352; y:542.664612; z:-250.773712
		"\040\079\225\104\048\003\007\198\100\097\218\082\129\100\046\203\245\006\012\197\066\059\098\068\190\149\089\195" ..
		-- tex:"284fe168300307c66461da5281642ecb"; x:-2240.435059; y:904.925964; z:-217.584946
		"\241\214\048\251\217\205\243\027\148\236\232\027\228\248\163\173\024\167\032\197\188\003\017\068\126\126\028\195",
		-- tex:"f1d630fbd9cdf31b94ece81be4f8a3ad"; x:-2570.443604; y:580.058411; z:-156.494125
	["Naxxramas"] = 
		"\044\191\245\055\235\215\143\040\130\005\036\022\141\143\118\053\000\074\139\196\207\085\131\068\241\112\125\195" ..
		-- tex:"2cbff537ebd78f28820524168d8f7635"; x:-1114.312622; y:1050.681641; z:-253.441193
		"\215\172\112\099\064\050\251\057\120\139\068\085\009\108\046\028\001\148\086\196\207\085\131\068\241\112\125\195" ..
		-- tex:"d7ac70634032fb39788b4455096c2e1c"; x:-858.312622; y:1050.681641; z:-253.441193
		"\132\250\018\200\093\198\062\037\114\027\250\247\250\177\148\153\000\074\139\196\159\171\070\068\241\112\125\195" ..
		-- tex:"84fa12c85dc63e25721bfaf7fab19499"; x:-1114.312622; y:794.681641; z:-253.441193
		"\211\194\025\066\153\071\154\039\227\072\108\243\082\136\180\248\001\148\086\196\159\171\070\068\241\112\125\195" ..
		-- tex:"d3c2194299479a27e3486cf35288b4f8"; x:-858.312622; y:794.681641; z:-253.441193
		"\013\169\105\098\247\144\211\084\071\070\092\061\189\004\028\170\164\162\060\068\097\071\249\195\015\041\255\194" ..
		-- tex:"0da96962f790d35447465c3dbd041caa"; x:754.541321; y:-498.557678; z:-127.580200
		"\204\078\135\073\218\123\163\159\109\165\030\132\011\117\130\005\164\162\060\068\176\163\060\196\015\041\255\194" ..
		-- tex:"cc4e8749da7ba39f6da51e840b758205"; x:754.541321; y:-754.557678; z:-127.580200
		"\133\016\057\043\160\072\152\120\043\243\126\180\176\230\116\019\164\162\124\068\176\163\060\196\015\041\255\194" ..
		-- tex:"8510392ba04898782bf37eb4b0e67413"; x:1010.541321; y:-754.557678; z:-127.580200
		"\227\027\101\063\007\171\241\160\043\212\166\045\236\037\204\036\056\204\244\067\120\245\127\196\014\041\255\194" ..
		-- tex:"e31b653f07abf1a02bd4a62dec25cc24"; x:489.595490; y:-1023.835510; z:-127.580193
		"\171\089\118\139\173\022\002\251\094\249\041\073\074\109\034\181\006\039\032\068\160\025\089\196\014\041\255\194" ..
		-- tex:"ab59768bad1602fb5ef929494a6d22b5"; x:640.609802; y:-868.400452; z:-127.580193
		"\188\037\029\108\193\172\025\227\121\116\149\015\064\224\170\160\028\102\058\068\120\245\127\196\014\041\255\194" ..
		-- tex:"bc251d6cc1ac19e37974950f40e0aaa0"; x:745.595490; y:-1023.835510; z:-127.580193
		"\113\204\099\188\216\128\049\053\189\011\094\157\245\094\059\018\056\204\244\067\120\245\063\196\014\041\255\194" ..
		-- tex:"71cc63bcd8803135bd0b5e9df55e3b12"; x:489.595490; y:-767.835510; z:-127.580193
		"\033\066\017\185\161\146\125\032\074\117\204\158\033\172\126\063\199\062\074\068\070\041\244\195\010\041\255\194" ..
		-- tex:"214211b9a1927d204a75cc9e21ac7e3f"; x:808.980957; y:-488.322479; z:-127.580162
		"\105\043\141\134\160\087\192\141\092\138\071\186\194\084\096\128\064\053\157\067\033\179\118\196\010\041\255\194" ..
		-- tex:"692b8d86a057c08d5c8a47bac2546080"; x:314.416046; y:-986.798950; z:-127.580162
		"\139\139\021\135\053\071\129\104\206\055\117\181\155\122\054\251\160\045\042\068\196\174\035\067\209\250\250\194" ..
		-- tex:"8b8b158735478168ce3775b59b7a36fb"; x:680.712921; y:163.682693; z:-125.489883
		"\156\142\233\194\238\235\255\109\035\056\135\151\039\240\072\254\129\182\040\067\196\174\035\067\209\250\250\194" ..
		-- tex:"9c8ee9c2eeebff6d2338879727f048fe"; x:168.712921; y:163.682693; z:-125.489883
		"\108\001\138\182\100\127\214\054\237\095\150\020\038\101\038\212\129\182\040\067\098\215\209\067\209\250\250\194" ..
		-- tex:"6c018ab6647fd636ed5f9614266526d4"; x:168.712921; y:419.682693; z:-125.489883
		"\210\149\129\243\184\098\005\117\024\129\072\251\041\175\202\040\064\091\212\067\196\174\035\067\209\250\250\194" ..
		-- tex:"d29581f3b8620575188148fb29afca28"; x:424.712921; y:163.682693; z:-125.489883
		"\157\203\232\040\092\228\000\010\118\242\090\124\030\243\157\039\154\161\125\068\147\166\141\196\006\061\241\194" ..
		-- tex:"9dcbe8285ce4000a76f25a7c1ef39d27"; x:1014.525085; y:-1133.205566; z:-120.619194
		"\052\047\012\197\203\023\251\155\246\049\108\026\168\030\133\147\154\161\125\068\039\077\091\196\006\061\241\194" ..
		-- tex:"342f0cc5cb17fb9bf6316c1aa81e8593"; x:1014.525085; y:-877.205566; z:-120.619194
		"\150\056\033\156\012\024\217\229\234\010\153\171\023\254\130\127\154\161\061\068\039\077\091\196\006\061\241\194" ..
		-- tex:"9638219c0c18d9e5ea0a99ab17fe827f"; x:758.525085; y:-877.205566; z:-120.619194
		"\172\149\096\117\113\168\200\099\179\161\065\242\060\161\087\113\154\161\061\068\147\166\141\196\006\061\241\194" ..
		-- tex:"ac95607571a8c863b3a141f23ca15771"; x:758.525085; y:-1133.205566; z:-120.619194
		"\048\111\126\221\015\248\117\111\118\223\093\029\223\020\019\082\070\236\213\194\226\190\102\196\188\179\221\194" ..
		-- tex:"306f7edd0ff8756f76df5d1ddf141352"; x:-106.961479; y:-922.982605; z:-110.851051
		"\041\216\129\085\142\012\233\195\172\058\018\133\002\053\107\135\164\135\184\063\226\190\102\196\188\179\221\194" ..
		-- tex:"29d881558e0ce9c3ac3a128502356b87"; x:1.441640; y:-922.982605; z:-110.851051
		"\056\127\245\157\048\160\203\039\183\031\061\009\126\028\009\124\163\050\090\068\218\061\226\189\186\179\221\194" ..
		-- tex:"387ff59d30a0cb27b71f3d097e1c097c"; x:872.791260; y:-0.110470; z:-110.851036
		"\149\036\127\063\191\204\254\082\214\193\075\222\248\011\154\162\163\050\090\068\249\006\217\194\186\179\221\194" ..
		-- tex:"95247f3fbfccfe52d6c14bdef80b9aa2"; x:872.791260; y:-108.513626; z:-110.851036
		"\193\088\005\142\169\129\108\026\219\240\179\147\064\117\154\148\136\091\102\196\095\124\099\189\185\179\221\194" ..
		-- tex:"c158058ea9816c1adbf0b39340759a94"; x:-921.430237; y:-0.055539; z:-110.851028
		"\208\240\065\033\090\069\178\219\204\186\008\066\051\233\208\067\218\178\213\194\078\207\089\068\184\179\221\194" ..
		-- tex:"d0f041215a45b2dbccba084233e9d043"; x:-106.849327; y:871.239197; z:-110.851021
		"\255\010\135\220\242\130\015\156\231\040\159\128\112\241\239\145\034\138\191\063\078\207\089\068\184\179\221\194" ..
		-- tex:"ff0a87dcf2820f9ce7289f8070f1ef91"; x:1.496403; y:871.239197; z:-110.851021
		"\214\146\185\011\128\192\182\059\098\129\200\000\150\142\242\247\136\091\102\196\120\205\216\194\182\179\221\194" ..
		-- tex:"d692b90b80c0b63b6281c800968ef2f7"; x:-921.430237; y:-108.401314; z:-110.851006
		"\183\120\178\152\126\020\067\031\185\013\097\189\149\053\241\039\203\242\004\196\035\095\155\067\213\194\167\194" ..
		-- tex:"b778b2987e14431fb90d61bd9535f127"; x:-531.793701; y:310.743286; z:-83.880539
		"\188\059\125\096\117\207\253\196\008\053\176\123\218\073\213\046\203\242\068\196\145\175\013\068\213\194\167\194" ..
		-- tex:"bc3b7d6075cffdc40835b07bda49d52e"; x:-787.793701; y:566.743286; z:-83.880539
		"\118\122\010\107\094\189\176\232\026\244\013\161\136\017\251\046\203\242\068\196\035\095\155\067\213\194\167\194" ..
		-- tex:"767a0a6b5ebdb0e81af40da18811fb2e"; x:-787.793701; y:310.743286; z:-83.880539
		"\062\150\206\051\034\062\148\134\148\218\192\128\091\064\124\097\203\242\004\196\145\175\013\068\213\194\167\194" ..
		-- tex:"3e96ce33223e948694dac0805b407c61"; x:-531.793701; y:566.743286; z:-83.880539
		"\132\236\005\012\127\187\103\160\108\059\054\123\068\114\034\097\151\229\137\195\145\175\013\068\213\194\167\194" ..
		-- tex:"84ec050c7fbb67a06c3b367b44722261"; x:-275.793701; y:566.743286; z:-83.880539
		"\049\166\037\129\064\191\018\152\201\199\135\075\058\242\035\100\103\250\001\068\108\151\152\065\222\070\159\194" ..
		-- tex:"31a6258140bf1298c9c7874b3af22364"; x:519.912598; y:19.073938; z:-79.638420
		"\170\112\076\116\141\099\176\217\021\196\089\143\131\111\080\195\090\193\165\067\251\210\151\066\176\125\155\194" ..
		-- tex:"aa704c748d63b0d915c4598f836f50c3"; x:331.510590; y:75.912079; z:-77.745491
		"\150\208\140\141\042\075\087\125\104\254\213\113\100\003\143\219\219\214\155\195\233\001\128\196\070\089\147\194" ..
		-- tex:"96d08c8d2a4b577d68fed57164038fdb"; x:-311.678589; y:-1024.059814; z:-73.674370
		"\247\141\106\010\243\150\086\089\091\003\078\157\245\015\229\229\134\149\127\196\135\142\156\195\057\089\147\194" ..
		-- tex:"f78d6a0af39656595b034e9df50fe5e5"; x:-1022.336365; y:-313.113525; z:-73.674271
		"\247\182\176\064\218\053\195\137\081\152\004\211\008\024\106\127\229\119\139\066\218\242\127\196\051\089\147\194" ..
		-- tex:"f7b6b040da35c389519804d308186a7f"; x:69.734177; y:-1023.794617; z:-73.674225
		"\199\055\061\193\197\100\011\067\197\212\094\136\218\103\048\129\159\088\065\068\072\146\156\195\051\089\147\194" ..
		-- tex:"c7373dc1c5640b43c5d45e88da673081"; x:773.384766; y:-313.142853; z:-73.674225
		"\061\096\222\176\218\105\078\037\104\235\204\240\179\182\203\093\086\177\139\066\179\197\127\068\049\089\147\194" ..
		-- tex:"3d60deb0da694e2568ebccf0b3b6cb5d"; x:69.846367; y:1023.089111; z:-73.674210
		"\087\067\056\058\095\025\009\075\234\227\227\110\100\113\085\159\086\177\139\066\179\197\063\068\049\089\147\194" ..
		-- tex:"5743383a5f19094beae3e36e6471559f"; x:69.846367; y:767.089111; z:-73.674210
		"\191\022\116\097\043\073\201\183\107\112\249\193\233\242\041\147\012\041\064\068\058\093\136\066\049\089\147\194" ..
		-- tex:"bf1674612b49c9b76b70f9c1e9f22993"; x:768.641418; y:68.182091; z:-73.674210
		"\111\247\091\086\086\025\132\116\207\102\153\027\186\231\119\119\134\020\128\068\058\093\136\066\049\089\147\194" ..
		-- tex:"6ff75b5656198474cf66991bbae77777"; x:1024.641418; y:68.182091; z:-73.674210
		"\186\051\087\180\123\253\251\207\215\249\224\120\018\153\225\237\064\189\155\195\179\197\063\068\047\089\147\194" ..
		-- tex:"ba3357b47bfdfbcfd7f9e0781299e1ed"; x:-311.478546; y:767.089111; z:-73.674194
		"\157\021\090\221\179\102\070\074\012\126\185\190\095\077\076\253\064\189\155\195\179\197\127\068\047\089\147\194" ..
		-- tex:"9d155addb366464a0c7eb9be5f4d4cfd"; x:-311.478546; y:1023.089111; z:-73.674194
		"\064\086\240\235\085\104\092\078\181\163\113\106\079\185\169\144\100\146\127\196\188\150\136\066\047\089\147\194" ..
		-- tex:"4056f0eb55685c4eb5a3716a4fb9a990"; x:-1022.287415; y:68.294411; z:-73.674194
		"\120\041\092\159\076\128\209\185\214\040\248\103\175\120\075\128\041\099\243\195\116\199\118\196\194\227\146\194" ..
		-- tex:"78295c9f4c80d1b9d628f867af784b80"; x:-486.774719; y:-987.116516; z:-73.444847
		"\167\062\124\022\153\140\022\017\138\230\107\072\059\192\006\157\172\067\157\067\118\219\073\068\185\227\146\194" ..
		-- tex:"a73e7c16998c16118ae66b483bc0069d"; x:314.528717; y:807.429138; z:-73.444778
		"\126\118\191\060\002\171\195\012\187\230\116\081\134\039\190\071\148\062\074\068\148\110\156\067\185\227\146\194" ..
		-- tex:"7e76bf3c02abc30cbbe674518627be47"; x:808.977844; y:312.863922; z:-73.444778
		"\102\228\062\092\207\255\153\144\186\074\246\226\120\182\074\228\004\080\118\196\001\125\156\067\183\227\146\194" ..
		-- tex:"66e43e5ccfff9990ba4af6e278b64ae4"; x:-985.250305; y:312.976624; z:-73.444763
		"\102\131\041\196\198\101\044\219\134\219\229\156\157\065\238\075\064\084\243\195\064\219\073\068\183\227\146\194" ..
		-- tex:"668329c4c6652cdb86dbe59c9d41ee4b"; x:-486.658234; y:807.425842; z:-73.444763
		"\217\004\170\142\116\018\070\194\062\132\112\126\226\096\169\102\207\079\118\196\214\026\244\195\182\227\146\194" ..
		-- tex:"d904aa8e741246c23e84707ee260a966"; x:-985.247070; y:-488.209686; z:-73.444756
		"\018\026\176\110\103\224\065\108\218\221\100\060\193\134\098\165\154\048\046\196\113\246\181\195\109\005\135\194" ..
		-- tex:"121ab06e67e0416cdadd643cc18662a5"; x:-696.759460; y:-363.925354; z:-67.510605
		"\024\018\187\099\071\090\199\232\174\062\037\203\105\099\121\104\154\048\046\196\199\217\215\194\109\005\135\194" ..
		-- tex:"1812bb63475ac7e8ae3e25cb69637968"; x:-696.759460; y:-107.925354; z:-67.510605
		"\209\160\163\243\060\139\037\039\092\121\078\077\253\043\194\087\053\097\220\195\199\217\215\194\109\005\135\194" ..
		-- tex:"d1a0a3f33c8b25275c794e4dfd2bc257"; x:-440.759460; y:-107.925354; z:-67.510605
		"\018\232\145\242\063\210\252\113\222\037\108\123\045\184\072\071\053\097\220\195\113\246\181\195\109\005\135\194" ..
		-- tex:"12e891f23fd2fc71de256c7b2db84847"; x:-440.759460; y:-363.925354; z:-67.510605
		"\119\075\113\144\160\211\195\196\123\041\056\139\185\141\174\216\129\143\199\067\072\137\052\196\145\233\133\194" ..
		-- tex:"774b7190a0d3c3c47b29388bb98daed8"; x:399.121155; y:-722.145081; z:-66.956192
		"\217\236\167\037\254\101\002\142\162\023\130\158\216\069\252\014\192\199\035\068\072\137\052\196\145\233\133\194" ..
		-- tex:"d9eca725fe65028ea217829ed845fc0e"; x:655.121155; y:-722.145081; z:-66.956192
		"\238\045\012\163\251\105\048\071\204\127\236\010\165\108\180\190\192\199\035\068\145\018\233\195\145\233\133\194" ..
		-- tex:"ee2d0ca3fb693047cc7fec0aa56cb4be"; x:655.121155; y:-466.145081; z:-66.956192
		"\069\103\065\100\044\197\022\064\139\056\131\028\222\070\200\173\129\143\199\067\145\018\233\195\145\233\133\194" ..
		-- tex:"456741642cc516408b38831cde46c8ad"; x:399.121155; y:-466.145081; z:-66.956192
		"\076\240\021\208\177\159\074\205\184\180\060\150\159\147\082\219\077\105\056\068\242\228\147\195\164\094\133\194" ..
		-- tex:"4cf015d0b19f4acdb8b43c969f9352db"; x:737.645355; y:-295.788666; z:-66.684853
		"\036\034\012\224\143\193\049\061\148\104\075\056\198\010\088\221\154\210\240\067\242\228\147\195\164\094\133\194" ..
		-- tex:"24220ce08fc1313d94684b38c60a58dd"; x:481.645355; y:-295.788666; z:-66.684853
		"\003\226\042\167\122\133\131\198\061\115\163\239\138\217\166\076\077\105\056\068\151\039\031\194\164\094\133\194" ..
		-- tex:"03e22aa77a8583c63d73a3ef8ad9a64c"; x:737.645355; y:-39.788666; z:-66.684853
		"\159\103\121\119\108\096\169\092\143\116\208\152\068\006\137\132\154\210\240\067\151\039\031\194\164\094\133\194" ..
		-- tex:"9f6779776c60a95c8f74d09844068984"; x:481.645355; y:-39.788666; z:-66.684853
		"\126\030\139\072\196\015\208\174\137\126\073\131\019\104\140\215\213\164\200\067\232\022\141\195\052\067\133\194" ..
		-- tex:"7e1e8b48c40fd0ae897e498313688cd7"; x:401.287781; y:-282.178986; z:-66.631264
		"\000\203\223\237\129\084\010\115\069\243\003\242\045\009\105\035\165\040\174\067\094\020\062\196\051\067\133\194" ..
		-- tex:"00cbdfed81540a7345f303f22d096923"; x:348.317558; y:-760.318298; z:-66.631256
		"\255\206\082\188\224\141\050\249\162\200\069\137\024\165\092\151\150\162\184\066\189\040\252\195\051\067\133\194" ..
		-- tex:"ffce52bce08d32f9a2c8458918a55c97"; x:92.317558; y:-504.318298; z:-66.631256
		"\191\128\150\196\157\252\094\015\198\101\004\002\253\204\143\009\150\162\184\066\094\020\062\196\051\067\133\194" ..
		-- tex:"bf8096c49dfc5e0fc6650402fdcc8f09"; x:92.317558; y:-760.318298; z:-66.631256
		"\049\029\002\088\093\230\152\037\238\137\013\183\179\013\204\054\165\040\174\067\189\040\252\195\051\067\133\194" ..
		-- tex:"311d02585de69825ee890db7b30dcc36"; x:348.317558; y:-504.318298; z:-66.631256
		"\218\245\218\255\215\222\081\212\117\076\218\077\120\232\083\038\073\134\025\067\197\005\025\068\176\024\129\194" ..
		-- tex:"daf5daffd7de51d4754cda4d78e85326"; x:153.524567; y:612.090210; z:-64.548225
		"\241\065\003\247\138\103\042\120\152\122\200\163\249\137\246\089\036\195\204\067\197\005\025\068\176\024\129\194" ..
		-- tex:"f14103f78a672a78987ac8a3f989f659"; x:409.524567; y:612.090210; z:-64.548225
		"\109\064\029\056\200\068\225\020\243\083\157\112\209\210\185\168\207\202\104\195\091\176\035\068\193\189\115\194" ..
		-- tex:"6d401d38c844e114f3539d70d1d2b9a8"; x:-232.792236; y:654.755615; z:-60.935310
		"\046\157\173\068\000\226\019\106\009\080\189\076\024\085\237\084\090\049\154\067\031\095\128\068\248\191\113\194" ..
		-- tex:"2e9dad4400e2136a0950bd4c1855ed54"; x:308.385590; y:1026.972656; z:-60.437473
		"\059\152\075\140\202\102\183\135\107\150\230\019\018\217\231\095\215\138\081\066\031\095\128\068\248\191\113\194" ..
		-- tex:"3b984b8cca66b7876b96e61312d9e75f"; x:52.385590; y:1026.972656; z:-60.437473
		"\210\136\016\115\018\002\100\129\104\245\032\004\009\114\087\115\252\209\179\067\168\192\202\067\181\012\095\194" ..
		-- tex:"d28810731202648168f5200409725773"; x:359.640533; y:405.505157; z:-55.762413
		"\192\130\080\210\092\065\144\233\166\117\211\226\225\078\027\239\084\246\201\195\136\175\198\195\123\228\063\194" ..
		-- tex:"c08250d25c4190e9a675d3e2e14e1bef"; x:-403.924469; y:-397.371368; z:-47.973129
		"\091\065\060\231\087\203\141\014\095\250\017\097\111\205\244\247\169\236\019\195\136\175\198\195\123\228\063\194" ..
		-- tex:"5b413ce757cb8d0e5ffa11616fcdf4f7"; x:-147.924469; y:-397.371368; z:-47.973129
		"\160\205\012\081\203\004\071\143\045\167\038\029\112\108\124\135\084\246\201\195\017\095\013\195\123\228\063\194" ..
		-- tex:"a0cd0c51cb04478f2da7261d706c7c87"; x:-403.924469; y:-141.371368; z:-47.973129
		"\073\230\128\013\156\210\069\147\071\092\048\189\165\179\193\074\200\152\226\195\031\226\114\067\247\120\042\194" ..
		-- tex:"49e6800d9cd24593475c30bda5b3c14a"; x:-453.193634; y:242.883301; z:-42.618134
		"\001\170\155\005\073\056\244\008\124\053\017\082\138\115\149\180\044\168\033\195\025\254\189\066\169\040\041\194" ..
		-- tex:"01aa9b054938f4087c3511528a7395b4"; x:-161.656937; y:94.996292; z:-42.289711
		"\234\054\033\206\005\246\049\254\112\150\234\022\000\111\050\106\165\175\188\066\242\000\033\195\169\040\041\194" ..
		-- tex:"ea3621ce05f631fe7096ea16006f326a"; x:94.343063; y:-161.003708; z:-42.289711
		"\210\055\224\051\188\098\045\172\180\067\178\052\095\070\251\075\044\168\033\195\242\000\033\195\169\040\041\194" ..
		-- tex:"d237e033bc622dacb443b2345f46fb4b"; x:-161.656937; y:-161.003708; z:-42.289711
		"\015\048\117\102\226\232\032\167\005\063\132\002\195\150\169\010\086\208\045\196\145\140\045\196\072\132\030\194" ..
		-- tex:"0f307566e2e820a7053f8402c396a90a"; x:-695.255310; y:-694.196411; z:-39.629185
		"\005\174\044\103\204\154\079\053\237\159\096\231\044\225\096\063\094\168\163\195\207\162\169\066\091\075\015\194" ..
		-- tex:"05ae2c67cc9a4f35ed9f60e72ce1603f"; x:-327.315399; y:84.817993; z:-35.823593
		"\232\222\162\052\001\011\163\078\009\042\162\012\157\176\161\121\111\252\040\196\017\088\080\067\135\104\006\194" ..
		-- tex:"e8dea234010ba34e092aa20c9db0a179"; x:-675.944336; y:208.344021; z:-33.602081
		"\122\184\057\022\051\066\169\181\063\106\165\086\036\003\205\039\111\252\040\196\184\159\062\194\135\104\006\194" ..
		-- tex:"7ab839163342a9b53f6aa5562403cd27"; x:-675.944336; y:-47.655979; z:-33.602081
		"\149\007\142\012\235\221\001\226\082\130\169\196\194\013\199\020\223\248\209\195\184\159\062\194\135\104\006\194" ..
		-- tex:"95078e0cebdd01e25282a9c4c20dc714"; x:-419.944336; y:-47.655979; z:-33.602081
		"\178\081\211\069\214\160\174\224\214\041\108\045\068\194\092\237\179\109\067\195\181\133\065\195\249\090\005\194" ..
		-- tex:"b251d345d6a0aee0d6296c2d44c25ced"; x:-195.428528; y:-193.522308; z:-33.338844
		"\197\137\070\071\003\223\000\011\085\068\146\189\204\095\012\195\057\082\198\195\016\210\030\066\248\136\234\193" ..
		-- tex:"c589464703df000b554492bdcc5f0cc3"; x:-396.642395; y:39.705143; z:-29.316881
		"\249\197\122\211\044\154\018\146\154\080\003\069\161\096\089\161\252\151\139\196\059\175\139\196\127\126\229\193" ..
		-- tex:"f9c57ad32c9a12929a500345a16059a1"; x:-1116.749634; y:-1117.476074; z:-28.686768
		"\003\001\137\192\115\028\211\143\118\170\213\211\167\138\117\002\252\151\139\196\119\094\087\196\127\126\229\193" ..
		-- tex:"030189c0731cd38f76aad5d3a78a7502"; x:-1116.749634; y:-861.476074; z:-28.686768
		"\152\145\125\020\089\021\186\155\144\209\218\049\065\191\169\203\249\047\087\196\119\094\087\196\127\126\229\193" ..
		-- tex:"98917d145915ba9b90d1da3141bfa9cb"; x:-860.749634; y:-861.476074; z:-28.686768
		"\227\095\169\004\094\187\207\116\169\040\023\076\062\101\061\069\249\047\087\196\059\175\139\196\127\126\229\193" ..
		-- tex:"e35fa9045ebbcf74a928174c3e653d45"; x:-860.749634; y:-1117.476074; z:-28.686768
		"\083\176\143\194\003\215\047\110\093\222\001\013\096\158\157\014\107\156\026\195\045\103\111\066\131\184\222\193" ..
		-- tex:"53b08fc203d72f6e5dde010d609e9d0e"; x:-154.611023; y:59.850761; z:-27.840096
		"\021\071\226\238\048\030\206\095\183\232\223\072\116\227\204\089\134\050\173\195\131\137\006\196\187\158\165\193" ..
		-- tex:"1547e2ee301ece5fb7e8df4874e3cc59"; x:-346.394745; y:-538.148682; z:-20.702507
		"\029\197\182\215\217\171\013\021\045\243\000\034\066\095\200\041\107\009\089\196\082\202\031\068\123\124\154\193" ..
		-- tex:"1dc5b6d7d9ab0d152df30022425fc829"; x:-868.147217; y:639.161316; z:-19.310783
		"\255\173\109\123\028\041\189\193\030\242\032\011\050\131\023\138\074\027\059\196\148\197\125\196\221\121\154\193" ..
		-- tex:"ffad6d7b1c29bdc11ef2200b3283178a"; x:-748.426453; y:-1015.087219; z:-19.309505
		"\171\188\007\151\067\130\161\007\021\045\077\005\127\100\040\169\074\027\059\196\148\197\061\196\221\121\154\193" ..
		-- tex:"abbc07974382a107152d4d057f6428a9"; x:-748.426453; y:-759.087219; z:-19.309505
		"\212\068\122\057\048\203\224\030\209\187\117\181\045\110\141\109\149\054\246\195\148\197\125\196\221\121\154\193" ..
		-- tex:"d4447a3930cbe01ed1bb75b52d6e8d6d"; x:-492.426453; y:-1015.087219; z:-19.309505
		"\106\246\046\211\085\040\160\223\015\201\198\066\065\112\077\180\161\145\127\196\219\028\090\196\200\121\154\193" ..
		-- tex:"6af62ed35528a0df0fc9c64241704db4"; x:-1022.275513; y:-872.450928; z:-19.309465
		"\249\048\171\182\178\223\119\236\198\061\255\007\174\039\226\245\161\145\063\196\219\028\090\196\200\121\154\193" ..
		-- tex:"f930abb6b2df77ecc63dff07ae27e2f5"; x:-766.275513; y:-872.450928; z:-19.309465
		"\185\219\113\095\171\146\078\157\117\115\033\049\015\076\100\117\161\145\127\196\219\028\026\196\200\121\154\193" ..
		-- tex:"b9db715fab924e9d757321310f4c6475"; x:-1022.275513; y:-616.450928; z:-19.309465
		"\203\187\240\194\200\135\085\045\208\128\129\000\101\217\014\054\161\145\063\196\219\028\026\196\200\121\154\193" ..
		-- tex:"cbbbf0c2c887552dd080810065d90e36"; x:-766.275513; y:-616.450928; z:-19.309465
		"\111\154\198\033\187\188\101\037\064\058\034\033\022\051\000\015\151\163\060\068\156\005\244\067\182\121\154\193" ..
		-- tex:"6f9ac621bbbc6525403a22211633000f"; x:754.556152; y:488.043854; z:-19.309431
		"\117\251\035\179\028\172\110\002\198\177\153\008\105\090\122\053\087\109\058\068\086\063\060\068\182\121\154\193" ..
		-- tex:"75fb23b31cac6e02c6b19908695a7a35"; x:745.708466; y:752.989685; z:-19.309431
		"\233\065\198\215\142\002\253\117\039\040\205\000\054\125\004\059\151\163\060\068\206\002\058\068\182\121\154\193" ..
		-- tex:"e941c6d78e02fd752728cd00367d043b"; x:754.556152; y:744.043854; z:-19.309431
		"\243\252\243\187\254\205\175\154\179\014\240\067\099\043\146\120\151\163\124\068\156\005\244\067\182\121\154\193" ..
		-- tex:"f3fcf3bbfecdaf9ab30ef043632b9278"; x:1010.556152; y:488.043854; z:-19.309431
		"\068\085\180\141\006\129\081\160\020\171\114\045\022\143\182\157\174\218\244\067\086\063\124\068\182\121\154\193" ..
		-- tex:"4455b48d068151a014ab722d168fb69d"; x:489.708466; y:1008.989685; z:-19.309431
		"\249\255\001\017\019\158\125\199\076\055\023\106\086\222\082\139\174\218\244\067\086\063\060\068\182\121\154\193" ..
		-- tex:"f9ff0111139e7dc74c37176a56de528b"; x:489.708466; y:752.989685; z:-19.309431
		"\243\081\077\235\015\017\086\013\055\212\150\056\244\218\090\050\166\045\032\068\183\195\031\068\177\121\154\193" ..
		-- tex:"f3514deb0f11560d37d49638f4da5a32"; x:640.713318; y:639.058105; z:-19.309422
		"\151\188\100\252\059\098\254\203\228\208\121\098\226\118\032\012\020\146\127\196\248\019\244\067\175\121\154\193" ..
		-- tex:"97bc64fc3b62fecbe4d07962e276200c"; x:-1022.282532; y:488.156036; z:-19.309418
		"\094\080\089\011\137\200\118\027\122\246\075\007\050\013\053\049\020\146\127\196\252\009\058\068\175\121\154\193" ..
		-- tex:"5e50590b89c8761b7af64b07320d3531"; x:-1022.282532; y:744.156036; z:-19.309418
		"\174\169\128\218\186\146\251\128\141\006\067\227\112\068\154\200\020\146\063\196\248\019\244\067\175\121\154\193" ..
		-- tex:"aea980daba92fb808d0643e370449ac8"; x:-766.282532; y:488.156036; z:-19.309418
		"\089\095\197\032\026\100\132\139\153\248\039\230\007\092\228\193\121\115\248\195\067\064\060\068\172\121\154\193" ..
		-- tex:"595fc5201a64848b99f827e6075ce4c1"; x:-496.902161; y:753.004150; z:-19.309412
		"\160\196\065\074\039\227\074\117\186\045\224\071\038\029\088\056\188\057\060\196\067\064\060\068\172\121\154\193" ..
		-- tex:"a0c4414a27e34a75ba2de047261d5838"; x:-752.902161; y:753.004150; z:-19.309412
		"\229\210\038\090\044\157\141\124\217\133\122\200\107\182\184\191\188\057\060\196\067\064\124\068\172\121\154\193" ..
		-- tex:"e5d2265a2c9d8d7cd9857ac86bb6b8bf"; x:-752.902161; y:1009.004150; z:-19.309412
		"\041\197\206\023\038\069\167\152\062\067\224\045\139\091\106\035\135\164\027\195\115\213\254\195\023\071\131\193" ..
		-- tex:"29c5ce172645a7983e43e02d8b5b6a23"; x:-155.642700; y:-509.667603; z:-16.409714
		"\024\173\208\112\160\207\032\012\019\231\240\195\184\192\096\045\067\210\205\195\115\213\254\195\023\071\131\193" ..
		-- tex:"18add070a0cf200c13e7f0c3b8c0602d"; x:-411.642700; y:-509.667603; z:-16.409714
		"\082\177\180\053\170\134\247\235\049\016\026\182\136\226\228\021\067\210\205\195\185\106\063\196\023\071\131\193" ..
		-- tex:"52b1b435aa86f7eb31101ab688e2e415"; x:-411.642700; y:-765.667603; z:-16.409714
		"\092\087\185\044\094\135\036\022\245\025\193\179\138\167\013\205\135\164\027\195\185\106\063\196\023\071\131\193" ..
		-- tex:"5c57b92c5e872416f519c1b38aa70dcd"; x:-155.642700; y:-765.667603; z:-16.409714
		"\216\209\014\212\204\188\123\113\143\039\145\191\192\164\078\023\033\233\038\196\115\213\254\195\023\071\131\193" ..
		-- tex:"d8d10ed4ccbc7b718f2791bfc0a44e17"; x:-667.642700; y:-509.667603; z:-16.409714
		"\009\156\251\040\113\230\085\099\152\221\122\058\133\082\090\146\033\233\038\196\185\106\063\196\023\071\131\193" ..
		-- tex:"099cfb2871e6556398dd7a3a85525a92"; x:-667.642700; y:-765.667603; z:-16.409714
		"\028\023\191\211\210\036\101\055\252\083\037\058\105\245\202\219\047\117\164\067\105\154\091\066\235\029\127\193" ..
		-- tex:"1c17bfd3d2246537fc53253a69f5cadb"; x:328.915527; y:54.900795; z:-15.944805
		"\156\074\136\140\064\111\131\092\100\090\185\101\022\206\066\210\191\212\145\066\105\154\091\066\235\029\127\193" ..
		-- tex:"9c4a888c406f835c645ab96516ce42d2"; x:72.915527; y:54.900795; z:-15.944805
		"\131\151\186\193\229\146\194\169\240\098\235\101\124\190\227\096\167\052\158\067\144\215\192\195\057\041\188\192" ..
		-- tex:"8397bac1e592c2a9f062eb657cbee360"; x:316.411369; y:-385.684113; z:-5.880033
		"\032\023\215\126\003\232\211\147\094\068\201\082\162\255\211\193\061\165\113\066\144\215\192\195\057\041\188\192" ..
		-- tex:"2017d77e03e8d3935e44c952a2ffd3c1"; x:60.411369; y:-385.684113; z:-5.880033
		"\099\118\044\053\138\135\048\245\243\137\140\112\108\032\233\035\061\165\113\066\033\175\001\195\057\041\188\192",
		-- tex:"63762c358a8730f5f3898c706c20e923"; x:60.411369; y:-129.684113; z:-5.880033
	["Old Hillsbrad Foothills"] = 
		"\096\146\171\052\042\027\224\185\059\252\080\143\003\025\068\021\255\255\215\069\255\255\199\197\000\000\000\000" ..
		-- tex:"6092ab342a1be0b93bfc508f03194415"; x:6912.000000; y:-6400.000000
		"\082\050\011\185\099\130\158\184\168\097\187\034\127\119\163\191\255\255\215\069\255\255\207\197\000\000\000\000" ..
		-- tex:"52320bb963829eb8a861bb227f77a3bf"; x:6912.000000; y:-6656.000000
		"\060\159\201\098\196\158\200\033\017\034\077\134\201\023\076\047\255\255\215\069\255\255\215\197\000\000\000\000" ..
		-- tex:"3c9fc962c49ec82111224d86c9174c2f"; x:6912.000000; y:-6912.000000
		"\166\170\140\240\245\172\095\070\113\165\250\179\166\214\109\019\255\255\215\069\255\255\223\197\000\000\000\000" ..
		-- tex:"a6aa8cf0f5ac5f4671a5fab3a6d66d13"; x:6912.000000; y:-7168.000000
		"\017\063\176\104\084\140\002\238\052\011\234\122\048\005\075\137\255\255\215\069\255\255\231\197\000\000\000\000" ..
		-- tex:"113fb068548c02ee340bea7a30054b89"; x:6912.000000; y:-7424.000000
		"\016\146\223\162\132\206\091\161\132\182\171\009\050\248\253\122\255\255\215\069\255\255\239\197\000\000\000\000" ..
		-- tex:"1092dfa284ce5ba184b6ab0932f8fd7a"; x:6912.000000; y:-7680.000000
		"\089\220\092\066\168\179\107\009\035\168\158\126\141\228\027\225\255\255\223\069\255\255\199\197\000\000\000\000" ..
		-- tex:"59dc5c42a8b36b0923a89e7e8de41be1"; x:7168.000000; y:-6400.000000
		"\044\198\061\071\087\040\210\094\223\148\160\096\115\200\191\153\255\255\223\069\255\255\207\197\000\000\000\000" ..
		-- tex:"2cc63d475728d25edf94a06073c8bf99"; x:7168.000000; y:-6656.000000
		"\074\146\250\140\066\125\212\029\126\167\192\183\241\074\199\117\255\255\223\069\255\255\215\197\000\000\000\000" ..
		-- tex:"4a92fa8c427dd41d7ea7c0b7f14ac775"; x:7168.000000; y:-6912.000000
		"\208\046\219\076\133\062\235\042\080\002\194\059\232\216\118\135\255\255\223\069\255\255\223\197\000\000\000\000" ..
		-- tex:"d02edb4c853eeb2a5002c23be8d87687"; x:7168.000000; y:-7168.000000
		"\129\161\019\105\110\021\195\201\177\200\167\172\196\167\104\054\255\255\223\069\255\255\231\197\000\000\000\000" ..
		-- tex:"81a113696e15c3c9b1c8a7acc4a76836"; x:7168.000000; y:-7424.000000
		"\019\091\122\044\153\140\127\237\073\114\045\091\033\158\171\139\255\255\223\069\255\255\239\197\000\000\000\000" ..
		-- tex:"135b7a2c998c7fed49722d5b219eab8b"; x:7168.000000; y:-7680.000000
		"\144\007\038\246\049\167\243\187\032\067\251\046\255\038\063\026\255\255\231\069\255\255\199\197\000\000\000\000" ..
		-- tex:"900726f631a7f3bb2043fb2eff263f1a"; x:7424.000000; y:-6400.000000
		"\120\012\136\072\049\079\132\233\110\077\069\047\019\237\161\166\255\255\231\069\255\255\207\197\000\000\000\000" ..
		-- tex:"780c8848314f84e96e4d452f13eda1a6"; x:7424.000000; y:-6656.000000
		"\081\080\206\009\150\160\157\196\155\116\243\206\200\201\201\179\255\255\231\069\255\255\215\197\000\000\000\000" ..
		-- tex:"5150ce0996a09dc49b74f3cec8c9c9b3"; x:7424.000000; y:-6912.000000
		"\093\035\171\024\156\200\013\144\102\125\230\026\225\108\131\100\255\255\231\069\255\255\223\197\000\000\000\000" ..
		-- tex:"5d23ab189cc80d90667de61ae16c8364"; x:7424.000000; y:-7168.000000
		"\254\055\243\003\093\108\228\137\246\123\156\228\086\091\222\097\255\255\231\069\255\255\231\197\000\000\000\000" ..
		-- tex:"fe37f3035d6ce489f67b9ce4565bde61"; x:7424.000000; y:-7424.000000
		"\117\052\166\093\158\075\209\153\106\089\070\004\008\235\058\013\255\255\231\069\255\255\239\197\000\000\000\000" ..
		-- tex:"7534a65d9e4bd1996a59460408eb3a0d"; x:7424.000000; y:-7680.000000
		"\006\223\151\093\240\075\061\147\126\010\073\081\211\007\082\233\255\255\239\069\255\255\199\197\000\000\000\000" ..
		-- tex:"06df975df04b3d937e0a4951d30752e9"; x:7680.000000; y:-6400.000000
		"\119\204\194\220\035\077\198\014\000\098\195\220\028\200\209\133\255\255\239\069\255\255\207\197\000\000\000\000" ..
		-- tex:"77ccc2dc234dc60e0062c3dc1cc8d185"; x:7680.000000; y:-6656.000000
		"\163\018\202\011\222\185\185\110\252\100\180\138\072\074\041\084\255\255\239\069\255\255\215\197\000\000\000\000" ..
		-- tex:"a312ca0bdeb9b96efc64b48a484a2954"; x:7680.000000; y:-6912.000000
		"\014\130\130\239\050\005\002\140\105\155\128\237\005\239\151\238\255\255\239\069\255\255\223\197\000\000\000\000" ..
		-- tex:"0e8282ef3205028c699b80ed05ef97ee"; x:7680.000000; y:-7168.000000
		"\208\093\056\241\192\048\078\051\203\002\179\225\110\252\081\049\255\255\239\069\255\255\231\197\000\000\000\000" ..
		-- tex:"d05d38f1c0304e33cb02b3e16efc5131"; x:7680.000000; y:-7424.000000
		"\070\209\244\218\162\167\025\195\226\194\048\003\126\037\217\145\255\255\239\069\255\255\239\197\000\000\000\000" ..
		-- tex:"46d1f4daa2a719c3e2c230037e25d991"; x:7680.000000; y:-7680.000000
		"\131\049\141\174\018\241\246\123\160\129\155\028\237\206\098\060\255\255\247\069\255\255\199\197\000\000\000\000" ..
		-- tex:"83318dae12f1f67ba0819b1cedce623c"; x:7936.000000; y:-6400.000000
		"\247\066\216\209\004\066\068\042\145\058\170\186\141\227\095\117\255\255\247\069\255\255\207\197\000\000\000\000" ..
		-- tex:"f742d8d10442442a913aaaba8de35f75"; x:7936.000000; y:-6656.000000
		"\154\190\213\137\032\238\000\141\069\121\242\016\145\071\241\087\255\255\247\069\255\255\215\197\000\000\000\000" ..
		-- tex:"9abed58920ee008d4579f2109147f157"; x:7936.000000; y:-6912.000000
		"\085\200\131\237\088\065\109\039\090\005\003\056\098\113\241\023\255\255\247\069\255\255\223\197\000\000\000\000" ..
		-- tex:"55c883ed58416d275a0503386271f117"; x:7936.000000; y:-7168.000000
		"\158\002\102\201\017\085\108\050\110\229\061\143\170\190\214\081\255\255\247\069\255\255\231\197\000\000\000\000" ..
		-- tex:"9e0266c911556c326ee53d8faabed651"; x:7936.000000; y:-7424.000000
		"\060\220\129\240\252\044\045\188\134\066\067\164\094\049\117\244\255\255\247\069\255\255\239\197\000\000\000\000" ..
		-- tex:"3cdc81f0fc2c2dbc864243a45e3175f4"; x:7936.000000; y:-7680.000000
		"\119\105\141\121\030\014\091\194\021\050\213\105\182\068\173\003\000\000\000\070\255\255\199\197\000\000\000\000" ..
		-- tex:"77698d791e0e5bc21532d569b644ad03"; x:8192.000000; y:-6400.000000
		"\180\113\210\113\134\218\200\238\172\051\122\053\148\198\126\224\000\000\000\070\255\255\207\197\000\000\000\000" ..
		-- tex:"b471d27186dac8eeac337a3594c67ee0"; x:8192.000000; y:-6656.000000
		"\135\208\195\092\019\051\206\012\235\162\068\179\222\137\127\172\000\000\000\070\255\255\215\197\000\000\000\000" ..
		-- tex:"87d0c35c1333ce0ceba244b3de897fac"; x:8192.000000; y:-6912.000000
		"\222\180\254\221\019\157\241\214\012\164\026\228\073\242\090\168\000\000\000\070\255\255\223\197\000\000\000\000" ..
		-- tex:"deb4fedd139df1d60ca41ae449f25aa8"; x:8192.000000; y:-7168.000000
		"\052\013\050\170\107\173\033\039\090\143\160\071\006\007\044\170\000\000\000\070\255\255\231\197\000\000\000\000" ..
		-- tex:"340d32aa6bad21275a8fa04706072caa"; x:8192.000000; y:-7424.000000
		"\078\039\026\091\099\166\114\167\036\089\003\145\205\079\127\081\000\000\000\070\255\255\239\197\000\000\000\000",
		-- tex:"4e271a5b63a672a724590391cd4f7f51"; x:8192.000000; y:-7680.000000
	["Old Stratholme"] = 
		"\111\204\121\028\088\069\199\081\026\056\139\231\001\226\139\158\223\185\184\195\111\098\139\194\246\051\131\194" ..
		-- tex:"6fcc791c5845c7511a388be701e28b9e"; x:-369.452148; y:-69.692261; z:-65.601494
		"\240\225\012\112\253\205\244\058\161\218\096\136\057\186\083\074\239\092\028\196\111\098\139\194\246\051\131\194" ..
		-- tex:"f0e10c70fdcdf43aa1da608839ba534a"; x:-625.452148; y:-69.692261; z:-65.601494
		"\086\204\247\181\085\205\022\016\208\083\076\200\187\143\044\055\239\092\028\196\155\216\162\195\246\051\131\194" ..
		-- tex:"56ccf7b555cd1610d0534cc8bb8f2c37"; x:-625.452148; y:-325.692261; z:-65.601494
		"\227\082\030\154\158\200\172\150\128\049\111\104\048\227\003\233\223\185\184\195\155\216\162\195\246\051\131\194" ..
		-- tex:"e3521e9a9ec8ac9680316f6830e303e9"; x:-369.452148; y:-325.692261; z:-65.601494
		"\108\044\167\052\012\178\239\059\108\247\235\143\041\238\050\075\093\149\167\195\189\049\187\195\225\068\128\194" ..
		-- tex:"6c2ca7340cb2ef3b6cf7eb8f29ee324b"; x:-335.166931; y:-374.388611; z:-64.134537
		"\128\175\015\198\171\040\138\126\152\066\137\137\001\214\185\171\093\149\167\195\222\152\029\196\225\068\128\194" ..
		-- tex:"80af0fc6ab288a7e9842898901d6b9ab"; x:-335.166931; y:-630.388611; z:-64.134537
		"\089\152\239\117\013\199\215\249\202\075\052\020\012\011\020\114\174\202\019\196\222\152\029\196\225\068\128\194" ..
		-- tex:"5998ef750dc7d7f9ca4b34140c0b1472"; x:-591.166931; y:-630.388611; z:-64.134537
		"\247\087\254\241\105\142\052\129\239\181\118\014\180\015\218\226\174\202\019\196\189\049\187\195\225\068\128\194" ..
		-- tex:"f757fef1698e3481efb5760eb40fdae2"; x:-591.166931; y:-374.388611; z:-64.134537
		"\058\029\165\111\211\221\190\087\145\048\087\135\216\249\044\025\168\224\134\196\225\218\040\067\200\232\124\194" ..
		-- tex:"3a1da56fd3ddbe5791305787d8f92c19"; x:-1079.020630; y:168.855011; z:-63.227329
		"\050\207\237\210\238\049\074\038\144\128\148\187\081\040\236\242\081\193\077\196\059\074\174\194\200\232\124\194" ..
		-- tex:"32cfedd2ee314a26908094bb5128ecf2"; x:-823.020630; y:-87.144989; z:-63.227329
		"\069\109\110\138\080\234\138\202\217\012\065\180\112\220\125\059\168\224\134\196\059\074\174\194\200\232\124\194" ..
		-- tex:"456d6e8a50ea8acad90c41b470dc7d3b"; x:-1079.020630; y:-87.144989; z:-63.227329
		"\254\080\252\219\243\012\242\072\108\147\240\146\137\110\096\247\248\109\165\195\253\127\151\195\003\235\121\194" ..
		-- tex:"fe50fcdbf30cf2486c93f092896e60f7"; x:-330.859161; y:-302.999939; z:-62.479507
		"\044\156\094\085\068\196\214\111\103\161\060\024\040\141\002\062\227\183\149\194\003\000\081\067\003\235\121\194" ..
		-- tex:"2c9c5e5544c4d66f67a13c18288d023e"; x:-74.859161; y:209.000061; z:-62.479507
		"\145\204\206\105\183\094\116\074\061\132\020\168\161\115\196\139\227\183\149\194\253\127\151\195\003\235\121\194" ..
		-- tex:"91ccce69b75e744a3d8414a8a173c48b"; x:-74.859161; y:-302.999939; z:-62.479507
		"\037\240\140\020\096\006\076\028\232\186\165\113\183\007\037\062\227\183\149\194\239\255\059\194\003\235\121\194" ..
		-- tex:"25f08c1460064c1ce8baa571b707253e"; x:-74.859161; y:-46.999939; z:-62.479507
		"\131\174\141\083\153\140\055\005\081\131\121\166\231\211\176\205\248\109\165\195\239\255\059\194\003\235\121\194" ..
		-- tex:"83ae8d53998c3705518379a6e7d3b0cd"; x:-330.859161; y:-46.999939; z:-62.479507
		"\032\014\003\149\142\010\032\007\004\200\112\082\023\121\049\048\112\174\190\195\201\089\135\195\014\037\115\194" ..
		-- tex:"200e03958e0a200704c8705217793130"; x:-381.362823; y:-270.701477; z:-60.786190
		"\150\191\062\161\221\012\091\024\132\004\170\195\063\078\172\168\052\088\104\196\243\077\245\194\149\022\112\194" ..
		-- tex:"96bf3ea1dd0c5b188404aac33f4eaca8"; x:-929.378235; y:-122.652252; z:-60.022057
		"\174\178\145\175\000\147\119\146\177\190\076\119\119\069\175\205\052\088\040\196\124\083\189\195\149\022\112\194" ..
		-- tex:"aeb291af00937792b1be4c777745afcd"; x:-673.378235; y:-378.652252; z:-60.022057
		"\104\110\066\005\142\064\240\098\088\148\170\127\076\231\102\198\052\088\104\196\124\083\189\195\149\022\112\194" ..
		-- tex:"686e42058e40f0625894aa7f4ce766c6"; x:-929.378235; y:-378.652252; z:-60.022057
		"\103\108\184\002\096\054\138\187\130\182\152\187\165\206\217\069\161\028\183\195\126\034\170\067\141\026\093\194" ..
		-- tex:"676cb80260368abb82b698bba5ced945"; x:-366.223694; y:340.269485; z:-55.275932
		"\010\214\062\157\145\111\208\125\061\210\231\024\127\136\066\177\080\142\027\196\249\137\168\066\141\026\093\194" ..
		-- tex:"0ad63e9d916fd07d3dd2e7187f8842b1"; x:-622.223694; y:84.269485; z:-55.275932
		"\144\079\026\112\191\177\041\228\126\057\046\167\016\117\011\089\161\028\183\195\249\137\168\066\141\026\093\194" ..
		-- tex:"904f1a70bfb129e47e392ea710750b59"; x:-366.223694; y:84.269485; z:-55.275932
		"\207\092\004\006\225\062\224\214\213\000\061\039\094\139\127\177\080\142\027\196\126\034\170\067\141\026\093\194" ..
		-- tex:"cf5c0406e13ee0d6d5003d275e8b7fb1"; x:-622.223694; y:340.269485; z:-55.275932
		"\104\132\211\180\203\140\008\245\190\033\214\129\168\187\137\148\075\061\048\196\109\067\112\195\101\121\081\194" ..
		-- tex:"6884d3b4cb8c08f5be21d681a8bb8994"; x:-704.957764; y:-240.263397; z:-52.368553
		"\135\152\127\206\160\141\068\107\166\179\181\226\084\009\002\195\159\125\048\196\158\134\192\191\144\023\051\194" ..
		-- tex:"87987fcea08d446ba6b3b5e2540902c3"; x:-705.962891; y:-1.504108; z:-44.773014
		"\071\234\170\163\200\054\080\129\156\098\122\149\225\195\236\123\218\053\025\196\194\154\165\067\048\023\049\194" ..
		-- tex:"47eaaaa3c83650819c627a95e1c3ec7b"; x:-612.841492; y:331.209076; z:-44.272648
		"\105\128\200\177\100\061\154\223\169\252\200\006\125\197\019\226\218\053\025\196\097\205\018\068\048\023\049\194" ..
		-- tex:"6980c8b1643d9adfa9fcc8067dc513e2"; x:-612.841492; y:587.209076; z:-44.272648
		"\132\251\017\082\030\079\211\156\213\051\029\223\128\252\141\157\181\107\178\195\194\154\165\067\048\023\049\194" ..
		-- tex:"84fb11521e4fd39cd5331ddf80fc8d9d"; x:-356.841492; y:331.209076; z:-44.272648
		"\014\229\142\042\116\033\169\121\170\092\208\089\048\093\054\062\191\164\179\195\194\015\205\194\057\153\045\194" ..
		-- tex:"0ee58e2a7421a979aa5cd059305d363e"; x:-359.287109; y:-102.530785; z:-43.399635
		"\200\106\198\229\189\175\111\108\208\151\124\014\173\252\006\104\017\080\129\196\129\073\043\195\101\232\039\194" ..
		-- tex:"c86ac6e5bdaf6f6cd0977c0eadfc0668"; x:-1034.502197; y:-171.287140; z:-41.976952
		"\048\020\225\035\124\106\116\144\095\018\102\203\139\255\069\022\045\195\253\195\250\197\232\194\248\170\033\194" ..
		-- tex:"3014e1237c6a74905f1266cb8bff4516"; x:-507.524841; y:-116.386681; z:-40.416965
		"\038\208\024\098\012\254\201\163\233\099\060\184\107\027\126\037\247\138\032\196\178\134\135\195\126\242\011\194" ..
		-- tex:"26d018620cfec9a3e9633cb86b1b7e25"; x:-642.171387; y:-271.052338; z:-34.986813
		"\150\075\112\241\023\146\135\181\226\001\091\149\100\010\168\118\064\035\249\195\058\151\162\195\042\076\010\194" ..
		-- tex:"964b70f1179287b5e2015b95640aa876"; x:-498.275421; y:-325.181488; z:-34.574383
		"\147\029\192\252\181\228\051\111\241\095\220\121\054\118\028\035\010\134\102\195\152\148\245\066\218\246\009\194" ..
		-- tex:"931dc0fcb5e4336ff15fdc7936761c23"; x:-230.523605; y:122.790230; z:-34.491070
		"\171\134\127\097\024\133\030\115\191\087\116\077\093\066\021\254\030\255\009\196\229\184\140\066\067\039\245\193" ..
		-- tex:"ab867f6118851e73bf57744d5d4215fe"; x:-551.986267; y:70.361130; z:-30.644173
		"\205\073\216\026\168\000\223\001\136\239\201\049\026\032\250\130\124\198\093\196\108\253\201\194\239\090\244\193" ..
		-- tex:"cd49d81aa800df0188efc9311a20fa82"; x:-887.101379; y:-100.994972; z:-30.544403
		"\211\223\007\161\007\027\093\195\210\004\200\035\244\154\017\230\210\210\008\195\073\048\101\066\230\063\222\193" ..
		-- tex:"d3df07a1071b5dc3d204c823f49a11e6"; x:-136.823532; y:57.297157; z:-27.781202
		"\169\073\172\188\172\047\101\208\253\219\183\065\128\251\180\030\000\154\094\196\160\086\146\067\037\061\216\193" ..
		-- tex:"a949acbcac2f65d0fddbb74180fbb41e"; x:-890.406311; y:292.676788; z:-27.029858
		"\068\100\222\056\242\101\103\200\140\096\108\161\156\019\134\254\129\099\026\196\161\042\091\067\016\112\204\193" ..
		-- tex:"4464de38f26567c88c606ca19c1386fe"; x:-617.554810; y:219.166534; z:-25.554720
		"\024\003\036\204\047\195\212\014\029\037\180\038\187\091\158\017\238\143\163\195\120\049\202\195\246\229\203\193" ..
		-- tex:"180324cc2fc3d40e1d25b426bb5b9e11"; x:-327.124481; y:-404.386505; z:-25.487288
		"\131\043\029\103\000\083\231\032\179\212\222\228\232\225\006\164\198\220\130\194\211\237\099\195\102\091\194\193" ..
		-- tex:"832b1d670053e720b3d4dee4e8e106a4"; x:-65.431206; y:-227.929016; z:-24.294630
		"\151\143\012\238\206\145\088\208\219\043\181\141\152\119\127\254\206\199\060\196\074\046\208\066\213\203\189\193" ..
		-- tex:"978f0ceece9158d0db2bb58d98777ffe"; x:-755.122009; y:104.090416; z:-23.724529
		"\012\012\216\022\211\144\240\179\229\113\172\237\063\050\197\047\143\212\048\196\076\217\088\067\228\031\180\193" ..
		-- tex:"0c0cd816d390f0b3e571aced3f32c52f"; x:-707.321289; y:216.848831; z:-22.515574
		"\108\042\024\109\027\138\185\178\228\235\210\221\016\230\093\151\086\079\006\196\007\050\072\194\244\012\178\193" ..
		-- tex:"6c2a186d1b8ab9b2e4ebd2dd10e65d97"; x:-537.239685; y:-50.048859; z:-22.256327
		"\169\141\126\070\213\200\142\193\209\013\154\114\144\068\128\120\203\103\023\196\178\161\020\067\024\009\177\193" ..
		-- tex:"a98d7e46d5c88ec1d10d9a7290448078"; x:-605.621826; y:148.631638; z:-22.129442
		"\223\098\241\110\170\196\034\068\127\181\048\004\073\164\023\009\115\198\132\195\083\229\175\193\255\205\176\193" ..
		-- tex:"df62f16eaac422447fb5300449a41709"; x:-265.550415; y:-21.986977; z:-22.100586
		"\194\169\226\042\058\154\225\034\200\085\083\194\142\205\159\134\228\040\253\195\097\157\126\067\077\233\157\193" ..
		-- tex:"c2a9e22a3a9ae122c85553c28ecd9f86"; x:-506.319489; y:254.614777; z:-19.738918
		"\226\017\211\032\140\058\166\120\013\153\154\140\059\078\066\026\097\235\128\195\006\144\193\066\035\026\138\193" ..
		-- tex:"e211d3208c3aa6780d999a8c3b4e421a"; x:-257.838928; y:96.781303; z:-17.262764
		"\056\244\184\133\026\234\114\047\135\015\016\055\137\176\049\200\207\239\219\195\056\013\163\067\214\214\082\193" ..
		-- tex:"38f4b8851aea722f870f103789b031c8"; x:-439.873535; y:326.103302; z:-13.177451
		"\136\124\236\193\125\019\081\134\051\096\014\210\022\244\048\013\051\078\083\196\122\017\155\067\244\183\074\193" ..
		-- tex:"887cecc17d13518633600ed216f4300d"; x:-845.221924; y:310.136566; z:-12.669911
		"\138\106\027\143\118\036\174\220\216\047\083\225\116\189\005\163\027\088\156\195\174\134\143\067\135\103\068\193" ..
		-- tex:"8a6a1b8f7624aedcd82f53e174bd05a3"; x:-312.688354; y:287.052216; z:-12.275276
		"\094\239\149\005\239\221\180\046\216\002\239\112\230\044\164\201\222\016\152\194\185\013\178\194\066\070\054\193" ..
		-- tex:"5eef9505efddb42ed802ef70e62ca4c9"; x:-76.032951; y:-89.026810; z:-11.392154
		"\095\233\119\202\044\203\032\112\239\233\139\242\100\136\071\041\132\186\227\195\147\123\017\067\023\006\019\193" ..
		-- tex:"5fe977ca2ccb2070efe98bf264884729"; x:-455.457184; y:145.482727; z:-9.188988
		"\079\138\245\049\062\093\011\089\079\073\251\164\061\110\205\021\017\172\190\065\189\098\150\193\118\215\217\192" ..
		-- tex:"4f8af5313e5d0b594f49fba43d6ecd15"; x:23.834019; y:-18.798214; z:-6.807552
		"\187\244\218\131\005\074\067\036\068\013\027\085\247\029\049\110\109\093\188\066\119\079\044\194\199\200\098\192" ..
		-- tex:"bbf4da83054a4324440d1b55f71d316e"; x:94.182480; y:-43.077606; z:-3.543505
		"\135\176\237\146\209\127\160\163\195\139\199\014\042\085\062\197\071\177\070\196\217\067\145\067\012\045\139\064" ..
		-- tex:"87b0ed92d17fa0a3c38bc70e2a553ec5"; x:-794.770020; y:290.530090; z:4.349249
		"\085\161\174\030\154\087\209\151\210\212\020\125\040\157\029\153\225\057\041\196\184\174\093\067\209\215\178\064",
		-- tex:"55a1ae1e9a57d197d2d4147d289d1d99"; x:-676.904419; y:221.682510; z:5.588845
	["Onyxia's Lair"] = 
		"\214\006\144\090\106\192\089\060\010\142\001\023\104\144\162\224\078\183\009\067\203\044\007\068\072\243\064\195" ..
		-- tex:"d606905a6ac0593c0a8e01176890a2e0"; x:137.716049; y:540.699951; z:-192.950333
		"\181\074\120\175\075\229\201\167\184\106\061\252\037\057\012\105\097\145\236\194\151\089\142\067\072\243\064\195" ..
		-- tex:"b54a78af4be5c9a7b86a3dfc25390c69"; x:-118.283951; y:284.699951; z:-192.950333
		"\144\207\015\007\000\038\139\176\003\083\103\135\095\213\131\070\097\145\236\194\203\044\007\068\072\243\064\195" ..
		-- tex:"90cf0f0700268bb0035367875fd58346"; x:-118.283951; y:540.699951; z:-192.950333
		"\043\093\213\042\066\022\225\106\243\255\158\154\211\096\022\169\078\183\009\067\151\089\142\067\072\243\064\195" ..
		-- tex:"2b5dd52a4216e16af3ff9e9ad36016a9"; x:137.716049; y:284.699951; z:-192.950333
		"\136\194\130\218\077\215\174\124\226\047\242\207\219\251\210\005\152\052\125\067\198\013\110\067\170\169\013\195" ..
		-- tex:"88c282da4dd7ae7ce22ff2cfdbfbd205"; x:253.205460; y:238.053818; z:-141.662766
		"\224\127\009\025\246\075\144\241\178\011\252\122\086\207\237\196\152\052\125\067\227\006\247\067\170\169\013\195" ..
		-- tex:"e07f0919f64b90f1b20bfc7a56cfedc4"; x:253.205460; y:494.053818; z:-141.662766
		"\196\166\067\175\190\034\231\042\234\039\196\248\072\015\028\226\027\147\032\067\157\130\050\067\177\023\253\194" ..
		-- tex:"c4a643afbe22e72aea27c4f8480f1ce2"; x:160.574646; y:178.510223; z:-126.546280
		"\084\151\051\154\184\056\118\169\064\065\225\122\035\255\216\035\132\111\066\066\166\209\026\067\211\027\162\194" ..
		-- tex:"5497339ab83876a94041e17a23ffd823"; x:48.608906; y:154.818954; z:-81.054352
		"\244\003\171\195\152\093\005\159\034\172\188\111\127\059\166\069\079\194\095\064\235\109\042\067\186\084\133\194" ..
		-- tex:"f403abc3985d059f22acbc6f7f3ba645"; x:3.496235; y:170.429382; z:-66.665489
		"\092\086\177\009\088\185\109\173\238\028\060\117\148\253\011\222\216\251\252\194\169\112\197\066\071\208\103\194" ..
		-- tex:"5c56b10958b96dadee1c3c7594fd0bde"; x:-126.491890; y:98.720047; z:-57.953400
		"\072\149\007\251\121\227\001\132\144\096\153\023\045\197\028\199\221\124\180\194\095\111\203\065\164\141\024\193",
		-- tex:"489507fb79e30184906099172dc51cc7"; x:-90.243881; y:25.429382; z:-9.534581
	["Ragefire Chasm"] = 
		"\018\179\009\195\082\218\017\137\226\028\219\037\146\004\150\234\230\160\001\068\253\173\196\194\003\098\004\195" ..
		-- tex:"12b309c352da1189e21cdb25920496ea"; x:518.514069; y:-98.339828; z:-132.382874
		"\213\220\188\165\123\081\001\121\166\034\055\212\066\170\152\107\204\065\131\067\000\169\029\067\003\098\004\195" ..
		-- tex:"d5dcbca57b510179a62237d442aa986b"; x:262.514069; y:157.660172; z:-132.382874
		"\020\230\216\157\130\212\079\034\127\226\085\057\018\043\229\109\204\065\131\067\253\173\196\194\003\098\004\195" ..
		-- tex:"14e6d89d82d44f227fe25539122be56d"; x:262.514069; y:-98.339828; z:-132.382874
		"\205\141\054\021\177\051\097\012\098\243\164\116\094\029\201\152\230\160\001\068\000\169\029\067\003\098\004\195" ..
		-- tex:"cd8d3615b133610c62f3a4745e1dc998"; x:518.514069; y:157.660172; z:-132.382874
		"\224\240\052\102\044\071\220\008\155\193\200\130\202\194\230\109\107\049\005\067\018\029\022\065\023\226\175\194" ..
		-- tex:"e0f034662c47dc089bc1c882cac2e66d"; x:133.193054; y:9.382098; z:-87.941589
		"\125\205\248\225\212\203\162\153\126\172\148\013\046\247\045\094\241\180\016\068\045\016\138\195\012\071\159\194" ..
		-- tex:"7dcdf8e1d4cba2997eac940d2ef72d5e"; x:578.827240; y:-276.126404; z:-79.638771
		"\095\056\174\094\126\029\214\087\032\250\048\254\068\042\184\050\241\180\016\068\022\008\005\196\012\071\159\194" ..
		-- tex:"5f38ae5e7e1dd65720fa30fe442ab832"; x:578.827240; y:-532.126404; z:-79.638771
		"\235\054\250\152\080\143\082\192\071\221\154\092\225\107\157\248\226\105\161\067\022\008\005\196\012\071\159\194" ..
		-- tex:"eb36fa98508f52c047dd9a5ce16b9df8"; x:322.827240; y:-532.126404; z:-79.638771
		"\073\199\047\008\232\138\110\179\081\135\095\064\242\090\145\088\226\105\161\067\045\016\138\195\012\071\159\194" ..
		-- tex:"49c72f08e88a6eb351875f40f25a9158"; x:322.827240; y:-276.126404; z:-79.638771
		"\022\113\016\011\206\077\084\118\066\211\062\179\080\194\113\212\042\182\005\194\173\089\124\193\052\166\071\194" ..
		-- tex:"1671100bce4d547642d33eb350c271d4"; x:-33.427898; y:-15.771894; z:-49.912312
		"\203\172\045\222\220\182\192\195\197\061\080\076\004\165\101\089\114\142\253\066\051\182\085\195\250\236\066\194" ..
		-- tex:"cbac2ddedcb6c0c3c53d504c04a56559"; x:126.778221; y:-213.711731; z:-48.731426
		"\182\074\095\176\158\067\227\034\235\241\227\220\072\081\152\047\030\161\028\068\009\097\147\195\012\138\053\194" ..
		-- tex:"b64a5fb09e43e322ebf1e3dc4851982f"; x:626.517517; y:-294.758118; z:-45.384815
		"\038\167\085\129\022\133\254\207\064\185\244\242\034\004\251\120\030\161\028\068\132\176\009\196\012\138\053\194" ..
		-- tex:"26a755811685fecf40b9f4f22204fb78"; x:626.517517; y:-550.758118; z:-45.384815
		"\053\252\195\251\249\057\111\053\135\103\180\106\028\077\126\085\077\134\049\195\015\120\251\194\155\187\205\193" ..
		-- tex:"35fcc3fbf9396f358767b46a1c4d7e55"; x:-177.524628; y:-125.734497; z:-25.716606
		"\235\112\245\186\026\117\102\165\128\209\165\072\023\025\224\181\076\233\077\195\227\094\039\195\021\198\172\193" ..
		-- tex:"eb70f5ba1a7566a580d1a5481719e0b5"; x:-205.911331; y:-167.370667; z:-21.596722
		"\048\134\028\044\042\006\048\220\118\031\217\145\237\249\231\201\199\166\070\195\213\053\105\195\235\213\123\193" ..
		-- tex:"30861c2c2a0630dc761fd991edf9e7c9"; x:-198.651489; y:-233.210297; z:-15.739727
		"\112\247\106\245\073\065\195\044\078\000\066\173\088\175\133\230\125\236\066\195\017\193\159\195\152\239\204\064" ..
		-- tex:"70f76af54941c32c4e0042ad58af85e6"; x:-194.923798; y:-319.508362; z:6.404248
		"\235\063\054\081\157\143\161\195\206\062\012\022\159\215\210\152\053\251\080\194\033\065\186\195\046\255\045\066" ..
		-- tex:"eb3f36519d8fa1c3ce3e0c169fd7d298"; x:-52.245323; y:-372.508850; z:43.499203
		"\019\164\148\092\141\030\015\076\205\148\073\167\048\055\093\223\230\038\252\194\168\063\188\195\022\188\084\066",
		-- tex:"13a4945c8d1e0f4ccd9449a730375ddf"; x:-126.075981; y:-376.497345; z:53.183681
	["Razorfen Downs"] = 
		"\202\122\065\211\024\116\145\241\226\167\240\024\025\145\233\095\038\128\131\195\253\188\009\067\107\222\162\194" ..
		-- tex:"ca7a41d3187491f1e2a7f0181991e95f"; x:-263.001190; y:137.738251; z:-81.434418
		"\063\154\163\184\004\128\217\170\012\245\026\200\156\055\010\087\191\009\224\192\253\188\009\067\107\222\162\194" ..
		-- tex:"3f9aa3b80480d9aa0cf51ac89c370a57"; x:-7.001190; y:137.738251; z:-81.434418
		"\000\025\109\119\026\212\053\046\144\253\212\120\095\048\082\186\038\128\131\195\063\111\034\068\107\222\162\194" ..
		-- tex:"00196d771ad4352e90fdd4785f3052ba"; x:-263.001190; y:649.738251; z:-81.434418
		"\159\223\131\234\120\110\054\003\244\039\249\151\134\131\186\245\038\128\131\195\126\222\196\067\107\222\162\194" ..
		-- tex:"9fdf83ea786e3603f427f9978683baf5"; x:-263.001190; y:393.738251; z:-81.434418
		"\016\063\008\080\245\124\002\023\013\219\101\190\200\247\053\125\191\009\224\192\126\222\196\067\107\222\162\194" ..
		-- tex:"103f0850f57c02170ddb65bec8f7357d"; x:-7.001190; y:393.738251; z:-81.434418
		"\123\196\214\123\197\136\244\238\168\213\244\134\167\132\253\110\191\009\224\192\063\111\034\068\107\222\162\194" ..
		-- tex:"7bc4d67bc588f4eea8d5f486a784fd6e"; x:-7.001190; y:649.738251; z:-81.434418
		"\062\144\173\023\164\255\091\016\038\217\165\023\108\226\074\246\168\140\141\195\135\090\022\068\218\097\155\194" ..
		-- tex:"3e90ad17a4ff5b1026d9a5176ce24af6"; x:-283.098907; y:601.414551; z:-77.691124
		"\169\038\010\057\127\239\217\003\129\169\216\251\171\001\143\243\168\140\141\195\015\181\172\067\218\097\155\194" ..
		-- tex:"a9260a397fefd90381a9d8fbab018ff3"; x:-283.098907; y:345.414551; z:-77.691124
		"\038\163\111\109\172\117\028\091\247\145\011\131\145\030\103\120\143\202\216\193\135\090\022\068\218\097\155\194" ..
		-- tex:"26a36f6dac751c5bf7910b83911e6778"; x:-27.098907; y:601.414551; z:-77.691124
		"\066\220\036\160\060\016\178\004\114\220\117\222\014\107\241\140\242\028\073\066\252\084\251\067\114\046\150\194" ..
		-- tex:"42dc24a03c10b20472dc75de0e6bf18c"; x:50.278271; y:502.663956; z:-75.090721
		"\020\226\225\160\187\013\207\230\140\190\079\171\231\090\146\166\242\028\073\066\248\169\118\067\114\046\150\194" ..
		-- tex:"14e2e1a0bb0dcfe68cbe4fabe75a92a6"; x:50.278271; y:246.663956; z:-75.090721
		"\136\113\211\144\023\035\115\138\182\145\102\236\121\188\148\202\155\142\038\195\144\223\028\068\033\199\133\194" ..
		-- tex:"8871d3901723738ab69166ec79bc94ca"; x:-166.557068; y:627.493225; z:-66.888931
		"\178\062\014\000\210\060\009\163\085\214\048\203\151\212\105\077\155\142\038\195\144\223\092\068\033\199\133\194" ..
		-- tex:"b23e0e00d23c09a355d630cb97d4694d"; x:-166.557068; y:883.493225; z:-66.888931
		"\070\164\075\062\245\053\017\203\072\111\071\145\105\167\089\179\131\219\222\194\011\252\067\068\062\188\079\194" ..
		-- tex:"46a44b3ef53511cb486f479169a759b3"; x:-111.428741; y:783.938232; z:-51.933834
		"\052\149\168\239\083\241\076\106\183\127\179\173\236\161\012\093\224\182\183\195\011\252\067\068\062\188\079\194" ..
		-- tex:"3495a8ef53f14c6ab77fb3adeca10c5d"; x:-367.428741; y:783.938232; z:-51.933834
		"\156\123\142\176\025\173\230\064\052\122\107\023\217\189\041\059\126\093\165\195\230\180\077\068\205\137\024\194" ..
		-- tex:"9c7b8eb019ade640347a6b17d9bd293b"; x:-330.730438; y:822.826599; z:-38.134575
		"\060\031\250\095\144\098\237\032\069\012\225\224\149\024\227\080\126\093\165\195\230\180\013\068\205\137\024\194" ..
		-- tex:"3c1ffa5f9062ed20450ce1e09518e350"; x:-330.730438; y:566.826599; z:-38.134575
		"\102\162\219\144\211\112\023\192\072\000\052\126\065\179\110\084\135\142\215\195\245\051\130\067\138\190\251\193" ..
		-- tex:"66a2db90d37017c04800347e41b36e54"; x:-431.113525; y:260.405945; z:-31.468039
		"\125\152\100\073\207\128\180\130\207\110\184\111\132\133\162\077\045\207\124\195\051\151\109\068\059\101\243\193" ..
		-- tex:"7d986449cf80b482cf6eb86f8485a24d"; x:-252.809296; y:950.362549; z:-30.424431
		"\192\177\143\000\002\172\051\105\221\203\024\063\031\191\209\225\127\052\076\064\051\151\109\068\059\101\243\193" ..
		-- tex:"c0b18f0002ac3369ddcb183f1fbfd1e1"; x:3.190704; y:950.362549; z:-30.424431
		"\001\136\082\236\009\224\062\030\022\189\133\023\022\191\095\178\071\227\212\195\219\173\217\067\006\243\241\193" ..
		-- tex:"018852ec09e03e1e16bd851716bf5fb2"; x:-425.775635; y:435.358276; z:-30.243666
		"\010\043\221\153\235\212\114\218\080\195\070\177\125\000\161\067\064\101\227\195\009\103\084\068\131\215\241\193" ..
		-- tex:"0a2bdd99ebd472da50c346b17d00a143"; x:-454.791046; y:849.609985; z:-30.230232
		"\111\188\181\015\145\102\140\138\254\125\003\126\173\216\182\230\002\088\218\195\139\048\058\067\106\213\232\193",
		-- tex:"6fbcb50f91668c8afe7d037eadd8b6e6"; x:-436.687592; y:186.189636; z:-29.104208
	["Razorfen Kraul"] = 
		"\200\081\067\070\008\019\097\155\080\151\214\067\043\124\241\213\082\090\223\067\128\141\028\194\076\214\164\194" ..
		-- tex:"c85143460813619b5097d6432b7cf1d5"; x:446.705658; y:-39.138187; z:-82.418556
		"\177\149\207\025\074\076\014\129\221\226\159\082\209\157\224\041\041\173\047\068\128\141\028\194\076\214\164\194" ..
		-- tex:"b195cf194a4c0e81dde29f52d19de029"; x:702.705658; y:-39.138187; z:-82.418556
		"\199\050\002\206\023\142\012\167\031\224\066\205\106\252\206\178\041\173\047\068\159\220\088\067\076\214\164\194" ..
		-- tex:"c73202ce178e0ca71fe042cd6afcceb2"; x:702.705658; y:216.861813; z:-82.418556
		"\137\023\103\195\211\092\040\054\199\197\054\107\110\011\242\192\082\090\223\067\159\220\088\067\076\214\164\194" ..
		-- tex:"891767c3d35c2836c7c5366b6e0bf2c0"; x:446.705658; y:216.861813; z:-82.418556
		"\145\031\100\115\221\239\224\170\099\205\156\166\194\151\157\217\141\210\178\067\127\107\229\066\190\160\154\194" ..
		-- tex:"911f6473ddefe0aa63cd9ca6c2979dd9"; x:357.644958; y:114.709961; z:-77.313957
		"\057\064\129\171\146\061\254\033\196\246\113\099\195\094\199\097\141\210\178\067\063\074\013\195\190\160\154\194" ..
		-- tex:"394081ab923dfe21c4f67163c35ec761"; x:357.644958; y:-141.290039; z:-77.313957
		"\212\195\096\116\160\091\088\198\184\168\198\254\120\022\175\077\059\235\219\067\143\034\248\066\104\100\144\194" ..
		-- tex:"d4c36074a05b58c6b8a8c6fe7816af4d"; x:439.837769; y:124.067505; z:-72.196114
		"\142\052\121\162\160\166\083\214\027\229\033\069\177\250\071\000\145\066\153\067\133\217\082\195\022\107\142\194" ..
		-- tex:"8e3479a2a0a653d61be52145b1fa4700"; x:306.520081; y:-210.849701; z:-71.209160
		"\139\172\223\022\108\139\251\078\122\173\139\088\193\186\214\178\133\048\022\068\044\081\158\194\206\184\139\194" ..
		-- tex:"8bacdf166c8bfb4e7aad8b58c1bad6b2"; x:600.758179; y:-79.158546; z:-69.860954
		"\036\109\194\080\151\210\215\128\132\088\082\154\209\095\056\128\182\136\050\068\052\066\224\066\197\131\127\194" ..
		-- tex:"246dc25097d2d7808458529ad15f3880"; x:714.136169; y:112.129311; z:-63.878685
		"\174\244\041\172\049\019\080\011\244\196\185\064\244\021\076\186\061\071\118\067\218\238\121\194\167\012\125\194" ..
		-- tex:"aef429ac3113500bf4c4b940f4154cba"; x:246.278290; y:-62.483257; z:-63.262360
		"\075\179\024\234\145\238\019\184\169\145\187\022\041\199\124\146\219\157\167\067\016\126\095\195\007\200\121\194" ..
		-- tex:"4bb318ea91ee13b8a991bb1629c77c92"; x:335.233261; y:-223.492447; z:-62.445343
		"\217\122\055\196\013\199\024\011\136\011\186\110\058\068\002\114\109\119\158\066\016\126\095\195\007\200\121\194" ..
		-- tex:"d97a37c40dc7180b880bba6e3a440272"; x:79.233261; y:-223.492447; z:-62.445343
		"\210\085\129\254\119\045\013\243\087\104\145\075\109\110\003\232\118\051\022\068\055\116\074\067\083\048\116\194" ..
		-- tex:"d25581fe772d0df35768914b6d6e03e8"; x:600.804138; y:202.453979; z:-61.047195
		"\179\074\043\135\119\147\071\073\033\047\022\056\146\185\056\246\227\099\049\068\177\141\092\067\208\252\111\194" ..
		-- tex:"b34a2b8777934749212f163892b938f6"; x:709.560791; y:220.553497; z:-59.996891
		"\191\052\176\157\139\209\203\226\244\055\241\090\160\177\064\199\077\058\023\068\255\114\216\067\146\081\097\194" ..
		-- tex:"bf34b09d8bd1cbe2f437f15aa0b140c7"; x:604.911011; y:432.898438; z:-56.329662
		"\181\217\111\129\219\103\038\057\237\024\196\240\059\116\243\147\134\251\013\068\149\103\248\194\155\092\089\194" ..
		-- tex:"b5d96f81db672639ed18c4f03b74f393"; x:567.930115; y:-124.202316; z:-54.340439
		"\030\160\071\115\240\022\253\020\070\196\235\251\104\120\006\115\252\153\181\194\015\010\159\195\088\089\072\194" ..
		-- tex:"1ea04773f016fd1446c4ebfb68780673"; x:-90.800758; y:-318.078613; z:-50.087254
		"\158\070\150\235\212\101\167\242\180\206\120\121\008\190\030\129\252\153\181\194\007\133\015\196\088\089\072\194" ..
		-- tex:"9e4696ebd465a7f2b4ce787908be1e81"; x:-90.800758; y:-574.078613; z:-50.087254
		"\151\063\223\107\021\134\067\244\083\071\168\251\184\000\245\194\063\172\141\194\186\137\111\195\017\190\063\194" ..
		-- tex:"973fdf6b158643f45347a8fbb800f5c2"; x:-70.836426; y:-239.538010; z:-47.935616
		"\085\105\023\198\022\147\019\111\125\239\057\149\205\094\158\240\072\080\010\066\085\186\014\196\076\000\045\194" ..
		-- tex:"556917c61693136f7def3995cd5e9ef0"; x:34.578403; y:-570.911499; z:-43.250294
		"\076\180\218\046\019\060\060\140\064\091\234\214\171\045\001\242\050\003\003\067\071\167\003\196\231\035\041\194" ..
		-- tex:"4cb4da2e133c3c8c405bead6ab2d01f2"; x:131.012497; y:-526.613770; z:-42.285065
		"\157\033\093\255\118\042\029\146\083\180\255\130\005\238\128\122\023\110\035\068\196\120\020\067\020\018\012\194" ..
		-- tex:"9d215dff762a1d9253b4ff8205ee807a"; x:653.720215; y:148.471756; z:-35.017658
		"\222\093\196\073\012\144\015\234\253\072\152\221\049\248\142\140\013\206\152\067\103\106\202\195\185\164\205\193" ..
		-- tex:"de5dc4490c900feafd4898dd31f88e8c"; x:305.609802; y:-404.831299; z:-25.705433
		"\060\044\087\033\132\008\161\216\103\147\111\220\129\158\141\018\173\247\114\067\182\001\137\195\031\115\188\193" ..
		-- tex:"3c2c57218408a1d867936fdc819e8d12"; x:242.967499; y:-274.013397; z:-23.556213
		"\241\112\189\143\155\195\146\124\100\057\211\154\104\211\001\210\024\089\182\066\079\011\164\195\222\121\177\193" ..
		-- tex:"f170bd8f9bc3927c6439d39a68d301d2"; x:91.174019; y:-328.088379; z:-22.184507
		"\132\208\169\043\130\063\166\152\140\100\141\028\183\061\033\105\025\239\047\067\185\111\158\195\153\031\148\193" ..
		-- tex:"84d0a92b823fa6988c648d1cb73d2169"; x:175.933990; y:-316.872864; z:-18.515430
		"\166\136\002\083\046\189\080\100\027\194\103\154\013\215\150\080\023\217\079\194\095\235\249\194\246\007\144\193" ..
		-- tex:"a68802532ebd50641bc2679a0dd79650"; x:-51.962006; y:-124.959717; z:-18.003889
		"\172\190\044\064\072\055\242\087\090\198\097\024\227\033\091\038\172\088\009\067\063\198\081\194\047\006\141\193" ..
		-- tex:"acbe2c404837f2575ac66118e3215b26"; x:137.346390; y:-52.443604; z:-17.628021
		"\186\049\190\021\159\215\247\173\006\097\229\168\110\204\208\182\085\173\179\194\204\224\122\194\104\160\071\193",
		-- tex:"ba31be159fd7f7ad0661e5a86eccd0b6"; x:-89.838547; y:-62.719532; z:-12.476663
	["Ruins of Ahn'Qiraj"] = 
		"\052\089\231\066\186\082\009\200\228\242\174\183\044\128\069\205\255\255\215\069\255\255\059\198\000\000\000\000" ..
		-- tex:"3459e742ba5209c8e4f2aeb72c8045cd"; x:6912.000000; y:-12032.000000
		"\253\229\219\107\114\076\128\096\198\104\142\201\199\255\214\141\255\255\215\069\255\255\063\198\000\000\000\000" ..
		-- tex:"fde5db6b724c8060c6688ec9c7ffd68d"; x:6912.000000; y:-12288.000000
		"\111\179\176\123\106\205\007\035\012\125\204\092\208\060\056\125\255\255\215\069\255\255\067\198\000\000\000\000" ..
		-- tex:"6fb3b07b6acd07230c7dcc5cd03c387d"; x:6912.000000; y:-12544.000000
		"\071\198\049\191\113\032\094\018\252\187\238\168\132\104\050\206\255\255\215\069\255\255\071\198\000\000\000\000" ..
		-- tex:"47c631bf71205e12fcbbeea8846832ce"; x:6912.000000; y:-12800.000000
		"\241\129\058\044\158\088\118\246\142\037\075\109\251\100\076\039\255\255\223\069\255\255\059\198\000\000\000\000" ..
		-- tex:"f1813a2c9e5876f68e254b6dfb644c27"; x:7168.000000; y:-12032.000000
		"\161\069\131\065\118\221\120\112\039\034\207\114\198\043\102\083\255\255\223\069\255\255\063\198\000\000\000\000" ..
		-- tex:"a145834176dd78702722cf72c62b6653"; x:7168.000000; y:-12288.000000
		"\007\172\223\022\168\192\033\214\241\225\094\246\157\057\213\113\255\255\223\069\255\255\067\198\000\000\000\000" ..
		-- tex:"07acdf16a8c021d6f1e15ef69d39d571"; x:7168.000000; y:-12544.000000
		"\250\085\114\065\135\184\185\001\213\253\166\118\240\030\105\218\255\255\223\069\255\255\071\198\000\000\000\000" ..
		-- tex:"fa55724187b8b901d5fda676f01e69da"; x:7168.000000; y:-12800.000000
		"\077\232\042\158\043\233\072\176\247\212\190\196\010\045\228\216\255\255\231\069\255\255\059\198\000\000\000\000" ..
		-- tex:"4de82a9e2be948b0f7d4bec40a2de4d8"; x:7424.000000; y:-12032.000000
		"\248\164\210\252\004\214\203\126\141\251\220\124\116\028\209\162\255\255\231\069\255\255\063\198\000\000\000\000" ..
		-- tex:"f8a4d2fc04d6cb7e8dfbdc7c741cd1a2"; x:7424.000000; y:-12288.000000
		"\189\223\003\107\140\205\140\145\242\196\039\178\108\114\219\203\255\255\231\069\255\255\067\198\000\000\000\000" ..
		-- tex:"bddf036b8ccd8c91f2c427b26c72dbcb"; x:7424.000000; y:-12544.000000
		"\247\115\244\102\162\123\199\106\034\104\062\167\215\032\199\220\255\255\231\069\255\255\071\198\000\000\000\000",
		-- tex:"f773f466a27bc76a22683ea7d720c7dc"; x:7424.000000; y:-12800.000000
	["Scholomance"] = 
		"\015\101\159\249\232\168\141\146\172\046\003\121\197\190\105\222\026\113\210\194\068\143\125\067\054\165\026\195" ..
		-- tex:"0f659ff9e8a88d92ac2e0379c5be69de"; x:-105.220909; y:253.559647; z:-154.645370
		"\096\116\255\060\157\166\057\132\007\126\120\164\232\134\082\052\068\210\129\195\048\229\054\067\177\038\023\195" ..
		-- tex:"6074ff3c9da63984077e78a4e8865234"; x:-259.642731; y:182.895279; z:-151.151154
		"\223\070\074\051\135\123\101\056\012\031\236\072\036\131\127\170\084\250\009\194\122\086\034\067\056\177\022\195" ..
		-- tex:"df464a33877b65380c1fec4824837faa"; x:-34.494465; y:162.337814; z:-150.692276
		"\078\247\052\194\132\249\152\169\163\033\073\079\087\089\210\149\117\049\008\195\181\040\023\067\252\059\017\195" ..
		-- tex:"4ef734c284f998a9a321494f5759d295"; x:-136.193207; y:151.159027; z:-145.234329
		"\243\222\093\148\144\073\005\235\183\078\034\161\044\178\121\098\158\085\206\066\133\173\188\194\033\079\001\195" ..
		-- tex:"f3de5d94904905ebb74e22a12cb27962"; x:103.167229; y:-94.338913; z:-129.309113
		"\236\232\049\040\057\035\011\007\063\118\213\248\125\026\147\016\099\247\037\067\129\095\254\194\058\060\001\195" ..
		-- tex:"ece8312839230b073f76d5f87d1a9310"; x:165.966370; y:-127.186539; z:-129.235275
		"\058\143\141\247\064\120\188\114\092\243\125\239\168\125\238\175\022\208\137\195\011\109\043\067\026\195\253\194" ..
		-- tex:"3a8f8df74078bc725cf37defa87deeaf"; x:-275.625702; y:171.425964; z:-126.881065
		"\068\094\063\023\102\129\028\050\148\220\072\100\032\119\074\195\017\070\233\194\077\115\134\067\021\195\253\194" ..
		-- tex:"445e3f1766811c3294dc486420774ac3"; x:-116.636856; y:268.900818; z:-126.881027
		"\078\156\237\126\230\134\213\017\234\025\192\000\063\236\230\026\067\156\147\193\171\001\057\067\006\163\253\194" ..
		-- tex:"4e9ced7ee686d511ea19c0003fece61a"; x:-18.451302; y:185.006531; z:-126.818413
		"\087\212\079\033\078\053\226\210\097\022\147\184\203\032\207\224\169\027\179\194\016\208\189\066\209\153\237\194" ..
		-- tex:"57d44f214e35e2d2611693b8cb20cfe0"; x:-89.554031; y:94.906380; z:-118.800430
		"\004\026\181\213\081\176\231\068\093\173\006\135\100\066\002\085\069\222\071\194\044\004\070\195\252\168\224\194" ..
		-- tex:"041ab5d551b0e7445dad068764420255"; x:-49.967064; y:-198.016312; z:-112.330055
		"\243\102\151\169\019\027\240\237\246\127\145\233\028\070\248\250\199\153\091\195\049\181\066\195\078\066\209\194" ..
		-- tex:"f36697a9131bf0edf67f91e91c46f8fa"; x:-219.600708; y:-194.707794; z:-104.629509
		"\008\104\054\216\129\020\092\103\168\049\023\168\151\094\055\041\051\173\145\195\117\226\021\195\032\024\209\194" ..
		-- tex:"086836d881145c67a83117a8975e3729"; x:-291.353149; y:-149.884613; z:-104.547127
		"\161\235\237\212\066\184\071\136\020\242\096\240\117\243\179\165\167\045\123\194\228\011\018\194\094\187\203\194" ..
		-- tex:"a1ebedd442b8478814f260f075f3b3a5"; x:-62.794586; y:-36.511616; z:-101.865959
		"\116\149\244\238\223\085\220\096\224\198\108\229\008\077\250\055\148\155\179\195\142\070\042\065\221\076\186\194" ..
		-- tex:"7495f4eedf55dc60e0c66ce5084dfa37"; x:-359.215485; y:10.642226; z:-93.150131
		"\177\055\060\214\207\038\034\202\253\065\174\124\226\026\085\027\207\191\053\195\221\093\018\195\220\104\175\194" ..
		-- tex:"b1373cd6cf2622cafd41ae7ce21a551b"; x:-181.749268; y:-146.366669; z:-87.704811
		"\046\122\089\215\120\255\231\019\207\033\184\251\002\158\108\180\043\119\147\195\192\063\119\194\061\140\154\194" ..
		-- tex:"2e7a59d778ffe713cf21b8fb029e6cb4"; x:-294.931030; y:-61.812260; z:-77.273911
		"\054\161\032\224\113\176\220\230\125\126\175\215\170\072\101\093\157\180\140\195\088\122\252\194\011\211\153\194" ..
		-- tex:"36a120e071b0dce67d7eafd7aa48655d"; x:-281.411072; y:-126.238960; z:-76.912201
		"\093\206\243\078\048\216\187\115\240\118\099\034\205\246\079\226\055\226\082\195\221\021\171\066\097\134\132\194" ..
		-- tex:"5dcef34e30d8bb73f0766322cdf64fe2"; x:-210.883667; y:85.542709; z:-66.262466
		"\252\226\194\119\147\079\115\002\094\069\030\049\111\151\152\229\159\214\251\194\192\115\069\194\229\175\032\194" ..
		-- tex:"fce2c277934f73025e451e316f9798e5"; x:-125.919189; y:-49.363041; z:-40.171776
		"\105\052\071\013\022\196\136\059\217\230\141\188\234\243\203\199\038\021\135\194\174\069\081\194\202\035\120\192",
		-- tex:"6934470d16c4883bd9e68dbceaf3cbc7"; x:-67.541313; y:-52.318050; z:-3.877185
	["Serpentshrine Cavern"] = 
		"\043\067\108\191\238\115\035\126\168\017\124\071\186\026\209\031\089\136\020\196\080\236\003\068\230\220\141\195" ..
		-- tex:"2b436cbfee73237ea8117c47ba1ad11f"; x:-594.130493; y:527.692387; z:-283.725800
		"\091\184\063\061\164\176\029\109\213\041\226\066\045\037\224\108\207\066\164\194\003\020\123\065\230\220\141\195" ..
		-- tex:"5bb83f3da4b01d6dd529e2422d25e06c"; x:-82.130493; y:15.692387; z:-283.725800
		"\242\119\155\201\147\243\197\005\048\093\141\066\161\239\153\188\179\016\169\195\040\246\193\068\230\220\141\195" ..
		-- tex:"f2779bc993f3c505305d8d42a1ef99bc"; x:-338.130493; y:1551.692387; z:-283.725800
		"\179\007\197\096\026\075\064\002\207\137\131\159\034\201\196\210\179\016\169\195\040\246\161\068\230\220\141\195" ..
		-- tex:"b307c5601a4b4002cf89839f22c9c4d2"; x:-338.130493; y:1295.692387; z:-283.725800
		"\106\102\106\119\238\082\037\072\009\234\159\156\064\180\083\100\207\066\164\194\160\216\135\067\230\220\141\195" ..
		-- tex:"6a666a77ee52254809ea9f9c40b45364"; x:-82.130493; y:271.692387; z:-283.725800
		"\150\230\231\056\163\010\201\139\126\202\062\213\238\232\067\229\207\066\164\194\080\236\067\068\230\220\141\195" ..
		-- tex:"96e6e738a30ac98b7eca3ed5eee843e5"; x:-82.130493; y:783.692387; z:-283.725800
		"\235\140\205\229\143\059\010\051\012\014\255\101\155\006\004\124\207\066\164\194\080\236\003\068\230\220\141\195" ..
		-- tex:"eb8ccde58f3b0a330c0eff659b06047c"; x:-82.130493; y:527.692387; z:-283.725800
		"\242\064\054\248\227\076\110\235\154\221\175\234\080\091\080\247\207\066\164\194\040\246\129\068\230\220\141\195" ..
		-- tex:"f24036f8e34c6eeb9addafea505b50f7"; x:-82.130493; y:1039.692387; z:-283.725800
		"\044\180\001\098\129\072\001\208\234\041\245\137\233\059\252\188\179\016\169\195\040\246\129\068\230\220\141\195" ..
		-- tex:"2cb40162814801d0ea29f589e93bfcbc"; x:-338.130493; y:1039.692387; z:-283.725800
		"\105\062\206\162\045\130\025\165\034\183\162\161\178\044\178\024\179\016\169\195\080\236\003\068\230\220\141\195" ..
		-- tex:"693ecea22d8219a522b7a2a1b22cb218"; x:-338.130493; y:527.692387; z:-283.725800
		"\016\213\252\100\143\103\211\191\168\162\166\036\110\249\033\175\089\136\020\196\040\246\129\068\230\220\141\195" ..
		-- tex:"10d5fc648f67d3bfa8a2a6246ef921af"; x:-594.130493; y:1039.692387; z:-283.725800
		"\021\194\113\228\021\129\176\109\142\090\013\059\226\247\140\241\089\136\020\196\080\236\067\068\230\220\141\195" ..
		-- tex:"15c271e41581b06d8e5a0d3be2f78cf1"; x:-594.130493; y:783.692387; z:-283.725800
		"\150\057\146\028\171\175\230\006\082\237\125\153\210\117\068\216\179\016\169\195\080\236\067\068\230\220\141\195" ..
		-- tex:"9639921cabafe60652ed7d99d27544d8"; x:-338.130493; y:783.692387; z:-283.725800
		"\026\209\046\011\247\160\163\036\117\218\051\005\016\225\235\118\089\136\020\196\040\246\161\068\230\220\141\195" ..
		-- tex:"1ad12e0bf7a0a32475da330510e1eb76"; x:-594.130493; y:1295.692387; z:-283.725800
		"\132\090\025\008\145\206\117\221\042\080\048\015\239\120\188\094\179\016\169\195\160\216\135\067\230\220\141\195" ..
		-- tex:"845a190891ce75dd2a50300fef78bc5e"; x:-338.130493; y:271.692387; z:-283.725800
		"\050\017\243\066\162\241\026\229\119\027\196\239\126\025\126\190\179\016\169\195\003\020\123\065\230\220\141\195" ..
		-- tex:"3211f342a2f11ae5771bc4ef7e197ebe"; x:-338.130493; y:15.692387; z:-283.725800
		"\214\163\254\199\121\177\202\130\176\111\090\115\003\038\225\125\089\136\020\196\160\216\135\067\230\220\141\195" ..
		-- tex:"d6a3fec779b1ca82b06f5a730326e17d"; x:-594.130493; y:271.692387; z:-283.725800
		"\250\060\022\162\096\181\143\249\074\009\123\165\249\118\027\105\207\066\164\194\040\246\161\068\230\220\141\195" ..
		-- tex:"fa3c16a260b58ff94a097ba5f9761b69"; x:-82.130493; y:1295.692387; z:-283.725800
		"\074\008\000\183\211\076\117\014\175\238\233\139\181\035\104\215\151\222\045\067\003\020\123\065\230\220\141\195" ..
		-- tex:"4a0800b7d34c750eafeee98bb52368d7"; x:173.869507; y:15.692387; z:-283.725800
		"\151\064\252\055\013\057\150\193\037\201\143\140\224\118\161\065\075\239\214\067\040\246\129\068\230\220\141\195" ..
		-- tex:"9740fc370d3996c125c98f8ce076a141"; x:429.869507; y:1039.692387; z:-283.725800
		"\043\048\092\017\084\212\046\025\058\138\234\145\168\105\054\252\075\239\214\067\080\236\067\068\230\220\141\195" ..
		-- tex:"2b305c1154d42e193a8aea91a86936fc"; x:429.869507; y:783.692387; z:-283.725800
		"\191\044\006\053\116\084\106\153\040\174\187\165\140\094\088\163\075\239\214\067\080\236\003\068\230\220\141\195" ..
		-- tex:"bf2c063574546a9928aebba58c5e58a3"; x:429.869507; y:527.692387; z:-283.725800
		"\030\234\127\066\213\128\080\159\090\143\251\236\085\029\237\177\075\239\214\067\040\246\161\068\230\220\141\195" ..
		-- tex:"1eea7f42d580509f5a8ffbec551dedb1"; x:429.869507; y:1295.692387; z:-283.725800
		"\024\210\046\022\232\016\232\104\144\022\077\180\246\128\115\225\165\119\043\068\080\236\067\068\230\220\141\195" ..
		-- tex:"18d22e16e810e86890164db4f68073e1"; x:685.869507; y:783.692387; z:-283.725800
		"\107\059\070\048\155\100\058\075\212\028\171\116\204\235\064\005\165\119\043\068\080\236\003\068\230\220\141\195" ..
		-- tex:"6b3b46309b643a4bd41cab74cceb4005"; x:685.869507; y:527.692387; z:-283.725800
		"\224\064\126\076\249\140\054\135\121\108\212\201\017\232\208\168\207\066\164\194\040\246\193\068\230\220\141\195" ..
		-- tex:"e0407e4cf98c3687796cd4c911e8d0a8"; x:-82.130493; y:1551.692387; z:-283.725800
		"\068\153\186\171\055\208\019\125\222\076\222\003\211\237\127\083\075\239\214\067\160\216\135\067\230\220\141\195" ..
		-- tex:"4499baab37d0137dde4cde03d3ed7f53"; x:429.869507; y:271.692387; z:-283.725800
		"\242\143\021\140\075\087\230\155\156\187\235\094\013\087\253\237\151\222\045\067\040\246\193\068\230\220\141\195" ..
		-- tex:"f28f158c4b57e69b9cbbeb5e0d57fded"; x:173.869507; y:1551.692387; z:-283.725800
		"\255\058\026\189\120\048\114\065\227\103\137\128\098\053\159\069\151\222\045\067\080\236\003\068\230\220\141\195" ..
		-- tex:"ff3a1abd78307241e367898062359f45"; x:173.869507; y:527.692387; z:-283.725800
		"\138\049\088\072\095\138\150\069\079\032\171\236\242\112\212\242\151\222\045\067\160\216\135\067\230\220\141\195" ..
		-- tex:"8a3158485f8a96454f20abecf270d4f2"; x:173.869507; y:271.692387; z:-283.725800
		"\126\072\057\216\255\216\050\182\186\046\026\190\091\217\232\044\075\239\214\067\003\020\123\065\230\220\141\195" ..
		-- tex:"7e4839d8ffd832b6ba2e1abe5bd9e82c"; x:429.869507; y:15.692387; z:-283.725800
		"\249\161\184\072\102\116\051\088\092\136\215\136\195\090\065\127\151\222\045\067\080\236\067\068\230\220\141\195" ..
		-- tex:"f9a1b848667433585c88d788c35a417f"; x:173.869507; y:783.692387; z:-283.725800
		"\200\221\157\233\106\227\003\085\227\241\130\184\058\081\072\164\151\222\045\067\040\246\161\068\230\220\141\195" ..
		-- tex:"c8dd9de96ae30355e3f182b83a5148a4"; x:173.869507; y:1295.692387; z:-283.725800
		"\102\025\210\051\076\131\112\137\236\240\070\181\088\016\050\178\151\222\045\067\040\246\129\068\230\220\141\195" ..
		-- tex:"6619d2334c837089ecf046b5581032b2"; x:173.869507; y:1039.692387; z:-283.725800
		"\156\085\081\105\067\126\113\203\163\048\004\121\114\027\059\129\165\119\043\068\040\246\129\068\230\220\141\195" ..
		-- tex:"9c555169437e71cba3300479721b3b81"; x:685.869507; y:1039.692387; z:-283.725800
		"\154\199\029\183\069\105\044\174\024\164\240\217\130\106\184\049\067\025\036\195\141\048\056\194\035\079\014\195" ..
		-- tex:"9ac71db745692cae18a4f0d9826ab831"; x:-164.098694; y:-46.047417; z:-142.309143
		"\204\075\213\203\206\093\191\220\231\152\246\034\231\144\106\161\209\062\010\195\249\213\002\069\056\101\251\194" ..
		-- tex:"cc4bd5cbce5dbfdce798f622e7906aa1"; x:-138.245392; y:2093.373413; z:-125.697701
		"\193\164\188\049\082\167\094\190\252\041\252\197\169\029\074\199\209\062\010\195\242\171\229\068\056\101\251\194" ..
		-- tex:"c1a4bc3152a75ebefc29fcc5a91d4ac7"; x:-138.245392; y:1837.373413; z:-125.697701
		"\070\141\059\109\120\144\230\195\118\153\028\049\138\004\247\166\091\130\235\066\242\171\197\068\056\101\251\194" ..
		-- tex:"468d3b6d7890e6c376991c318a04f7a6"; x:117.754608; y:1581.373413; z:-125.697701
		"\037\068\001\019\146\109\152\009\081\050\117\006\254\145\088\240\091\130\235\066\242\171\229\068\056\101\251\194" ..
		-- tex:"25440113926d980951327506fe9158f0"; x:117.754608; y:1837.373413; z:-125.697701
		"\003\059\137\186\162\081\056\064\234\021\014\097\117\145\030\093\209\062\010\195\242\171\197\068\056\101\251\194" ..
		-- tex:"033b89baa2513840ea150e6175911e5d"; x:-138.245392; y:1581.373413; z:-125.697701
		"\236\202\236\247\204\061\177\252\117\040\170\010\057\076\111\241\104\031\197\195\242\171\229\068\056\101\251\194" ..
		-- tex:"eccaecf7cc3db1fc7528aa0a394c6ff1"; x:-394.245392; y:1837.373413; z:-125.697701
		"\083\158\124\233\228\182\028\154\106\248\057\089\148\210\031\083\104\031\197\195\249\213\002\069\056\101\251\194" ..
		-- tex:"539e7ce9e4b61c9a6af8395994d21f53"; x:-394.245392; y:2093.373413; z:-125.697701
		"\169\157\144\162\088\044\066\067\203\117\173\147\088\001\177\143\104\031\197\195\242\171\197\068\056\101\251\194" ..
		-- tex:"a99d90a2582c4243cb75ad935801b18f"; x:-394.245392; y:1581.373413; z:-125.697701
		"\242\153\204\119\250\059\087\150\138\150\231\085\205\195\167\128\091\130\235\066\249\213\002\069\056\101\251\194" ..
		-- tex:"f299cc77fa3b57968a96e755cdc3a780"; x:117.754608; y:2093.373413; z:-125.697701
		"\077\134\160\002\165\133\005\045\024\036\204\195\215\038\174\002\216\151\039\196\061\028\165\068\026\176\224\193" ..
		-- tex:"4d86a002a585052d1824ccc3d726ae02"; x:-670.372620; y:1320.882568; z:-28.085989
		"\149\231\075\252\099\090\159\082\171\010\001\133\127\113\061\077\216\151\103\196\061\028\165\068\026\176\224\193" ..
		-- tex:"95e74bfc635a9f52ab0a01857f713d4d"; x:-926.372620; y:1320.882568; z:-28.085989
		"\061\144\229\134\048\243\020\147\117\220\075\209\182\093\252\062\218\073\128\196\198\242\065\068\074\091\223\193" ..
		-- tex:"3d90e58630f3149375dc4bd1b65dfc3e"; x:-1026.307983; y:775.793396; z:-27.919577
		"\149\079\106\171\199\116\088\160\183\030\250\217\117\231\159\018\066\038\024\196\133\174\160\068\051\088\211\193" ..
		-- tex:"954f6aabc77458a0b71efad975e79f12"; x:-608.597839; y:1285.453857; z:-26.418068
		"\036\072\213\076\192\082\102\187\226\206\032\203\235\064\173\057\039\092\094\196\099\007\135\068\004\250\210\193" ..
		-- tex:"2448d54cc05266bbe2ce20cbeb40ad39"; x:-889.439941; y:1080.230896; z:-26.372080
		"\215\037\220\138\038\211\117\223\111\182\213\024\173\115\054\029\039\092\094\196\198\014\078\068\004\250\210\193" ..
		-- tex:"d725dc8a26d375df6fb6d518ad73361d"; x:-889.439941; y:824.230896; z:-26.372080
		"\091\092\203\131\227\206\171\071\239\235\082\026\023\231\173\206\019\046\143\196\099\007\135\068\004\250\210\193" ..
		-- tex:"5b5ccb83e3ceab47efeb521a17e7adce"; x:-1145.439941; y:1080.230896; z:-26.372080
		"\048\095\172\029\019\004\141\044\159\220\142\179\039\002\155\221\019\046\143\196\198\014\078\068\004\250\210\193" ..
		-- tex:"305fac1d13048d2c9fdc8eb327029bdd"; x:-1145.439941; y:824.230896; z:-26.372080
		"\053\024\149\147\162\053\169\076\105\071\079\197\224\044\063\174\242\120\143\196\178\145\150\068\168\129\101\193" ..
		-- tex:"35189593a235a94c69474fc5e02c3fae"; x:-1147.779663; y:1204.553101; z:-14.344155
		"\175\208\249\155\254\050\255\239\204\165\080\179\107\144\195\080\242\120\143\196\178\145\182\068\168\129\101\193" ..
		-- tex:"afd0f99bfe32ffefcca550b36b90c350"; x:-1147.779663; y:1460.553101; z:-14.344155
		"\113\192\056\124\154\197\011\086\149\114\254\135\061\252\036\227\212\022\057\196\087\137\235\067\165\113\204\189" ..
		-- tex:"71c0387c9ac50b569572fe873dfc24e3"; x:-740.356750; y:471.072998; z:-0.099826
		"\098\090\253\192\098\118\135\252\231\041\115\160\219\071\093\175\206\138\096\196\040\069\082\068\159\019\133\065" ..
		-- tex:"625afdc0627687fce72973a0db475daf"; x:-898.168884; y:841.080627; z:16.634583
		"\084\160\255\062\110\172\057\199\044\210\255\192\075\245\070\090\187\070\017\196\170\116\136\068\155\133\012\066" ..
		-- tex:"54a0ff3e6eac39c72cd2ffc04bf5465a"; x:-581.105225; y:1091.645874; z:35.130478
		"\219\219\000\088\074\185\238\193\105\065\200\130\102\052\181\005\187\070\017\196\085\233\080\068\155\133\012\066" ..
		-- tex:"dbdb00584ab9eec16941c8826634b505"; x:-581.105225; y:835.645874; z:35.130478
		"\051\198\012\007\056\064\034\174\129\120\252\121\028\120\034\222\187\070\081\196\085\233\016\068\155\133\012\066" ..
		-- tex:"33c60c07384022ae8178fc791c7822de"; x:-837.105225; y:579.645874; z:35.130478
		"\195\099\066\113\088\142\089\218\065\050\045\056\139\238\137\066\187\070\081\196\170\116\136\068\155\133\012\066" ..
		-- tex:"c3634271588e59da41322d388bee8942"; x:-837.105225; y:1091.645874; z:35.130478
		"\094\244\018\206\059\094\212\032\077\225\045\098\214\188\154\012\187\070\081\196\085\233\080\068\155\133\012\066" ..
		-- tex:"5ef412ce3b5ed4204de12d62d6bc9a0c"; x:-837.105225; y:835.645874; z:35.130478
		"\036\144\147\212\051\086\252\133\042\141\175\241\034\034\113\218\187\070\017\196\085\233\016\068\155\133\012\066" ..
		-- tex:"249093d43356fc852a8daff1222271da"; x:-581.105225; y:579.645874; z:35.130478
		"\046\203\155\143\163\167\240\116\021\250\019\222\239\131\034\124\233\036\075\195\061\167\102\195\038\086\197\068" ..
		-- tex:"2ecb9b8fa3a7f07415fa13deef83227c"; x:-203.144196; y:-230.653290; z:1578.692261
		"\243\013\001\009\097\244\201\118\012\105\000\238\006\028\203\187\087\108\083\066\015\198\202\065\038\086\197\068" ..
		-- tex:"f30d010961f4c9760c6900ee061ccbbb"; x:52.855804; y:25.346710; z:1578.692261
		"\222\085\164\077\184\043\216\072\066\174\090\006\000\160\159\109\138\109\154\067\015\198\202\065\038\086\197\068" ..
		-- tex:"de55a44db82bd84842ae5a0600a09f6d"; x:308.855804; y:25.346710; z:1578.692261
		"\233\069\063\045\099\033\158\232\101\191\133\025\175\130\172\085\087\108\083\066\061\167\102\195\038\086\197\068" ..
		-- tex:"e9453f2d63219ee865bf8519af82ac55"; x:52.855804; y:-230.653290; z:1578.692261
		"\160\158\034\108\008\135\170\105\084\120\209\060\195\235\036\023\138\109\154\067\061\167\102\195\038\086\197\068" ..
		-- tex:"a09e226c0887aa695478d13cc3eb2417"; x:308.855804; y:-230.653290; z:1578.692261
		"\143\178\150\022\099\086\204\000\027\204\209\045\077\124\196\098\233\036\075\195\015\198\202\065\038\086\197\068",
		-- tex:"8fb296166356cc001bccd12d4d7cc462"; x:-203.144196; y:25.346710; z:1578.692261
	["Sethekk Halls"] = 
		"\178\186\076\162\254\031\118\118\021\027\019\231\087\229\242\166\167\157\142\194\114\246\195\195\235\213\212\192" ..
		-- tex:"b2ba4ca2fe1f7676151b13e757e5f2a6"; x:-71.307922; y:-391.925385; z:-6.651114
		"\188\210\231\129\244\240\201\100\138\051\148\103\204\048\242\155\105\167\163\195\114\246\195\195\235\213\212\192" ..
		-- tex:"bcd2e781f4f0c9648a339467cc30f29b"; x:-327.307922; y:-391.925385; z:-6.651114
		"\210\017\050\014\163\247\114\076\029\060\153\179\237\116\092\068\167\157\142\194\229\236\007\195\235\213\212\192" ..
		-- tex:"d211320ea3f7724c1d3c99b3ed745c44"; x:-71.307922; y:-135.925385; z:-6.651114
		"\186\032\019\016\033\171\115\194\176\016\113\008\055\203\037\025\105\167\163\195\229\236\007\195\235\213\212\192" ..
		-- tex:"ba20131021ab73c2b010710837cb2519"; x:-327.307922; y:-135.925385; z:-6.651114
		"\253\131\135\048\198\240\174\134\022\017\215\209\135\101\060\141\000\196\202\067\039\147\217\195\252\193\098\192" ..
		-- tex:"fd838730c6f0ae861611d7d187653c8d"; x:405.531281; y:-435.149658; z:-3.543090
		"\246\071\044\236\240\029\122\015\063\149\234\007\154\106\054\224\202\143\141\066\223\002\136\195\166\191\054\192" ..
		-- tex:"f6472cecf01d7a0f3f95ea079a6a36e0"; x:70.780846; y:-272.022461; z:-2.855448
		"\188\116\145\206\248\233\233\203\228\066\168\205\074\231\202\076\029\140\135\065\147\253\183\193\051\052\234\191" ..
		-- tex:"bc7491cef8e9e9cbe442a8cd4ae7ca4c"; x:16.943417; y:-22.998817; z:-1.829718
		"\226\067\056\108\191\250\043\006\246\118\114\250\237\140\194\111\008\092\089\067\246\051\229\195\117\110\231\191" ..
		-- tex:"e243386cbffa2b06f67672faed8cc26f"; x:217.359512; y:-458.405975; z:-1.808059
		"\130\059\113\254\060\118\227\049\106\127\010\197\170\113\049\030\075\221\219\194\117\063\248\194\064\223\066\189" ..
		-- tex:"823b71fe3c76e3316a7f0ac5aa71311e"; x:-109.932220; y:-124.123947; z:-0.047576
		"\154\157\058\113\252\161\234\117\101\010\015\216\227\179\151\190\002\070\237\066\212\246\184\195\211\230\048\189" ..
		-- tex:"9a9d3a71fca1ea75650a0fd8e3b397be"; x:118.636742; y:-369.928375; z:-0.043189
		"\208\116\127\192\182\121\212\018\221\110\203\167\214\121\141\136\179\016\070\065\081\056\096\195\009\178\040\189" ..
		-- tex:"d0747fc0b679d412dd6ecba7d6798d88"; x:12.379078; y:-224.220001; z:-0.041185
		"\099\072\006\113\019\225\215\148\137\180\003\153\032\197\081\129\218\053\225\194\051\092\164\195\217\152\038\189" ..
		-- tex:"6348067113e1d79489b4039920c55181"; x:-112.605186; y:-328.720337; z:-0.040673
		"\066\198\077\124\250\023\222\156\249\023\219\201\124\019\035\200\078\095\179\067\210\247\184\195\239\116\011\189" ..
		-- tex:"42c64d7cfa17de9cf917dbc97c1323c8"; x:358.744598; y:-369.936127; z:-0.034047
		"\191\240\177\019\219\092\183\098\110\011\089\120\211\092\059\246\218\053\225\194\090\009\199\195\109\243\161\061" ..
		-- tex:"bff0b113db5cb7626e0b5978d35c3bf6"; x:-112.605186; y:-398.073090; z:0.079078
		"\188\058\071\078\220\016\168\159\210\179\101\165\051\241\200\148\146\140\128\194\169\234\250\195\127\094\056\066" ..
		-- tex:"bc3a474edc10a89fd2b365a533f1c894"; x:-64.274559; y:-501.833313; z:46.092285
		"\023\046\135\145\198\083\202\018\154\006\007\146\125\042\129\165\182\185\063\067\084\117\061\196\127\094\056\066" ..
		-- tex:"172e8791c653ca129a0607927d2a81a5"; x:191.725441; y:-757.833313; z:46.092285
		"\120\061\171\225\210\061\049\184\247\243\208\200\167\234\051\068\146\140\128\194\084\117\061\196\127\094\056\066" ..
		-- tex:"783dabe1d23d31b8f7f3d0c8a7ea3344"; x:-64.274559; y:-757.833313; z:46.092285
		"\159\115\172\222\050\096\251\146\228\061\081\132\048\129\149\019\182\185\063\067\169\234\250\195\127\094\056\066" ..
		-- tex:"9f73acde3260fb92e43d518430819513"; x:191.725441; y:-501.833313; z:46.092285
		"\240\006\090\044\057\062\104\179\047\185\193\040\246\198\091\198\138\207\156\067\179\155\054\196\134\174\058\066" ..
		-- tex:"f0065a2c393e68b32fb9c128f6c65bc6"; x:313.621429; y:-730.432861; z:46.670437
		"\065\030\199\137\121\209\103\017\043\199\136\162\198\161\240\163\182\036\057\195\091\066\039\196\015\224\071\066" ..
		-- tex:"411ec78979d167112bc788a2c6a1f0a3"; x:-185.143417; y:-669.036865; z:49.968811
		"\010\003\118\028\250\128\159\218\081\125\182\027\231\001\101\226\074\054\225\194\077\039\231\195\210\128\085\066" ..
		-- tex:"0a03761cfa809fda517db61be70165e2"; x:-112.606041; y:-462.307068; z:53.375805
		"\136\000\028\025\036\168\167\096\124\058\049\089\231\185\074\055\170\210\230\067\097\178\002\196\187\143\085\066" ..
		-- tex:"88001c1924a8a7607c3a3159e7b94a37"; x:461.645844; y:-522.787231; z:53.390366
		"\176\103\059\170\104\165\029\034\184\021\117\246\011\168\151\165\119\044\136\067\227\039\021\196\022\159\085\066" ..
		-- tex:"b0673baa68a51d22b81575f60ba897a5"; x:272.347412; y:-596.623291; z:53.405361
		"\047\199\008\013\136\046\073\055\136\090\163\125\104\095\108\124\088\239\168\065\051\039\021\196\025\159\085\066",
		-- tex:"2fc7080d882e4937885aa37d685f6c7c"; x:21.116869; y:-596.612549; z:53.405373
	["Shadow Labyrinth"] = 
		"\229\181\102\130\097\205\211\205\173\242\215\207\181\199\111\162\043\168\157\064\142\119\035\067\232\234\135\193" ..
		-- tex:"e5b5668261cdd3cdadf2d7cfb5c76fa2"; x:4.926779; y:163.467026; z:-16.989702
		"\232\168\029\197\240\179\009\169\198\227\026\172\177\160\144\227\043\168\157\064\225\016\185\194\232\234\135\193" ..
		-- tex:"e8a81dc5f0b309a9c6e31aacb1a090e3"; x:4.926779; y:-92.532974; z:-16.989702
		"\016\107\227\013\009\156\142\255\119\040\190\089\052\068\212\079\100\237\033\195\222\128\202\194\125\055\131\192" ..
		-- tex:"106be30d099c8eff7728be593444d44f"; x:-161.927322; y:-101.251701; z:-4.100524
		"\251\001\159\038\123\085\059\158\046\004\187\014\203\049\027\195\026\168\203\066\019\042\079\067\021\249\019\192" ..
		-- tex:"fb019f267b553b9e2e04bb0ecb311bc3"; x:101.828331; y:207.164368; z:-2.312078
		"\032\216\095\122\231\086\081\136\012\148\065\238\231\202\097\164\044\216\226\066\037\093\020\195\079\221\186\062" ..
		-- tex:"20d85f7ae75651880c9441eee7ca61a4"; x:113.422218; y:-148.363861; z:0.364970
		"\199\253\255\139\024\133\169\121\246\013\060\018\143\208\081\155\173\092\111\067\024\042\079\067\016\218\218\064" ..
		-- tex:"c7fdff8b1885a979f60d3c128fd0519b"; x:239.362030; y:207.164444; z:6.839119
		"\224\134\165\138\048\244\103\211\214\245\202\021\204\146\150\065\101\110\070\067\090\161\121\067\019\218\218\064" ..
		-- tex:"e086a58a30f467d3d6f5ca15cc929641"; x:198.431244; y:249.630295; z:6.839121
		"\001\167\235\135\032\211\171\030\129\028\049\001\144\169\228\195\068\116\111\067\049\093\020\195\211\222\218\064" ..
		-- tex:"01a7eb8720d3ab1e811c310190a9e4c3"; x:239.454178; y:-148.364044; z:6.839701
		"\065\064\134\053\126\185\247\032\164\078\222\244\081\247\113\132\252\133\070\067\061\151\028\195\213\222\218\064" ..
		-- tex:"414086357eb9f720a44edef451f77184"; x:198.523392; y:-156.590790; z:6.839702
		"\235\042\010\130\000\174\168\176\012\019\236\164\090\146\201\196\216\172\103\067\026\135\071\067\230\199\224\064" ..
		-- tex:"eb2a0a8200aea8b00c13eca45a92c9c4"; x:231.675186; y:199.527744; z:7.024402
		"\194\033\158\205\072\153\250\240\021\198\244\013\011\086\089\081\216\172\103\067\150\227\097\194\230\199\224\064" ..
		-- tex:"c2219ecd4899faf015c6f40d0b565951"; x:231.675186; y:-56.472256; z:7.024402
		"\029\246\250\059\046\170\168\164\206\018\177\133\177\008\144\184\105\205\041\068\095\136\229\066\232\199\224\064" ..
		-- tex:"1df6fa3b2eaaa8a4ce12b185b10890b8"; x:679.209595; y:114.766357; z:7.024403
		"\145\214\108\095\144\114\148\249\189\097\200\206\173\051\253\145\105\205\041\068\207\059\013\195\232\199\224\064" ..
		-- tex:"91d66c5f907294f9bd61c8cead33fd91"; x:679.209595; y:-141.233643; z:7.024403
		"\200\009\165\163\164\071\179\212\067\117\183\110\041\132\112\045\211\154\211\067\207\059\013\195\232\199\224\064" ..
		-- tex:"c809a5a3a447b3d44375b76e2984702d"; x:423.209595; y:-141.233643; z:7.024403
		"\033\116\231\132\180\030\101\053\051\156\067\241\046\064\248\031\211\154\211\067\095\136\229\066\232\199\224\064" ..
		-- tex:"2174e784b41e6535339c43f12e40f81f"; x:423.209595; y:114.766357; z:7.024403
		"\100\135\226\216\144\158\214\085\118\234\167\140\137\088\225\104\203\045\198\067\034\077\092\066\091\180\128\065" ..
		-- tex:"6487e2d8909ed65576eaa78c8958e168"; x:396.357788; y:55.075329; z:16.088066
		"\203\001\128\096\187\226\061\000\254\139\140\173\051\114\064\239\176\175\035\068\153\114\004\067\152\019\144\065" ..
		-- tex:"cb018060bbe23d00fe8b8cad337240ef"; x:654.745178; y:132.447662; z:18.009569
		"\039\133\233\124\243\075\231\213\052\209\098\117\196\034\155\126\176\175\099\068\076\057\194\067\152\019\144\065" ..
		-- tex:"2785e97cf34be7d534d16275c4229b7e"; x:910.745178; y:388.447662; z:18.009569
		"\121\228\180\181\248\101\169\162\038\036\034\099\016\122\219\197\176\175\099\068\153\114\004\067\152\019\144\065" ..
		-- tex:"79e4b4b5f865a9a226242263107adbc5"; x:910.745178; y:132.447662; z:18.009569
		"\091\243\195\114\195\128\153\083\114\237\190\047\218\046\254\125\176\175\035\068\076\057\194\067\152\019\144\065" ..
		-- tex:"5bf3c372c380995372edbe2fda2efe7d"; x:654.745178; y:388.447662; z:18.009569
		"\127\025\053\143\052\013\145\179\135\053\021\223\037\174\182\150\189\164\044\068\155\096\217\067\081\053\181\065" ..
		-- tex:"7f19358f340d91b3873515df25aeb696"; x:690.574097; y:434.754761; z:22.651035
		"\128\196\002\090\034\026\037\065\053\089\071\235\055\169\089\236\123\073\217\067\155\096\217\067\081\053\181\065" ..
		-- tex:"80c4025a221a2541355947eb37a959ec"; x:434.574097; y:434.754761; z:22.651035
		"\203\230\160\120\039\036\099\104\002\055\039\000\217\012\147\127\115\070\062\068\241\072\092\066\095\133\202\065" ..
		-- tex:"cbe6a0782724636802372700d90c937f"; x:761.100830; y:55.071236; z:25.315125
		"\147\145\001\046\211\014\142\042\176\132\119\237\202\026\004\250\117\070\062\068\081\151\201\067\120\133\202\065" ..
		-- tex:"9391012ed30e8e2ab08477edca1a04fa"; x:761.100952; y:403.182190; z:25.315172
		"\216\118\224\030\213\024\133\044\213\246\062\099\127\249\170\225\043\175\074\067\193\053\093\068\067\016\252\065" ..
		-- tex:"d876e01ed518852cd5f63e637ff9aae1"; x:202.684265; y:884.839966; z:31.507942
		"\161\212\211\008\230\235\107\115\046\243\189\160\131\081\040\111\043\175\074\067\193\053\029\068\067\016\252\065" ..
		-- tex:"a1d4d308e6eb6b732ef3bda08351286f"; x:202.684265; y:628.839966; z:31.507942
		"\033\161\087\191\156\209\112\115\004\205\122\056\084\042\180\176\144\012\145\067\231\045\252\067\183\112\008\066",
		-- tex:"21a157bf9cd1707304cd7a38542ab4b0"; x:290.098175; y:504.358643; z:34.110077
	["Shadowfang Keep"] = 
		"\225\167\238\044\164\163\012\131\156\208\136\254\161\146\218\235\069\104\187\195\072\228\103\195\249\154\154\192" ..
		-- tex:"e1a7ee2ca4a30c839cd088fea192daeb"; x:-374.814636; y:-231.891739; z:-4.831418
		"\031\218\034\073\092\024\100\046\239\193\108\227\181\200\219\141\045\115\180\195\049\188\202\194\195\115\151\192" ..
		-- tex:"1fda22495c18642eefc16ce3b5c8db8d"; x:-360.899841; y:-101.367569; z:-4.732882
		"\090\051\074\123\190\215\151\248\152\249\169\050\106\156\250\089\154\123\159\195\012\150\163\193\195\203\028\192" ..
		-- tex:"5a334a7bbed797f898f9a9326a9cfa59"; x:-318.965668; y:-20.448267; z:-2.449937
		"\149\253\105\087\099\142\078\042\231\185\041\209\121\223\077\220\249\034\022\195\142\011\143\194\205\055\134\191" ..
		-- tex:"95fd6957638e4e2ae7b929d179df4ddc"; x:-150.136627; y:-71.522575; z:-1.048578
		"\081\251\252\025\042\066\001\161\192\056\181\047\190\000\031\106\135\034\082\194\006\236\215\065\028\181\122\191" ..
		-- tex:"51fbfc192a4201a1c038b52fbe001f6a"; x:-52.533722; y:26.990248; z:-0.979326
		"\209\197\168\059\166\202\085\100\204\013\154\174\225\151\234\206\245\122\034\194\025\011\141\065\056\039\116\191" ..
		-- tex:"d1c5a83ba6ca5564cc0d9aaee197eace"; x:-40.620079; y:17.630421; z:-0.953723
		"\030\198\178\104\011\074\253\061\017\064\247\239\004\199\106\073\077\190\175\195\206\127\164\194\013\037\171\062" ..
		-- tex:"1ec6b2680b4afd3d1140f7ef04c76a49"; x:-351.486755; y:-82.249626; z:0.334267
		"\217\062\098\062\022\009\009\024\019\035\015\066\221\170\044\184\025\035\152\195\065\068\243\194\152\013\152\064" ..
		-- tex:"d93e623e1609091813230f42ddaa2cb8"; x:-304.274231; y:-121.633316; z:4.751660
		"\199\152\176\219\233\247\046\026\197\199\137\033\054\245\100\039\060\253\248\194\157\200\254\064\017\105\234\064" ..
		-- tex:"c798b0dbe9f72e1ac5c7892136f56427"; x:-124.494606; y:7.961989; z:7.325326
		"\246\170\097\047\180\086\052\105\007\207\021\162\219\079\029\205\090\080\169\194\008\181\139\194\199\118\240\064" ..
		-- tex:"f6aa612fb456346907cf15a2db4f1dcd"; x:-84.656944; y:-69.853584; z:7.514500
		"\097\225\113\203\020\146\175\168\008\230\023\134\119\061\165\076\066\207\184\195\080\013\128\195\109\142\255\064" ..
		-- tex:"61e171cb1492afa808e61786773da54c"; x:-369.619232; y:-256.104034; z:7.986136
		"\149\090\041\198\176\246\071\131\102\097\137\024\072\079\137\057\194\001\227\194\069\060\130\194\212\062\154\065" ..
		-- tex:"955a29c6b0f6478366618918484f8939"; x:-113.503441; y:-65.117722; z:19.280680
		"\195\080\021\165\226\212\178\156\193\252\081\008\159\027\243\108\133\034\082\194\095\046\210\065\022\027\163\065" ..
		-- tex:"c35015a5e2d4b29cc1fc51089f1bf36c"; x:-52.533714; y:26.272644; z:20.388227
		"\073\001\247\192\011\122\054\251\070\100\202\119\034\052\169\043\059\013\000\195\025\014\128\194\106\047\197\065" ..
		-- tex:"4901f7c00b7a36fb4664ca772234a92b"; x:-128.051697; y:-64.027542; z:24.648153
		"\243\076\210\185\001\097\242\146\179\205\232\111\125\025\233\122\164\099\179\195\190\252\138\195\218\225\211\065" ..
		-- tex:"f34cd2b90161f292b3cde86f7d19e97a"; x:-358.778473; y:-277.974579; z:26.485281
		"\169\094\031\046\108\205\001\203\193\100\186\249\057\008\201\101\186\116\168\195\185\252\138\195\077\237\211\065" ..
		-- tex:"a95e1f2e6ccd01cbc164baf93908c965"; x:-336.911957; y:-277.974426; z:26.490871
		"\055\131\097\007\207\032\231\189\118\249\079\049\073\058\039\189\097\068\192\195\185\252\138\195\085\237\211\065" ..
		-- tex:"37836107cf20e7bd76f94f31493a27bd"; x:-384.534241; y:-277.974426; z:26.490887
		"\060\250\026\168\126\076\144\169\227\001\180\140\045\195\090\248\191\001\227\194\037\188\181\193\030\010\212\065" ..
		-- tex:"3cfa1aa87e4c90a9e301b48c2dc35af8"; x:-113.503418; y:-22.716869; z:26.504942
		"\245\113\108\181\234\204\152\182\091\224\159\189\036\086\175\255\191\001\227\194\157\005\000\194\178\033\212\065" ..
		-- tex:"f5716cb5eacc98b65be09fbd2456afff"; x:-113.503418; y:-32.005486; z:26.516455
		"\131\078\128\237\166\013\187\101\218\168\077\055\244\155\165\095\193\099\179\195\209\084\125\194\089\104\212\065" ..
		-- tex:"834e80eda60dbb65daa84d37f49ba55f"; x:-358.779358; y:-63.332832; z:26.550953
		"\026\237\145\165\174\009\047\126\213\040\034\092\049\102\067\094\123\068\192\195\062\081\125\194\149\114\212\065" ..
		-- tex:"1aed91a5ae092f7ed528225c3166435e"; x:-384.535034; y:-63.329342; z:26.555950
		"\236\063\085\096\119\207\197\199\023\205\237\032\125\046\128\219\241\201\133\195\128\240\220\194\047\090\001\066" ..
		-- tex:"ec3f556077cfc5c717cded207d2e80db"; x:-267.577698; y:-110.469734; z:32.338074
		"\006\206\019\171\104\006\187\121\077\093\022\106\235\078\147\204\001\139\127\195\248\169\239\194\052\100\001\066" ..
		-- tex:"06ce13ab6806bb794d5d166aeb4e93cc"; x:-255.542999; y:-119.831978; z:32.347858
		"\214\047\042\049\159\123\127\082\237\086\068\199\135\065\213\202\184\088\125\195\062\088\199\194\165\102\001\066" ..
		-- tex:"d62f2a319f7b7f52ed5644c78741d5ca"; x:-253.346573; y:-99.672356; z:32.350243
		"\007\250\088\201\225\078\038\220\024\126\142\036\065\205\253\234\241\070\125\195\054\093\121\066\137\101\005\066" ..
		-- tex:"07fa58c9e14e26dc187e8e2441cdfdea"; x:-253.277130; y:62.341030; z:33.349159
		"\068\067\215\186\090\238\249\095\211\024\124\244\145\051\145\080\224\207\070\195\193\219\076\066\022\104\005\066" ..
		-- tex:"4443d7ba5aeef95fd3187cf491339150"; x:-198.812027; y:51.214607; z:33.351650
		"\199\215\043\186\239\008\178\161\092\101\100\061\084\160\249\050\034\188\087\195\198\125\052\066\137\049\008\066" ..
		-- tex:"c7d72bbaef08b2a15c65643d54a0f932"; x:-215.734909; y:45.122829; z:34.048378
		"\063\180\131\148\193\167\115\044\039\118\212\214\009\028\074\177\233\027\218\195\219\172\040\195\105\124\010\066" ..
		-- tex:"3fb48394c1a7732c2776d4d6091c4ab1"; x:-436.218079; y:-168.675232; z:34.621498
		"\228\199\227\204\064\002\116\114\195\099\082\239\038\248\080\053\022\134\149\194\052\241\212\194\174\165\019\066" ..
		-- tex:"e4c7e3cc40027472c36352ef26f85035"; x:-74.761894; y:-106.471107; z:36.911800
		"\115\214\002\004\087\144\004\092\187\051\234\189\056\127\178\032\056\197\209\195\234\060\106\195\129\229\019\066" ..
		-- tex:"73d602045790045cbb33eabd387fb220"; x:-419.540802; y:-234.237961; z:36.974129
		"\203\195\056\226\153\129\045\229\066\151\009\205\022\156\182\039\244\133\157\195\085\061\106\195\104\001\020\066" ..
		-- tex:"cbc338e299812de5429709cd169cb627"; x:-315.046539; y:-234.239594; z:37.001377
		"\070\130\181\017\082\022\251\118\236\036\004\046\195\197\163\185\246\133\157\195\119\095\084\195\104\001\020\066" ..
		-- tex:"4682b5115216fb76ec24042ec3c5a3b9"; x:-315.046600; y:-212.372925; z:37.001377
		"\173\121\202\061\170\064\233\041\072\052\101\055\164\068\164\201\201\133\157\195\248\252\138\195\104\001\020\066" ..
		-- tex:"ad79ca3daa40e92948346537a444a4c9"; x:-315.045227; y:-277.976349; z:37.001377
		"\017\251\040\105\062\229\112\067\183\151\136\181\148\133\139\103\040\051\203\195\097\013\128\195\104\001\020\066" ..
		-- tex:"11fb28693ee57043b79788b594858b67"; x:-406.399689; y:-256.104553; z:37.001377
		"\041\217\026\116\121\076\105\079\112\073\060\082\095\059\018\247\244\133\157\195\151\013\128\195\104\001\020\066" ..
		-- tex:"29d91a74794c694f70493c525f3b12f7"; x:-315.046539; y:-256.106201; z:37.001377
		"\074\039\205\208\082\123\147\232\069\056\062\103\202\251\121\013\050\051\203\195\195\252\138\195\104\001\020\066" ..
		-- tex:"4a27cdd0527b93e845383e67cafb790d"; x:-406.399994; y:-277.974731; z:37.001377
		"\137\191\181\144\011\122\203\086\079\112\094\244\145\124\167\201\059\134\157\195\157\129\062\195\112\001\020\066" ..
		-- tex:"89bfb5900b7acb564f705ef4917ca7c9"; x:-315.048706; y:-190.506317; z:37.001408
		"\120\043\230\099\073\221\238\106\146\129\229\071\242\131\219\116\094\051\203\195\049\099\170\194\010\068\020\066" ..
		-- tex:"782be66349ddee6a9281e547f283db74"; x:-406.401337; y:-85.193741; z:37.066448
		"\071\175\189\078\121\076\145\141\212\206\254\222\086\129\102\035\093\051\203\195\248\078\125\194\010\068\020\066" ..
		-- tex:"47afbd4e794c918dd4cefede56816623"; x:-406.401306; y:-63.327122; z:37.066448
		"\137\253\136\208\108\203\072\028\038\241\062\195\010\107\105\186\094\051\203\195\232\030\214\194\011\068\020\066" ..
		-- tex:"89fd88d06ccb481c26f13ec30a6b69ba"; x:-406.401337; y:-107.060371; z:37.066452
		"\152\107\048\226\255\013\134\202\003\229\197\131\117\247\043\097\137\115\138\194\086\229\193\194\236\040\023\066" ..
		-- tex:"986b30e2ff0d86ca03e5c58375f72b61"; x:-69.225662; y:-96.947929; z:37.789967
		"\067\032\147\211\204\208\178\013\039\198\203\212\047\142\247\035\034\188\087\195\122\153\225\065\136\049\024\066" ..
		-- tex:"432093d3ccd0b20d27c6cbd42f8ef723"; x:-215.734909; y:28.199942; z:38.048374
		"\083\044\002\101\042\018\036\092\037\172\037\054\079\048\161\216\015\114\126\195\140\125\008\195\176\158\028\066" ..
		-- tex:"532c02652a12245c25ac25364f30a1d8"; x:-254.445557; y:-136.490433; z:39.154972
		"\191\067\084\187\115\133\122\193\185\178\207\232\011\109\168\195\146\058\070\195\122\153\225\065\134\049\032\066" ..
		-- tex:"bf4354bb73857ac1b9b2cfe80b6da8c3"; x:-198.228806; y:28.199942; z:40.048367
		"\184\223\112\218\206\224\166\208\203\121\160\238\033\027\037\154\077\135\241\193\243\239\154\194\224\077\053\066" ..
		-- tex:"b8df70dacee0a6d0cb79a0ee211b259a"; x:-30.191067; y:-77.468658; z:45.326054
		"\091\245\190\028\201\015\003\047\090\238\251\004\127\003\155\139\245\013\201\194\097\062\158\194\237\077\053\066" ..
		-- tex:"5bf5be1cc90f032f5aeefb047f039b8b"; x:-100.527267; y:-79.121841; z:45.326103
		"\182\006\072\104\030\149\087\167\186\019\095\164\178\022\104\253\099\035\191\193\211\194\031\194\159\081\053\066" ..
		-- tex:"b60648681e9557a7ba135fa4b21668fd"; x:-23.892281; y:-39.940262; z:45.329712
		"\063\234\026\043\112\208\143\205\132\126\123\213\129\251\087\079\186\202\157\195\228\216\029\195\070\186\059\066" ..
		-- tex:"3fea1a2b70d08fcd847e7bd581fb574f"; x:-315.583832; y:-157.847244; z:46.931911
		"\105\163\205\125\134\216\150\036\143\109\121\124\066\005\038\194\153\204\147\195\005\249\054\195\002\001\060\066" ..
		-- tex:"69a3cd7d86d896248f6d797c420526c2"; x:-295.598450; y:-182.972748; z:47.000988
		"\186\232\228\225\098\110\146\054\092\008\211\254\115\225\186\163\252\140\154\195\089\163\040\195\226\046\060\066" ..
		-- tex:"bae8e4e1626e92365c08d3fe73e1baa3"; x:-309.101471; y:-168.638092; z:47.045788
		"\061\229\189\242\125\082\185\122\245\191\198\079\007\253\240\191\232\200\167\195\230\184\004\195\157\050\060\066" ..
		-- tex:"3de5bdf27d52b97af5bfc64f07fdf0bf"; x:-335.569611; y:-132.722275; z:47.049431
		"\188\181\061\051\144\057\182\073\139\188\022\205\127\045\181\125\255\205\129\195\106\161\012\195\100\063\060\066" ..
		-- tex:"bcb53d339039b6498bbc16cd7f2db57d"; x:-259.609375; y:-140.630539; z:47.061909
		"\013\034\185\136\100\044\105\006\104\032\115\020\027\140\072\232\070\148\097\195\199\146\034\066\008\030\127\066" ..
		-- tex:"0d22b988642c6906682073141b8c48e8"; x:-225.579208; y:40.643341; z:63.779331
		"\168\103\134\135\174\211\205\090\211\176\121\017\125\110\254\251\113\018\099\195\201\121\141\065\004\143\137\066" ..
		-- tex:"a8678687aed3cd5ad3b079117d6efefb"; x:-227.072052; y:17.684467; z:68.779335
		"\071\211\053\145\216\240\000\225\240\222\242\034\128\078\071\110\028\159\085\195\102\136\129\065\004\143\147\066" ..
		-- tex:"47d33591d8f000e1f0def222804e476e"; x:-213.621536; y:16.191603; z:73.779335
		"\167\235\172\002\048\245\027\243\249\006\102\005\035\204\243\093\114\018\099\195\165\218\012\066\003\143\162\066" ..
		-- tex:"a7ebac0230f51bf3f906660523ccf35d"; x:-227.072067; y:35.213524; z:81.279327
		"\103\116\147\089\246\046\206\244\207\024\019\140\141\055\226\014\114\018\099\195\098\136\129\065\089\228\180\066" ..
		-- tex:"67749359f62ecef4cf18138c8d37e20e"; x:-227.072067; y:16.191595; z:90.445999
		"\056\073\102\076\212\250\227\025\210\090\077\216\172\248\080\146\202\195\088\195\015\035\237\065\003\143\197\066" ..
		-- tex:"3849664cd4fae319d25a4dd8acf85092"; x:-216.764816; y:29.642120; z:98.779327
		"\206\044\249\229\187\238\131\159\184\127\246\054\078\110\041\221\131\249\120\195\235\225\119\066\079\089\202\066" ..
		-- tex:"ce2cf9e5bbee839fb87ff6364e6e29dd"; x:-248.974670; y:61.970627; z:101.174438
		"\026\095\021\196\206\136\099\230\242\061\051\189\007\183\117\217\069\084\118\195\124\155\016\067\194\079\206\066" ..
		-- tex:"1a5f15c4ce8863e6f23d33bd07b775d9"; x:-246.329193; y:144.607376; z:103.155785
		"\139\234\207\045\241\168\077\093\171\150\092\146\117\157\201\000\232\093\136\195\111\004\251\066\066\029\214\066" ..
		-- tex:"8beacf2df1a84d5dab965c92759dc900"; x:-272.733673; y:125.508667; z:107.057152
		"\237\207\097\228\183\170\133\190\051\231\133\041\193\229\072\253\214\168\139\195\156\254\173\066\188\234\221\066" ..
		-- tex:"edcf61e4b7aa85be33e78529c1e548fd"; x:-279.319061; y:86.997292; z:110.958473
		"\228\163\157\139\019\162\172\008\219\239\120\009\082\166\030\219\081\046\138\195\040\038\099\066\154\171\231\066" ..
		-- tex:"e4a39d8b13a2ac08dbef780952a61edb"; x:-276.361877; y:56.787266; z:115.835167
		"\042\149\116\159\231\006\010\130\194\030\162\187\104\244\066\196\189\105\126\195\003\254\052\066\022\121\239\066" ..
		-- tex:"2a95749fe7060a82c21ea2bb68f442c4"; x:-254.413055; y:45.248062; z:119.736504
		"\125\127\197\075\051\097\117\152\178\071\225\051\189\055\092\222\069\084\118\195\124\155\016\067\029\083\245\066" ..
		-- tex:"7d7fc54b33617598b247e133bd375cde"; x:-246.329193; y:144.607376; z:122.662338
		"\030\232\119\047\022\024\061\105\198\123\174\011\138\220\101\055\232\093\136\195\109\004\251\066\052\235\254\066" ..
		-- tex:"1ee8772f16183d69c67bae0b8adc6537"; x:-272.733673; y:125.508652; z:127.459389
		"\002\086\205\122\120\007\141\091\040\079\174\102\121\116\119\202\213\168\139\195\157\254\173\066\003\007\005\067" ..
		-- tex:"0256cd7a78078d5b284fae66797477ca"; x:-279.319031; y:86.997299; z:133.027405
		"\246\178\121\000\034\246\037\194\177\184\093\254\069\096\044\250\077\075\117\195\092\130\041\067\252\027\007\067" ..
		-- tex:"f6b2790022f625c2b1b85dfe45602cfa"; x:-245.294159; y:169.509232; z:135.109329
		"\214\103\208\009\163\016\239\128\018\187\127\156\200\123\093\103\080\046\138\195\042\038\099\066\052\019\012\067" ..
		-- tex:"d667d009a310ef8012bb7f9cc87b5d67"; x:-276.361847; y:56.787273; z:140.075027
		"\068\096\244\203\026\129\195\103\000\147\169\195\036\150\134\106\188\105\126\195\008\254\052\066\045\206\017\067" ..
		-- tex:"4460f4cb1a81c3670093a9c32496866a"; x:-254.413040; y:45.248081; z:145.805389
		"\175\142\218\241\053\009\170\160\104\075\216\128\074\067\184\155\189\095\116\195\237\225\119\066\121\020\021\067",
		-- tex:"af8edaf13509aaa0684bd8804a43b89b"; x:-244.373993; y:61.970634; z:149.079987
	["Stratholme"] = 
		"\230\243\254\199\119\077\098\064\081\218\117\161\183\055\231\003\234\069\137\196\147\108\187\067\206\210\052\195" ..
		-- tex:"e6f3fec7774d624051da75a1b737e703"; x:-1098.184937; y:374.848267; z:-180.823471
		"\028\139\063\101\100\072\030\205\218\065\072\233\233\148\057\001\234\069\169\196\093\170\220\067\206\210\052\195" ..
		-- tex:"1c8b3f6564481ecdda4148e9e9943901"; x:-1354.184937; y:441.330994; z:-180.823471
		"\068\054\160\186\162\218\059\189\060\141\175\002\086\114\129\045\234\069\169\196\073\182\029\068\206\210\052\195" ..
		-- tex:"4436a0baa2da3bbd3c8daf025672812d"; x:-1354.184937; y:630.848267; z:-180.823471
		"\010\139\032\038\049\008\115\213\034\040\122\234\041\019\201\118\234\069\169\196\093\170\220\067\206\210\052\195" ..
		-- tex:"0a8b2026310873d522287aea2913c976"; x:-1354.184937; y:441.330994; z:-180.823471
		"\047\221\134\114\088\229\016\098\215\110\006\226\244\170\132\058\234\069\169\196\147\108\187\067\206\210\052\195" ..
		-- tex:"2fdd867258e51062d76e06e2f4aa843a"; x:-1354.184937; y:374.848267; z:-180.823471
		"\052\182\133\209\153\053\005\073\124\157\165\053\225\069\185\083\187\159\085\196\181\240\166\067\140\182\035\195" ..
		-- tex:"34b685d1993505497c9da535e145b953"; x:-854.495850; y:333.880554; z:-163.713089
		"\028\244\188\144\221\215\124\222\224\115\202\098\162\156\129\136\221\207\138\196\215\194\155\066\140\182\035\195" ..
		-- tex:"1cf4bc90ddd77cdee073ca62a29c8188"; x:-1110.495850; y:77.880554; z:-163.713089
		"\246\155\193\138\114\053\097\067\177\077\114\112\021\070\203\057\221\207\138\196\181\240\166\067\140\182\035\195" ..
		-- tex:"f69bc18a72356143b14d72701546cb39"; x:-1110.495850; y:333.880554; z:-163.713089
		"\244\186\004\092\135\218\047\213\140\242\255\193\114\059\141\068\028\087\123\196\221\090\199\066\140\182\035\195" ..
		-- tex:"f4ba045c87da2fd58cf2ffc1723b8d44"; x:-1005.361145; y:99.677475; z:-163.713089
		"\077\089\026\082\227\153\109\112\192\059\063\163\199\230\232\026\081\248\101\196\221\090\199\066\140\182\035\195" ..
		-- tex:"4d591a52e3996d70c03b3fa3c7e6e81a"; x:-919.880005; y:99.677475; z:-163.713089
		"\225\183\244\064\149\211\196\124\143\159\160\101\195\013\093\093\187\159\085\196\215\194\155\066\140\182\035\195" ..
		-- tex:"e1b7f44095d3c47c8f9fa065c30d5d5d"; x:-854.495850; y:77.880554; z:-163.713089
		"\041\103\147\229\142\042\010\099\173\127\165\130\182\066\131\123\059\195\105\196\049\075\022\068\071\243\027\195" ..
		-- tex:"296793e58e2a0a63ad7fa582b642837b"; x:-935.050537; y:601.174927; z:-155.950317
		"\070\204\233\079\162\064\002\145\204\045\170\195\048\193\155\115\059\195\105\196\049\075\022\068\071\243\027\195" ..
		-- tex:"46cce94fa2400291cc2daac330c19b73"; x:-935.050537; y:601.174927; z:-155.950317
		"\135\156\144\118\045\072\234\009\156\125\028\136\120\195\006\171\065\127\138\196\229\045\217\067\071\243\027\195" ..
		-- tex:"879c90762d48ea099c7d1c8878c306ab"; x:-1107.976807; y:434.358582; z:-155.950317
		"\248\218\108\210\190\006\000\164\076\204\191\230\124\187\187\135\131\254\084\196\229\045\217\067\071\243\027\195" ..
		-- tex:"f8da6cd2be0600a44cccbfe67cbbbb87"; x:-851.976807; y:434.358582; z:-155.950317
		"\110\229\174\200\240\166\182\050\009\020\225\013\152\102\047\082\131\254\084\196\242\150\044\068\071\243\027\195" ..
		-- tex:"6ee5aec8f0a6b6320914e10d98662f52"; x:-851.976807; y:690.358582; z:-155.950317
		"\125\074\008\056\128\042\033\067\138\224\015\044\195\220\198\173\065\127\138\196\242\150\044\068\071\243\027\195" ..
		-- tex:"7d4a0838802a21438ae00f2cc3dcc6ad"; x:-1107.976807; y:690.358582; z:-155.950317
		"\141\051\165\206\181\016\061\126\129\191\196\132\236\235\049\181\052\223\143\196\109\107\083\195\005\161\027\195" ..
		-- tex:"8d33a5ceb5103d7e81bfc484eceb31b5"; x:-1150.975220; y:-211.419647; z:-155.628998
		"\088\237\033\154\018\065\250\122\011\079\238\147\149\137\142\132\105\190\095\196\182\181\233\195\005\161\027\195" ..
		-- tex:"58ed219a1241fa7a0b4fee9395898e84"; x:-894.975220; y:-467.419647; z:-155.628998
		"\140\098\153\029\005\108\188\229\245\174\161\194\028\248\182\136\105\190\031\196\182\181\233\195\005\161\027\195" ..
		-- tex:"8c62991d056cbce5f5aea1c21cf8b688"; x:-638.975220; y:-467.419647; z:-155.628998
		"\216\100\220\217\112\227\113\058\119\084\163\172\192\150\250\057\052\223\143\196\182\181\233\195\005\161\027\195" ..
		-- tex:"d864dcd970e3713a7754a3acc096fa39"; x:-1150.975220; y:-467.419647; z:-155.628998
		"\004\126\007\165\069\205\252\142\127\021\130\253\187\197\165\150\105\190\095\196\109\107\083\195\005\161\027\195" ..
		-- tex:"047e07a545cdfc8e7f1582fdbbc5a596"; x:-894.975220; y:-211.419647; z:-155.628998
		"\037\031\090\033\180\254\230\067\178\212\174\115\133\146\157\185\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"251f5a21b4fee643b2d4ae7385929db9"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\034\217\251\056\148\151\035\049\231\176\192\066\181\128\086\003\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"22d9fb3894972331e7b0c042b5805603"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\065\084\244\223\021\026\179\239\197\117\186\076\226\246\211\120\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"4154f4df151ab3efc575ba4ce2f6d378"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\172\004\253\090\080\211\034\140\084\213\153\163\168\045\009\009\041\195\171\196\006\153\134\194\151\067\242\194" ..
		-- tex:"ac04fd5a50d3228c54d599a3a82d0909"; x:-1374.098877; y:-67.298882; z:-121.132019
		"\147\084\024\244\003\202\090\238\204\255\056\135\097\251\136\101\041\195\139\196\158\029\221\194\151\067\242\194" ..
		-- tex:"935418f403ca5aeeccff388761fb8865"; x:-1118.098877; y:-110.557854; z:-121.132019
		"\194\161\222\162\092\040\104\219\145\106\005\129\061\089\050\148\041\195\171\196\158\029\221\194\151\067\242\194" ..
		-- tex:"c2a1dea25c2868db916a05813d593294"; x:-1374.098877; y:-110.557854; z:-121.132019
		"\105\254\167\131\205\108\149\122\041\191\099\089\242\057\011\248\105\190\095\196\223\194\155\194\201\147\222\194" ..
		-- tex:"69fea783cd6c957a29bf6359f2390bf8"; x:-894.975220; y:-77.880615; z:-111.288651
		"\041\219\140\134\024\029\018\013\011\142\117\152\052\085\185\148\052\223\143\196\060\007\141\194\201\147\222\194" ..
		-- tex:"29db8c86181d120d0b8e75983455b994"; x:-1150.975220; y:-70.514137; z:-111.288651
		"\170\130\199\021\139\229\089\215\011\018\068\193\170\244\217\046\052\223\143\196\186\047\124\194\201\147\222\194" ..
		-- tex:"aa82c7158be559d70b1244c1aaf4d92e"; x:-1150.975220; y:-63.046612; z:-111.288651
		"\076\038\190\034\153\156\068\116\105\088\128\101\048\028\063\149\052\223\143\196\223\194\155\194\201\147\222\194" ..
		-- tex:"4c26be22999c447469588065301c3f95"; x:-1150.975220; y:-77.880615; z:-111.288651
		"\038\047\025\054\000\185\045\174\180\108\223\207\106\155\054\071\052\223\143\196\181\156\252\194\201\147\222\194" ..
		-- tex:"262f193600b92daeb46cdfcf6a9b3647"; x:-1150.975220; y:-126.306076; z:-111.288651
		"\009\014\180\204\135\066\034\241\248\170\017\080\061\230\058\176\105\190\095\196\181\156\252\194\201\147\222\194" ..
		-- tex:"090eb4cc874222f1f8aa11503de63ab0"; x:-894.975220; y:-126.306076; z:-111.288651
		"\056\181\076\197\221\178\172\203\128\205\052\145\175\057\200\086\052\223\143\196\193\087\095\194\201\147\222\194" ..
		-- tex:"38b54cc5ddb2accb80cd3491af39c856"; x:-1150.975220; y:-55.835701; z:-111.288651
		"\077\170\249\163\073\238\238\087\136\029\227\165\072\036\175\022\216\033\143\196\036\143\082\195\017\100\212\194" ..
		-- tex:"4daaf9a349eeee57881de3a54824af16"; x:-1145.057739; y:-210.559158; z:-106.195450
		"\164\068\182\098\098\128\187\035\208\120\212\071\197\078\157\049\216\033\175\196\036\143\082\195\017\100\212\194" ..
		-- tex:"a444b6626280bb23d078d447c54e9d31"; x:-1401.057739; y:-210.559158; z:-106.195450
		"\063\252\123\085\110\143\156\195\011\212\146\123\052\055\102\211\216\033\175\196\107\195\053\066\017\100\212\194" ..
		-- tex:"3ffc7b556e8f9cc30bd4927b343766d3"; x:-1401.057739; y:45.440842; z:-106.195450
		"\194\114\167\144\251\151\162\027\213\142\238\100\064\205\092\093\216\033\143\196\107\195\053\066\017\100\212\194" ..
		-- tex:"c272a790fb97a21bd58eee6440cd5c5d"; x:-1145.057739; y:45.440842; z:-106.195450
		"\223\116\186\056\060\090\236\050\208\058\179\042\150\213\219\160\071\115\017\195\233\204\156\194\248\134\205\194" ..
		-- tex:"df74ba383c5aec32d03ab32a96d5dba0"; x:-145.450317; y:-78.400223; z:-102.763618
		"\024\128\180\020\035\026\073\187\236\201\239\017\148\192\171\087\111\025\221\066\233\204\156\194\248\134\205\194" ..
		-- tex:"1880b414231a49bbecc9ef1194c0ab57"; x:110.549683; y:-78.400223; z:-102.763618
		"\216\035\007\054\195\166\127\204\046\231\043\004\017\145\254\131\253\025\166\196\037\232\077\067\233\050\177\194" ..
		-- tex:"d8230736c3a67fcc2ee72b041191fe83"; x:-1328.812256; y:205.906830; z:-88.599442
		"\157\152\211\149\155\203\024\067\100\069\066\194\049\220\025\126\069\136\159\196\091\091\088\067\233\050\177\194" ..
		-- tex:"9d98d3959bcb1843644542c231dc197e"; x:-1276.258545; y:216.356873; z:-88.599442
		"\185\143\065\180\002\144\054\235\124\097\156\208\160\159\246\021\069\136\159\196\068\052\071\067\233\050\177\194" ..
		-- tex:"b98f41b4029036eb7c619cd0a09ff615"; x:-1276.258545; y:199.204178; z:-88.599442
		"\198\092\040\158\085\192\015\016\058\061\151\104\072\056\029\050\139\016\127\196\091\091\088\067\233\050\177\194" ..
		-- tex:"c65c289e55c00f103a3d976848381d32"; x:-1020.258545; y:216.356873; z:-88.599442
		"\145\212\139\140\144\075\199\042\200\200\184\045\227\055\135\137\131\198\019\196\222\152\029\196\211\069\176\194" ..
		-- tex:"91d48b8c904bc72ac8c8b82de3378789"; x:-591.101807; y:-630.388611; z:-88.136383
		"\097\177\045\166\239\255\109\214\004\115\179\186\242\068\110\162\191\193\164\195\153\177\129\195\211\069\176\194" ..
		-- tex:"61b12da6efff6dd60473b3baf2446ea2"; x:-329.513672; y:-259.387512; z:-88.136383
		"\239\157\066\097\176\089\152\141\132\251\236\146\191\103\238\226\078\039\019\196\121\229\144\195\211\069\176\194" ..
		-- tex:"ef9d4261b059988d84fbec92bf67eee2"; x:-588.614197; y:-289.792786; z:-88.136383
		"\051\152\033\185\223\235\015\231\235\011\151\130\076\098\171\123\078\039\019\196\188\114\008\196\211\069\176\194" ..
		-- tex:"339821b9dfeb0fe7eb0b97824c62ab7b"; x:-588.614197; y:-545.792786; z:-88.136383
		"\199\091\117\128\025\147\168\103\084\167\176\004\081\112\142\152\223\096\018\196\153\177\129\195\211\069\176\194" ..
		-- tex:"c75b75801993a86754a7b00451708e98"; x:-585.513672; y:-259.387512; z:-88.136383
		"\242\016\142\117\033\197\246\028\119\206\078\031\171\147\056\223\131\198\019\196\189\049\187\195\211\069\176\194" ..
		-- tex:"f2108e7521c5f61c77ce4e1fab9338df"; x:-591.101807; y:-374.388611; z:-88.136383
		"\056\194\113\098\249\142\254\194\009\144\152\024\141\250\160\024\007\141\167\195\222\152\029\196\211\069\176\194" ..
		-- tex:"38c27162f98efec2099098188dfaa018"; x:-335.101807; y:-630.388611; z:-88.136383
		"\006\089\116\119\046\127\186\224\050\103\090\054\241\167\120\131\171\239\197\195\059\108\165\195\211\069\176\194" ..
		-- tex:"065974772e7fbae032675a36f1a77883"; x:-395.872437; y:-330.845581; z:-88.136383
		"\143\224\038\002\137\099\150\159\142\046\052\148\019\089\090\021\213\247\034\196\059\108\165\195\211\069\176\194" ..
		-- tex:"8fe026028963969f8e2e349413595a15"; x:-651.872437; y:-330.845581; z:-88.136383
		"\212\255\227\189\120\181\066\172\211\084\064\065\244\161\058\124\007\141\167\195\189\049\187\195\211\069\176\194" ..
		-- tex:"d4ffe3bd78b542acd3544041f4a13a7c"; x:-335.101807; y:-374.388611; z:-88.136383
		"\074\237\085\081\170\091\009\023\233\114\009\139\226\009\063\035\157\033\155\195\191\162\168\192\137\221\174\194" ..
		-- tex:"4aed5551aa5b0917e972098be2093f23"; x:-310.262634; y:-5.269867; z:-87.432693
		"\206\236\022\084\098\248\048\106\046\190\241\083\076\015\141\027\157\033\155\195\162\094\036\195\137\221\174\194" ..
		-- tex:"ceec165462f8306a2ebef1534c0f8d1b"; x:-310.262634; y:-164.369675; z:-87.432693
		"\121\130\095\126\159\244\216\004\120\150\019\233\167\212\116\138\206\144\013\196\162\094\036\195\137\221\174\194" ..
		-- tex:"79825f7e9ff4d804789613e9a7d4748a"; x:-566.262634; y:-164.369675; z:-87.432693
		"\213\060\129\083\031\172\196\011\105\232\089\001\114\149\196\233\138\038\253\195\065\065\135\195\137\221\174\194" ..
		-- tex:"d53c81531facc40b69e859017295c4e9"; x:-506.301117; y:-270.509827; z:-87.432693
		"\141\216\036\105\042\123\051\102\159\107\185\137\145\037\157\196\206\144\013\196\162\094\036\195\137\221\174\194" ..
		-- tex:"8dd824692a7b33669f6bb98991259dc4"; x:-566.262634; y:-164.369675; z:-87.432693
		"\233\061\228\021\136\101\148\168\173\109\083\046\028\077\073\013\206\144\013\196\138\162\130\195\137\221\174\194" ..
		-- tex:"e93de415886594a8ad6d532e1c4d490d"; x:-566.262634; y:-261.269867; z:-87.432693
		"\141\064\231\203\013\033\140\020\062\184\221\255\058\226\133\007\157\033\155\195\138\162\130\195\137\221\174\194" ..
		-- tex:"8d40e7cb0d218c143eb8ddff3ae28507"; x:-310.262634; y:-261.269867; z:-87.432693
		"\089\103\083\056\231\172\239\149\068\098\155\036\148\153\218\042\119\252\052\194\138\162\130\195\075\181\171\194" ..
		-- tex:"59675338e7acef9544629b249499da2a"; x:-45.246552; y:-261.269867; z:-85.854095
		"\249\167\159\104\244\095\242\197\177\164\070\038\099\154\047\074\142\159\150\195\138\162\130\195\075\181\171\194" ..
		-- tex:"f9a79f68f45ff2c5b1a44626639a2f4a"; x:-301.246552; y:-261.269867; z:-85.854095
		"\084\178\131\053\158\187\080\247\158\249\184\230\117\206\121\226\119\252\052\194\191\162\168\192\075\181\171\194" ..
		-- tex:"54b283359ebb50f79ef9b8e675ce79e2"; x:-45.246552; y:-5.269867; z:-85.854095
		"\252\239\108\252\069\124\175\225\121\232\166\123\240\251\081\022\142\159\150\195\191\162\168\192\075\181\171\194" ..
		-- tex:"fcef6cfc457cafe179e8a67bf0fb5116"; x:-301.246552; y:-5.269867; z:-85.854095
		"\090\112\208\100\010\061\092\182\027\226\198\097\161\156\041\037\194\147\236\195\190\023\006\196\071\145\170\194" ..
		-- tex:"5a70d0640a3d5cb61be2c661a19c2925"; x:-473.154388; y:-536.371033; z:-85.283752
		"\069\213\081\043\232\048\084\157\003\218\160\005\247\068\229\069\026\155\001\196\082\141\248\195\071\145\170\194" ..
		-- tex:"45d5512be830549d03daa005f744e545"; x:-518.423523; y:-497.104095; z:-85.283752
		"\147\005\040\087\240\123\243\075\210\059\044\164\129\107\152\224\100\038\030\196\101\204\003\195\132\065\162\194" ..
		-- tex:"93052857f07bf34bd23b2ca4816b98e0"; x:-632.599915; y:-131.798431; z:-81.127968
		"\081\121\179\026\113\128\115\060\153\001\119\162\243\016\170\013\245\097\183\195\055\039\150\066\132\065\162\194" ..
		-- tex:"5179b31a7180733c990177a2f310aa0d"; x:-366.765320; y:75.076599; z:-81.127968
		"\117\002\231\172\026\226\092\087\001\192\164\004\061\246\059\198\201\076\188\195\101\204\003\195\132\065\162\194" ..
		-- tex:"7502e7ac1ae25c5701c0a4043df63bc6"; x:-376.599915; y:-131.798431; z:-81.127968
		"\121\087\114\045\105\096\192\180\079\008\174\084\030\228\058\241\021\048\030\196\171\246\081\066\132\065\162\194" ..
		-- tex:"7957722d6960c0b44f08ae541ee43af1"; x:-632.751343; y:52.490891; z:-81.127968
		"\216\047\151\071\081\232\084\187\058\021\188\211\214\176\104\238\007\252\035\196\222\170\085\066\132\065\162\194" ..
		-- tex:"d82f974751e854bb3a15bcd3d6b068ee"; x:-655.937988; y:53.416866; z:-81.127968
		"\222\084\023\096\099\245\121\085\237\147\156\002\193\008\225\079\250\176\027\196\205\137\165\067\132\065\162\194" ..
		-- tex:"de54176063f57955ed939c02c108e14f"; x:-622.765320; y:331.076599; z:-81.127968
		"\187\142\102\083\159\160\243\000\253\186\139\147\142\214\135\048\250\176\027\196\055\039\150\066\132\065\162\194" ..
		-- tex:"bb8e66539fa0f300fdba8b938ed68730"; x:-622.765320; y:75.076599; z:-81.127968
		"\183\162\057\135\230\107\199\053\233\002\008\167\126\062\146\099\245\097\183\195\205\137\165\067\132\065\162\194" ..
		-- tex:"b7a23987e66bc735e90208a77e3e9263"; x:-366.765320; y:331.076599; z:-81.127968
		"\210\189\143\062\023\216\124\144\223\063\125\251\137\126\208\254\021\048\030\196\032\041\130\066\132\065\162\194" ..
		-- tex:"d2bd8f3e17d87c90df3f7dfb897ed0fe"; x:-632.751343; y:65.080330; z:-81.127968
		"\083\192\041\207\164\232\166\207\137\085\186\233\036\205\174\156\100\038\030\196\051\103\248\066\132\065\162\194" ..
		-- tex:"53c029cfa4e8a6cf8955bae924cdae9c"; x:-632.599915; y:124.201569; z:-81.127968
		"\097\133\163\034\030\141\183\005\036\130\039\244\133\170\201\213\221\207\138\196\116\076\029\067\025\088\153\194" ..
		-- tex:"6185a3221e8db705248227f485aac9d5"; x:-1110.495850; y:157.298660; z:-76.672073
		"\245\058\253\190\158\055\225\252\105\096\007\084\105\163\182\120\221\207\138\196\080\061\135\067\025\088\153\194" ..
		-- tex:"f53afdbe9e37e1fc6960075469a3b678"; x:-1110.495850; y:270.479034; z:-76.672073
		"\217\048\097\187\158\164\210\065\106\065\205\242\073\180\218\044\248\030\147\196\173\074\141\067\025\088\153\194" ..
		-- tex:"d93061bb9ea4d2416a41cdf249b4da2c"; x:-1176.967896; y:282.583435; z:-76.672073
		"\178\229\017\130\055\137\103\167\157\125\002\205\171\244\137\094\241\061\102\196\173\074\141\067\025\088\153\194" ..
		-- tex:"b2e51182378967a79d7d02cdabf4895e"; x:-920.967896; y:282.583435; z:-76.672073
		"\255\094\222\121\011\095\014\250\077\246\033\066\041\183\035\252\071\115\017\195\233\204\156\194\062\112\149\194" ..
		-- tex:"ff5ede790b5f0efa4df6214229b723fc"; x:-145.450317; y:-78.400223; z:-74.719231
		"\197\089\159\006\225\207\247\121\234\102\135\059\212\011\219\163\131\254\020\196\083\232\138\067\108\127\135\194" ..
		-- tex:"c5599f06e1cff779ea66873bd40bdba3"; x:-595.976807; y:277.815063; z:-67.748878
		"\117\230\053\048\050\152\074\067\195\121\181\091\116\193\084\032\065\127\138\196\015\228\220\067\108\127\135\194" ..
		-- tex:"75e6353032984a43c379b55b74c15420"; x:-1107.976807; y:441.781738; z:-67.748878
		"\031\147\026\211\088\207\044\017\088\030\243\236\039\159\008\064\131\254\084\196\041\116\005\068\108\127\135\194" ..
		-- tex:"1f931ad358cf2c11581ef3ec279f0840"; x:-851.976807; y:533.815063; z:-67.748878
		"\204\015\203\250\051\112\246\078\154\131\049\014\060\044\070\058\065\127\138\196\083\232\138\067\108\127\135\194" ..
		-- tex:"cc0fcbfa3370f64e9a83310e3c2c463a"; x:-1107.976807; y:277.815063; z:-67.748878
		"\240\218\042\046\088\242\058\201\088\055\163\064\130\025\129\044\131\254\084\196\083\232\138\067\108\127\135\194" ..
		-- tex:"f0da2a2e58f23ac95837a3408219812c"; x:-851.976807; y:277.815063; z:-67.748878
		"\249\209\237\057\103\227\126\000\180\249\175\060\022\062\153\158\065\127\138\196\028\007\194\067\108\127\135\194" ..
		-- tex:"f9d1ed3967e37e00b4f9af3c163e999e"; x:-1107.976807; y:388.055573; z:-67.748878
		"\021\246\253\247\031\120\167\168\056\199\054\155\123\034\007\027\163\170\234\195\029\005\178\066\104\152\131\194" ..
		-- tex:"15f6fdf71f78a7a838c7369b7b22071b"; x:-469.333130; y:89.009995; z:-65.797676
		"\018\236\248\188\191\119\212\161\042\004\149\075\224\032\118\101\071\085\085\195\029\005\178\066\104\152\131\194" ..
		-- tex:"12ecf8bcbf77d4a12a04954be0207665"; x:-213.333130; y:89.009995; z:-65.797676
		"\216\117\155\206\127\027\098\064\183\216\147\223\209\179\079\108\071\085\085\195\224\188\182\066\104\152\131\194" ..
		-- tex:"d8759bce7f1b6240b7d893dfd1b34f6c"; x:-213.333130; y:91.368904; z:-65.797676
		"\228\069\044\138\023\157\191\103\241\008\162\049\183\050\225\246\163\170\234\195\224\188\182\066\104\152\131\194" ..
		-- tex:"e4452c8a179dbf67f108a231b732e1f6"; x:-469.333130; y:91.368904; z:-65.797676
		"\059\035\008\012\237\045\015\023\135\015\075\071\145\126\243\183\205\236\255\195\215\206\177\067\003\101\093\194" ..
		-- tex:"3b23080ced2d0f17870f4b47917ef3b7"; x:-511.850037; y:355.615967; z:-55.348648
		"\195\080\219\059\248\194\036\060\129\172\208\170\114\107\195\191\163\045\186\195\252\206\018\068\003\101\093\194" ..
		-- tex:"c350db3bf8c2243c81acd0aa726bc3bf"; x:-372.356567; y:587.234192; z:-55.348648
		"\049\132\058\154\166\234\216\089\176\162\112\042\172\138\153\003\205\236\255\195\251\001\077\067\003\101\093\194" ..
		-- tex:"31843a9aa6ead859b0a2702aac8a9903"; x:-511.850037; y:205.007751; z:-55.348648
		"\009\068\108\180\089\078\014\148\066\180\174\225\153\000\125\090\209\022\029\196\249\157\165\067\003\101\093\194" ..
		-- tex:"09446cb4594e0e9442b4aee199007d5a"; x:-628.356567; y:331.234192; z:-55.348648
		"\161\074\080\155\130\225\119\224\124\081\214\045\230\239\076\037\209\022\029\196\252\206\018\068\003\101\093\194" ..
		-- tex:"a14a509b82e177e07c51d62de6ef4c25"; x:-628.356567; y:587.234192; z:-55.348648
		"\015\142\119\187\231\162\153\049\226\063\011\064\087\101\210\054\163\045\186\195\249\157\165\067\003\101\093\194" ..
		-- tex:"0f8e77bbe7a29931e23f0b405765d236"; x:-372.356567; y:331.234192; z:-55.348648
		"\187\060\029\102\182\124\125\131\011\074\082\111\091\196\049\111\017\227\177\195\029\005\178\066\119\013\090\194" ..
		-- tex:"bb3c1d66b67c7d830b4a526f5bc4316f"; x:-355.773987; y:89.009995; z:-54.513153
		"\195\211\176\191\051\210\238\032\101\068\206\127\133\233\130\092\071\140\199\194\029\005\178\066\119\013\090\194" ..
		-- tex:"c3d3b0bf33d2ee206544ce7f85e9825c"; x:-99.773987; y:89.009995; z:-54.513153
		"\192\118\134\054\013\198\073\037\163\081\025\164\103\217\241\123\017\227\177\195\029\005\178\066\119\013\090\194" ..
		-- tex:"c07686360dc64925a35119a467d9f17b"; x:-355.773987; y:89.009995; z:-54.513153
		"\227\034\117\143\218\222\129\147\090\080\073\066\041\206\241\120\219\064\128\196\183\225\076\065\111\184\069\194" ..
		-- tex:"e322758fdade81935a50494229cef178"; x:-1026.026855; y:12.805107; z:-49.430115
		"\072\198\041\069\074\084\197\076\200\122\218\046\049\089\199\033\253\252\115\196\136\221\118\065\128\179\069\194" ..
		-- tex:"48c629454a54c54cc87ada2e3159c721"; x:-975.953003; y:15.429086; z:-49.425297
		"\220\081\071\080\020\172\048\142\171\218\100\067\005\017\197\061\213\026\233\195\120\108\225\067\088\159\064\194" ..
		-- tex:"dc51475014ac308eabda64430511c53d"; x:-466.209656; y:450.847443; z:-48.155613
		"\187\105\169\087\211\186\201\135\247\010\065\009\071\062\190\087\213\026\233\195\120\108\225\067\088\159\064\194" ..
		-- tex:"bb69a957d3bac987f70a4109473ebe57"; x:-466.209656; y:450.847443; z:-48.155613
		"\030\227\152\040\090\126\047\098\228\066\208\088\209\089\054\202\213\026\233\195\120\108\225\067\088\159\064\194" ..
		-- tex:"1ee398285a7e2f62e442d058d15936ca"; x:-466.209656; y:450.847443; z:-48.155613
		"\020\175\166\023\089\000\012\088\068\113\089\231\042\075\047\020\022\070\096\196\196\010\028\067\113\074\064\194" ..
		-- tex:"14afa61759000c58447159e72a4b2f14"; x:-897.095154; y:156.042068; z:-48.072701
		"\004\176\127\149\242\162\175\179\032\135\061\051\166\076\129\118\034\054\015\196\084\084\198\067\199\087\056\194" ..
		-- tex:"04b07f95f2a2afb320873d33a64c8176"; x:-572.845886; y:396.658844; z:-46.085724
		"\171\005\068\015\173\079\163\173\063\214\090\075\135\163\243\102\173\234\164\195\060\008\198\195\211\039\047\194" ..
		-- tex:"ab05440fad4fa3ad3fd65a4b87a3f366"; x:-329.833435; y:-396.064362; z:-43.788895
		"\185\188\097\111\197\209\074\046\202\162\155\087\102\235\166\078\033\215\046\196\144\122\031\193\112\127\046\194" ..
		-- tex:"b9bc616fc5d14a2ecaa29b5766eba64e"; x:-699.361450; y:-9.967423; z:-43.624454
		"\224\200\231\021\098\204\065\254\091\187\141\197\140\125\011\133\230\233\144\195\136\181\097\196\093\009\036\194" ..
		-- tex:"e0c8e71562cc41fe5bbb8dc58c7d0b85"; x:-289.827362; y:-902.836487; z:-41.009148
		"\014\199\113\197\184\215\044\208\005\013\237\067\239\169\199\177\021\190\083\196\170\207\182\067\126\142\033\194" ..
		-- tex:"0ec771c5b8d72cd0050ded43efa9c7b1"; x:-846.970093; y:365.622406; z:-40.389156
		"\180\000\004\145\125\029\153\101\048\158\217\150\112\252\246\055\092\055\109\195\073\176\047\196\247\160\028\194" ..
		-- tex:"b40004917d1d9965309ed99670fcf637"; x:-237.216263; y:-702.754517; z:-39.157196
		"\169\150\151\196\208\161\065\006\083\178\214\112\112\206\107\112\174\076\065\196\249\139\202\067\246\087\013\194" ..
		-- tex:"a99697c4d0a1410653b2d67070ce6b70"; x:-773.198181; y:405.093567; z:-35.335903
		"\211\129\096\238\162\213\201\108\064\228\145\116\040\028\162\238\174\076\065\196\183\239\129\067\246\087\013\194" ..
		-- tex:"d38160eea2d5c96c40e49174281ca2ee"; x:-773.198181; y:259.872803; z:-35.335903
		"\030\084\212\096\171\013\007\195\016\072\184\218\094\092\223\098\174\076\065\196\030\228\195\067\246\087\013\194" ..
		-- tex:"1e54d460ab0d07c31048b8da5e5cdf62"; x:-773.198181; y:391.782196; z:-35.335903
		"\013\044\165\210\204\206\105\230\082\061\071\169\169\067\223\064\030\186\137\196\048\152\252\067\081\136\215\193" ..
		-- tex:"0d2ca5d2ccce69e6523d47a9a943df40"; x:-1101.816284; y:505.188995; z:-26.941563
		"\082\231\215\078\048\216\062\124\242\078\191\177\044\241\145\231\155\067\207\195\213\131\029\196\106\089\165\193" ..
		-- tex:"52e7d74e30d83e7cf24ebfb12cf191e7"; x:-414.528198; y:-630.059937; z:-20.668661
		"\082\108\093\184\023\121\157\211\175\232\098\184\238\129\006\039\206\016\204\195\061\220\013\196\106\089\165\193" ..
		-- tex:"526c5db817799dd3afe862b8ee810627"; x:-408.131317; y:-567.441284; z:-20.668661
		"\064\085\090\193\253\216\043\030\025\217\004\045\051\001\123\077\147\184\217\195\086\023\018\196\106\089\165\193" ..
		-- tex:"40555ac1fdd82b1e19d9042d33017b4d"; x:-435.442017; y:-584.364685; z:-20.668661
		"\187\041\034\111\087\015\019\063\074\107\148\226\169\227\045\202\040\026\136\195\080\239\038\196\054\066\151\193" ..
		-- tex:"bb29226f570f133f4a6b94e2a9e32dca"; x:-272.204376; y:-667.739319; z:-18.907331
		"\015\177\137\197\222\048\120\128\000\217\081\038\086\121\188\153\119\058\087\195\016\233\030\196\054\066\151\193" ..
		-- tex:"0fb189c5de30788000d951265679bc99"; x:-215.228394; y:-635.641663; z:-18.907331
		"\135\096\134\123\246\122\058\020\218\016\059\249\084\098\094\044\003\057\112\195\032\219\033\196\054\066\151\193" ..
		-- tex:"8760867bf67a3a14da103bf954625e2c"; x:-240.222717; y:-647.423889; z:-18.907331
		"\210\121\153\174\018\204\100\161\044\219\211\061\020\109\051\012\101\082\006\195\191\151\031\196\053\066\151\193" ..
		-- tex:"d27999ae12cc64a12cdbd33d146d330c"; x:-134.321869; y:-638.371094; z:-18.907330
		"\103\029\225\144\251\094\215\038\100\236\238\228\021\164\174\044\059\070\031\195\055\246\035\196\053\066\151\193" ..
		-- tex:"671de190fb5ed72664eceee415a4ae2c"; x:-159.274353; y:-655.847168; z:-18.907330
		"\113\193\007\216\099\008\215\246\063\213\206\148\052\183\021\037\192\001\064\195\215\041\041\196\053\066\151\193" ..
		-- tex:"71c107d86308d7f63fd5ce9434b71525"; x:-192.006851; y:-676.653809; z:-18.907330
		"\187\149\191\071\032\157\007\249\131\248\083\002\111\251\125\171\025\185\218\194\049\057\027\196\053\066\151\193" ..
		-- tex:"bb95bf47209d07f983f853026ffb7dab"; x:-109.361526; y:-620.893677; z:-18.907330
		"\147\237\158\238\112\152\183\075\065\105\123\059\024\085\142\223\054\063\186\194\048\234\038\196\245\212\150\193" ..
		-- tex:"93ed9eee7098b74b41697b3b18558edf"; x:-93.123466; y:-667.659241; z:-18.853985
		"\015\031\212\147\108\038\071\061\110\145\142\138\249\135\249\054\104\190\159\195\069\138\033\196\079\002\140\193" ..
		-- tex:"0f1fd4936c26473d6e918e8af987f936"; x:-319.487579; y:-646.160522; z:-17.501129
		"\210\047\196\214\124\208\189\130\232\173\239\036\089\090\085\243\149\238\176\195\049\101\004\196\028\247\139\193" ..
		-- tex:"d22fc4d67cd0bd82e8adef24595a55f3"; x:-353.863953; y:-529.581177; z:-17.495661
		"\136\038\106\077\246\238\237\115\050\136\180\046\206\132\107\042\184\235\247\194\241\163\018\196\056\237\139\193" ..
		-- tex:"88266a4df6eeed733288b42ece846b2a"; x:-123.960396; y:-586.561646; z:-17.490831
		"\055\041\033\174\033\161\197\051\108\000\177\026\128\117\050\174\104\139\154\064\206\118\045\196\132\069\125\193" ..
		-- tex:"372921ae21a1c5336c00b11a807532ae"; x:4.829518; y:-693.856384; z:-15.829473
		"\037\173\172\182\196\165\168\220\120\154\192\063\098\197\186\170\038\067\137\194\138\032\020\196\196\191\123\193" ..
		-- tex:"25adacb6c4a5a8dc789ac03f62c5baaa"; x:-68.631157; y:-592.508484; z:-15.734319
		"\120\081\020\178\071\114\145\127\002\105\040\169\050\197\144\177\034\214\001\194\141\203\013\196\193\191\123\193" ..
		-- tex:"785114b24772917f026928a932c590b1"; x:-32.459118; y:-567.180542; z:-15.734316
		"\241\238\030\098\197\052\254\066\026\139\043\002\043\006\169\189\088\091\156\195\119\127\005\068\056\228\067\193" ..
		-- tex:"f1ee1e62c534fe421a8b2b022b06a9bd"; x:-312.713654; y:533.991699; z:-12.243218
		"\145\250\118\080\190\241\254\191\247\139\110\239\098\135\132\120\148\117\095\196\069\214\051\068\046\253\009\193" ..
		-- tex:"91fa7650bef1febff78b6eef62878478"; x:-893.837219; y:719.348022; z:-8.624312
		"\011\110\011\106\087\118\023\116\213\053\069\025\176\129\152\123\003\045\154\196\046\058\011\068\031\126\152\065",
		-- tex:"0b6e0b6a57761774d5354519b081987b"; x:-1233.406738; y:556.909119; z:19.061584
	["Sunwell Plateau"] = 
		"\201\074\204\083\033\148\081\142\084\196\231\253\248\180\040\084\086\207\070\195\069\133\080\195\195\186\152\195" ..
		-- tex:"c94acc532194518e54c4e7fdf8b42854"; x:-198.809921; y:-208.520599; z:-305.459106
		"\064\240\219\076\007\196\097\026\066\131\078\005\061\055\238\131\233\070\081\196\224\012\139\195\173\181\014\195" ..
		-- tex:"40f0db4c07c4611a42834e053d37ee83"; x:-837.108032; y:-278.100616; z:-142.709686
		"\073\058\174\115\103\207\176\140\123\214\235\229\084\062\075\064\233\070\081\196\015\206\176\193\173\181\014\195" ..
		-- tex:"493aae7367cfb08c7bd6ebe5543e4b40"; x:-837.108032; y:-22.100616; z:-142.709686
		"\215\140\182\216\196\162\237\204\077\098\136\210\144\096\115\109\102\246\018\195\146\040\166\195\197\051\077\194" ..
		-- tex:"d78cb6d8c4a2edcc4d6288d29060736d"; x:-146.962509; y:-332.316986; z:-51.300560
		"\101\024\022\158\035\207\045\014\015\149\238\093\247\116\134\081\102\246\018\195\064\078\180\195\191\051\077\194" ..
		-- tex:"6518169e23cf2d0e0f95ee5df7748651"; x:-146.962509; y:-360.611359; z:-51.300537
		"\027\037\241\111\230\168\011\156\090\080\057\078\039\230\078\220\209\158\035\196\223\172\057\195\252\125\132\193" ..
		-- tex:"1b25f16fe6a80b9c5a50394e27e64edc"; x:-654.481567; y:-185.675293; z:-16.561518
		"\143\110\201\173\085\027\055\103\204\121\243\034\037\035\052\123\209\158\035\196\111\214\220\195\252\125\132\193" ..
		-- tex:"8f6ec9ad551b3767cc79f3222523347b"; x:-654.481567; y:-441.675293; z:-16.561518
		"\080\222\241\017\195\200\090\046\095\205\135\004\087\218\172\241\209\158\099\196\223\172\057\195\252\125\132\193" ..
		-- tex:"50def111c3c85a2e5fcd870457daacf1"; x:-910.481567; y:-185.675293; z:-16.561518
		"\177\070\190\128\154\103\204\013\224\045\213\163\158\060\126\255\209\158\099\196\111\214\220\195\252\125\132\193" ..
		-- tex:"b146be809a67cc0de02dd5a39e3c7eff"; x:-910.481567; y:-441.675293; z:-16.561518
		"\139\214\185\090\250\215\087\007\038\227\013\117\097\050\254\090\020\097\075\196\063\154\228\195\018\145\102\193" ..
		-- tex:"8bd6b95afad7570726e30d756132fe5a"; x:-813.516907; y:-457.205078; z:-14.410419
		"\026\240\206\129\241\235\207\114\154\027\010\169\198\238\014\080\013\004\069\196\153\127\131\066\154\019\104\065" ..
		-- tex:"1af0ce81f1ebcf729a1b0aa9c6ee0e50"; x:-788.063354; y:65.749222; z:14.504786
		"\255\150\031\020\127\223\069\116\074\076\020\240\191\116\166\058\148\151\004\196\248\252\183\194\161\158\204\065" ..
		-- tex:"ff961f147fdf45744a4c14f0bf74a63a"; x:-530.368469; y:-91.994087; z:25.577457
		"\152\043\002\033\076\012\238\126\053\085\060\141\066\002\078\156\099\247\128\196\102\027\062\195\200\031\178\066",
		-- tex:"982b02214c0cee7e35553c8d42024e9c"; x:-1031.730957; y:-190.107040; z:89.062080
	["The Arcatraz"] = 
		"\017\052\139\151\097\151\248\236\144\101\205\027\143\071\044\186\107\250\033\196\060\098\006\195\150\143\233\196" ..
		-- tex:"11348b976197f8ec9065cd1b8f472cba"; x:-647.912842; y:-134.383743; z:-1868.487183
		"\028\001\087\153\149\229\147\087\210\228\172\134\065\195\022\181\006\106\035\196\156\234\012\195\105\217\211\195" ..
		-- tex:"1c01579995e59357d2e4ac8641c316b5"; x:-653.656677; y:-140.916458; z:-423.698547
		"\070\033\237\100\225\119\167\202\217\020\013\016\095\022\061\086\007\106\035\196\156\234\012\195\138\224\044\195" ..
		-- tex:"4621ed64e177a7cad9140d105f163d56"; x:-653.656738; y:-140.916458; z:-172.877121
		"\185\018\170\094\022\159\231\188\000\241\204\104\193\016\227\176\103\200\225\195\017\085\075\195\243\045\237\194" ..
		-- tex:"b912aa5e169fe7bc00f1cc68c110e3b0"; x:-451.565674; y:-203.332306; z:-118.589752
		"\182\006\041\230\219\091\198\224\048\004\149\135\058\251\137\170\222\166\042\196\250\124\007\067\189\052\028\194" ..
		-- tex:"b60629e6db5bc6e0300495873afb89aa"; x:-682.607361; y:135.488205; z:-39.051506
		"\207\251\228\136\171\237\008\051\177\038\070\184\004\174\225\136\189\077\213\195\250\124\007\067\189\052\028\194" ..
		-- tex:"cffbe488abed0833b12646b804aee188"; x:-426.607361; y:135.488205; z:-39.051506
		"\084\027\114\098\001\028\199\151\115\179\200\103\079\101\081\098\222\166\042\196\125\190\195\067\189\052\028\194" ..
		-- tex:"541b7262011cc79773b3c8674f655162"; x:-682.607361; y:391.488205; z:-39.051506
		"\070\049\200\191\084\103\094\253\168\005\070\154\194\136\248\229\189\077\213\195\125\190\195\067\189\052\028\194" ..
		-- tex:"4631c8bf54675efda805469ac288f8e5"; x:-426.607361; y:391.488205; z:-39.051506
		"\037\017\235\136\037\194\157\099\138\047\031\066\251\210\252\076\212\248\244\195\218\142\161\194\050\238\014\194" ..
		-- tex:"2511eb8825c29d638a2f1f42fbd2fc4c"; x:-489.944000; y:-80.779015; z:-35.732616
		"\109\080\081\249\135\036\097\248\116\087\255\123\192\089\166\028\123\087\213\195\075\047\019\067\170\246\207\193" ..
		-- tex:"6d5051f9872461f87457ff7bc059a61c"; x:-426.683472; y:147.184753; z:-25.995443
		"\002\188\226\042\071\098\050\207\221\112\080\196\222\067\226\194\203\200\158\195\045\236\161\193\131\246\207\193" ..
		-- tex:"02bce22a476232cfdd7050c4de43e2c2"; x:-317.568726; y:-20.240322; z:-25.995369
		"\090\018\158\094\244\163\156\200\247\245\214\062\196\021\153\050\079\161\240\195\013\101\062\195\216\008\199\193" ..
		-- tex:"5a129e5ef4a39cc8f7f5d63ec4159932"; x:-481.260254; y:-190.394745; z:-24.879320
		"\072\215\083\183\016\005\250\158\102\237\103\130\027\217\039\081\079\161\240\195\227\053\131\066\216\008\199\193" ..
		-- tex:"48d753b71005fa9e66ed67821bd92751"; x:-481.260254; y:65.605255; z:-24.879320
		"\148\093\047\178\132\208\152\171\174\135\218\027\238\193\156\199\167\080\056\196\227\053\131\066\216\008\199\193" ..
		-- tex:"945d2fb284d098abae87da1beec19cc7"; x:-737.260254; y:65.605255; z:-24.879320
		"\013\064\005\216\123\194\221\213\246\251\141\111\055\109\060\199\167\080\056\196\013\101\062\195\216\008\199\193" ..
		-- tex:"0d4005d87bc2ddd5f6fb8d6f376d3cc7"; x:-737.260254; y:-190.394745; z:-24.879320
		"\085\126\154\123\017\206\247\063\003\248\093\191\175\016\051\043\255\177\078\194\232\101\018\195\219\165\178\193" ..
		-- tex:"557e9a7b11cef73f03f85dbfaf10332b"; x:-51.673828; y:-146.398087; z:-22.330986
		"\173\214\200\083\154\040\018\165\053\236\151\187\082\075\058\069\063\214\153\195\232\101\018\195\219\165\178\193" ..
		-- tex:"add6c8539a2812a535ec97bb524b3a45"; x:-307.673828; y:-146.398087; z:-22.330986
		"\131\167\200\234\095\127\089\180\023\120\011\168\128\026\221\164\063\214\153\195\045\052\219\066\219\165\178\193" ..
		-- tex:"83a7c8ea5f7f59b417780ba8801adda4"; x:-307.673828; y:109.601913; z:-22.330986
		"\131\039\061\147\181\030\032\185\014\119\178\014\098\062\074\144\232\020\129\194\062\016\170\194\136\118\198\192" ..
		-- tex:"83273d93b51e20b90e77b20e623e4a90"; x:-64.540840; y:-85.031731; z:-6.201970
		"\223\006\079\209\203\129\180\121\104\005\229\208\010\027\181\078\012\030\043\196\105\192\188\195\013\094\231\065" ..
		-- tex:"df064fd1cb81b4796805e5d00a1bb54e"; x:-684.469543; y:-377.503235; z:28.920925
		"\023\250\212\024\061\251\042\094\028\252\134\036\137\149\172\157\010\015\011\196\204\246\135\066\207\203\027\066" ..
		-- tex:"17fad4183dfb2a5e1cfc86248995ac9d"; x:-556.235046; y:67.982033; z:38.949036
		"\099\142\151\104\214\160\060\168\214\205\252\073\049\126\025\029\031\130\235\195\197\228\098\195\045\147\031\066" ..
		-- tex:"638e9768d6a03ca8d6cdfc49317e191d"; x:-471.016602; y:-226.893646; z:39.893730
		"\087\161\249\069\170\015\183\061\102\240\001\125\143\115\192\189\063\004\087\195\098\114\241\195\045\147\031\066" ..
		-- tex:"57a1f945aa0fb73d66f0017d8f73c0bd"; x:-215.016602; y:-482.893646; z:39.893730
		"\062\118\077\155\054\079\081\142\220\091\085\190\123\167\102\132\063\004\087\195\197\228\098\195\045\147\031\066" ..
		-- tex:"3e764d9b364f518edc5b55be7ba76684"; x:-215.016602; y:-226.893646; z:39.893730
		"\242\019\021\148\125\040\146\078\064\174\120\151\170\159\117\126\031\130\235\195\098\114\241\195\045\147\031\066" ..
		-- tex:"f21315947d28924e40ae7897aa9f757e"; x:-471.016602; y:-482.893646; z:39.893730
		"\076\102\207\099\064\065\154\134\191\034\170\018\091\133\140\255\048\067\027\196\173\032\077\195\033\147\049\066" ..
		-- tex:"4c66cf6340419a86bf22aa125b858cff"; x:-621.049866; y:-205.127655; z:44.393684
		"\128\003\238\144\195\224\060\232\012\107\224\071\071\239\115\008\104\150\246\195\022\216\155\195\128\249\049\066" ..
		-- tex:"8003ee90c3e03ce80c6be04747ef7308"; x:-493.175079; y:-311.688202; z:44.493656
		"\105\227\096\058\184\036\225\251\041\099\112\033\185\091\118\076\233\084\208\195\234\072\109\195\168\249\049\066" ..
		-- tex:"69e3603ab824e1fb29637021b95b764c"; x:-416.663391; y:-237.284836; z:44.493809
		"\012\167\164\128\060\150\045\250\177\101\008\154\142\003\220\255\014\194\135\196\193\155\202\066\167\184\144\066" ..
		-- tex:"0ca7a4803c962dfab165089a8e03dcff"; x:-1086.064331; y:101.304214; z:72.360657
		"\033\102\099\083\198\105\040\131\029\218\121\220\001\201\078\143\014\194\135\196\240\166\178\067\167\184\144\066" ..
		-- tex:"21666353c66928831dda79dc01c94e8f"; x:-1086.064331; y:357.304214; z:72.360657
		"\124\058\222\121\179\027\194\200\053\032\087\139\196\030\116\009\029\132\079\196\240\166\178\067\167\184\144\066" ..
		-- tex:"7c3ade79b31bc2c83520578bc41e7409"; x:-830.064331; y:357.304214; z:72.360657
		"\002\161\170\160\116\146\081\003\213\015\178\254\237\127\058\153\029\132\079\196\193\155\202\066\167\184\144\066" ..
		-- tex:"02a1aaa074925103d50fb2feed7f3a99"; x:-830.064331; y:101.304214; z:72.360657
		"\214\084\160\204\233\128\077\250\044\213\003\209\255\166\121\022\170\225\115\196\126\081\249\194\078\203\161\066" ..
		-- tex:"d654a0cce9804dfa2cd503d1ffa67916"; x:-975.526062; y:-124.659172; z:80.897087
		"\208\173\150\095\116\158\069\183\084\187\192\014\042\183\006\132\159\201\072\196\204\108\127\194\023\181\177\066" ..
		-- tex:"d0ad965f749e45b754bbc00e2ab70684"; x:-803.150391; y:-63.856251; z:88.853699
		"\095\176\208\075\149\163\233\138\213\057\041\085\072\019\168\065\212\182\223\195\060\036\173\194\071\189\192\066",
		-- tex:"5fb0d04b95a3e98ad53929554813a841"; x:-447.428375; y:-86.570778; z:96.369690
	["The Black Morass"] = 
		"\065\054\206\162\013\139\205\225\250\086\085\155\216\105\020\023\255\255\135\069\255\255\007\198\000\000\000\000" ..
		-- tex:"4136cea20d8bcde1fa56559bd8691417"; x:4352.000000; y:-8704.000000
		"\085\169\214\105\164\225\042\117\034\109\038\094\112\016\063\248\255\255\135\069\255\255\011\198\000\000\000\000" ..
		-- tex:"55a9d669a4e12a75226d265e70103ff8"; x:4352.000000; y:-8960.000000
		"\052\102\163\016\027\033\084\177\161\008\227\105\132\120\010\082\255\255\135\069\255\255\015\198\000\000\000\000" ..
		-- tex:"3466a3101b2154b1a108e36984780a52"; x:4352.000000; y:-9216.000000
		"\200\077\088\223\124\052\030\158\146\077\092\077\147\018\218\151\255\255\143\069\255\255\007\198\000\000\000\000" ..
		-- tex:"c84d58df7c341e9e924d5c4d9312da97"; x:4608.000000; y:-8704.000000
		"\042\206\156\007\050\027\221\204\048\168\071\179\088\239\209\035\255\255\143\069\255\255\011\198\000\000\000\000" ..
		-- tex:"2ace9c07321bddcc30a847b358efd123"; x:4608.000000; y:-8960.000000
		"\180\203\209\223\238\159\207\224\157\017\085\029\015\043\238\012\255\255\143\069\255\255\015\198\000\000\000\000" ..
		-- tex:"b4cbd1dfee9fcfe09d11551d0f2bee0c"; x:4608.000000; y:-9216.000000
		"\151\227\127\215\062\245\082\003\007\199\151\006\136\001\040\171\255\255\151\069\255\255\007\198\000\000\000\000" ..
		-- tex:"97e37fd73ef5520307c79706880128ab"; x:4864.000000; y:-8704.000000
		"\012\226\088\219\033\205\216\010\023\129\071\005\017\116\084\029\255\255\151\069\255\255\011\198\000\000\000\000" ..
		-- tex:"0ce258db21cdd80a178147051174541d"; x:4864.000000; y:-8960.000000
		"\203\147\104\007\088\115\214\080\096\016\013\104\100\012\034\254\255\255\151\069\255\255\015\198\000\000\000\000",
		-- tex:"cb9368075873d65060100d68640c22fe"; x:4864.000000; y:-9216.000000
	["The Blood Furnace"] = 
		"\203\086\229\051\174\167\130\235\236\101\078\079\247\105\151\081\143\073\000\196\138\023\194\066\096\027\141\195" ..
		-- tex:"cb56e533aea782ebec654e4ff7699751"; x:-513.149414; y:97.045982; z:-282.213898
		"\213\130\162\222\054\247\018\253\015\231\206\133\007\012\061\101\206\138\028\196\100\031\039\067\012\056\139\195" ..
		-- tex:"d582a2de36f712fd0fe7ce85070c3d65"; x:-626.168884; y:167.122627; z:-278.437897
		"\131\195\056\162\094\138\009\220\243\095\086\031\164\173\206\170\206\138\092\196\100\031\039\067\012\056\139\195" ..
		-- tex:"83c338a25e8a09dcf35f561fa4adceaa"; x:-882.168884; y:167.122627; z:-278.437897
		"\158\239\246\203\010\185\085\077\046\017\101\123\211\055\210\024\206\138\028\196\054\193\177\194\012\056\139\195" ..
		-- tex:"9eeff6cb0ab9554d2e11657bd337d218"; x:-626.168884; y:-88.877373; z:-278.437897
		"\159\066\059\046\017\154\011\206\161\011\038\095\089\080\247\154\206\138\092\196\054\193\177\194\012\056\139\195" ..
		-- tex:"9f423b2e119a0bcea10b265f5950f79a"; x:-882.168884; y:-88.877373; z:-278.437897
		"\014\100\146\135\118\067\077\178\222\235\214\129\218\197\070\221\206\138\092\196\178\143\211\067\012\056\139\195" ..
		-- tex:"0e64928776434db2deebd681dac546dd"; x:-882.168884; y:423.122627; z:-278.437897
		"\013\062\242\002\045\093\003\007\015\036\079\187\253\101\087\142\176\072\138\196\088\029\229\066\069\011\015\195" ..
		-- tex:"0d3ef2022d5d03070f244fbbfd65578e"; x:-1106.271606; y:114.557320; z:-143.044037
		"\203\019\240\141\008\076\092\073\175\180\063\190\176\152\047\096\050\090\239\195\172\217\096\067\056\026\236\194" ..
		-- tex:"cb13f08d084c5c49afb43fbeb0982f60"; x:-478.704681; y:224.850296; z:-118.051216
		"\090\247\163\219\084\227\216\224\246\097\191\213\049\190\183\034\101\180\094\195\172\217\096\067\056\026\236\194" ..
		-- tex:"5af7a3db54e3d8e0f661bfd531beb722"; x:-222.704681; y:224.850296; z:-118.051216
		"\140\064\015\249\163\065\220\185\164\128\147\213\246\076\092\099\250\111\191\195\207\113\067\194\118\134\179\194" ..
		-- tex:"8c400ff9a341dcb9a48093d5f64c5c63"; x:-382.874847; y:-48.861145; z:-89.762627
		"\176\240\050\077\036\001\053\122\066\190\083\117\039\245\184\080\250\111\191\195\139\035\079\067\118\134\179\194" ..
		-- tex:"b0f0324d2401357a42be537527f5b850"; x:-382.874847; y:207.138855; z:-89.762627
		"\093\068\019\001\033\170\115\243\252\046\152\172\244\040\017\177\235\191\253\194\207\113\067\194\118\134\179\194" ..
		-- tex:"5d44130121aa73f3fc2e98acf42811b1"; x:-126.874847; y:-48.861145; z:-89.762627
		"\064\102\172\025\052\047\056\093\040\054\030\133\001\048\148\207\235\191\253\194\139\035\079\067\118\134\179\194" ..
		-- tex:"4066ac19342f385d28361e85013094cf"; x:-126.874847; y:207.138855; z:-89.762627
		"\112\146\027\082\136\218\130\215\167\255\072\178\226\192\089\098\168\067\098\196\027\023\163\194\054\134\132\194" ..
		-- tex:"70921b5288da82d7a7ff48b2e2c05962"; x:-905.057190; y:-81.545135; z:-66.262138
		"\092\154\178\235\005\012\116\223\095\025\020\099\244\022\232\016\081\135\196\195\027\023\163\194\054\134\132\194" ..
		-- tex:"5c9ab2eb050c74df5f191463f416e810"; x:-393.057190; y:-81.545135; z:-66.262138
		"\104\034\076\017\179\243\023\117\129\101\207\008\139\175\056\243\081\135\196\195\113\116\046\067\054\134\132\194" ..
		-- tex:"68224c11b3f317758165cf088baf38f3"; x:-393.057190; y:174.454865; z:-66.262138
		"\097\109\019\184\000\016\133\116\005\132\105\190\089\221\191\034\168\067\098\196\113\116\046\067\054\134\132\194" ..
		-- tex:"616d13b800108574058469be59ddbf22"; x:-905.057190; y:174.454865; z:-66.262138
		"\049\173\095\147\099\033\166\025\210\110\140\146\030\245\109\150\168\067\034\196\027\023\163\194\054\134\132\194" ..
		-- tex:"31ad5f936321a619d26e8c921ef56d96"; x:-649.057190; y:-81.545135; z:-66.262138
		"\013\141\063\184\190\041\008\156\095\027\086\029\098\091\175\174\168\067\034\196\113\116\046\067\054\134\132\194" ..
		-- tex:"0d8d3fb8be29089c5f1b561d625bafae"; x:-649.057190; y:174.454865; z:-66.262138
		"\172\038\208\067\068\068\012\182\010\243\010\245\209\207\103\148\029\246\127\196\169\227\150\195\108\180\227\064" ..
		-- tex:"ac26d04344440cb60af30af5d1cf6794"; x:-1023.845581; y:-301.778625; z:7.115775
		"\097\246\215\000\114\197\099\070\184\051\083\022\137\144\186\199\173\153\063\196\054\120\162\195\087\181\227\064" ..
		-- tex:"61f6d70072c56346b83353168990bac7"; x:-766.401245; y:-324.939178; z:7.115887
		"\172\016\174\009\150\191\000\145\037\115\114\110\205\020\078\114\036\020\130\196\093\082\062\067\211\170\145\065" ..
		-- tex:"ac10ae0996bf00912573726ecd144e72"; x:-1040.629517; y:190.321739; z:18.208412
		"\165\204\152\066\015\140\122\023\005\107\249\128\127\055\045\089\036\020\130\196\068\091\131\194\211\170\145\065" ..
		-- tex:"a5cc98420f8c7a17056bf9807f372d59"; x:-1040.629517; y:-65.678261; z:18.208412
		"\242\130\150\184\063\128\215\092\212\015\155\203\188\108\024\254\097\082\057\196\055\092\213\195\202\179\151\065" ..
		-- tex:"f28296b83f80d75cd40f9bcbbc6c18fe"; x:-741.287231; y:-426.720459; z:18.962790
		"\079\012\242\063\099\102\203\046\184\226\247\233\174\115\156\177\097\082\121\196\055\092\213\195\202\179\151\065",
		-- tex:"4f0cf23f6366cb2eb8e2f7e9ae739cb1"; x:-997.287231; y:-426.720459; z:18.962790
	["The Botanica"] = 
		"\102\177\095\062\032\035\053\131\066\168\004\061\186\147\087\000\235\061\228\066\103\211\067\196\054\205\022\196" ..
		-- tex:"66b15f3e2023358342a8043dba935700"; x:114.120941; y:-783.303223; z:-603.206482
		"\009\234\009\097\217\226\129\250\104\014\166\077\248\006\113\006\235\061\228\066\179\233\129\196\054\205\022\196" ..
		-- tex:"09ea0961d9e281fa680ea64df8067106"; x:114.120941; y:-1039.303223; z:-603.206482
		"\030\162\234\250\194\100\156\220\226\028\043\104\181\100\072\033\132\240\198\195\179\233\129\196\054\205\022\196" ..
		-- tex:"1ea2eafac2649cdce21c2b68b5644821"; x:-397.879059; y:-1039.303223; z:-603.206482
		"\100\147\128\210\069\146\171\145\130\082\068\231\153\253\170\106\132\240\198\195\103\211\067\196\054\205\022\196" ..
		-- tex:"649380d24592ab91825244e799fdaa6a"; x:-397.879059; y:-783.303223; z:-603.206482
		"\153\246\111\061\031\128\106\024\195\180\235\021\002\020\027\149\009\225\013\195\179\233\129\196\054\205\022\196" ..
		-- tex:"99f66f3d1f806a18c3b4eb1502141b95"; x:-141.879059; y:-1039.303223; z:-603.206482
		"\062\042\146\115\142\243\201\157\208\196\187\002\244\089\154\119\009\225\013\195\103\211\067\196\054\205\022\196" ..
		-- tex:"3e2a92738ef3c99dd0c4bb02f4599a77"; x:-141.879059; y:-783.303223; z:-603.206482
		"\044\091\166\010\170\073\168\206\186\029\084\125\093\109\111\244\069\193\206\194\215\081\222\195\009\102\066\195" ..
		-- tex:"2c5ba60aaa49a8ceba1d547d5d6d6ff4"; x:-103.377487; y:-444.639404; z:-194.398590
		"\053\108\218\077\107\060\150\117\204\228\064\107\071\183\027\054\069\193\206\194\235\040\047\196\009\102\066\195" ..
		-- tex:"356cda4d6b3c9675cce4406b47b71b36"; x:-103.377487; y:-700.639404; z:-194.398590
		"\217\218\033\032\191\077\159\182\239\222\002\112\151\133\014\117\092\159\024\067\235\040\047\196\009\102\066\195" ..
		-- tex:"d9da2120bf4d9fb6efde027097850e75"; x:152.622513; y:-700.639404; z:-194.398590
		"\202\034\025\237\170\029\233\023\061\116\204\044\089\113\150\066\027\168\013\195\185\166\019\067\246\208\078\194" ..
		-- tex:"ca2219edaa1de9173d74cc2c59719642"; x:-141.656677; y:147.651276; z:-51.704067
		"\014\058\234\050\127\060\096\158\089\224\098\155\173\078\106\010\027\168\013\195\139\178\216\194\246\208\078\194" ..
		-- tex:"0e3aea327f3c609e59e0629bad4e6a0a"; x:-141.656677; y:-108.348724; z:-51.704067
		"\044\053\122\122\247\153\195\213\091\248\027\004\064\092\220\216\027\168\013\195\162\044\182\195\246\208\078\194" ..
		-- tex:"2c357a7af799c3d55bf81b04405cdcd8"; x:-141.656677; y:-364.348724; z:-51.704067
		"\172\176\052\030\066\080\217\225\237\096\231\233\001\030\016\016\199\175\228\066\139\178\216\194\246\208\078\194" ..
		-- tex:"acb0341e4250d9e1ed60e7e9011e1010"; x:114.343323; y:-108.348724; z:-51.704067
		"\026\047\171\255\077\166\221\253\240\051\017\235\123\198\146\024\126\188\160\067\037\010\159\196\136\177\073\194" ..
		-- tex:"1a2fabff4da6ddfdf03311eb7bc69218"; x:321.472626; y:-1272.317139; z:-50.423374
		"\148\183\187\056\218\030\248\018\116\239\021\005\151\041\019\156\126\188\160\067\075\020\062\196\136\177\073\194" ..
		-- tex:"94b7bb38da1ef81274ef15059729139c"; x:321.472626; y:-760.317139; z:-50.423374
		"\056\045\214\166\221\027\255\026\182\005\201\208\022\126\008\194\126\188\160\067\075\020\126\196\136\177\073\194" ..
		-- tex:"382dd6a6dd1bff1ab605c9d0167e08c2"; x:321.472626; y:-1016.317139; z:-50.423374
		"\015\067\229\153\012\205\015\016\113\111\087\070\067\254\166\194\251\241\130\066\075\020\126\196\136\177\073\194" ..
		-- tex:"0f43e5990ccd0f10716f574643fea6c2"; x:65.472626; y:-1016.317139; z:-50.423374
		"\094\086\244\010\236\166\217\077\192\234\077\117\088\139\237\089\251\241\130\066\075\020\062\196\136\177\073\194" ..
		-- tex:"5e56f40aeca6d94dc0ea4d75588bed59"; x:65.472626; y:-760.317139; z:-50.423374
		"\246\027\051\158\041\076\086\153\160\218\183\059\165\084\082\193\001\135\062\195\075\020\126\196\136\177\073\194" ..
		-- tex:"f61b339e294c5699a0dab73ba55452c1"; x:-190.527374; y:-1016.317139; z:-50.423374
		"\045\052\078\070\086\148\100\177\104\233\094\151\187\044\188\151\251\241\130\066\037\010\159\196\136\177\073\194" ..
		-- tex:"2d344e46569464b168e95e97bb2cbc97"; x:65.472626; y:-1272.317139; z:-50.423374
		"\134\045\197\217\063\024\220\127\069\239\200\184\101\012\131\063\001\135\062\195\037\010\159\196\136\177\073\194" ..
		-- tex:"862dc5d93f18dc7f45efc8b8650c833f"; x:-190.527374; y:-1272.317139; z:-50.423374
		"\030\097\144\069\152\120\167\156\114\086\043\168\199\119\252\160\197\208\071\195\228\235\133\196\217\243\043\194" ..
		-- tex:"1e6190459878a79c72562ba8c777fca0"; x:-199.815521; y:-1071.371704; z:-42.988136
		"\148\213\106\191\045\007\130\242\242\108\186\116\203\018\180\226\098\232\227\195\228\235\133\196\217\243\043\194" ..
		-- tex:"94d56abf2d0782f2f26cba74cb12b4e2"; x:-455.815521; y:-1071.371704; z:-42.988136
		"\053\013\122\085\016\225\136\228\198\172\033\218\169\204\020\083\098\232\227\195\201\215\075\196\217\243\043\194" ..
		-- tex:"350d7a5510e188e4c6ac21daa9cc1453"; x:-455.815521; y:-815.371704; z:-42.988136
		"\038\160\072\184\086\045\146\012\136\230\191\105\236\022\204\204\197\208\071\195\002\109\014\196\192\243\043\194" ..
		-- tex:"26a048b8562d920c88e6bf69ec16cccc"; x:-199.815521; y:-569.703308; z:-42.988041
		"\138\215\005\097\206\029\106\165\142\103\064\167\002\133\081\112\098\232\227\195\002\109\014\196\192\243\043\194" ..
		-- tex:"8ad70561ce1d6aa58e6740a702855170"; x:-455.815521; y:-569.703308; z:-42.988041
		"\142\073\034\244\125\229\003\162\240\040\074\009\165\115\121\013\197\208\071\195\002\109\078\196\192\243\043\194" ..
		-- tex:"8e4922f47de503a2f0284a09a573790d"; x:-199.815521; y:-825.703308; z:-42.988041
		"\005\116\166\037\047\048\164\029\098\182\243\169\213\201\041\118\098\232\227\195\002\109\078\196\192\243\043\194",
		-- tex:"0574a6252f30a41d62b6f3a9d5c92976"; x:-455.815521; y:-825.703308; z:-42.988041
	["The Deadmines"] = 
		"\026\112\014\170\158\169\021\040\199\216\136\167\078\013\104\156\143\118\022\194\179\224\003\195\182\242\059\194" ..
		-- tex:"1a700eaa9ea91528c7d888a74e0d689c"; x:-37.615784; y:-131.877747; z:-46.987026
		"\167\147\090\111\017\242\108\041\000\132\162\092\163\227\146\184\040\195\056\065\059\081\171\194\136\091\015\194" ..
		-- tex:"a7935a6f11f26c290084a25ca3e392b8"; x:11.547647; y:-85.658661; z:-35.839390
		"\106\189\199\032\049\212\235\171\227\240\122\249\251\229\053\013\024\239\082\066\186\109\238\194\153\186\012\194" ..
		-- tex:"6abdc72031d4ebabe3f07af9fbe5350d"; x:52.733494; y:-119.214317; z:-35.182228
		"\036\252\036\134\107\099\133\219\219\107\112\085\176\119\157\180\207\160\218\066\085\250\130\194\203\176\214\193" ..
		-- tex:"24fc24866b6385dbdb6b7055b0779db4"; x:109.314087; y:-65.488937; z:-26.836327
		"\156\202\116\001\108\215\250\081\136\069\232\003\016\167\002\194\045\066\135\066\072\015\184\065\154\189\169\193" ..
		-- tex:"9cca74016cd7fa518845e80310a702c2"; x:67.629257; y:23.007463; z:-21.217581
		"\048\037\158\001\007\204\001\209\120\182\154\089\223\107\182\027\252\142\173\195\066\138\037\195\116\025\146\065" ..
		-- tex:"30259e0107cc01d178b69a59df6bb61b"; x:-347.117096; y:-165.540085; z:18.262430
		"\051\241\156\175\133\056\055\222\189\101\150\247\097\020\086\055\134\127\126\066\189\063\120\067\086\199\002\066" ..
		-- tex:"33f19caf853837debd6596f761145637"; x:63.624538; y:248.248993; z:32.694668
		"\153\186\039\071\129\075\192\025\088\068\051\137\140\137\200\217\197\144\152\067\191\061\243\066\231\086\007\066" ..
		-- tex:"99ba2747814bc019584433898c89c8d9"; x:305.131042; y:121.620605; z:33.834869
		"\071\253\199\017\215\022\164\192\013\124\159\019\158\119\229\141\095\245\252\066\177\144\114\067\125\176\007\066" ..
		-- tex:"47fdc711d716a4c00d7c9f139e77e58d"; x:126.479248; y:242.565216; z:33.922356
		"\128\201\152\012\094\046\157\167\196\070\140\143\205\105\184\141\123\238\092\067\058\230\090\067\127\216\014\066" ..
		-- tex:"80c9980c5e2e9da7c4468c8fcd69b88d"; x:220.931580; y:218.899338; z:35.711426
		"\116\113\186\034\202\038\160\060\064\211\049\150\026\125\136\220\207\129\124\067\035\151\201\066\017\244\014\066" ..
		-- tex:"7471ba22ca26a03c40d331961a7d88dc"; x:252.507080; y:100.795197; z:35.738350
		"\133\224\087\233\165\005\232\240\124\018\094\034\250\176\214\220\058\206\088\067\127\006\204\193\126\055\022\066" ..
		-- tex:"85e057e9a505e8f07c125e22fab0d6dc"; x:216.805588; y:-25.503174; z:37.554195
		"\036\097\060\029\119\044\171\115\060\237\004\021\190\231\178\131\095\013\181\066\083\237\043\067\120\093\028\066" ..
		-- tex:"24613c1d772cab733ced0415bee7b283"; x:90.526123; y:171.927063; z:39.091282
		"\143\130\056\127\048\240\097\184\112\008\160\191\190\224\152\213\020\037\197\067\075\196\225\194\002\213\034\066" ..
		-- tex:"8f82387f30f061b87008a0bfbee098d5"; x:394.289703; y:-112.883392; z:40.708019
		"\042\184\017\072\007\061\128\181\140\118\161\087\170\144\090\120\086\094\135\067\081\132\044\066\080\055\045\066" ..
		-- tex:"2ab81148073d80b58c76a157aa905a78"; x:270.737030; y:43.129219; z:43.304020
		"\003\022\196\179\125\136\138\007\190\196\093\052\031\116\223\206\165\145\176\067\209\038\019\066\129\103\046\066" ..
		-- tex:"0316c4b37d888a07bec45d341f74dfce"; x:353.137878; y:36.787910; z:43.601082
		"\136\048\081\231\136\031\232\251\116\186\057\246\248\031\021\172\020\108\135\067\138\253\003\193\191\128\051\066" ..
		-- tex:"883051e7881fe8fb74ba39f6f81f15ac"; x:270.844391; y:-8.249400; z:44.875732
		"\048\020\220\133\232\011\026\146\168\070\110\081\126\250\147\126\008\250\238\067\186\149\099\195\020\120\056\066" ..
		-- tex:"3014dc85e80b1a92a8466e517efa937e"; x:477.953400; y:-227.584885; z:46.117268
		"\213\180\201\139\189\009\179\245\115\171\032\018\153\043\088\124\173\204\016\068\173\039\063\195\186\151\062\066" ..
		-- tex:"d5b4c98bbd09b3f573ab2012992b587c"; x:579.198120; y:-191.154999; z:47.648174
		"\034\084\205\137\053\246\054\114\131\030\165\110\121\046\141\044\122\072\229\067\077\081\167\065\208\133\067\066" ..
		-- tex:"2254cd8935f63672831ea56e792e8d2c"; x:458.566254; y:20.914700; z:48.880680
		"\206\199\069\067\136\090\083\216\201\016\068\089\155\145\072\195\018\047\000\068\169\048\147\195\152\084\073\066" ..
		-- tex:"cec74543885a53d8c91044599b9148c3"; x:512.735535; y:-294.380188; z:50.332615
		"\155\099\082\204\127\062\122\166\046\118\110\121\075\082\039\204\163\047\241\067\111\021\113\193\217\077\081\066" ..
		-- tex:"9b6352cc7f3e7aa62e766e794b5227cc"; x:482.372192; y:-15.067734; z:52.326027
		"\248\080\085\140\219\050\014\057\128\079\068\168\175\103\222\055\103\047\237\067\060\185\015\195\156\215\082\066" ..
		-- tex:"f850558cdb320e39804f44a8af67de37"; x:474.370361; y:-143.723587; z:52.710560
		"\158\087\023\239\134\042\172\119\090\135\180\160\169\232\005\047\136\045\196\067\009\075\172\195\105\231\130\066" ..
		-- tex:"9e5717ef862aac775a87b4a0a9e8052f"; x:392.355743; y:-344.586243; z:65.451981
		"\190\117\154\000\189\200\159\214\079\114\202\132\193\135\002\036\113\246\200\067\012\238\148\195\105\231\130\066" ..
		-- tex:"be759a00bdc89fd64f72ca84c1870224"; x:401.925354; y:-297.859772; z:65.451981
		"\054\244\232\040\233\007\204\021\184\027\079\079\215\225\166\074\213\035\004\068\161\175\075\195\251\049\144\066" ..
		-- tex:"36f4e828e907cc15b81b4f4fd7e1a64a"; x:528.559937; y:-203.686066; z:72.097626
		"\214\076\121\150\156\083\037\190\165\057\140\074\052\018\049\015\064\091\170\067\015\005\131\195\149\034\165\066" ..
		-- tex:"d64c79969c5325bea5398c4a3412310f"; x:340.712921; y:-262.039551; z:82.567551
		"\252\159\132\105\191\042\031\186\124\047\031\098\069\069\157\054\186\190\151\067\021\164\082\195\098\063\167\066",
		-- tex:"fc9f8469bf2a1fba7c2f1f6245459d36"; x:303.490082; y:-210.640961; z:83.623802
	["The Eye"] = 
		"\117\168\166\042\245\121\045\051\075\022\199\206\020\204\028\069\118\135\035\196\047\002\112\065\022\080\049\195" ..
		-- tex:"75a8a62af5792d334b16c7ce14cc1c45"; x:-654.116638; y:15.000534; z:-177.312851
		"\159\040\199\157\021\134\018\041\093\126\161\255\238\165\251\255\118\135\035\196\220\255\112\195\022\080\049\195" ..
		-- tex:"9f28c79d158612295d7ea1ffeea5fbff"; x:-654.116638; y:-240.999466; z:-177.312851
		"\214\025\231\251\127\019\200\004\199\052\033\040\008\146\208\066\118\135\099\196\047\002\112\065\022\080\049\195" ..
		-- tex:"d619e7fb7f13c804c73421280892d042"; x:-910.116638; y:15.000534; z:-177.312851
		"\027\018\022\213\047\234\157\170\068\156\241\125\209\119\192\046\118\135\099\196\220\255\112\195\022\080\049\195" ..
		-- tex:"1b1216d52fea9daa449cf17dd177c02e"; x:-910.116638; y:-240.999466; z:-177.312851
		"\199\248\241\120\051\232\067\013\147\179\051\066\215\048\014\229\013\240\001\196\181\142\165\194\170\022\079\193" ..
		-- tex:"c7f8f17833e8430d93b33342d7300ee5"; x:-519.750854; y:-82.778732; z:-12.943034
		"\216\013\212\208\048\141\118\197\249\207\129\189\066\098\019\025\027\224\131\195\181\142\165\194\170\022\079\193" ..
		-- tex:"d80dd4d0308d76c5f9cf81bd42621319"; x:-263.750854; y:-82.778732; z:-12.943034
		"\042\183\168\191\067\145\196\232\110\187\116\180\096\211\248\234\255\006\248\192\181\142\165\194\170\022\079\193" ..
		-- tex:"2ab7a8bf4391c4e86ebb74b460d3f8ea"; x:-7.750854; y:-82.778732; z:-12.943034
		"\042\136\014\027\182\193\235\033\095\005\067\163\096\164\113\166\016\082\139\196\079\109\060\068\047\071\231\065" ..
		-- tex:"2a880e1bb6c1eb215f0543a360a471a6"; x:-1114.564575; y:753.707977; z:28.909760
		"\111\234\162\092\020\089\206\055\236\106\009\046\066\081\215\214\033\164\086\196\158\218\248\067\047\071\231\065" ..
		-- tex:"6feaa25c1459ce37ec6a092e4251d7d6"; x:-858.564575; y:497.707977; z:28.909760
		"\109\128\137\178\221\077\064\255\143\095\227\195\014\037\093\083\033\164\086\196\079\109\060\068\047\071\231\065" ..
		-- tex:"6d8089b2dd4d40ff8f5fe3c30e255d53"; x:-858.564575; y:753.707977; z:28.909760
		"\235\183\231\007\186\211\039\137\088\157\227\069\139\017\156\046\016\082\139\196\158\218\248\067\047\071\231\065" ..
		-- tex:"ebb7e707bad32789589de3458b119c2e"; x:-1114.564575; y:497.707977; z:28.909760
		"\028\135\110\096\089\063\121\031\250\223\222\151\119\227\247\145\045\055\140\196\010\187\055\196\165\077\232\065" ..
		-- tex:"1c876e60593f791ffadfde9777e3f791"; x:-1121.724365; y:-734.922546; z:29.037914
		"\227\132\224\121\189\013\030\208\215\188\215\186\240\029\033\162\045\055\140\196\010\187\119\196\165\077\232\065" ..
		-- tex:"e384e079bd0d1ed0d7bcd7baf01d21a2"; x:-1121.724365; y:-990.922546; z:29.037914
		"\019\153\108\034\135\235\012\012\066\255\242\084\203\230\040\110\091\110\088\196\010\187\119\196\165\077\232\065" ..
		-- tex:"13996c2287eb0c0c42fff254cbe6286e"; x:-865.724365; y:-990.922546; z:29.037914
		"\113\105\104\194\069\048\006\147\110\129\180\163\153\116\138\016\091\110\088\196\010\187\055\196\165\077\232\065" ..
		-- tex:"716968c2453006936e81b4a399748a10"; x:-865.724365; y:-734.922546; z:29.037914
		"\084\243\115\219\128\145\211\084\247\180\198\126\020\242\222\120\052\239\137\196\069\173\174\067\162\166\000\066" ..
		-- tex:"54f373db8091d354f7b4c67e14f2de78"; x:-1103.475220; y:349.353699; z:32.162731
		"\167\013\050\059\143\226\071\206\152\189\219\034\092\199\176\160\105\222\083\196\023\181\186\066\162\166\000\066" ..
		-- tex:"a70d323b8fe247ce98bddb225cc7b0a0"; x:-847.475220; y:93.353699; z:32.162731
		"\155\147\071\252\148\236\207\145\199\205\038\183\253\100\050\102\052\239\137\196\023\181\186\066\162\166\000\066" ..
		-- tex:"9b9347fc94eccf91c7cd26b7fd643266"; x:-1103.475220; y:93.353699; z:32.162731
		"\208\024\032\047\004\090\155\128\228\064\037\197\059\081\108\015\049\239\137\196\181\241\155\195\173\166\000\066" ..
		-- tex:"d018202f045a9b80e44025c53b516c0f"; x:-1103.474854; y:-311.888367; z:32.162773
		"\132\101\028\161\098\107\246\214\205\006\083\254\111\189\046\157\049\239\137\196\218\248\013\196\173\166\000\066" ..
		-- tex:"84651ca1626bf6d6cd0653fe6fbd2e9d"; x:-1103.474854; y:-567.888367; z:32.162773
		"\081\158\103\038\092\099\165\202\233\077\190\000\015\153\035\224\099\222\083\196\181\241\155\195\173\166\000\066" ..
		-- tex:"519e67265c63a5cae94dbe000f9923e0"; x:-847.474854; y:-311.888367; z:32.162773
		"\098\201\097\013\003\010\111\080\218\173\076\204\118\024\169\246\164\110\170\196\154\036\169\066\166\227\085\066" ..
		-- tex:"62c9610d030a6f50daad4ccc7618a9f6"; x:-1363.457642; y:84.571495; z:53.472317
		"\216\224\068\154\247\012\071\079\083\008\139\050\011\018\253\084\164\110\138\196\154\036\169\066\166\227\085\066" ..
		-- tex:"d8e0449af70c474f53088b320b12fd54"; x:-1107.457642; y:84.571495; z:53.472317
		"\031\043\231\133\005\115\009\131\162\066\225\115\203\061\045\032\161\110\170\196\059\031\156\195\176\227\085\066" ..
		-- tex:"1f2be78505730983a242e173cb3d2d20"; x:-1363.457275; y:-312.244019; z:53.472355
		"\168\204\233\125\085\148\023\214\209\010\008\144\144\100\143\249\161\110\138\196\059\031\156\195\176\227\085\066" ..
		-- tex:"a8cce97d559417d6d10a089090648ff9"; x:-1107.457275; y:-312.244019; z:53.472355
		"\053\236\142\213\047\132\053\081\048\168\244\016\094\083\111\180\109\190\187\196\046\105\036\195\017\134\182\066" ..
		-- tex:"35ec8ed52f84355130a8f4105e536fb4"; x:-1501.950928; y:-164.410873; z:91.261856
		"\144\146\207\241\037\052\242\027\052\226\029\145\065\221\131\014\109\190\187\196\161\045\183\066\017\134\182\066" ..
		-- tex:"9092cff12534f21b34e21d9141dd830e"; x:-1501.950928; y:91.589127; z:91.261856
		"\196\024\154\144\189\095\237\078\152\157\170\187\067\240\041\195\109\190\219\196\046\105\036\195\017\134\182\066" ..
		-- tex:"c4189a90bd5fed4e989daabb43f029c3"; x:-1757.950928; y:-164.410873; z:91.261856
		"\121\115\198\170\017\108\039\253\108\188\136\141\101\073\140\233\109\190\219\196\161\045\183\066\017\134\182\066" ..
		-- tex:"7973c6aa116c27fd6cbc888d65498ce9"; x:-1757.950928; y:91.589127; z:91.261856
		"\084\022\134\160\074\197\085\057\114\206\069\209\200\245\205\127\109\190\155\196\046\105\036\195\017\134\182\066",
		-- tex:"541686a04ac5553972ce45d1c8f5cd7f"; x:-1245.950928; y:-164.410873; z:91.261856
	["The Mechanar"] = 
		"\177\216\207\231\136\035\043\018\069\194\037\030\129\185\040\205\189\123\011\196\247\043\083\195\018\019\066\194" ..
		-- tex:"b1d8cfe788232b1245c2251e81b928cd"; x:-557.933472; y:-211.171753; z:-48.518627
		"\144\249\043\099\230\039\186\238\038\183\155\040\142\084\015\123\123\247\150\195\247\043\083\195\018\019\066\194" ..
		-- tex:"90f92b63e627baee26b79b288e540f7b"; x:-301.933472; y:-211.171753; z:-48.518627
		"\019\055\222\065\085\041\089\095\008\000\224\101\194\165\017\110\189\123\011\196\003\106\150\067\018\019\066\194" ..
		-- tex:"1337de415529595f0800e065c2a5116e"; x:-557.933472; y:300.828247; z:-48.518627
		"\224\068\192\232\000\194\232\017\160\187\191\198\191\238\086\155\189\123\011\196\031\080\051\066\018\019\066\194" ..
		-- tex:"e044c0e800c2e811a0bbbfc6bfee569b"; x:-557.933472; y:44.828247; z:-48.518627
		"\183\231\157\148\161\040\152\088\060\040\218\128\178\126\238\005\123\247\150\195\031\080\051\066\018\019\066\194" ..
		-- tex:"b7e79d94a12898583c28da80b27eee05"; x:-301.933472; y:44.828247; z:-48.518627
		"\102\133\244\208\069\177\241\154\187\051\080\089\018\056\131\021\123\247\150\195\003\106\150\067\018\019\066\194" ..
		-- tex:"6685f4d045b1f19abb33505912388315"; x:-301.933472; y:300.828247; z:-48.518627
		"\020\032\158\184\196\080\150\180\083\028\169\230\050\038\008\218\151\081\194\195\144\154\205\195\190\244\059\194" ..
		-- tex:"14209eb8c45096b4531ca9e6322608da"; x:-388.637451; y:-411.207550; z:-46.989010
		"\066\107\014\117\077\055\032\020\046\201\215\248\027\133\186\046\052\223\134\066\060\189\136\194\019\000\048\193" ..
		-- tex:"426b0e754d3720142ec9d7f81b85ba2e"; x:67.435951; y:-68.369606; z:-11.000019
		"\013\167\145\076\035\100\143\171\033\173\137\211\134\060\044\169\246\092\224\194\173\039\179\194\082\098\015\193" ..
		-- tex:"0da7914c23648fab21ad89d3863c2ca9"; x:-112.181572; y:-89.577499; z:-8.961505
		"\009\097\253\168\083\110\058\149\201\128\249\117\032\034\002\012\136\205\004\196\005\064\239\194\198\107\112\192" ..
		-- tex:"0961fda8536e3a95c980f9752022020c"; x:-531.211487; y:-119.625046; z:-3.756578
		"\231\214\069\128\187\228\207\242\230\086\087\150\185\172\227\035\174\234\158\194\059\074\012\195\084\149\099\189" ..
		-- tex:"e7d64580bbe4cff2e6565796b9ace323"; x:-79.458366; y:-140.289978; z:-0.055562
		"\002\202\200\188\005\000\058\216\181\191\164\200\163\204\135\248\163\234\158\194\202\085\163\066\198\145\099\189" ..
		-- tex:"02cac8bc05003ad8b5bfa4c8a3cc87f8"; x:-79.458282; y:81.667564; z:-0.055559
		"\198\006\025\007\214\102\247\136\075\249\087\046\121\009\086\078\046\253\195\194\254\215\000\195\255\135\138\062" ..
		-- tex:"c6061907d666f7884bf9572e7909564e"; x:-97.994499; y:-128.843735; z:0.270569
		"\242\118\088\031\097\175\108\065\229\040\189\073\105\213\093\055\109\253\195\194\001\095\206\066\011\136\138\062" ..
		-- tex:"f276581f61af6c41e528bd4969d55d37"; x:-97.994980; y:103.185562; z:0.270569
		"\096\045\050\014\075\088\048\007\242\026\115\074\163\048\129\213\058\254\046\196\255\219\131\066\158\045\066\065" ..
		-- tex:"602d320e4b583007f21a734aa33081d5"; x:-699.972351; y:65.929688; z:12.136138
		"\015\082\235\066\151\053\056\239\068\008\009\193\146\086\237\021\058\254\046\196\255\017\062\195\158\045\066\065" ..
		-- tex:"0f52eb42973538ef440809c19256ed15"; x:-699.972351; y:-190.070313; z:12.136138
		"\051\181\119\099\091\188\214\004\098\158\076\000\236\218\044\139\141\123\028\195\037\196\183\195\043\037\047\066" ..
		-- tex:"33b577635bbcd604629e4c00ecda2c8b"; x:-156.482635; y:-367.532410; z:43.786301
		"\225\186\186\197\176\149\018\119\161\167\029\023\063\013\148\192\038\175\005\196\134\122\206\065\165\103\082\066" ..
		-- tex:"e1babac5b0951277a1a71d173f0d94c0"; x:-534.736755; y:25.809828; z:52.601219
		"\021\112\075\047\065\154\172\003\252\013\182\214\235\205\224\172\095\251\147\195\179\044\102\195\154\195\082\066" ..
		-- tex:"15704b2f419aac03fc0db6d6ebcde0ac"; x:-295.963867; y:-230.174622; z:52.691021
		"\110\211\119\251\028\125\096\006\100\230\191\031\232\156\103\161\092\194\008\196\135\165\070\195\045\251\059\067" ..
		-- tex:"6ed377fb1c7d600664e6bf1fe89c67a1"; x:-547.036926; y:-198.646606; z:187.981171
		"\230\221\059\015\068\036\060\249\046\253\239\099\054\169\171\220\185\132\145\195\059\173\156\067\045\251\059\067" ..
		-- tex:"e6dd3b0f44243cf92efdef6336a9abdc"; x:-291.036926; y:313.353394; z:187.981171
		"\245\130\251\045\046\026\076\048\172\242\123\172\011\242\063\191\185\132\145\195\135\165\070\195\045\251\059\067" ..
		-- tex:"f582fb2d2e1a4c30acf27bac0bf23fbf"; x:-291.036926; y:-198.646606; z:187.981171
		"\248\163\026\091\188\124\032\207\089\235\152\187\254\217\209\093\092\194\008\196\059\173\156\067\045\251\059\067" ..
		-- tex:"f8a31a5bbc7c20cf59eb98bbfed9d15d"; x:-547.036926; y:313.353394; z:187.981171
		"\038\020\053\129\228\116\131\245\062\162\189\119\098\004\078\240\092\194\008\196\223\105\101\066\045\251\059\067" ..
		-- tex:"26143581e47483f53ea2bd7762044ef0"; x:-547.036926; y:57.353394; z:187.981171
		"\011\222\214\219\233\007\217\075\126\191\105\131\004\124\097\110\185\132\145\195\223\105\101\066\045\251\059\067",
		-- tex:"0bded6dbe907d94b7ebf6983047c616e"; x:-291.036926; y:57.353394; z:187.981171
	["The Nexus"] = 
		"\231\143\111\112\252\049\203\169\241\232\079\066\011\151\115\112\215\144\199\196\165\105\071\195\173\075\006\196" ..
		-- tex:"e78f6f70fc31cba9f1e84f420b977370"; x:-1596.526367; y:-199.412689; z:-537.182495
		"\046\054\050\226\032\030\172\045\051\192\181\254\220\246\011\167\215\144\135\196\165\105\071\195\173\075\006\196" ..
		-- tex:"2e3632e2201eac2d33c0b5fedcf60ba7"; x:-1084.526367; y:-199.412689; z:-537.182495
		"\105\036\041\213\124\074\045\085\056\198\027\073\097\165\195\181\215\144\167\196\150\037\078\068\173\075\006\196" ..
		-- tex:"692429d57c4a2d5538c61b4961a5c3b5"; x:-1340.526367; y:824.587311; z:-537.182495
		"\236\130\043\107\227\084\003\154\175\210\065\243\067\223\206\046\215\144\167\196\150\037\014\068\173\075\006\196" ..
		-- tex:"ec822b6be354039aafd241f343dfce2e"; x:-1340.526367; y:568.587311; z:-537.182495
		"\157\242\178\003\142\107\040\050\152\137\001\030\016\170\253\167\215\144\135\196\103\089\098\066\173\075\006\196" ..
		-- tex:"9df2b2038e6b28329889011e10aafda7"; x:-1084.526367; y:56.587311; z:-537.182495
		"\252\010\227\202\115\044\081\023\250\012\248\021\238\232\060\192\215\144\135\196\150\037\014\068\173\075\006\196" ..
		-- tex:"fc0ae3ca732c5117fa0cf815eee83cc0"; x:-1084.526367; y:568.587311; z:-537.182495
		"\248\117\108\211\027\154\155\238\080\224\108\091\090\022\142\167\215\144\135\196\044\075\156\067\173\075\006\196" ..
		-- tex:"f8756cd31b9a9bee50e06c5b5a168ea7"; x:-1084.526367; y:312.587311; z:-537.182495
		"\190\223\136\085\014\232\133\138\016\051\245\210\224\188\216\091\215\144\135\196\150\037\078\068\173\075\006\196" ..
		-- tex:"bedf88550ee8858a1033f5d2e0bcd85b"; x:-1084.526367; y:824.587311; z:-537.182495
		"\210\049\191\205\073\066\125\010\081\018\046\102\217\071\072\222\215\144\167\196\044\075\156\067\173\075\006\196" ..
		-- tex:"d231bfcd49427d0a51122e66d94748de"; x:-1340.526367; y:312.587311; z:-537.182495
		"\240\110\115\175\172\128\030\008\190\196\076\085\185\167\176\174\215\144\167\196\203\018\135\068\173\075\006\196" ..
		-- tex:"f06e73afac801e08bec44c55b9a7b0ae"; x:-1340.526367; y:1080.587311; z:-537.182495
		"\193\023\010\217\241\177\128\026\178\091\073\180\019\049\012\015\215\144\167\196\165\105\071\195\173\075\006\196" ..
		-- tex:"c1170ad9f1b1801ab25b49b413310c0f"; x:-1340.526367; y:-199.412689; z:-537.182495
		"\073\083\220\217\005\049\153\143\166\077\129\224\114\245\243\120\215\144\199\196\044\075\156\067\173\075\006\196" ..
		-- tex:"4953dcd90531998fa64d81e072f5f378"; x:-1596.526367; y:312.587311; z:-537.182495
		"\249\045\154\067\148\008\103\031\025\018\153\094\139\010\165\158\215\144\167\196\103\089\098\066\173\075\006\196" ..
		-- tex:"f92d9a439408671f1912995e8b0aa59e"; x:-1340.526367; y:56.587311; z:-537.182495
		"\161\196\024\196\045\119\049\123\146\075\128\122\029\023\185\053\215\144\199\196\150\037\014\068\173\075\006\196" ..
		-- tex:"a1c418c42d77317b924b807a1d17b935"; x:-1596.526367; y:568.587311; z:-537.182495
		"\215\031\045\190\010\191\075\064\085\115\165\057\157\067\068\030\215\144\199\196\103\089\098\066\173\075\006\196" ..
		-- tex:"d71f2dbe0abf4b405573a5399d43441e"; x:-1596.526367; y:56.587311; z:-537.182495
		"\017\115\173\037\017\122\249\030\085\121\141\121\142\062\233\039\215\144\199\196\203\018\135\068\173\075\006\196" ..
		-- tex:"1173ad25117af91e55798d798e3ee927"; x:-1596.526367; y:1080.587311; z:-537.182495
		"\003\230\128\117\209\019\210\008\209\203\116\219\023\017\115\018\215\144\199\196\150\037\078\068\173\075\006\196" ..
		-- tex:"03e68075d113d208d1cb74db17117312"; x:-1596.526367; y:824.587311; z:-537.182495
		"\084\169\122\116\191\058\022\171\218\238\019\086\001\057\012\179\077\061\058\196\138\044\230\194\172\075\006\196" ..
		-- tex:"54a97a74bf3a16abdaee135601390cb3"; x:-744.957886; y:-115.086998; z:-537.182434
		"\035\193\066\144\247\109\247\123\177\034\117\087\239\204\229\207\077\061\122\196\138\044\230\194\172\075\006\196" ..
		-- tex:"23c14290f76df77bb1227557efcce5cf"; x:-1000.957886; y:-115.086998; z:-537.182434
		"\126\003\222\146\194\205\029\172\178\240\206\188\037\070\161\185\131\228\141\196\234\096\145\195\045\050\203\194" ..
		-- tex:"7e03de92c2cd1dacb2f0cebc2546a1b9"; x:-1135.141113; y:-290.757172; z:-101.598007
		"\153\251\178\050\029\170\055\181\121\139\101\101\050\185\126\142\164\175\120\196\183\078\089\195\086\254\178\194" ..
		-- tex:"99fbb2321daa37b5798b656532b97e8e"; x:-994.744446; y:-217.307495; z:-89.496758
		"\159\043\198\114\127\190\024\138\255\106\248\227\153\009\115\244\164\175\120\196\091\167\236\195\086\254\178\194" ..
		-- tex:"9f2bc6727fbe188aff6af8e3990973f4"; x:-994.744446; y:-473.307495; z:-89.496758
		"\020\008\148\137\042\006\164\248\037\199\029\214\060\087\150\097\164\175\056\196\091\167\236\195\086\254\178\194" ..
		-- tex:"140894892a06a4f825c71dd63c579661"; x:-738.744446; y:-473.307495; z:-89.496758
		"\254\238\210\134\218\056\045\002\139\220\185\043\207\217\092\214\209\057\139\196\127\084\173\195\134\155\138\194" ..
		-- tex:"feeed286da382d028bdcb92bcfd95cd6"; x:-1113.806885; y:-346.660156; z:-69.303764
		"\034\125\192\248\163\210\028\236\004\089\124\068\191\118\138\125\253\130\054\196\244\084\173\195\179\151\138\194" ..
		-- tex:"227dc0f8a3d21cec04597c44bf768a7d"; x:-730.046753; y:-346.663727; z:-69.296295
		"\018\014\237\116\081\172\227\066\247\207\087\078\217\171\243\209\181\160\207\195\209\131\032\193\117\058\051\194" ..
		-- tex:"120eed7451ace342f7cf574ed9abf3d1"; x:-415.255554; y:-10.032183; z:-44.807091
		"\214\189\184\041\215\201\040\226\143\255\067\237\074\108\042\251\107\023\164\196\178\069\041\195\039\141\045\194" ..
		-- tex:"d6bdb829d7c928e28fff43ed4a6c2afb"; x:-1312.731934; y:-169.272263; z:-43.387848
		"\050\045\010\203\050\185\045\183\046\040\065\178\164\057\066\172\009\176\067\196\208\116\012\066\185\164\040\194" ..
		-- tex:"322d0acb32b92db72e2841b2a43942ac"; x:-782.750610; y:35.114079; z:-42.160866
		"\218\058\233\229\183\137\149\143\117\224\073\034\012\049\020\208\010\176\067\196\043\247\039\195\175\164\040\194" ..
		-- tex:"da3ae9e5b789958f75e049220c3114d0"; x:-782.750671; y:-167.965515; z:-42.160828
		"\022\152\182\174\082\177\185\186\039\025\014\176\185\078\045\173\253\234\016\196\246\117\012\066\175\164\040\194" ..
		-- tex:"1698b6ae52b1b9ba27190eb0b94e2dad"; x:-579.671753; y:35.115200; z:-42.160828
		"\203\071\050\220\142\137\152\162\174\139\161\177\037\069\202\176\250\234\016\196\043\247\039\195\173\164\040\194" ..
		-- tex:"cb4732dc8e8998a2ae8ba1b12545cab0"; x:-579.671570; y:-167.965515; z:-42.160820
		"\237\106\054\130\200\016\004\223\244\189\129\227\246\082\219\247\133\254\040\196\222\098\010\067\042\163\040\194" ..
		-- tex:"ed6a3682c81004dff4bd81e3f652dbf7"; x:-675.976929; y:138.386215; z:-42.159344
		"\072\108\062\181\180\032\179\006\033\109\178\148\159\197\051\140\136\005\055\196\030\154\234\194\025\163\040\194" ..
		-- tex:"486c3eb5b420b306216db2949fc5338c"; x:-732.086487; y:-117.301018; z:-42.159279
		"\151\062\052\176\198\169\114\184\110\147\040\134\186\162\149\154\039\040\041\196\175\061\131\195\021\163\040\194" ..
		-- tex:"973e34b0c6a972b86e932886baa2959a"; x:-676.627441; y:-262.481934; z:-42.159264
		"\221\166\175\070\122\026\218\117\144\173\113\149\216\104\224\172\029\051\238\195\101\196\116\194\002\163\040\194" ..
		-- tex:"dda6af467a1ada7590ad7195d868e0ac"; x:-476.399353; y:-61.191795; z:-42.159191
		"\200\058\228\215\237\159\015\028\165\224\028\074\247\177\166\044\133\211\132\196\010\171\180\067\064\122\037\194" ..
		-- tex:"c83ae4d7ed9f0f1ca5e01c4af7b1a62c"; x:-1062.610107; y:361.336273; z:-41.369389
		"\009\146\171\159\114\011\165\114\072\140\074\065\086\002\008\111\064\253\160\196\196\024\082\195\044\001\037\194" ..
		-- tex:"0992ab9f720ba572488c4a415602086f"; x:-1287.914185; y:-210.096756; z:-41.251148
		"\187\129\149\042\077\066\060\070\204\173\204\201\231\204\124\171\073\217\230\195\201\207\135\067\084\042\028\194" ..
		-- tex:"bb81952a4d423c46ccadccc9e7cc7cab"; x:-461.697571; y:271.623352; z:-39.041340
		"\214\084\090\225\145\005\148\106\080\196\020\217\079\198\125\075\164\108\051\196\228\231\003\068\084\042\028\194" ..
		-- tex:"d6545ae19105946a50c414d94fc67d4b"; x:-717.697571; y:527.623352; z:-39.041340
		"\159\146\060\003\209\186\074\228\035\217\252\225\125\197\113\216\164\108\115\196\228\231\003\068\084\042\028\194" ..
		-- tex:"9f923c03d1ba4ae423d9fce17dc571d8"; x:-973.697571; y:527.623352; z:-39.041340
		"\076\218\118\136\123\191\079\104\093\077\217\168\051\050\129\246\164\108\051\196\201\207\135\067\084\042\028\194" ..
		-- tex:"4cda76887bbf4f685d4dd9a8333281f6"; x:-717.697571; y:271.623352; z:-39.041340
		"\006\123\038\239\036\157\187\225\246\171\174\081\090\110\240\158\164\108\115\196\201\207\135\067\084\042\028\194" ..
		-- tex:"067b26ef249dbbe1f6abae515a6ef09e"; x:-973.697571; y:271.623352; z:-39.041340
		"\074\001\220\220\155\156\134\134\047\017\106\215\142\221\110\199\171\155\157\196\249\188\130\195\245\004\018\194" ..
		-- tex:"4a01dcdc9b9c86862f116ad78edd6ec7"; x:-1260.864746; y:-261.476379; z:-36.504845
		"\040\129\038\029\062\190\208\242\225\194\045\188\172\150\207\075\045\004\155\195\166\039\176\063\251\080\005\194" ..
		-- tex:"2881261d3ebed0f2e1c22dbcac96cf4b"; x:-310.032654; y:1.376210; z:-33.329086
		"\031\039\235\097\226\185\137\022\205\019\042\170\045\066\168\154\244\155\165\195\155\036\198\063\213\080\005\194",
		-- tex:"1f27eb61e2b98916cd132aaa2d42a89a"; x:-331.218414; y:1.547992; z:-33.328941
	["The Shattered Halls"] = 
		"\251\249\069\181\011\028\114\154\049\046\062\105\017\250\141\171\047\142\229\195\235\038\228\195\214\161\197\194" ..
		-- tex:"fbf945b50b1c729a312e3e6911fa8dab"; x:-459.110840; y:-456.304077; z:-98.816093
		"\112\042\077\249\058\058\128\103\150\195\199\181\169\118\221\219\096\147\139\195\189\171\009\196\198\002\189\194" ..
		-- tex:"702a4df93a3a806796c3c7b5a976dddb"; x:-279.151398; y:-550.683472; z:-94.505424
		"\004\219\252\108\009\209\055\237\232\019\235\135\221\129\031\009\033\015\218\195\115\141\027\196\019\229\048\194" ..
		-- tex:"04dbfc6c09d137ede813eb87dd811f09"; x:-436.118225; y:-622.210205; z:-44.223709
		"\254\088\244\142\143\142\060\121\152\235\116\034\217\236\140\179\151\200\164\195\108\100\244\065\178\128\004\194" ..
		-- tex:"fe58f48e8f8e3c7998eb7422d9ec8cb3"; x:-329.567139; y:30.549036; z:-33.125683
		"\253\059\163\057\107\224\133\145\051\143\226\027\026\209\236\247\075\100\018\196\108\100\244\065\178\128\004\194" ..
		-- tex:"fd3ba3396be08591338fe21b1ad1ecf7"; x:-585.567139; y:30.549036; z:-33.125683
		"\050\136\031\066\006\006\105\051\047\227\185\143\036\152\217\117\075\100\018\196\070\070\143\067\178\128\004\194" ..
		-- tex:"32881f42060669332fe3b98f2498d975"; x:-585.567139; y:286.549036; z:-33.125683
		"\211\073\123\182\083\124\003\096\172\160\182\254\144\151\219\013\053\016\089\195\139\009\168\195\255\097\247\193" ..
		-- tex:"d3497bb6537c0360aca0b6fe9097db0d"; x:-217.063324; y:-336.074585; z:-30.922852
		"\119\086\211\110\183\086\244\225\174\085\236\173\145\017\046\123\053\016\089\195\197\004\020\196\255\097\247\193" ..
		-- tex:"7756d36eb756f4e1ae55ecad91112e7b"; x:-217.063324; y:-592.074585; z:-30.922852
		"\254\245\250\018\191\063\142\084\179\217\223\236\166\250\192\045\162\105\058\066\239\145\132\063\205\218\225\193" ..
		-- tex:"fef5fa12bf3f8e54b3d9dfeca6fac02d"; x:46.603161; y:1.035704; z:-28.231838
		"\155\035\202\070\156\110\065\023\142\212\232\215\008\004\042\225\218\220\046\195\099\169\161\194\034\013\212\193" ..
		-- tex:"9b23ca469c6e41178ed4e8d708042ae1"; x:-174.862717; y:-80.830841; z:-26.506414
		"\227\070\185\237\066\094\199\179\229\119\157\142\164\187\229\126\148\105\018\196\195\018\039\196\066\008\212\193" ..
		-- tex:"e346b9ed425ec7b3e5779d8ea4bbe57e"; x:-585.649719; y:-668.293213; z:-26.504034
		"\213\124\111\137\088\111\239\196\008\164\066\189\198\000\228\179\099\181\096\196\203\116\149\195\154\240\186\193" ..
		-- tex:"d57c6f89586fefc408a442bdc600e4b3"; x:-898.834229; y:-298.912476; z:-23.367483
		"\231\215\104\128\026\092\173\108\096\240\223\093\223\050\038\089\177\090\144\196\101\186\010\196\154\240\186\193" ..
		-- tex:"e7d768801a5cad6c60f0df5ddf322659"; x:-1154.834229; y:-554.912476; z:-23.367483
		"\142\090\142\247\211\148\175\003\203\219\094\046\176\244\097\217\177\090\144\196\203\116\149\195\154\240\186\193" ..
		-- tex:"8e5a8ef7d394af03cbdb5e2eb0f461d9"; x:-1154.834229; y:-298.912476; z:-23.367483
		"\179\133\060\236\090\022\201\096\058\010\162\182\066\055\053\115\064\161\090\196\024\124\125\195\006\190\129\193" ..
		-- tex:"b3853cec5a16c9603a0aa2b642373573"; x:-874.519592; y:-253.484756; z:-16.217787
		"\071\122\142\111\144\018\144\102\111\204\142\066\093\018\124\186\064\161\090\196\191\249\032\064\006\190\129\193" ..
		-- tex:"477a8e6f901290666fcc8e425d127cba"; x:-874.519592; y:2.515244; z:-16.217787
		"\216\245\232\237\209\252\030\202\125\168\141\182\165\030\224\014\064\161\026\196\024\124\125\195\006\190\129\193" ..
		-- tex:"d8f5e8edd1fc1eca7da88db6a51ee00e"; x:-618.519592; y:-253.484756; z:-16.217787
		"\051\037\213\032\200\115\236\011\042\198\103\151\003\163\031\060\064\161\026\196\191\249\032\064\006\190\129\193" ..
		-- tex:"3325d520c873ec0b2ac6679703a31f3c"; x:-618.519592; y:2.515244; z:-16.217787
		"\100\193\112\002\223\010\205\225\217\167\203\058\203\048\107\008\053\057\082\196\117\224\047\196\100\149\036\191" ..
		-- tex:"64c17002df0acde1d9a7cb3acb306b08"; x:-840.893921; y:-703.507202; z:-0.642905
		"\227\177\171\076\061\096\201\215\213\048\068\127\144\224\120\088\154\028\137\196\117\224\047\196\100\149\036\191",
		-- tex:"e3b1ab4c3d60c9d7d530447f90e07858"; x:-1096.893921; y:-703.507202; z:-0.642905
	["The Slave Pens"] = 
		"\051\231\023\144\160\170\230\042\013\017\173\200\250\001\211\110\197\025\232\067\001\002\108\068\193\036\246\194" ..
		-- tex:"33e71790a0aae62a0d11adc8fa01d36e"; x:464.201355; y:944.031372; z:-123.071793
		"\164\252\254\224\200\060\071\037\206\005\065\011\029\093\244\163\207\049\063\194\001\002\108\068\193\036\246\194" ..
		-- tex:"a4fcfee0c83c4725ce05410b1d5df4a3"; x:-47.798645; y:944.031372; z:-123.071793
		"\188\018\070\084\140\188\082\172\059\187\082\059\247\112\180\179\207\049\063\194\000\001\150\068\193\036\246\194" ..
		-- tex:"bc1246548cbc52ac3bbb523bf770b4b3"; x:-47.798645; y:1200.031372; z:-123.071793
		"\240\026\236\112\254\201\161\254\086\163\082\120\239\187\249\254\207\049\063\194\001\002\044\068\193\036\246\194" ..
		-- tex:"f01aec70fec9a1fe56a35278efbbf9fe"; x:-47.798645; y:688.031372; z:-123.071793
		"\158\013\156\212\039\003\253\062\117\136\142\184\154\010\067\009\207\049\063\194\003\004\216\067\193\036\246\194" ..
		-- tex:"9e0d9cd42703fd3e75888eb89a0a4309"; x:-47.798645; y:432.031372; z:-123.071793
		"\041\200\051\117\103\231\203\018\017\129\181\166\153\065\208\106\207\049\063\194\007\008\048\067\193\036\246\194" ..
		-- tex:"29c8337567e7cb121181b5a69941d06a"; x:-47.798645; y:176.031372; z:-123.071793
		"\049\075\067\045\101\009\137\111\002\203\034\071\004\112\207\252\139\051\080\067\007\008\048\067\193\036\246\194" ..
		-- tex:"314b432d6509896f02cb22470470cffc"; x:208.201355; y:176.031372; z:-123.071793
		"\137\181\040\115\238\155\010\005\061\176\102\168\044\223\103\193\139\051\080\067\001\002\044\068\193\036\246\194" ..
		-- tex:"89b52873ee9b0a053db066a82cdf67c1"; x:208.201355; y:688.031372; z:-123.071793
		"\078\206\223\178\112\146\022\130\006\222\230\052\054\034\020\067\197\025\232\067\003\004\216\067\193\036\246\194" ..
		-- tex:"4ecedfb27092168206dee63436221443"; x:464.201355; y:432.031372; z:-123.071793
		"\171\064\129\000\011\161\242\059\138\219\193\160\154\055\225\185\139\051\080\067\003\004\216\067\193\036\246\194" ..
		-- tex:"ab4081000ba1f23b8adbc1a09a37e1b9"; x:208.201355; y:432.031372; z:-123.071793
		"\036\073\018\158\018\149\116\107\056\231\100\118\050\059\123\202\139\051\080\067\000\001\150\068\193\036\246\194" ..
		-- tex:"2449129e1295746b38e76476323b7bca"; x:208.201355; y:1200.031372; z:-123.071793
		"\105\039\007\006\173\253\095\019\058\169\181\234\178\159\005\205\139\051\080\067\001\002\108\068\193\036\246\194" ..
		-- tex:"69270706adfd5f133aa9b5eab29f05cd"; x:208.201355; y:944.031372; z:-123.071793
		"\115\224\088\215\168\129\052\080\238\215\198\191\131\082\226\055\197\025\232\067\001\002\044\068\193\036\246\194" ..
		-- tex:"73e058d7a8813450eed7c6bf8352e237"; x:464.201355; y:688.031372; z:-123.071793
		"\009\210\093\029\203\196\190\200\088\007\006\149\247\212\018\205\057\230\151\195\001\002\108\068\193\036\246\194" ..
		-- tex:"09d25d1dcbc4bec858070695f7d412cd"; x:-303.798645; y:944.031372; z:-123.071793
		"\010\140\191\229\229\173\125\034\093\116\193\125\176\119\064\076\057\230\151\195\003\004\216\067\193\036\246\194" ..
		-- tex:"0a8cbfe5e5ad7d225d74c17db077404c"; x:-303.798645; y:432.031372; z:-123.071793
		"\190\045\074\171\205\060\123\218\158\027\200\079\210\053\045\139\057\230\151\195\007\008\048\067\193\036\246\194" ..
		-- tex:"be2d4aabcd3c7bda9e1bc84fd2352d8b"; x:-303.798645; y:176.031372; z:-123.071793
		"\138\191\021\032\252\234\250\038\002\066\132\239\093\240\131\117\057\230\151\195\001\002\044\068\193\036\246\194" ..
		-- tex:"8abf1520fceafa26024284ef5df08375"; x:-303.798645; y:688.031372; z:-123.071793
		"\189\254\072\129\218\039\172\019\042\003\084\190\220\166\165\093\092\093\032\067\139\236\130\193\251\029\160\193" ..
		-- tex:"bdfe4881da27ac132a0354bedca6a55d"; x:160.364700; y:-16.365501; z:-20.014641
		"\143\249\203\060\077\171\015\152\138\053\064\254\013\136\200\220\007\167\088\194\190\033\050\067\187\237\130\193" ..
		-- tex:"8ff9cb3c4dab0f988a3540fe0d88c8dc"; x:-54.163116; y:178.131813; z:-16.366081
		"\151\004\045\200\255\032\064\000\212\082\220\073\221\171\030\098\224\020\155\195\190\033\050\067\187\237\130\193" ..
		-- tex:"97042dc8ff204000d452dc49ddab1e62"; x:-310.163116; y:178.131813; z:-16.366081
		"\060\131\129\242\237\151\218\208\244\204\085\212\053\161\184\003\007\167\088\194\130\188\155\194\187\237\130\193" ..
		-- tex:"3c8381f2ed97dad0f4cc55d435a1b803"; x:-54.163116; y:-77.868187; z:-16.366081
		"\207\217\140\112\103\095\167\153\250\230\186\252\245\012\060\096\224\020\155\195\130\188\155\194\187\237\130\193" ..
		-- tex:"cfd98c70675fa799fae6bafcf50c3c60"; x:-310.163116; y:-77.868187; z:-16.366081
		"\223\067\129\133\186\167\230\222\002\006\008\215\023\144\075\242\189\162\249\067\158\243\154\068\022\231\131\065" ..
		-- tex:"df438185baa7e6de020608d717904bf2"; x:499.271408; y:1239.613159; z:16.487837
		"\047\091\061\099\209\206\065\060\229\116\096\037\178\061\020\241\122\069\115\067\158\243\186\068\022\231\131\065" ..
		-- tex:"2f5b3d63d1ce413ce5746025b23d14f1"; x:243.271408; y:1495.613159; z:16.487837
		"\093\010\166\080\178\208\036\108\242\114\033\206\167\048\204\062\122\069\115\067\158\243\154\068\022\231\131\065" ..
		-- tex:"5d0aa650b2d0246cf27221cea730cc3e"; x:243.271408; y:1239.613159; z:16.487837
		"\071\211\077\150\074\078\044\122\239\146\194\251\166\149\241\065\251\015\254\066\006\009\166\068\038\252\081\066",
		-- tex:"47d34d964a4e2c7aef92c2fba695f141"; x:127.031219; y:1328.282104; z:52.496243
	["The Steamvault"] = 
		"\122\056\058\228\088\110\027\250\131\138\238\093\187\198\138\087\017\145\128\195\238\137\113\194\169\203\058\195" ..
		-- tex:"7a383ae4586e1bfa838aee5dbbc68a57"; x:-257.133362; y:-60.384701; z:-186.795563
		"\199\240\178\039\105\220\195\053\166\061\032\151\238\230\212\092\255\017\145\191\194\206\225\067\169\203\058\195" ..
		-- tex:"c7f0b22769dcc335a63d2097eee6d45c"; x:-1.133362; y:451.615299; z:-186.795563
		"\094\035\155\220\181\044\161\082\106\198\051\202\127\007\069\165\255\017\145\191\097\231\048\068\169\203\058\195" ..
		-- tex:"5e239bdcb52ca1526ac633ca7f0745a5"; x:-1.133362; y:707.615299; z:-186.795563
		"\031\033\089\221\203\157\092\085\177\029\199\152\200\212\134\176\219\221\126\067\194\206\225\067\169\203\058\195" ..
		-- tex:"1f2159ddcb9d5c55b11dc798c8d486b0"; x:254.866638; y:451.615299; z:-186.795563
		"\155\066\226\176\003\228\089\096\005\114\127\254\228\089\168\235\255\017\145\191\132\157\067\067\169\203\058\195" ..
		-- tex:"9b42e2b003e4596005727ffee459a8eb"; x:-1.133362; y:195.615299; z:-186.795563
		"\054\234\014\074\150\040\038\029\251\251\116\119\017\185\099\241\219\221\126\067\097\231\048\068\169\203\058\195" ..
		-- tex:"36ea0e4a9628261dfbfb747711b963f1"; x:254.866638; y:707.615299; z:-186.795563
		"\080\236\122\114\133\020\252\143\045\021\210\056\066\224\163\250\017\145\128\195\097\231\048\068\169\203\058\195" ..
		-- tex:"50ec7a728514fc8f2d15d23842e0a3fa"; x:-257.133362; y:707.615299; z:-186.795563
		"\215\183\017\130\068\073\081\062\036\115\157\050\021\113\052\039\017\145\128\195\132\157\067\067\169\203\058\195" ..
		-- tex:"d7b711824449513e24739d3215713427"; x:-257.133362; y:195.615299; z:-186.795563
		"\068\075\174\002\217\051\070\070\207\169\028\158\168\207\247\192\255\017\145\191\238\137\113\194\169\203\058\195" ..
		-- tex:"444bae02d9334646cfa91c9ea8cff7c0"; x:-1.133362; y:-60.384701; z:-186.795563
		"\063\062\135\092\057\059\063\224\034\017\201\164\202\072\255\236\017\145\128\195\194\206\225\067\169\203\058\195" ..
		-- tex:"3f3e875c393b3fe02211c9a4ca48ffec"; x:-257.133362; y:451.615299; z:-186.795563
		"\080\076\089\199\231\175\254\057\056\117\037\151\110\148\036\214\078\153\184\067\053\011\004\067\114\086\007\195" ..
		-- tex:"504c59c7e7affe39387525976e9424d6"; x:369.197723; y:132.043793; z:-135.337692
		"\031\099\172\243\102\109\128\217\005\038\044\056\225\117\226\031\078\153\184\067\154\005\194\067\114\086\007\195" ..
		-- tex:"1f63acf3666d80d905262c38e175e21f"; x:369.197723; y:388.043793; z:-135.337692
		"\036\176\127\001\120\193\020\219\171\194\129\217\119\036\253\217\167\076\028\068\053\011\004\067\114\086\007\195" ..
		-- tex:"24b07f0178c114dbabc281d97724fdd9"; x:625.197723; y:132.043793; z:-135.337692
		"\034\237\015\108\099\224\128\035\245\253\112\212\186\183\115\183\182\137\196\067\028\231\019\068\114\086\007\195" ..
		-- tex:"22ed0f6c63e08023f5fd70d4bab773b7"; x:393.075897; y:591.611145; z:-135.337692
		"\194\171\127\052\020\226\164\045\231\009\144\195\222\134\016\134\167\076\028\068\154\005\194\067\114\086\007\195" ..
		-- tex:"c2ab7f3414e2a42de70990c3de861086"; x:625.197723; y:388.043793; z:-135.337692
		"\040\154\180\107\049\230\188\113\161\158\090\077\242\043\245\202\004\039\127\067\102\247\094\068\014\025\044\194" ..
		-- tex:"289ab46b31e6bc71a19e5a4df22bf5ca"; x:255.152419; y:891.865662; z:-43.024471
		"\146\113\067\238\253\129\203\015\158\237\004\112\234\223\058\155\004\039\127\067\179\123\143\068\014\025\044\194" ..
		-- tex:"927143eefd81cb0f9eed0470eadf3a9b"; x:255.152419; y:1147.865662; z:-43.024471
		"\024\236\229\033\078\038\121\161\001\099\134\164\065\061\091\107\024\251\088\191\102\247\094\068\014\025\044\194" ..
		-- tex:"18ece5214e2679a1016386a4413d5b6b"; x:-0.847581; y:891.865662; z:-43.024471
		"\115\022\219\082\237\117\060\055\145\029\048\145\085\088\119\175\024\251\088\191\179\123\143\068\014\025\044\194" ..
		-- tex:"7316db52ed753c37911d3091555877af"; x:-0.847581; y:1147.865662; z:-43.024471
		"\184\240\160\036\248\073\048\124\072\164\154\034\226\017\124\224\067\234\139\067\152\159\220\067\235\196\125\193",
		-- tex:"b8f0a024f849307c48a49a22e2117ce0"; x:279.830200; y:441.246857; z:-15.860577
	["The Stockade"] = 
		"\096\209\215\217\051\130\072\243\095\097\058\112\131\090\058\179\074\015\123\195\229\110\238\194\070\183\142\194" ..
		-- tex:"60d1d7d9338248f35f613a70835a3ab3"; x:-251.059738; y:-119.216599; z:-71.357964
		"\135\147\107\142\064\089\049\104\044\245\103\185\245\220\200\111\179\008\165\195\089\076\209\194\070\183\142\194" ..
		-- tex:"87936b8e405931682cf567b9f5dcc86f"; x:-330.067993; y:-104.649124; z:-71.357964
		"\181\047\253\069\184\178\074\069\021\091\026\057\039\242\145\161\137\053\139\195\149\255\044\195\070\183\142\194" ..
		-- tex:"b52ffd45b8b24a45155b1a3927f291a1"; x:-278.418274; y:-172.998383; z:-71.357964
		"\062\178\229\130\011\190\019\161\048\057\130\036\009\157\049\091\129\045\118\195\049\021\110\066\070\183\142\194" ..
		-- tex:"3eb2e5820bbe13a130398224099d315b"; x:-246.177765; y:59.520699; z:-71.357964
		"\165\043\127\086\219\145\084\089\063\149\191\249\149\125\104\050\022\044\159\195\228\145\234\066\070\183\142\194" ..
		-- tex:"a52b7f56db9154593f95bff9957d6832"; x:-318.344452; y:117.284950; z:-71.357964
		"\119\055\047\049\007\041\189\160\072\218\010\187\207\106\067\017\177\023\163\195\054\200\142\066\070\183\142\194" ..
		-- tex:"77372f310729bda048da0abbcf6a4311"; x:-326.185120; y:71.391045; z:-71.357964
		"\105\063\131\007\011\059\026\240\085\085\122\090\146\080\209\177\005\003\112\195\057\224\198\066\069\183\142\194" ..
		-- tex:"693f83070b3b1af055557a5a9250d1b1"; x:-240.011810; y:99.437943; z:-71.357956
		"\097\150\070\079\098\018\090\039\146\104\199\107\146\082\071\228\175\093\169\195\031\153\017\195\069\183\142\194" ..
		-- tex:"6196464f62125a279268c76b925247e4"; x:-338.731934; y:-145.598145; z:-71.357956
		"\095\140\087\186\010\229\134\085\038\056\089\235\081\243\128\154\104\164\117\195\226\215\048\067\143\222\140\194" ..
		-- tex:"5f8c57ba0ae58655263859eb51f3809a"; x:-245.642227; y:176.843307; z:-70.434692
		"\020\007\128\203\213\024\197\120\011\130\231\242\074\151\128\187\199\211\170\195\013\179\122\195\143\222\140\194" ..
		-- tex:"140780cbd518c5780b82e7f24a9780bb"; x:-341.654541; y:-250.699432; z:-70.434692
		"\099\003\092\145\080\020\096\199\078\211\008\107\115\010\255\173\071\148\149\195\094\040\061\195\058\137\139\194" ..
		-- tex:"63035c91501460c74ed3086b730affad"; x:-299.158447; y:-189.157700; z:-69.768028
		"\233\147\194\168\071\248\098\190\228\081\139\011\193\020\185\112\110\176\134\195\002\151\043\066\058\137\139\194" ..
		-- tex:"e993c2a847f862bee4518b0bc114b970"; x:-269.378387; y:42.897472; z:-69.768028
		"\235\042\151\016\056\090\214\148\109\009\217\032\066\003\121\140\203\201\141\195\076\104\136\195\155\012\139\194" ..
		-- tex:"eb2a9710385ad6946d09d9204203798c"; x:-283.576538; y:-272.814850; z:-69.524628
		"\180\013\111\133\038\069\165\102\101\015\076\047\140\206\041\208\141\226\181\195\057\210\151\195\155\012\139\194" ..
		-- tex:"b40d6f852645a566650f4c2f8cce29d0"; x:-363.769958; y:-303.642395; z:-69.524628
		"\055\098\131\028\171\009\236\153\246\157\053\058\182\216\034\248\231\074\149\195\061\194\085\067\155\012\139\194" ..
		-- tex:"3762831cab09ec99f69d353ab6d822f8"; x:-298.585205; y:213.758759; z:-69.524628
		"\109\205\013\064\054\142\096\143\004\136\227\163\019\036\130\182\012\186\080\195\218\235\106\067\155\012\139\194" ..
		-- tex:"6dcd0d40368e608f0488e3a3132482b6"; x:-208.726761; y:234.921310; z:-69.524628
		"\002\172\055\106\170\104\048\078\168\180\078\143\212\080\207\052\122\076\197\195\177\200\085\195\155\012\139\194" ..
		-- tex:"02ac376aaa68304ea8b44e8fd450cf34"; x:-394.597504; y:-213.783966; z:-69.524628
		"\005\229\241\034\114\055\214\026\131\115\003\191\073\096\040\109\113\144\059\195\085\186\026\067\155\012\139\194" ..
		-- tex:"05e5f1227237d61a837303bf4960286d"; x:-187.564240; y:154.727875; z:-69.524628
		"\058\061\130\183\189\233\047\164\012\136\103\181\078\020\161\118\222\236\145\195\035\247\055\194\247\122\110\194" ..
		-- tex:"3a3d82b7bde92fa40c8867b54e14a176"; x:-291.850555; y:-45.991348; z:-59.620087
		"\116\133\188\098\129\002\152\101\070\040\211\145\075\027\228\133\025\160\058\195\111\079\029\065\226\195\090\194" ..
		-- tex:"7485bc62810298654628d3914b1be485"; x:-186.625397; y:9.831894; z:-54.691296
		"\061\165\142\116\205\122\176\086\252\068\094\201\092\141\081\113\128\013\103\195\049\061\140\194\225\195\090\194" ..
		-- tex:"3da58e74cd7ab056fc445ec95c8d5171"; x:-231.052750; y:-70.119522; z:-54.691292
		"\173\012\103\204\028\255\244\094\100\045\157\179\084\143\056\223\128\013\103\195\111\079\029\065\225\195\090\194" ..
		-- tex:"ad0c67cc1cfff45e642d9db3548f38df"; x:-231.052750; y:9.831894; z:-54.691292
		"\132\171\091\220\067\068\037\119\003\110\151\234\150\014\144\035\025\160\058\195\049\061\140\194\224\195\090\194" ..
		-- tex:"84ab5bdc43442577036e97ea960e9023"; x:-186.625397; y:-70.119522; z:-54.691288
		"\019\073\250\219\023\117\075\131\018\116\106\099\127\039\215\009\195\153\063\195\084\254\096\193\202\103\084\194" ..
		-- tex:"1349fadb17754b8312746a637f27d709"; x:-191.600647; y:-14.062093; z:-53.101360
		"\058\211\125\188\016\214\110\125\018\141\213\114\192\135\018\243\168\088\174\195\134\161\150\193\182\085\077\194" ..
		-- tex:"3ad37dbc10d66e7d128dd572c08712f3"; x:-348.692657; y:-18.828871; z:-51.333706
		"\038\074\023\034\254\165\164\205\162\045\215\097\204\160\211\180\225\011\240\194\178\105\139\194\105\012\051\194",
		-- tex:"264a1722fea5a4cda22dd761cca0d3b4"; x:-120.023209; y:-69.706444; z:-44.762123
	["The Temple of Atal'Hakkar"] = 
		"\181\144\105\101\185\059\229\139\188\065\166\225\186\186\059\028\126\227\131\068\190\158\167\195\235\193\189\195" ..
		-- tex:"b5906965b93be58bbc41a6e1baba3b1c"; x:1055.109192; y:-335.240204; z:-379.515015
		"\147\232\045\114\077\112\221\018\113\036\232\077\091\173\131\152\252\198\071\068\190\158\167\195\235\193\189\195" ..
		-- tex:"93e82d724d70dd127124e84d5bad8398"; x:799.109192; y:-335.240204; z:-379.515015
		"\059\228\036\213\182\031\051\076\124\104\153\092\090\163\201\076\252\198\071\068\251\122\158\194\235\193\189\195" ..
		-- tex:"3be424d5b61f334c7c68995c5aa3c94c"; x:799.109192; y:-79.240204; z:-379.515015
		"\117\241\199\232\232\237\156\223\085\155\107\031\002\023\178\064\184\175\041\068\107\125\091\195\007\046\173\195" ..
		-- tex:"75f1c7e8e8ed9cdf559b6b1f0217b240"; x:678.745667; y:-219.489929; z:-346.359619
		"\253\159\133\169\234\082\223\245\014\209\178\014\002\222\246\100\059\235\010\068\208\132\136\195\223\007\173\195" ..
		-- tex:"fd9f85a9ea52dff50ed1b20e02def664"; x:555.675537; y:-273.037628; z:-346.061523
		"\014\045\025\105\090\034\234\180\198\005\046\204\040\044\086\166\211\049\027\068\095\040\079\195\141\005\173\195" ..
		-- tex:"0e2d19695a22eab4c6052ecc282c56a6"; x:620.778564; y:-207.157715; z:-346.043396
		"\110\036\068\217\127\101\233\182\063\246\054\105\120\081\235\017\103\146\014\068\057\096\166\195\043\254\172\195" ..
		-- tex:"6e2444d97f65e9b63ff636697851eb11"; x:570.287598; y:-332.751770; z:-345.985718
		"\194\191\197\177\019\101\195\080\058\116\202\226\128\188\215\010\233\237\021\068\162\124\169\195\059\065\169\195" ..
		-- tex:"c2bfc5b11365c3503a74cae280bcd70a"; x:599.717407; y:-338.973724; z:-338.509644
		"\242\102\078\011\050\002\057\012\067\205\255\162\255\101\117\040\251\213\014\068\153\177\163\195\047\199\161\195" ..
		-- tex:"f2664e0b3202390c43cdffa2ff657528"; x:571.343506; y:-327.387512; z:-323.556152
		"\136\203\075\072\011\212\067\207\095\082\113\190\230\243\091\251\075\227\059\068\093\127\187\195\249\080\149\195" ..
		-- tex:"88cb4b480bd443cf5f5271bee6f35bfb"; x:751.551514; y:-374.995056; z:-298.632629
		"\003\052\155\216\250\055\054\250\070\099\086\148\061\221\090\129\186\216\040\068\183\118\152\195\014\247\148\195" ..
		-- tex:"03349bd8fa3736fa466356943ddd5a81"; x:675.386414; y:-304.927490; z:-297.930145
		"\152\245\055\207\156\152\140\061\071\184\218\087\071\203\226\162\095\037\051\068\048\150\149\195\224\234\148\195" ..
		-- tex:"98f537cf9c988c3d47b8da5747cbe2a2"; x:716.583984; y:-299.173370; z:-297.834991
		"\068\125\037\003\193\156\226\163\148\229\209\030\130\005\052\006\183\209\079\068\070\135\202\195\210\232\148\195" ..
		-- tex:"447d2503c19ce2a394e5d11e82053406"; x:831.276855; y:-405.056854; z:-297.818939
		"\094\178\149\231\177\038\158\153\035\148\219\052\145\003\212\183\059\203\059\068\028\158\205\194\204\228\148\195" ..
		-- tex:"5eb295e7b1269e992394db349103d4b7"; x:751.175537; y:-102.808815; z:-297.787506
		"\139\157\040\153\084\066\104\232\196\133\086\227\133\017\204\222\218\215\135\068\088\155\192\195\232\224\148\195" ..
		-- tex:"8b9d2899544268e8c48556e38511ccde"; x:1086.745483; y:-385.213654; z:-297.757111
		"\212\160\236\042\212\186\179\200\100\251\088\010\211\087\049\227\114\182\064\068\111\149\037\195\191\222\148\195" ..
		-- tex:"d4a0ec2ad4bab3c864fb580ad35731e3"; x:770.850769; y:-165.583740; z:-297.740234
		"\051\206\057\135\192\036\183\216\008\105\032\188\099\030\244\255\055\008\063\068\115\130\057\195\191\222\148\195" ..
		-- tex:"33ce3987c024b7d8086920bc631ef4ff"; x:764.128418; y:-185.509583; z:-297.740234
		"\085\194\001\165\034\028\088\161\158\083\053\047\127\001\104\206\137\076\050\068\247\248\109\194\150\222\148\195" ..
		-- tex:"55c201a5221c58a19e53352f7f0168ce"; x:713.195923; y:-59.493134; z:-297.738983
		"\116\031\097\032\038\143\116\197\172\245\151\249\127\139\010\210\099\068\127\068\194\057\212\194\171\213\148\195" ..
		-- tex:"741f6120268f74c5acf597f97f8b0ad2"; x:1021.068604; y:-106.112816; z:-297.669312
		"\106\131\198\130\169\066\166\112\083\232\251\020\217\045\016\009\244\033\136\068\115\130\147\195\043\213\148\195" ..
		-- tex:"6a83c682a942a67053e8fb14d92d1009"; x:1089.061157; y:-295.019165; z:-297.665405
		"\037\158\087\217\059\109\170\010\127\159\169\180\028\125\066\251\189\123\135\068\245\158\105\195\043\213\148\195" ..
		-- tex:"259e57d93b6daa0a7f9fa9b41c7d42fb"; x:1083.866943; y:-233.620941; z:-297.665405
		"\099\064\191\162\072\096\014\089\213\236\204\062\117\221\032\001\043\175\131\068\033\196\126\195\040\213\148\195" ..
		-- tex:"6340bfa248600e59d5eccc3e75dd2001"; x:1053.474121; y:-254.766144; z:-297.665314
		"\039\143\091\097\147\047\070\239\210\189\112\003\198\052\194\010\240\151\072\068\016\132\155\195\186\212\148\195" ..
		-- tex:"278f5b61932f46efd2bd7003c634c20a"; x:802.374084; y:-311.031769; z:-297.661957
		"\035\227\146\228\120\186\084\241\151\192\141\209\082\095\042\018\023\186\075\068\146\013\168\195\184\212\148\195" ..
		-- tex:"23e392e478ba54f197c08dd1525f2a12"; x:814.907715; y:-336.106049; z:-297.661896
		"\092\118\206\167\093\131\115\176\078\016\255\025\137\182\144\039\108\177\106\068\246\242\202\195\161\212\148\195" ..
		-- tex:"5c76cea75d8373b04e10ff1989b69027"; x:938.772278; y:-405.898163; z:-297.661194
		"\099\137\023\253\016\184\022\086\137\000\117\226\062\113\239\138\108\014\110\068\087\193\179\195\131\212\148\195" ..
		-- tex:"638917fd10b81656890075e23e71ef8a"; x:952.225403; y:-359.510498; z:-297.660278
		"\078\003\191\135\229\170\167\033\094\087\200\008\000\046\111\217\040\181\115\068\162\146\176\195\129\212\148\195" ..
		-- tex:"4e03bf87e5aaa7215e57c808002e6fd9"; x:974.830627; y:-353.145599; z:-297.660217
		"\230\192\052\061\244\227\028\235\142\240\163\185\098\144\070\024\017\006\127\068\031\075\163\194\128\212\148\195" ..
		-- tex:"e6c0343df4e31ceb8ef0a3b962904618"; x:1020.094849; y:-81.646729; z:-297.660187
		"\140\062\042\181\191\176\203\059\211\007\168\141\096\069\195\241\003\253\104\068\130\041\010\194\127\212\148\195" ..
		-- tex:"8c3e2ab5bfb0cb3bd307a88d6045c3f1"; x:931.953369; y:-34.540539; z:-297.660156
		"\112\082\005\002\048\116\152\187\095\064\179\070\227\143\000\161\051\200\141\068\089\248\014\195\127\212\148\195" ..
		-- tex:"70520502307498bb5f40b346e38f00a1"; x:1134.256348; y:-142.970123; z:-297.660156
		"\008\235\115\246\003\089\221\170\026\135\001\006\010\164\224\140\019\217\127\068\010\067\197\194\127\212\148\195" ..
		-- tex:"08eb73f60359ddaa1a8701060aa4e08c"; x:1023.391846; y:-98.630943; z:-297.660156
		"\246\102\101\184\126\036\124\067\133\213\191\151\164\185\218\184\067\105\136\068\054\151\060\195\127\212\148\195" ..
		-- tex:"f66665b87e247c4385d5bf97a4b9dab8"; x:1091.289551; y:-188.590683; z:-297.660156
		"\150\180\191\251\195\013\203\082\192\188\231\192\007\121\215\243\215\197\078\068\064\250\016\194\126\212\148\195" ..
		-- tex:"96b4bffbc30dcb52c0bce7c00779d7f3"; x:827.091309; y:-36.244389; z:-297.660126
		"\077\255\248\233\063\151\192\138\201\191\064\204\156\070\118\144\214\216\051\068\253\068\066\195\125\212\148\195" ..
		-- tex:"4dfff8e93f97c08ac9bf40cc9c467690"; x:719.388123; y:-194.269501; z:-297.660095
		"\237\161\250\077\200\224\179\169\080\115\184\227\225\189\090\169\147\114\128\068\112\085\187\195\125\212\148\195" ..
		-- tex:"eda1fa4dc8e0b3a95073b8e3e1bd5aa9"; x:1027.580566; y:-374.667511; z:-297.660095
		"\177\075\219\221\189\063\189\152\178\052\102\089\067\050\003\019\030\017\094\068\166\210\142\194\191\197\148\195" ..
		-- tex:"b14bdbddbd3fbd98b234665943320313"; x:888.267517; y:-71.411430; z:-297.544922
		"\099\114\152\118\214\213\048\182\100\067\217\091\154\237\201\212\172\202\048\068\168\145\164\195\221\194\148\195" ..
		-- tex:"63729876d6d530b66443d95b9aedc9d4"; x:707.166809; y:-329.137970; z:-297.522400
		"\144\059\132\080\015\057\158\075\253\025\126\221\104\236\134\162\123\132\139\068\079\082\166\195\186\172\148\195" ..
		-- tex:"903b84500f399e4bfd197edd68ec86a2"; x:1116.140137; y:-332.643066; z:-297.349457
		"\035\191\241\108\192\134\242\134\073\242\021\074\025\073\070\227\169\054\051\068\042\233\232\194\101\170\148\195" ..
		-- tex:"23bff16cc086f28649f2154a194946e3"; x:716.854126; y:-116.455406; z:-297.331238
		"\205\115\152\073\072\132\079\108\034\046\232\032\019\090\123\093\061\017\086\068\182\006\083\194\153\160\148\195" ..
		-- tex:"cd73984948844f6c222ee820135a7b5d"; x:856.269409; y:-52.756557; z:-297.254700
		"\064\122\230\244\156\104\240\043\206\002\107\183\177\133\142\009\186\252\136\068\157\025\189\194\077\160\148\195" ..
		-- tex:"407ae6f49c68f02bce026bb7b1858e09"; x:1095.897827; y:-94.550034; z:-297.252380
		"\210\184\097\180\088\032\160\177\221\016\239\179\144\026\106\174\237\024\020\068\235\131\169\195\010\022\143\195" ..
		-- tex:"d2b861b45820a0b1dd10efb3901a6aae"; x:592.389526; y:-339.030640; z:-286.172211
		"\043\236\225\145\162\234\222\072\045\072\139\166\066\148\124\212\136\042\245\067\020\126\083\195\192\178\132\195" ..
		-- tex:"2bece191a2eade482d488ba642947cd4"; x:490.332306; y:-211.492508; z:-265.396515
		"\167\240\049\037\195\230\204\102\123\176\227\172\078\142\095\000\164\074\060\068\114\111\182\195\056\053\132\195" ..
		-- tex:"a7f03125c3e6cc667bb0e3ac4e8e5f00"; x:753.166321; y:-364.870697; z:-264.415802
		"\145\228\076\113\120\099\167\207\203\081\063\190\075\153\042\214\150\209\061\068\170\132\159\195\051\231\131\195" ..
		-- tex:"91e44c717863a7cfcb513fbe4b992ad6"; x:759.274841; y:-319.036469; z:-263.806274
		"\049\245\067\022\055\124\215\205\098\255\014\186\036\063\208\201\254\171\033\068\069\058\020\195\226\229\131\195" ..
		-- tex:"31f54316377cd7cd62ff0eba243fd0c9"; x:646.687439; y:-148.227631; z:-263.795990
		"\004\174\031\152\050\252\230\092\016\221\178\025\058\191\157\088\025\105\052\068\135\107\066\195\154\229\131\195" ..
		-- tex:"04ae1f9832fce65c10ddb2193abf9d58"; x:721.642212; y:-194.420044; z:-263.793793
		"\208\163\160\088\193\115\103\134\208\154\082\102\027\071\098\208\216\104\045\068\172\178\018\195\154\229\131\195" ..
		-- tex:"d0a3a058c1736786d09a52661b4762d0"; x:693.638245; y:-146.697952; z:-263.793793
		"\064\162\026\065\108\160\226\123\009\201\035\080\148\248\252\174\006\224\050\068\175\077\143\195\008\227\131\195" ..
		-- tex:"40a21a416ca0e27b09c9235094f8fcae"; x:715.500427; y:-286.606934; z:-263.773712
		"\039\132\097\037\251\138\244\060\211\224\092\099\106\019\204\127\083\026\028\068\161\046\143\195\235\226\131\195" ..
		-- tex:"27846125fb8af43cd3e05c636a13cc7f"; x:624.411377; y:-286.364319; z:-263.772827
		"\074\075\226\159\012\088\146\197\113\028\187\031\218\210\246\163\192\031\024\068\192\199\177\194\124\169\130\195" ..
		-- tex:"4a4be29f0c5892c5711cbb1fdad2f6a3"; x:608.496155; y:-88.890144; z:-261.324127
		"\058\133\030\075\213\024\012\084\164\081\132\134\160\225\161\076\129\170\045\068\224\088\179\195\190\239\128\195" ..
		-- tex:"3a851e4bd5180c54a4518486a0e1a14c"; x:694.664185; y:-358.694366; z:-257.873016
		"\111\190\252\178\131\168\116\137\043\217\092\153\069\131\245\233\146\122\143\068\124\160\164\195\154\217\128\195" ..
		-- tex:"6fbefcb283a874892bd95c994583f5e9"; x:1147.830444; y:-329.253815; z:-257.700043
		"\245\196\053\018\010\157\034\096\032\232\041\180\239\150\001\197\231\058\139\068\129\017\135\195\154\217\128\195" ..
		-- tex:"f5c435120a9d226020e829b4ef9601c5"; x:1113.840820; y:-270.136780; z:-257.700043
		"\035\207\033\111\084\052\093\119\211\212\154\056\049\078\212\037\121\064\043\068\147\065\242\194\070\215\128\195" ..
		-- tex:"23cf216f54345d77d3d49a38314ed425"; x:685.007446; y:-121.128082; z:-257.681854
		"\025\035\106\040\232\157\000\053\045\027\010\146\223\038\052\194\172\131\138\068\046\151\129\194\042\205\128\195" ..
		-- tex:"19236a28e89d00352d1b0a92df2634c2"; x:1108.114868; y:-64.795280; z:-257.602875
		"\155\183\230\033\179\209\146\058\056\166\243\146\206\010\142\003\204\096\134\068\238\212\145\194\042\205\128\195" ..
		-- tex:"9bb7e621b3d1923a38a6f392ce0a8e03"; x:1075.025024; y:-72.915886; z:-257.602875
		"\121\005\178\100\016\240\046\042\047\014\234\206\058\134\179\199\229\089\015\068\252\001\242\194\172\254\120\195" ..
		-- tex:"7905b26410f02e2a2f0eeace3a86b3c7"; x:573.404663; y:-121.003883; z:-248.994827
		"\076\068\107\053\027\231\020\086\026\123\010\000\025\034\233\132\202\189\017\068\183\069\019\195\083\010\106\195" ..
		-- tex:"4c446b351be714561a7b0a001922e984"; x:582.965515; y:-147.272339; z:-234.040344
		"\018\039\069\227\225\133\246\088\131\240\236\014\254\224\116\249\176\237\030\068\073\241\004\195\038\022\091\195" ..
		-- tex:"122745e3e185f65883f0ec0efee074f9"; x:635.713928; y:-132.942535; z:-219.086533
		"\202\093\140\082\204\240\082\111\043\006\063\162\047\011\180\086\210\019\040\068\063\238\169\195\236\053\090\195" ..
		-- tex:"ca5d8c52ccf0526f2b063fa22f0bb456"; x:672.309753; y:-339.861328; z:-218.210648
		"\099\103\035\049\123\139\029\016\188\001\242\153\013\070\139\245\107\122\048\068\144\129\164\195\224\046\090\195" ..
		-- tex:"636723317b8b1d10bc01f2990d468bf5"; x:705.912842; y:-329.012238; z:-218.183121
		"\102\105\079\062\181\129\003\170\088\071\123\042\224\076\254\039\015\101\140\068\112\117\180\195\162\009\090\195" ..
		-- tex:"66694f3eb58103aa58477b2ae04cfe27"; x:1123.158203; y:-360.917511; z:-218.037643
		"\133\143\074\081\027\003\144\141\192\122\102\182\220\053\015\243\038\175\042\068\037\020\106\194\249\004\090\195" ..
		-- tex:"858f4a511b03908dc07a66b6dc350ff3"; x:682.736755; y:-58.519676; z:-218.019440
		"\016\154\196\022\224\059\221\252\192\041\150\163\136\233\168\002\122\147\139\068\238\208\166\195\150\002\090\195" ..
		-- tex:"109ac416e03bddfcc02996a388e9a802"; x:1116.608765; y:-333.632294; z:-218.010117
		"\099\058\111\027\178\109\212\153\107\234\090\170\087\146\182\136\252\051\051\068\001\000\232\194\236\253\089\195" ..
		-- tex:"633a6f1bb26dd4996bea5aaa5792b688"; x:716.812317; y:-116.000015; z:-217.991898
		"\198\059\082\115\246\093\086\226\092\121\100\067\119\019\244\075\218\058\144\068\249\231\197\194\198\240\089\195" ..
		-- tex:"c63b5273f65d56e25c7964437713f44b"; x:1153.839233; y:-98.953079; z:-217.940536
		"\067\107\212\148\233\191\019\123\187\207\012\240\135\112\204\090\093\010\137\068\062\228\191\194\194\233\089\195" ..
		-- tex:"436bd494e9bf137bbbcf0cf08770cc5a"; x:1096.323975; y:-95.945793; z:-217.913132
		"\078\136\217\124\037\175\019\054\100\075\173\112\054\129\073\227\119\105\014\068\033\237\233\194\150\130\073\195" ..
		-- tex:"4e88d97c25af1336644bad70368149e3"; x:569.647949; y:-116.963150; z:-201.510117
		"\031\054\229\063\064\142\107\104\247\237\153\092\132\099\011\050\129\114\061\068\059\101\212\194\240\113\071\195" ..
		-- tex:"1f36e53f408e6b68f7ed995c84630b32"; x:757.789185; y:-106.197723; z:-199.445084
		"\158\015\074\061\052\199\186\202\070\217\197\184\160\191\127\080\129\114\061\068\078\025\181\195\240\113\071\195" ..
		-- tex:"9e0f4a3d34c7baca46d9c5b8a0bf7f50"; x:757.789185; y:-362.197723; z:-199.445084
		"\127\080\174\032\129\062\199\223\104\074\166\038\095\008\025\146\129\114\125\068\078\025\181\195\240\113\071\195" ..
		-- tex:"7f50ae20813ec7df684aa6265f081992"; x:1013.789185; y:-362.197723; z:-199.445084
		"\124\027\023\244\216\107\246\114\022\036\152\144\191\102\110\133\129\114\125\068\059\101\212\194\240\113\071\195" ..
		-- tex:"7c1b17f4d86bf67216249890bf666e85"; x:1013.789185; y:-106.197723; z:-199.445084
		"\029\132\020\144\079\089\054\217\223\202\108\004\165\214\032\228\084\153\057\068\015\150\144\194\029\065\060\195" ..
		-- tex:"1d8414904f5936d9dfca6c04a5d620e4"; x:742.395813; y:-72.293091; z:-188.254364
		"\016\142\210\068\254\190\210\074\119\163\157\074\076\216\163\008\132\149\010\068\018\137\078\195\210\071\055\195" ..
		-- tex:"108ed244febed24a77a39d4a4cd8a308"; x:554.336243; y:-206.535446; z:-183.280563
		"\116\215\154\005\036\253\048\138\179\133\197\128\076\122\249\001\084\042\026\068\143\231\088\195\062\000\055\195" ..
		-- tex:"74d79a0524fd308ab385c5804c7af901"; x:616.661438; y:-216.904541; z:-183.000961
		"\243\242\067\122\255\094\018\094\211\130\233\213\067\231\166\118\067\033\153\068\214\121\147\194\213\135\054\195" ..
		-- tex:"f3f2437aff5e125ed382e9d543e7a676"; x:1225.039551; y:-73.737968; z:-182.530609
		"\146\017\230\209\124\146\070\008\130\171\207\221\130\098\221\112\024\246\075\068\080\012\034\196\243\131\054\195" ..
		-- tex:"9211e6d17c92460882abcfdd8262dd70"; x:815.845276; y:-648.192444; z:-182.515442
		"\091\040\204\231\090\001\017\244\195\123\032\219\164\121\070\109\189\144\080\068\229\112\150\066\233\131\054\195" ..
		-- tex:"5b28cce75a0111f4c37b20dba479466d"; x:834.261597; y:75.220505; z:-182.515289
		"\076\040\045\060\060\055\094\151\160\008\227\083\032\101\003\198\026\182\116\068\139\182\242\195\155\225\053\195" ..
		-- tex:"4c282d3c3c375e97a008e353206503c6"; x:978.845398; y:-485.426147; z:-181.881287
		"\104\132\191\038\001\117\144\011\156\119\236\186\178\149\212\017\095\191\136\068\252\051\105\195\220\215\053\195" ..
		-- tex:"6884bf260175900b9c77ecbab295d411"; x:1093.980469; y:-233.203079; z:-181.843216
		"\152\064\109\244\247\085\041\012\186\155\194\082\064\162\188\079\168\015\057\068\102\190\242\195\165\215\053\195" ..
		-- tex:"98406df4f755290cba9bc25240a2bc4f"; x:740.244690; y:-485.487518; z:-181.842377
		"\070\051\220\202\221\034\113\145\064\019\139\194\181\248\137\105\101\171\116\068\110\139\143\194\251\210\053\195" ..
		-- tex:"4633dccadd22719140138bc2b5f88969"; x:978.678101; y:-71.772331; z:-181.824158
		"\014\249\041\021\015\082\224\128\005\096\076\119\005\071\205\121\210\130\131\068\002\070\132\066\089\210\053\195" ..
		-- tex:"0ef929150f52e08005604c770547cd79"; x:1052.088257; y:66.136742; z:-181.821686
		"\089\197\242\012\041\158\087\058\100\150\155\170\011\191\167\210\213\000\051\068\128\020\024\196\085\210\053\195" ..
		-- tex:"59c5f20c299e573a64969baa0bbfa7d2"; x:716.013062; y:-608.320374; z:-181.821625
		"\113\014\251\000\059\104\244\112\057\143\091\227\185\164\023\086\127\135\131\068\128\020\024\196\084\210\053\195" ..
		-- tex:"710efb003b68f470398f5be3b9a41756"; x:1052.234375; y:-608.320374; z:-181.821609
		"\201\081\216\209\079\130\171\009\045\171\065\073\168\141\050\046\078\120\156\068\052\103\152\195\084\210\053\195" ..
		-- tex:"c951d8d14f82ab092dab4149a88d322e"; x:1251.759644; y:-304.806305; z:-181.821609
		"\059\078\020\231\078\085\222\079\150\041\028\133\016\210\114\163\134\073\060\068\173\113\181\195\076\138\050\195" ..
		-- tex:"3b4e14e74e55de4f96291c8510d272a3"; x:753.148865; y:-362.888123; z:-178.540237
		"\251\133\163\172\170\202\132\183\102\167\007\230\008\203\242\012\203\188\045\068\184\094\179\195\076\138\050\195" ..
		-- tex:"fb85a3acaaca84b766a707e608cbf20c"; x:694.949951; y:-358.740021; z:-178.540237
		"\124\154\185\057\025\121\055\132\020\195\159\185\158\128\218\015\085\118\143\068\188\110\164\195\005\094\050\195" ..
		-- tex:"7c9ab9391979378414c39fb99e80da0f"; x:1147.697998; y:-328.865143; z:-178.367279
		"\184\142\096\237\099\058\159\004\034\087\052\074\084\203\058\242\229\060\139\068\008\076\135\195\004\094\050\195" ..
		-- tex:"b88e60ed633a9f042257344a54cb3af2"; x:1113.903076; y:-270.594025; z:-178.367264
		"\087\196\164\029\081\027\100\013\138\200\207\077\100\022\044\202\129\073\043\068\008\063\242\194\090\089\050\195" ..
		-- tex:"57c4a41d511b640d8ac8cf4d64162cca"; x:685.148560; y:-121.123116; z:-178.349045
		"\022\235\220\144\226\202\216\099\222\096\007\123\177\115\126\027\250\104\045\068\125\170\019\195\090\089\050\195" ..
		-- tex:"16ebdc90e2cad863de60077bb1737e1b"; x:693.640320; y:-147.665985; z:-178.349045
		"\254\103\014\213\148\131\246\250\167\134\059\169\124\196\145\067\220\137\138\068\251\210\128\194\040\069\050\195" ..
		-- tex:"fe670ed59483f6faa7863ba97cc49143"; x:1108.308228; y:-64.412079; z:-178.270157
		"\028\125\218\029\238\236\059\155\000\234\034\255\255\164\048\144\108\110\134\068\062\048\146\194\031\069\050\195" ..
		-- tex:"1c7dda1deeec3b9b00ea22ffffa43090"; x:1075.450806; y:-73.094231; z:-178.270020
		"\063\059\113\172\063\178\105\233\202\161\126\238\021\108\132\189\102\028\040\068\037\044\135\195\111\190\012\195" ..
		-- tex:"3f3b71ac3fb269e9caa17eee156c84bd"; x:672.443787; y:-270.344910; z:-140.743896
		"\184\183\238\146\022\250\067\183\049\022\177\042\159\015\231\087\072\054\133\068\038\221\192\195\039\146\012\195" ..
		-- tex:"b8b7ee9216fa43b73116b12a9f0fe757"; x:1065.696411; y:-385.727753; z:-140.570923
		"\188\151\200\079\244\111\035\121\212\224\199\132\156\156\146\072\008\060\057\068\216\124\244\193\133\141\012\195" ..
		-- tex:"bc97c84ff46f2379d4e0c7849c9c9248"; x:740.938049; y:-30.560961; z:-140.552826
		"\087\064\180\015\183\026\194\186\142\155\038\207\194\064\091\163\021\166\143\068\162\185\036\195\075\121\012\195" ..
		-- tex:"5740b40fb71ac2ba8e9b26cfc2405ba3"; x:1149.190186; y:-164.725143; z:-140.473816
		"\017\091\050\173\142\202\250\005\206\159\212\147\152\240\119\233\189\042\045\068\099\021\153\195\004\008\011\195" ..
		-- tex:"115b32ad8ecafa05ce9fd49398f077e9"; x:692.667847; y:-306.167114; z:-139.031326
		"\194\174\217\035\069\064\071\105\085\085\062\187\009\218\113\173\027\087\032\068\022\236\172\195\004\008\011\195" ..
		-- tex:"c2aed9234540476955553ebb09da71ad"; x:641.361084; y:-345.844452; z:-139.031326
		"\191\214\184\142\092\236\021\207\254\249\187\123\059\107\083\121\088\112\049\068\208\157\137\195\002\008\011\195" ..
		-- tex:"bfd6b88e5cec15cffef9bb7b3b6b5379"; x:709.755432; y:-275.232941; z:-139.031296
		"\147\227\080\111\218\013\229\030\166\074\105\050\163\127\009\230\111\035\140\068\119\214\201\195\189\219\010\195" ..
		-- tex:"93e3506fda0de51ea64a6932a37f09e6"; x:1121.107422; y:-403.675537; z:-138.858368
		"\183\134\016\153\120\216\060\066\068\003\088\147\095\110\241\124\048\108\131\068\166\028\175\195\186\219\010\195" ..
		-- tex:"b786109978d83c42440358935f6ef17c"; x:1051.380981; y:-350.223846; z:-138.858322
		"\158\189\044\008\236\193\207\236\132\023\107\118\128\157\013\089\129\045\137\068\032\109\176\195\186\219\010\195" ..
		-- tex:"9ebd2c08ecc1cfec84176b76809d0d59"; x:1097.422119; y:-352.852570; z:-138.858322
		"\185\231\184\127\255\009\242\177\100\142\232\014\040\140\112\114\246\150\038\068\017\052\104\194\021\215\010\195" ..
		-- tex:"b9e7b87fff09f2b1648ee80e288c7072"; x:666.358826; y:-58.050850; z:-138.840179
		"\175\216\083\057\015\200\006\092\040\211\245\178\006\200\172\251\136\055\051\068\185\093\157\194\021\215\010\195" ..
		-- tex:"afd853390fc8065c28d3f5b206c8acfb"; x:716.867737; y:-78.683060; z:-138.840179
		"\146\066\019\012\232\119\179\198\147\039\187\090\161\008\021\101\180\245\059\068\118\039\183\194\018\215\010\195" ..
		-- tex:"9242130ce877b3c69327bb5aa1081565"; x:751.839172; y:-91.577080; z:-138.840134
		"\082\098\025\165\233\117\041\051\119\019\136\182\152\070\057\115\241\227\145\068\227\147\252\194\224\194\010\195" ..
		-- tex:"526219a5e9752933771388b698463973"; x:1167.123291; y:-126.288849; z:-138.761246
		"\112\134\088\190\222\095\219\251\169\195\246\082\052\241\035\178\253\041\140\068\061\111\220\194\223\194\010\195" ..
		-- tex:"708658bede5fdbfba9c3f65234f123b2"; x:1121.312256; y:-110.217270; z:-138.761230
		"\105\204\215\056\251\074\163\216\252\081\171\016\083\139\089\091\215\225\134\068\032\026\017\195\221\194\010\195" ..
		-- tex:"69ccd738fb4aa3d8fc51ab10538b595b"; x:1079.057617; y:-145.102066; z:-138.761200
		"\076\023\193\029\095\173\098\212\214\037\056\170\167\016\005\049\221\060\059\068\228\223\186\195\118\087\004\195" ..
		-- tex:"4c17c11d5fad62d4d62538aaa7100531"; x:748.951050; y:-373.749176; z:-132.341660
		"\162\188\254\048\025\009\115\058\120\010\185\095\238\187\177\103\159\199\113\068\039\101\125\194\211\084\004\195" ..
		-- tex:"a2bcfe301909733a780ab95feebbb167"; x:967.119141; y:-63.348785; z:-132.331360
		"\041\209\116\141\095\114\234\250\253\129\005\132\220\137\026\043\212\023\095\068\064\252\178\195\133\193\002\195" ..
		-- tex:"29d1748d5f72eafafd810584dc891a2b"; x:892.372375; y:-357.970734; z:-130.755951
		"\127\037\015\051\144\253\140\046\128\173\169\230\098\031\104\082\245\072\110\068\113\047\027\194\223\190\002\195" ..
		-- tex:"7f250f3390fd8c2e80ada9e6621f6852"; x:953.140015; y:-38.796333; z:-130.745605
		"\239\137\097\196\249\015\239\227\056\237\153\223\030\044\241\092\175\072\127\068\116\014\187\195\050\126\216\194" ..
		-- tex:"ef8961c4f90fefe338ed99df1e2cf15c"; x:1021.135742; y:-374.112946; z:-108.246483
		"\252\035\201\028\181\140\192\053\181\123\022\249\122\224\110\038\030\211\049\068\123\010\147\195\135\091\216\194" ..
		-- tex:"fc23c91cb58cc035b57b16f97ae06e26"; x:711.298767; y:-294.081909; z:-108.178772
		"\216\110\105\135\021\225\240\200\027\128\163\035\152\209\110\172\168\193\124\068\139\097\133\194\168\043\216\194" ..
		-- tex:"d86e698715e1f0c81b80a32398d16eac"; x:1011.025940; y:-66.690521; z:-108.085274
		"\148\235\213\158\084\063\036\066\227\044\166\075\042\099\150\092\199\081\059\068\182\104\195\194\068\034\216\194" ..
		-- tex:"94ebd59e543f2442e32ca64b2a63965c"; x:749.277832; y:-97.704521; z:-108.066933
		"\210\122\226\029\000\093\016\092\106\166\246\229\126\143\245\176\234\044\136\068\155\086\065\195\135\229\215\194" ..
		-- tex:"d27ae21d005d105c6aa6f6e57e8ff5b0"; x:1089.403687; y:-193.338318; z:-107.948303
		"\141\002\105\119\188\104\142\015\218\224\005\092\002\114\240\177\186\034\128\068\194\203\203\194\135\229\215\194" ..
		-- tex:"8d026977bc688e0fdae0055c0272f0b1"; x:1025.085327; y:-101.897972; z:-107.948303
		"\245\226\153\091\027\057\063\019\055\057\235\255\054\036\198\081\197\050\078\068\188\011\203\195\128\229\215\194" ..
		-- tex:"f5e2995b1b393f133739ebff3624c651"; x:824.793335; y:-406.091705; z:-107.948250
		"\174\047\151\061\245\064\252\205\150\074\079\084\058\070\097\207\159\030\136\068\170\025\149\195\127\229\215\194" ..
		-- tex:"ae2f973df540fccd964a4f543a4661cf"; x:1088.957031; y:-298.200531; z:-107.948242
		"\043\000\251\100\025\224\059\151\015\144\129\174\048\059\149\174\078\059\079\068\096\050\006\194\127\229\215\194" ..
		-- tex:"2b00fb6419e03b970f9081ae303b95ae"; x:828.926697; y:-33.549198; z:-107.948242
		"\225\184\171\078\193\124\099\086\208\085\075\042\245\080\016\239\078\107\104\068\074\001\202\195\127\229\215\194" ..
		-- tex:"e1b8ab4ec17c6356d0554b2af55010ef"; x:929.676697; y:-404.010101; z:-107.948242
		"\100\136\197\035\181\107\108\166\046\177\141\191\198\225\102\040\177\038\106\068\124\249\007\194\126\229\215\194" ..
		-- tex:"6488c523b56b6ca62eb18dbfc6e16628"; x:936.604614; y:-33.993641; z:-107.948235
		"\086\061\050\190\107\012\107\002\013\214\199\020\168\103\224\042\139\183\051\068\248\132\058\195\126\229\215\194",
		-- tex:"563d32be6b0c6b020dd6c714a867e02a"; x:718.867920; y:-186.519424; z:-107.948235
	["The Underbog"] = 
		"\103\252\217\066\216\221\144\165\049\174\168\146\251\057\221\251\006\222\083\196\183\015\012\067\178\097\171\194" ..
		-- tex:"67fcd942d8dd90a531aea892fb39ddfb"; x:-847.469177; y:140.061401; z:-85.690819
		"\022\082\039\122\094\137\168\155\235\038\164\068\140\115\170\113\055\240\158\194\143\224\231\194\178\097\171\194" ..
		-- tex:"1652277a5e89a89beb26a4448c73aa71"; x:-79.469177; y:-115.938599; z:-85.690819
		"\061\003\247\251\086\127\132\241\037\039\171\252\195\108\209\240\055\240\158\194\183\015\012\067\178\097\171\194" ..
		-- tex:"3d03f7fb567f84f12527abfcc36cd1f0"; x:-79.469177; y:140.061401; z:-85.690819
		"\054\111\232\211\112\203\148\180\195\134\186\174\097\023\250\255\055\240\158\194\035\248\185\195\178\097\171\194" ..
		-- tex:"366fe8d370cb94b4c386baae6117faff"; x:-79.469177; y:-371.938599; z:-85.690819
		"\203\205\089\217\020\194\051\157\093\102\228\022\070\148\094\084\013\188\167\195\237\003\035\068\178\097\171\194" ..
		-- tex:"cbcd59d914c2339d5d66e41646945e54"; x:-335.469177; y:652.061401; z:-85.690819
		"\207\245\099\172\010\254\209\111\081\131\209\145\122\167\223\032\013\188\167\195\237\003\099\068\178\097\171\194" ..
		-- tex:"cff563ac0afed16f5183d1917aa7df20"; x:-335.469177; y:908.061401; z:-85.690819
		"\154\217\028\245\227\144\162\116\214\124\228\233\013\104\005\040\013\188\167\195\219\007\198\067\178\097\171\194" ..
		-- tex:"9ad91cf5e390a274d67ce4e90d680528"; x:-335.469177; y:396.061401; z:-85.690819
		"\219\130\091\160\225\073\090\238\026\023\125\091\205\171\188\015\055\240\158\194\219\007\198\067\178\097\171\194" ..
		-- tex:"db825ba0e1495aee1a177d5bcdabbc0f"; x:-79.469177; y:396.061401; z:-85.690819
		"\110\111\093\051\185\136\091\124\064\043\210\129\230\005\222\201\055\240\158\194\237\003\099\068\178\097\171\194" ..
		-- tex:"6e6f5d33b9885b7c402bd281e605dec9"; x:-79.469177; y:908.061401; z:-85.690819
		"\149\113\191\151\070\002\066\072\123\063\164\012\053\130\072\234\227\135\048\067\183\015\012\067\178\097\171\194" ..
		-- tex:"9571bf97460242487b3fa40c358248ea"; x:176.530823; y:140.061401; z:-85.690819
		"\041\078\068\246\015\236\050\211\219\202\209\204\110\169\095\107\055\240\158\194\237\003\035\068\178\097\171\194" ..
		-- tex:"294e44f60fec32d3dbcad1cc6ea95f6b"; x:-79.469177; y:652.061401; z:-85.690819
		"\107\052\014\093\151\217\137\254\136\151\014\081\141\188\252\191\227\135\048\067\143\224\231\194\178\097\171\194" ..
		-- tex:"6b340e5d97d989fe88970e518dbcfcbf"; x:176.530823; y:-115.938599; z:-85.690819
		"\227\246\016\239\173\175\073\185\023\154\191\190\010\087\064\015\227\135\048\067\035\248\185\195\178\097\171\194" ..
		-- tex:"e3f610efadaf49b9179abfbe0a57400f"; x:176.530823; y:-371.938599; z:-85.690819
		"\101\205\228\217\252\070\107\049\210\144\073\251\053\008\145\058\227\135\048\067\219\007\198\067\178\097\171\194" ..
		-- tex:"65cde4d9fc466b31d29049fb3508913a"; x:176.530823; y:396.061401; z:-85.690819
		"\071\235\167\072\018\238\217\218\176\083\078\208\205\049\107\217\013\188\167\195\183\015\012\067\178\097\171\194" ..
		-- tex:"47eba74812eed9dab0534ed0cd316bd9"; x:-335.469177; y:140.061401; z:-85.690819
		"\120\200\025\168\151\207\047\041\068\049\237\233\075\103\044\224\013\188\167\195\035\248\185\195\178\097\171\194" ..
		-- tex:"78c819a897cf2f294431ede94b672ce0"; x:-335.469177; y:-371.938599; z:-85.690819
		"\135\142\155\211\244\046\076\159\001\141\012\022\003\046\045\246\006\222\083\196\246\129\145\068\178\097\171\194" ..
		-- tex:"878e9bd3f42e4c9f018d0c16032e2df6"; x:-847.469177; y:1164.061401; z:-85.690819
		"\209\152\128\104\054\253\153\138\163\098\110\108\121\116\192\101\006\222\019\196\035\248\185\195\178\097\171\194" ..
		-- tex:"d198806836fd998aa3626e6c7974c065"; x:-591.469177; y:-371.938599; z:-85.690819
		"\044\001\224\177\112\126\061\068\251\100\194\022\038\082\108\067\006\222\083\196\237\003\099\068\178\097\171\194" ..
		-- tex:"2c01e0b1707e3d44fb64c21626526c43"; x:-847.469177; y:908.061401; z:-85.690819
		"\128\199\078\064\075\204\013\174\004\014\228\205\225\204\251\056\006\222\083\196\219\007\198\067\178\097\171\194" ..
		-- tex:"80c74e404bcc0dae040ee4cde1ccfb38"; x:-847.469177; y:396.061401; z:-85.690819
		"\146\070\140\011\149\104\061\160\079\141\220\097\146\186\123\180\006\222\083\196\237\003\035\068\178\097\171\194" ..
		-- tex:"92468c0b95683da04f8ddc6192ba7bb4"; x:-847.469177; y:652.061401; z:-85.690819
		"\228\198\070\109\116\174\244\082\168\209\215\216\146\158\073\114\013\188\167\195\143\224\231\194\178\097\171\194" ..
		-- tex:"e4c6466d74aef452a8d1d7d8929e4972"; x:-335.469177; y:-115.938599; z:-85.690819
		"\180\116\072\047\197\043\101\025\237\203\231\148\053\195\238\018\006\222\019\196\143\224\231\194\178\097\171\194" ..
		-- tex:"b474482fc52b6519edcbe79435c3ee12"; x:-591.469177; y:-115.938599; z:-85.690819
		"\133\072\001\157\046\020\108\166\181\100\117\113\140\208\019\146\006\222\019\196\219\007\198\067\178\097\171\194" ..
		-- tex:"8548019d2e146ca6b56475718cd01392"; x:-591.469177; y:396.061401; z:-85.690819
		"\242\179\254\115\156\224\212\026\202\072\010\134\175\088\072\006\006\222\019\196\246\129\145\068\178\097\171\194" ..
		-- tex:"f2b3fe739ce0d41aca480a86af584806"; x:-591.469177; y:1164.061401; z:-85.690819
		"\094\204\080\214\077\075\000\065\249\148\127\148\200\222\045\150\006\222\019\196\183\015\012\067\178\097\171\194" ..
		-- tex:"5ecc50d64d4b0041f9947f94c8de2d96"; x:-591.469177; y:140.061401; z:-85.690819
		"\127\017\239\108\133\093\046\084\229\055\187\073\106\190\039\056\006\222\019\196\237\003\099\068\178\097\171\194" ..
		-- tex:"7f11ef6c855d2e54e537bb496abe2738"; x:-591.469177; y:908.061401; z:-85.690819
		"\188\038\002\038\222\132\220\058\182\008\184\248\193\148\125\126\006\222\019\196\237\003\035\068\178\097\171\194" ..
		-- tex:"bc260226de84dc3ab608b8f8c1947d7e"; x:-591.469177; y:652.061401; z:-85.690819
		"\141\136\056\003\144\017\008\081\104\212\133\142\150\179\157\044\227\135\048\067\237\003\035\068\178\097\171\194",
		-- tex:"8d8838039011085168d4858e96b39d2c"; x:176.530823; y:652.061401; z:-85.690819
	["The Violet Hold"] = 
		"\109\070\254\179\173\187\152\243\089\194\212\053\013\172\063\203\134\088\168\195\010\206\067\195\226\042\087\194" ..
		-- tex:"6d46feb3adbb98f359c2d4350dac3fcb"; x:-336.691620; y:-195.804855; z:-53.791882
		"\240\213\107\099\062\175\050\240\206\202\032\065\115\032\163\084\027\098\161\194\010\206\067\195\226\042\087\194" ..
		-- tex:"f0d56b633eaf32f0ceca20417320a354"; x:-80.691620; y:-195.804855; z:-53.791882
		"\015\200\088\072\127\068\173\129\200\073\004\060\139\055\121\057\134\088\168\195\211\199\112\066\226\042\087\194" ..
		-- tex:"0fc858487f44ad81c849043c8b377939"; x:-336.691620; y:60.195145; z:-53.791882
		"\115\238\181\035\206\098\060\253\106\022\107\229\119\241\075\117\027\098\161\194\211\199\112\066\226\042\087\194",
		-- tex:"73eeb523ce623cfd6a166be577f14b75"; x:-80.691620; y:60.195145; z:-53.791882
	["Uldaman"] = 
		"\207\135\219\239\176\135\047\033\072\252\030\181\214\017\134\015\127\239\029\068\003\105\155\195\147\106\225\194" ..
		-- tex:"cf87dbefb0872f2148fc1eb5d611860f"; x:631.742188; y:-310.820435; z:-112.708160
		"\149\047\203\105\135\000\043\236\211\160\146\243\103\027\252\172\072\173\105\195\072\209\229\195\021\010\220\194" ..
		-- tex:"952fcb6987002becd3a092f3671bfcac"; x:-233.676895; y:-459.635040; z:-110.019699
		"\146\183\106\170\052\026\009\130\147\189\031\064\090\131\172\207\123\228\156\067\112\018\039\196\068\250\217\194" ..
		-- tex:"92b76aaa341a098293bd1f405a83accf"; x:313.785034; y:-668.288147; z:-108.988808
		"\082\005\164\008\082\235\055\149\243\187\036\074\141\228\035\085\207\003\105\067\234\183\022\196\143\235\217\194" ..
		-- tex:"5205a40852eb3795f3bb244a8de42355"; x:233.014893; y:-602.873718; z:-108.960083
		"\187\110\027\027\122\178\077\143\110\154\061\067\008\046\165\251\009\162\021\195\187\116\008\196\049\062\217\194" ..
		-- tex:"bb6e1b1b7ab24d8f6e9a3d43082ea5fb"; x:-149.632965; y:-545.823975; z:-108.621475
		"\055\105\010\243\009\159\158\163\157\154\016\248\195\177\113\100\082\070\085\067\109\084\248\195\062\058\210\194" ..
		-- tex:"37690af3099f9ea39d9a10f8c3b17164"; x:213.274704; y:-496.659607; z:-105.113762
		"\228\148\197\148\211\015\141\125\078\142\160\231\119\201\197\097\157\024\176\195\064\021\032\196\162\016\209\194" ..
		-- tex:"e494c594d30f8d7d4e8ea0e777c9c561"; x:-352.192322; y:-640.332092; z:-104.532494
		"\243\077\115\170\062\206\139\099\176\059\000\218\115\103\255\060\050\211\141\195\001\001\027\196\250\237\208\194" ..
		-- tex:"f34d73aa3ece8b63b03b00da7367ff3c"; x:-283.649994; y:-620.015747; z:-104.464806
		"\210\026\031\204\172\160\023\167\248\201\175\089\198\229\228\129\068\071\183\067\166\015\169\194\254\007\208\194" ..
		-- tex:"d21a1fccaca017a7f8c9af59c6e5e481"; x:366.556793; y:-84.530571; z:-104.015617
		"\156\001\135\005\046\067\227\095\086\240\142\122\086\007\154\171\085\103\150\066\251\079\067\196\014\203\207\194" ..
		-- tex:"9c0187052e43e35f56f08e7a56079aab"; x:75.201828; y:-781.249756; z:-103.896599
		"\050\031\068\230\240\147\160\129\027\255\199\112\195\006\225\151\254\210\019\067\066\168\043\196\235\119\205\194" ..
		-- tex:"321f44e6f093a0811bffc770c306e197"; x:147.824203; y:-686.629089; z:-102.734222
		"\066\123\216\251\251\215\095\104\206\073\112\144\052\250\162\239\057\196\187\067\013\099\021\196\173\194\204\194" ..
		-- tex:"427bd8fbfbd75f68ce49709034faa2ef"; x:375.533020; y:-597.547729; z:-102.380234
		"\149\038\174\218\160\203\134\160\108\168\183\035\204\188\218\200\251\111\121\066\157\217\246\195\103\224\203\194" ..
		-- tex:"9526aedaa0cb86a06ca8b723ccbcdac8"; x:62.359360; y:-493.700134; z:-101.938293
		"\219\098\174\188\163\238\138\053\038\099\100\184\133\063\054\183\150\217\109\067\215\143\044\196\240\075\203\194" ..
		-- tex:"db62aebca3ee8a35266364b8853f36b7"; x:237.849960; y:-690.247559; z:-101.648323
		"\242\045\027\235\016\012\157\096\035\169\006\237\058\062\090\060\075\185\140\067\070\016\231\195\144\123\202\194" ..
		-- tex:"f22d1beb100c9d6023a906ed3a3e5a3c"; x:281.447632; y:-462.127167; z:-101.241341
		"\072\058\189\192\176\082\243\091\239\121\013\116\099\034\019\099\159\136\067\066\042\204\013\196\091\230\201\194" ..
		-- tex:"483abdc0b052f35bef790d7463221363"; x:48.883423; y:-567.190125; z:-100.949921
		"\073\210\029\241\225\235\232\211\030\068\239\166\164\102\035\161\148\024\083\192\222\185\017\196\119\151\200\194" ..
		-- tex:"49d21df1e1ebe8d31e44efa6a46623a1"; x:-3.298375; y:-582.904236; z:-100.295837
		"\075\008\008\074\120\007\233\047\048\244\053\109\219\086\090\133\140\203\201\067\043\180\148\195\239\074\200\194" ..
		-- tex:"4b08084a7807e92f30f4356ddb565a85"; x:403.590240; y:-297.407593; z:-100.146362
		"\001\156\058\200\201\028\186\102\224\206\050\112\247\154\064\089\010\047\151\067\127\238\075\195\245\004\200\194" ..
		-- tex:"019c3ac8c91cba66e0ce3270f79a4059"; x:302.367523; y:-203.931641; z:-100.009689
		"\141\038\028\142\182\100\092\171\043\014\201\219\038\139\242\146\250\076\013\067\191\031\021\196\147\247\198\194" ..
		-- tex:"8d261c8eb6645cab2b0ec9db268bf292"; x:141.300705; y:-596.496094; z:-99.483551
		"\118\091\139\064\000\120\043\158\111\213\233\065\088\096\102\149\087\164\165\067\239\046\178\195\195\245\196\194" ..
		-- tex:"765b8b4000782b9e6fd5e94158606695"; x:331.283936; y:-356.366699; z:-98.480011
		"\190\204\131\006\137\126\019\222\137\085\246\205\190\206\012\007\122\167\253\067\020\121\072\195\118\095\195\194" ..
		-- tex:"becc8306897e13de8955f6cdbece0c07"; x:507.308441; y:-200.472977; z:-97.686455
		"\012\194\181\220\119\217\055\068\255\127\126\225\034\050\000\097\152\087\069\067\206\203\055\196\118\084\195\194" ..
		-- tex:"0cc2b5dc77d93744ff7f7ee122320061"; x:197.342178; y:-735.184509; z:-97.664970
		"\200\245\026\157\152\040\113\179\140\111\019\151\167\016\117\094\115\185\019\068\163\173\137\195\109\170\194\194" ..
		-- tex:"c8f51a9d982871b38c6f1397a710755e"; x:590.897705; y:-275.356567; z:-97.332870
		"\006\232\087\024\177\060\181\212\236\220\177\048\198\076\053\196\074\197\133\193\248\237\052\196\183\028\193\194" ..
		-- tex:"06e85718b13cb5d4ecdcb130c64c35c4"; x:-16.721334; y:-723.718323; z:-96.556091
		"\139\042\229\078\127\058\054\110\037\205\216\063\009\167\083\241\204\129\115\194\054\179\085\196\034\244\192\194" ..
		-- tex:"8b2ae54e7f3a366e25cdd83f09a753f1"; x:-60.876759; y:-854.800232; z:-96.476830
		"\036\145\055\238\200\057\210\085\221\237\055\240\094\223\184\112\075\055\202\067\008\174\028\195\123\134\192\194" ..
		-- tex:"249137eec839d255dded37f05edfb870"; x:404.432007; y:-156.679825; z:-96.262665
		"\232\044\181\022\252\050\246\150\176\236\069\089\207\097\069\218\122\167\253\067\048\047\178\195\054\047\191\194" ..
		-- tex:"e82cb516fc32f696b0ec4559cf6145da"; x:507.308441; y:-356.368683; z:-95.592216
		"\144\152\248\064\056\247\122\146\065\068\156\071\233\056\249\246\030\094\214\067\126\058\038\196\090\128\190\194" ..
		-- tex:"9098f84038f77a9241449c47e938f9f6"; x:428.735321; y:-664.914001; z:-95.250694
		"\243\096\230\039\252\148\026\250\083\075\191\038\216\132\201\170\087\179\093\065\004\099\030\196\184\009\190\194" ..
		-- tex:"f360e627fc941afa534bbf26d884c9aa"; x:13.856285; y:-633.547180; z:-95.018990
		"\036\046\121\175\032\075\219\193\005\163\133\028\225\147\236\093\075\055\202\067\062\042\187\195\033\248\186\194" ..
		-- tex:"242e79af204bdbc105a3851ce193ec5d"; x:404.432007; y:-374.330048; z:-93.484634
		"\071\121\114\100\228\036\176\048\004\217\110\059\067\055\128\018\116\216\000\068\189\033\053\066\251\197\182\194" ..
		-- tex:"47797264e424b03004d96e3b43378012"; x:515.382141; y:45.282951; z:-91.386688
		"\000\119\129\010\196\140\206\247\009\026\225\042\202\138\029\139\043\112\243\193\147\138\063\196\091\224\176\194" ..
		-- tex:"0077810ac48ccef7091ae12aca8a1d8b"; x:-30.429771; y:-766.165283; z:-88.438202
		"\236\030\254\071\203\251\092\114\227\019\165\084\077\034\022\073\083\004\031\195\010\063\071\196\030\116\175\194" ..
		-- tex:"ec1efe47cbfb5c72e313a5544d221649"; x:-159.016907; y:-796.985046; z:-87.726799
		"\065\084\076\249\141\031\204\078\005\043\036\030\093\002\109\239\076\130\249\194\133\024\042\196\001\125\174\194" ..
		-- tex:"41544cf98d1fcc4e052b241e5d026def"; x:-124.754494; y:-680.383179; z:-87.244156
		"\172\080\141\205\035\021\222\109\033\033\208\173\134\103\002\056\104\229\122\067\140\023\077\196\026\006\171\194" ..
		-- tex:"ac508dcd2315de6d2121d0ad86670238"; x:250.896133; y:-820.367981; z:-85.511925
		"\006\087\045\001\205\152\124\170\177\208\042\212\189\031\105\182\178\046\140\195\246\156\236\195\183\021\170\194" ..
		-- tex:"06572d01cd987caab1d02ad4bd1f69b6"; x:-280.364838; y:-473.226288; z:-85.042419
		"\129\086\022\123\238\103\058\179\008\084\006\041\055\203\180\241\104\078\184\195\034\089\008\196\032\019\170\194" ..
		-- tex:"8156167bee673ab30854062937cbb4f1"; x:-368.612579; y:-545.392761; z:-85.037361
		"\117\056\201\223\232\182\110\167\026\008\178\165\228\120\060\142\011\099\042\195\182\042\105\196\227\244\168\194" ..
		-- tex:"7538c9dfe8b66ea71a08b2a5e4783c8e"; x:-170.386902; y:-932.667419; z:-84.478302
		"\109\125\155\177\017\108\178\005\145\210\077\069\065\250\190\230\008\030\206\067\082\250\058\196\058\088\163\194" ..
		-- tex:"6d7d9bb1116cb20591d24d4541fabee6"; x:412.234650; y:-747.911316; z:-81.672325
		"\162\013\255\167\054\028\002\089\036\195\227\121\088\150\161\044\030\012\129\194\098\141\022\196\031\199\162\194" ..
		-- tex:"a20dffa7361c025924c3e3795896a12c"; x:-64.523674; y:-602.209167; z:-81.388916
		"\151\149\091\075\138\144\110\225\154\194\009\026\003\180\190\010\227\231\184\067\175\183\077\196\178\161\162\194" ..
		-- tex:"97955b4b8a906ee19ac2091a03b4be0a"; x:369.811646; y:-822.870117; z:-81.315819
		"\019\049\225\135\152\071\095\016\212\138\217\191\155\031\181\023\201\051\074\195\005\107\081\196\229\127\161\194" ..
		-- tex:"1331e18798475f10d48ad9bf9b1fb517"; x:-202.202301; y:-837.672241; z:-80.749802
		"\126\008\130\245\112\100\040\231\031\057\126\141\140\188\204\124\250\139\228\067\196\203\063\196\096\030\159\194" ..
		-- tex:"7e0882f5706428e71f397e8d8cbccc7c"; x:457.093597; y:-767.183899; z:-79.559334
		"\037\025\208\078\010\179\131\133\044\136\005\195\175\225\194\048\096\093\249\067\071\220\072\196\162\114\150\194" ..
		-- tex:"2519d04e0ab383852c8805c3afe1c230"; x:498.729523; y:-803.441895; z:-75.223900
		"\110\030\100\229\093\042\083\006\223\223\147\188\068\190\151\015\026\157\240\194\216\123\005\196\228\039\145\194" ..
		-- tex:"6e1e64e55d2a5306dfdf93bc44be970f"; x:-120.306847; y:-533.935120; z:-72.577919
		"\199\246\043\071\216\155\023\060\229\175\025\100\093\051\224\217\144\025\179\067\110\232\104\065\056\006\145\194" ..
		-- tex:"c7f62b47d89b173ce5af19645d33e0d9"; x:358.199738; y:14.556746; z:-72.512154
		"\110\112\084\249\214\017\105\071\159\189\023\039\033\161\133\108\108\166\166\195\045\229\029\196\179\141\101\194" ..
		-- tex:"6e7054f9d61169479fbd172721a1856c"; x:-333.300201; y:-631.580933; z:-57.388382
		"\183\178\064\239\138\001\195\055\092\004\146\146\248\169\092\183\104\167\021\195\006\075\005\196\064\237\084\194" ..
		-- tex:"b7b240ef8a01c3375c049292f8a95cb7"; x:-149.653946; y:-533.172302; z:-53.231693
		"\114\051\212\009\127\120\231\111\227\059\187\183\043\217\042\121\224\213\141\195\248\032\026\196\063\237\084\194",
		-- tex:"7233d4097f78e76fe33bbbb72bd92a79"; x:-283.670929; y:-616.515198; z:-53.231689
	["Utgarde Keep"] = 
		"\009\101\238\238\236\092\185\067\201\164\061\119\052\073\070\099\010\094\181\194\102\153\238\065\030\131\221\193" ..
		-- tex:"0965eeeeec5cb943c9a43d7734494663"; x:-90.683678; y:29.824903; z:-27.689024
		"\241\208\072\180\082\196\069\100\153\107\212\081\054\024\014\147\211\019\199\194\005\072\159\195\076\051\088\193" ..
		-- tex:"f1d048b452c44564996bd45136180e93"; x:-99.538727; y:-318.562683; z:-13.512525
		"\031\007\000\104\076\202\244\210\233\123\204\085\001\245\100\021\021\118\028\067\005\072\159\195\076\051\088\193" ..
		-- tex:"1f0700684ccaf4d2e97bcc5501f56415"; x:156.461273; y:-318.562683; z:-13.512525
		"\149\230\002\016\246\054\169\123\076\076\234\142\074\241\099\227\211\019\199\194\047\064\122\194\076\051\088\193" ..
		-- tex:"95e60210f636a97b4c4cea8e4af163e3"; x:-99.538727; y:-62.562683; z:-13.512525
		"\060\098\001\135\014\081\104\037\250\240\234\237\196\109\148\013\093\081\013\196\251\066\027\195\128\241\149\065" ..
		-- tex:"3c6201870e516825faf0eaedc46d940d"; x:-565.271362; y:-155.261658; z:18.742922
		"\068\061\112\219\086\022\248\040\214\191\100\004\011\102\076\161\093\081\013\196\007\122\201\066\128\241\149\065" ..
		-- tex:"443d70db5616f828d6bf64040b664ca1"; x:-565.271362; y:100.738342; z:18.742922
		"\244\061\006\101\185\025\210\080\252\230\051\170\144\079\216\095\187\162\154\195\251\066\027\195\128\241\149\065" ..
		-- tex:"f43d0665b919d250fce633aa904fd85f"; x:-309.271362; y:-155.261658; z:18.742922
		"\193\050\234\170\140\049\055\071\153\193\173\115\084\019\150\117\187\162\154\195\007\122\201\066\128\241\149\065" ..
		-- tex:"c132eaaa8c31374799c1ad7354139675"; x:-309.271362; y:100.738342; z:18.742922
		"\188\183\249\165\053\057\207\225\101\231\052\182\056\182\045\097\015\210\008\196\135\143\076\195\094\242\182\065" ..
		-- tex:"bcb7f9a53539cfe165e734b638b62d61"; x:-547.282227; y:-204.560669; z:22.868345
		"\090\186\040\224\094\151\030\192\080\008\080\094\112\081\030\096\131\017\067\196\124\190\020\196\131\228\011\066" ..
		-- tex:"5aba28e05e971ec05008505e70511e60"; x:-780.273682; y:-594.976379; z:34.973160
		"\029\175\002\186\086\066\173\112\176\030\099\187\064\212\088\222\131\017\003\196\249\124\169\195\131\228\011\066" ..
		-- tex:"1daf02ba5642ad70b01e63bb40d458de"; x:-524.273682; y:-338.976379; z:34.973160
		"\127\067\004\172\121\002\213\052\232\160\184\050\242\009\005\021\131\017\003\196\124\190\020\196\131\228\011\066" ..
		-- tex:"7f4304ac7902d534e8a0b832f2090515"; x:-524.273682; y:-594.976379; z:34.973160
		"\215\158\246\133\252\204\196\017\071\097\019\117\078\180\031\114\131\017\067\196\249\124\169\195\131\228\011\066" ..
		-- tex:"d79ef685fcccc411476113754eb41f72"; x:-780.273682; y:-338.976379; z:34.973160
		"\025\060\098\087\241\028\129\080\161\164\106\033\125\022\127\000\007\035\134\195\249\124\169\195\131\228\011\066" ..
		-- tex:"193c6257f11c8150a1a46a217d167f00"; x:-268.273682; y:-338.976379; z:34.973160
		"\245\031\217\163\049\040\083\191\066\203\137\229\131\224\224\214\017\210\008\196\160\212\013\196\146\250\011\066" ..
		-- tex:"f51fd9a3312853bf42cb89e583e0e0d6"; x:-547.282349; y:-567.322327; z:34.994701
		"\029\090\034\010\109\180\201\145\078\218\015\178\114\060\254\161\092\157\199\195\111\076\205\195\244\199\092\066" ..
		-- tex:"1d5a220a6db4c9914eda0fb2723cfea1"; x:-399.229401; y:-410.597168; z:55.195271
		"\188\129\068\051\246\084\130\112\009\167\119\156\020\011\182\171\185\058\015\195\055\166\038\196\244\199\092\066" ..
		-- tex:"bc814433f654827009a7779c140bb6ab"; x:-143.229401; y:-666.597168; z:55.195271
		"\120\221\132\094\132\151\196\000\006\118\166\168\090\230\063\006\092\157\199\195\055\166\038\196\244\199\092\066" ..
		-- tex:"78dd845e8497c4000676a6a85ae63f06"; x:-399.229401; y:-666.597168; z:55.195271
		"\015\142\032\140\082\064\144\005\076\042\067\053\122\060\229\238\185\058\015\195\111\076\205\195\244\199\092\066" ..
		-- tex:"0f8e208c524090054c2a43357a3ce5ee"; x:-143.229401; y:-410.597168; z:55.195271
		"\045\055\167\197\224\188\187\038\246\148\105\052\116\048\022\152\149\055\095\195\007\201\054\196\221\181\103\066" ..
		-- tex:"2d37a7c5e0bcbb26f694693474301698"; x:-223.217133; y:-731.141113; z:57.927605
		"\074\064\098\113\014\018\061\242\175\023\137\211\146\029\129\024\149\055\095\195\015\146\237\195\221\181\103\066" ..
		-- tex:"4a4062710e123df2af1789d3921d8118"; x:-223.217133; y:-475.141113; z:57.927605
		"\242\195\003\150\058\185\144\214\053\073\178\255\123\151\068\237\167\033\003\066\007\201\054\196\221\181\103\066" ..
		-- tex:"f2c303963ab990d63549b2ff7b9744ed"; x:32.782867; y:-731.141113; z:57.927605
		"\238\157\229\097\225\057\237\024\138\214\039\246\060\058\131\189\167\033\003\066\015\146\237\195\221\181\103\066" ..
		-- tex:"ee9de561e139ed188ad627f63c3a83bd"; x:32.782867; y:-475.141113; z:57.927605
		"\118\076\192\229\123\086\046\143\222\048\218\215\116\074\202\066\189\099\224\194\144\088\233\195\243\141\208\066" ..
		-- tex:"764cc0e57b562e8fde30dad7744aca42"; x:-112.194809; y:-466.691925; z:104.277252
		"\253\228\237\230\124\157\223\002\057\166\125\201\090\013\129\154\155\119\048\195\125\210\162\195\004\198\209\066" ..
		-- tex:"fde4ede67c9ddf0239a67dc95a0d819a"; x:-176.467224; y:-325.644470; z:104.886757
		"\074\232\022\168\166\081\251\071\249\100\226\206\156\021\233\113\111\162\038\066\145\174\157\065\235\251\010\067" ..
		-- tex:"4ae816a8a651fb47f964e2ce9c15e971"; x:41.658630; y:19.710239; z:138.984070
		"\164\035\152\049\052\025\073\074\243\023\082\090\090\061\240\247\176\064\104\066\212\131\163\195\163\132\063\067" ..
		-- tex:"a42398313419494af317525a5a3df0f7"; x:58.063175; y:-327.029938; z:191.518127
		"\049\018\083\136\054\148\076\138\058\000\143\120\072\028\112\209\053\148\181\193\096\085\174\195\050\110\075\067" ..
		-- tex:"3112538836944c8a3a008f78481c70d1"; x:-22.697369; y:-348.667023; z:203.430466
		"\041\090\105\030\073\130\181\068\253\016\204\125\181\058\101\103\053\148\181\193\131\085\185\194\050\110\075\067" ..
		-- tex:"295a691e4982b544fd10cc7db53a6567"; x:-22.697369; y:-92.667023; z:203.430466
		"\020\229\081\094\015\147\168\137\117\050\175\082\220\016\210\154\106\130\114\195\021\217\061\195\067\068\115\067" ..
		-- tex:"14e5515e0f93a8897532af52dc10d29a"; x:-242.509445; y:-189.847992; z:243.266663
		"\216\125\054\053\247\133\126\059\248\179\105\104\061\119\086\084\216\088\085\195\245\221\126\194\254\065\165\067",
		-- tex:"d87d3635f7857e3bf8b369683d775654"; x:-213.347061; y:-63.716759; z:330.515594
	["Wailing Caverns"] = 
		"\083\146\040\125\187\000\045\130\081\007\156\098\112\194\085\193\036\073\029\068\069\111\139\066\237\233\194\195" ..
		-- tex:"5392287dbb002d8251079c6270c255c1"; x:629.142853; y:69.717331; z:-389.827576
		"\242\213\160\115\218\064\141\111\136\205\152\022\017\164\172\169\196\170\012\068\007\049\092\066\237\233\194\195" ..
		-- tex:"f2d5a073da408d6f88cd981611a4aca9"; x:562.668266; y:55.047882; z:-389.827576
		"\176\030\047\076\048\182\184\192\130\158\124\026\197\227\080\108\196\170\012\068\189\243\072\195\237\233\194\195" ..
		-- tex:"b01e2f4c30b6b8c0829e7c1ac5e3506c"; x:562.668266; y:-200.952118; z:-389.827576
		"\007\132\010\090\004\061\212\069\150\175\168\012\118\239\069\121\137\085\153\067\007\049\092\066\237\233\194\195" ..
		-- tex:"07840a5a043dd44596afa80c76ef4579"; x:306.668266; y:55.047882; z:-389.827576
		"\152\080\239\024\066\112\002\166\041\052\097\034\218\117\077\003\137\085\153\067\189\243\072\195\237\233\194\195" ..
		-- tex:"9850ef18427002a629346122da754d03"; x:306.668266; y:-200.952118; z:-389.827576
		"\191\163\051\096\240\180\202\250\167\016\074\239\108\226\154\059\072\146\186\067\150\213\039\196\237\233\194\195" ..
		-- tex:"bfa33360f0b4cafaa7104aef6ce29a3b"; x:373.142853; y:-671.337341; z:-389.827576
		"\217\022\092\184\186\189\176\067\222\112\054\233\137\234\077\199\036\073\029\068\092\072\058\195\237\233\194\195" ..
		-- tex:"d9165cb8babdb043de7036e989ea4dc7"; x:629.142853; y:-186.282669; z:-389.827576
		"\046\138\198\048\067\179\236\239\202\211\017\022\164\095\102\160\036\073\029\068\209\219\162\067\237\233\194\195" ..
		-- tex:"2e8ac63043b3ecefcad31116a45f66a0"; x:629.142853; y:325.717331; z:-389.827576
		"\070\182\024\190\015\204\107\222\089\241\152\060\007\239\118\230\072\146\186\067\209\219\162\067\237\233\194\195" ..
		-- tex:"46b618be0fcc6bde59f1983c07ef76e6"; x:373.142853; y:325.717331; z:-389.827576
		"\181\218\065\134\019\220\247\117\233\018\010\221\144\026\087\232\072\146\186\067\069\111\139\066\237\233\194\195" ..
		-- tex:"b5da418613dcf775e9120add901a57e8"; x:373.142853; y:69.717331; z:-389.827576
		"\204\033\065\227\064\095\253\027\159\098\061\158\020\170\034\039\077\172\074\066\007\049\092\066\237\233\194\195" ..
		-- tex:"cc2141e3405ffd1b9f623d9e14aa2227"; x:50.668266; y:55.047882; z:-389.827576
		"\055\165\165\004\104\138\188\223\023\061\252\062\065\131\196\067\072\146\186\067\045\171\207\195\237\233\194\195" ..
		-- tex:"37a5a504688abcdf173dfc3e4183c443"; x:373.142853; y:-415.337341; z:-389.827576
		"\184\033\021\099\201\061\206\173\001\219\001\205\073\248\141\034\077\172\074\066\189\243\072\195\237\233\194\195" ..
		-- tex:"b8211563c93dcead01db01cd49f88d22"; x:50.668266; y:-200.952118; z:-389.827576
		"\159\055\211\019\168\150\085\135\146\166\225\008\043\145\071\122\229\149\147\067\249\073\209\195\237\233\194\195" ..
		-- tex:"9f37d313a896558792a6e1082b91477a"; x:295.171082; y:-418.577942; z:-389.827576
		"\210\200\011\204\060\064\115\195\120\245\162\163\223\086\067\249\229\149\147\067\252\164\040\196\237\233\194\195" ..
		-- tex:"d2c80bcc3c4073c378f5a2a3df5643f9"; x:295.171082; y:-674.577942; z:-389.827576
		"\120\126\088\145\222\048\074\114\147\121\225\116\115\250\042\122\072\146\186\067\092\072\058\195\237\233\194\195" ..
		-- tex:"787e5891de304a729379e17473fa2a7a"; x:373.142853; y:-186.282669; z:-389.827576
		"\204\000\087\112\127\203\159\240\105\148\136\074\193\177\021\253\036\073\029\068\150\213\039\196\237\233\194\195" ..
		-- tex:"cc0057707fcb9ff06994884ac1b115fd"; x:629.142853; y:-671.337341; z:-389.827576
		"\125\019\019\017\246\117\222\233\243\034\094\145\048\023\154\120\036\073\029\068\045\171\207\195\237\233\194\195" ..
		-- tex:"7d131311f675dee9f3225e9130179a78"; x:629.142853; y:-415.337341; z:-389.827576
		"\036\095\214\056\140\016\191\059\015\009\227\139\136\179\245\141\135\202\205\194\223\099\119\194\104\096\110\195" ..
		-- tex:"245fd6388c10bf3b0f09e38b88b3f58d"; x:-102.895569; y:-61.847534; z:-238.376602
		"\138\156\250\120\206\203\081\054\176\207\236\170\061\188\118\229\135\202\205\194\123\236\158\195\104\096\110\195" ..
		-- tex:"8a9cfa78cecb5136b0cfecaa3dbc76e5"; x:-102.895569; y:-317.847534; z:-238.376602
		"\254\121\218\225\138\077\030\184\194\240\204\207\119\090\175\153\187\026\025\067\123\236\158\195\104\096\110\195" ..
		-- tex:"fe79dae18a4d1eb8c2f0cccf775aaf99"; x:153.104431; y:-317.847534; z:-238.376602
		"\055\177\227\228\109\211\142\078\246\150\217\126\132\083\078\146\058\201\014\195\002\178\037\196\068\025\090\195" ..
		-- tex:"37b1e3e46dd38e4ef696d97e84534e92"; x:-142.786057; y:-662.781433; z:-218.098709
		"\144\029\183\089\169\019\100\221\175\249\173\066\119\095\182\175\000\129\187\195\237\039\177\195\068\025\090\195" ..
		-- tex:"901db759a91364ddaff9ad42775fb6af"; x:-375.007843; y:-354.311951; z:-218.098709
		"\009\098\146\243\017\141\080\016\227\117\017\170\027\129\177\169\000\129\187\195\246\147\024\196\068\025\090\195" ..
		-- tex:"096292f3118d5010e37511aa1b81b1a9"; x:-375.007843; y:-610.311951; z:-218.098709
		"\003\191\103\092\063\127\165\107\229\219\093\102\068\038\144\178\137\109\226\066\002\178\037\196\068\025\090\195" ..
		-- tex:"03bf675c3f7fa56be5db5d66442690b2"; x:113.213943; y:-662.781433; z:-218.098709
		"\179\179\123\205\084\085\068\221\019\093\136\031\102\174\080\152\013\002\033\195\059\046\085\196\237\008\088\195" ..
		-- tex:"b3b37bcd545544dd135d881f66ae5098"; x:-161.008026; y:-852.722412; z:-216.034882
		"\186\061\126\220\174\254\094\120\050\178\147\118\162\211\084\127\227\251\189\066\059\046\085\196\237\008\088\195" ..
		-- tex:"ba3d7edcaefe5e7832b29376a2d3547f"; x:94.991974; y:-852.722412; z:-216.034882
		"\122\254\180\242\056\074\250\018\209\126\031\027\181\018\198\075\013\002\033\195\029\151\138\196\237\008\088\195" ..
		-- tex:"7afeb4f2384afa12d17e1f1bb512c64b"; x:-161.008026; y:-1108.722412; z:-216.034882
		"\069\082\184\224\000\087\228\163\108\137\154\219\223\027\209\174\227\251\189\066\029\151\138\196\237\008\088\195" ..
		-- tex:"4552b8e00057e4a36c899adbdf1bd1ae"; x:94.991974; y:-1108.722412; z:-216.034882
		"\043\137\052\072\164\233\031\109\057\194\091\218\203\118\183\089\179\253\222\066\039\136\056\196\043\238\085\195" ..
		-- tex:"2b893448a4e91f6d39c25bdacb76b759"; x:111.495514; y:-738.127441; z:-213.930359
		"\143\039\053\017\147\052\142\056\238\080\128\007\215\203\015\004\219\142\065\067\187\113\042\195\028\107\085\195" ..
		-- tex:"8f27351193348e38ee508007d7cb0f04"; x:193.558044; y:-170.444275; z:-213.418411
		"\135\040\200\155\035\157\124\224\203\231\058\098\246\144\245\036\057\111\249\066\130\011\237\195\052\195\084\195" ..
		-- tex:"8728c89b239d7ce0cbe73a62f690f524"; x:124.717239; y:-474.089935; z:-212.762527
		"\209\137\031\100\194\037\231\030\235\189\196\182\136\164\223\033\098\072\003\195\130\011\237\195\052\195\084\195" ..
		-- tex:"d1891f64c225e71eebbdc4b688a4df21"; x:-131.282761; y:-474.089935; z:-212.762527
		"\071\135\147\048\085\246\131\090\187\147\054\110\050\247\112\154\171\247\235\066\222\144\002\196\136\202\063\195" ..
		-- tex:"4787933055f6835abb93366e32f7709a"; x:117.983734; y:-522.263611; z:-191.791153
		"\241\117\057\037\226\090\129\140\123\145\245\190\055\162\232\089\099\127\067\067\131\194\156\195\068\077\052\195" ..
		-- tex:"f1753925e25a818c7b91f5be37a2e859"; x:195.497620; y:-313.519653; z:-180.301834
		"\091\154\190\082\049\109\030\216\024\023\113\210\169\114\153\120\042\218\020\067\042\103\126\067\119\191\047\195" ..
		-- tex:"5b9abe52316d1ed8181771d2a9729978"; x:148.852211; y:254.403000; z:-175.747925
		"\090\106\000\097\220\069\150\049\077\098\058\079\097\125\094\191\170\075\214\194\042\103\126\067\119\191\047\195" ..
		-- tex:"5a6a0061dc4596314d623a4f617d5ebf"; x:-107.147789; y:254.403000; z:-175.747925
		"\151\162\206\181\197\079\076\025\098\074\001\245\222\091\245\162\170\075\214\194\149\051\255\067\119\191\047\195" ..
		-- tex:"97a2ceb5c54f4c19624a01f5de5bf5a2"; x:-107.147789; y:510.403000; z:-175.747925
		"\224\163\115\018\050\016\249\195\204\053\165\092\143\012\157\158\101\028\039\195\032\068\077\067\034\020\033\195" ..
		-- tex:"e0a373123210f9c3cc35a55c8f0c9d9e"; x:-167.110931; y:205.266129; z:-161.078659
		"\077\005\028\099\077\103\142\138\205\254\182\062\104\183\154\056\051\199\177\066\032\068\077\067\034\020\033\195" ..
		-- tex:"4d051c634d678e8acdfeb63e68b79a38"; x:88.889069; y:205.266129; z:-161.078659
		"\200\113\110\018\152\204\158\122\111\144\163\106\211\036\086\184\077\196\173\067\243\101\178\067\232\234\031\195" ..
		-- tex:"c8716e1298cc9e7a6f90a36ad32456b8"; x:347.533630; y:356.796501; z:-159.917618
		"\220\180\165\139\163\127\067\003\135\075\250\016\116\227\070\175\055\017\183\066\206\151\201\066\232\234\031\195" ..
		-- tex:"dcb4a58ba37f4303874bfa1074e346af"; x:91.533630; y:100.796501; z:-159.917618
		"\216\092\002\101\205\021\181\091\240\043\118\192\082\125\215\237\055\017\183\066\243\101\178\067\232\234\031\195" ..
		-- tex:"d85c0265cd15b55bf02b76c0527dd7ed"; x:91.533630; y:356.796501; z:-159.917618
		"\189\076\240\081\029\155\074\006\027\109\068\137\205\077\042\111\077\196\173\067\206\151\201\066\232\234\031\195" ..
		-- tex:"bd4cf0511d9b4a061b6d4489cd4d2a6f"; x:347.533630; y:100.796501; z:-159.917618
		"\135\245\203\097\055\093\172\053\106\222\079\127\090\220\015\151\056\107\140\067\137\180\170\067\205\241\018\195" ..
		-- tex:"87f5cb61375dac356ade4f7f5adc0f97"; x:280.837677; y:341.410461; z:-146.944550
		"\085\136\244\237\064\068\003\107\096\139\167\032\244\075\084\236\235\083\044\067\131\098\236\067\232\198\016\195" ..
		-- tex:"5588f4ed4044036b608ba720f44b54ec"; x:172.327820; y:472.769653; z:-144.776993
		"\097\092\206\148\111\071\121\164\062\229\045\115\246\228\192\246\235\083\044\067\065\049\054\068\232\198\016\195" ..
		-- tex:"615cce946f4779a43ee52d73f6e4c0f6"; x:172.327820; y:728.769653; z:-144.776993
		"\175\043\091\242\199\089\035\022\127\193\250\118\162\111\058\017\245\041\214\067\131\098\236\067\232\198\016\195" ..
		-- tex:"af2b5bf2c75923167fc1fa76a26f3a11"; x:428.327820; y:472.769653; z:-144.776993
		"\216\235\053\218\212\026\187\025\199\229\222\141\229\066\147\097\043\021\182\067\224\005\228\067\035\042\016\195" ..
		-- tex:"d8eb35dad41abb19c7e5de8de5429361"; x:364.165405; y:456.045929; z:-144.164612
		"\003\224\151\149\101\131\098\000\200\237\046\092\249\062\184\061\184\219\192\193\241\174\233\065\205\042\015\195" ..
		-- tex:"03e0979565836200c8ed2e5cf93eb83d"; x:-24.107286; y:29.210423; z:-143.167206
		"\201\008\016\197\022\024\141\104\171\159\065\091\182\045\148\023\203\162\086\067\096\060\205\067\034\228\013\195" ..
		-- tex:"c90810c516188d68ab9f415bb62d9417"; x:214.635925; y:410.471710; z:-141.891159
		"\056\049\014\105\077\224\158\068\199\236\247\205\173\011\199\233\000\098\152\065\153\196\176\067\017\024\011\195" ..
		-- tex:"38310e694de09e44c7ecf7cdad0bc7e9"; x:19.047853; y:353.535950; z:-139.094025
		"\150\123\245\181\170\100\180\178\008\179\246\003\009\120\203\012\039\143\221\067\150\218\138\067\055\218\002\195" ..
		-- tex:"967bf5b5aa64b4b208b3f6030978cb0c"; x:443.118408; y:277.707733; z:-130.852417
		"\091\225\127\178\251\097\239\098\191\075\133\133\141\145\173\158\039\143\221\067\075\109\005\068\055\218\002\195",
		-- tex:"5be17fb2fb61ef62bf4b85858d91ad9e"; x:443.118408; y:533.707733; z:-130.852417
	["Zul'Aman"] = 
		"\002\176\006\217\248\054\242\127\142\123\057\156\017\085\117\087\255\255\231\069\255\255\247\197\000\000\000\000" ..
		-- tex:"02b006d9f836f27f8e7b399c11557557"; x:7424.000000; y:-7936.000000
		"\219\220\218\033\238\051\049\048\222\188\178\002\138\186\135\126\255\255\231\069\000\000\000\198\000\000\000\000" ..
		-- tex:"dbdcda21ee333130debcb2028aba877e"; x:7424.000000; y:-8192.000000
		"\015\216\091\060\197\194\090\222\135\045\034\216\242\150\027\239\255\255\239\069\255\255\247\197\000\000\000\000" ..
		-- tex:"0fd85b3cc5c25ade872d22d8f2961bef"; x:7680.000000; y:-7936.000000
		"\085\044\223\175\202\003\027\136\171\214\153\243\128\147\215\148\255\255\239\069\000\000\000\198\000\000\000\000",
		-- tex:"552cdfafca031b88abd699f38093d794"; x:7680.000000; y:-8192.000000
	["Zul'Farrak"] = 
		"\068\081\024\165\160\024\170\084\153\101\014\181\051\097\176\040\255\255\231\069\255\255\223\197\000\000\000\000" ..
		-- tex:"445118a5a018aa5499650eb53361b028"; x:7424.000000; y:-7168.000000
		"\223\068\162\211\077\136\230\094\175\058\017\230\120\096\036\014\255\255\231\069\255\255\231\197\000\000\000\000" ..
		-- tex:"df44a2d34d88e65eaf3a11e67860240e"; x:7424.000000; y:-7424.000000
		"\155\113\015\136\062\001\136\002\214\155\099\143\058\047\061\182\255\255\239\069\255\255\223\197\000\000\000\000" ..
		-- tex:"9b710f883e018802d69b638f3a2f3db6"; x:7680.000000; y:-7168.000000
		"\082\011\042\022\245\250\107\150\252\149\249\235\155\180\133\001\255\255\239\069\255\255\231\197\000\000\000\000",
		-- tex:"520b2a16f5fa6b96fc95f9eb9bb48501"; x:7680.000000; y:-7424.000000
	["Zul'Gurub"] = 
		"\223\048\207\070\194\201\097\009\145\034\158\217\079\136\214\244\255\255\007\070\255\255\083\198\000\000\000\000" ..
		-- tex:"df30cf46c2c9610991229ed94f88d6f4"; x:8704.000000; y:-13568.000000
		"\024\087\116\015\117\252\250\081\209\009\164\071\159\019\085\241\255\255\007\070\255\255\087\198\000\000\000\000" ..
		-- tex:"1857740f75fcfa51d109a4479f1355f1"; x:8704.000000; y:-13824.000000
		"\084\244\247\070\143\105\201\001\167\129\037\249\124\053\058\051\255\255\007\070\255\255\091\198\000\000\000\000" ..
		-- tex:"54f4f7468f69c901a78125f97c353a33"; x:8704.000000; y:-14080.000000
		"\002\250\036\134\121\014\228\208\072\078\084\118\227\150\154\178\255\255\011\070\255\255\083\198\000\000\000\000" ..
		-- tex:"02fa2486790ee4d0484e5476e3969ab2"; x:8960.000000; y:-13568.000000
		"\002\034\230\072\030\221\089\151\154\224\204\123\148\110\075\040\255\255\011\070\255\255\087\198\000\000\000\000" ..
		-- tex:"0222e6481edd59979ae0cc7b946e4b28"; x:8960.000000; y:-13824.000000
		"\030\211\125\049\084\177\072\206\153\254\007\025\149\069\023\098\255\255\011\070\255\255\091\198\000\000\000\000",
		-- tex:"1ed37d3154b148ce99fe071995451762"; x:8960.000000; y:-14080.000000
}
